: #-*- Perl -*-
eval 'exec perl -w -S $0 ${1+"$@"}' # Portability kludge
    if 0;

# config.values.sh --- create config.values.in from ../configure

# Copyright (C) 1997, 1999 Martin Buchholz

# Author:	Martin Buchholz
# Maintainer:	Martin Buchholz
# Keywords:	configure elisp report-xemacs-bugs

# This file is part of XEmacs.
# 
# XEmacs is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation, either version 3 of the License, or (at your
# option) any later version.
# 
# XEmacs is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
# 
# You should have received a copy of the GNU General Public License
# along with XEmacs.  If not, see <http://www.gnu.org/licenses/>.

### Commentary:

## Extract all the @foo@ configuration symbols from ../configure
## to make them available to elisp later (see util/config.el)
## Primarily useful for creating ridiculously verbose bug reports.
##
## See lisp/config.el, ../configure.in,
## and the Autoconf documentation on AC_OUTPUT, for more details.
##
## This script needs only to be run occasionally (before a Net release)
## by an XEmacs Maintainer (consider yourself so blessed, if you are
## actually reading this commentary).
##

if (! -r "./configure") {
  chdir ".." or die "Can't chdir: $!";
  if (! -r "./configure") {
    die "Can't find configure!";
  }
}

sub FileContents {
  local $/ = undef; # Slurp mode
  open (FILE, "< $_[0]") or die "$_[0]: $!";
  my $contents = <FILE>;
  close FILE or die "$_[0]: $!";
  return $contents;
}

my $configure_contents = FileContents "./configure";
my $cvi_contents = FileContents "lib-src/config.values.in";

my $new_cvi_contents =
";;; Do not edit this file!
;;; This file was automatically generated, by the config.values.sh script,
;;; from configure, which was itself automatically generated from configure.in.
;;;
;;; See lisp/config.el for details on how this file is used.
;;;
;;; You are trapped in a twisty maze of strange-looking files, all autogenerated...

;;; configure        is created, from configure.in,     by autoconf
;;; config.values.in is created, from configure,        by config.values.sh
;;; config.values    is created, from config.values.in, by configure
;;; config.values    is read by lisp/config.el,
;;;                  to create the (Lisp object) config-value-hash-table

;;; Variables defined in configure by AC_SUBST follow:
;;; (These are used in Makefiles)

";

my %done;
for my $var (sort { $a cmp $b }
	     $configure_contents =~
	     /^s\,\@([A-Za-z0-9_]+)\@\,\$[A-Za-z0-9_]+\,;t t/mg) {
  $new_cvi_contents .= "$var \"\@$var\@\"\n" unless exists $done{$var};
  $done{$var} = 1;
}

$new_cvi_contents .= "
;;; Variables defined in configure by AC_DEFINE and AC_DEFINE_UNQUOTED follow:
;;; (These are used in C code)

";

if ($cvi_contents ne $new_cvi_contents) {
  unlink "lib-src/config.values.in";
  open (CVI, "> lib-src/config.values.in")
    or die "lib-src/config.values.in: $!";
  print CVI $new_cvi_contents;
  close CVI
    or die "lib-src/config.values.in: $!";
}
