/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.grpc.json;

import com.google.protobuf.DescriptorProtos;
import com.intellij.httpClient.grpc.ProtoFileUtilsKt;
import com.intellij.httpClient.grpc.json.GrpcJsonSchemaBuilder;
import com.intellij.httpClient.grpc.json.GrpcResolveUtils;
import com.intellij.httpClient.grpc.json.JsonSchemaData;
import com.intellij.httpClient.grpc.json.reflection.GrpcDescriptorResolver;
import com.intellij.httpClient.grpc.json.reflection.GrpcReflectedJsonSchemaBuilder;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.protobuf.lang.psi.PbMessageDefinition;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.QualifiedName;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/httpClient/grpc/json/GrpcMessageToJsonSchemaConverter;", "", "<init>", "()V", "computeReflectedSchemaData", "Lcom/intellij/openapi/vfs/VirtualFile;", "inputTypeFqn", "", "descriptors", "", "Lcom/google/protobuf/DescriptorProtos$FileDescriptorProto;", "getOrComputeSchemaData", "Lcom/intellij/httpClient/grpc/json/JsonSchemaData;", "parameterMessageDefinition", "Lcom/intellij/protobuf/lang/psi/PbMessageDefinition;", "project", "Lcom/intellij/openapi/project/Project;", "grpcRequestPsi", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "computeSchemaData", "computeSchemaFile", "computeSchemaObject", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "schemaFile", "intellij.httpClient.grpc"})
public final class GrpcMessageToJsonSchemaConverter {
    @NotNull
    public static final GrpcMessageToJsonSchemaConverter INSTANCE = new GrpcMessageToJsonSchemaConverter();

    private GrpcMessageToJsonSchemaConverter() {
    }

    @Nullable
    public final VirtualFile computeReflectedSchemaData(@NotNull String inputTypeFqn, @NotNull List<DescriptorProtos.FileDescriptorProto> descriptors) {
        String string;
        Intrinsics.checkNotNullParameter((Object)inputTypeFqn, (String)"inputTypeFqn");
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        GrpcReflectedJsonSchemaBuilder grpcReflectedJsonSchemaBuilder = GrpcReflectedJsonSchemaBuilder.Companion.messageToSchema$intellij_httpClient_grpc$default(GrpcReflectedJsonSchemaBuilder.Companion, inputTypeFqn, new GrpcDescriptorResolver(descriptors), null, 4, null);
        if (grpcReflectedJsonSchemaBuilder == null || (string = grpcReflectedJsonSchemaBuilder.build()) == null) {
            return null;
        }
        String schema = string;
        return (VirtualFile)new LightVirtualFile(inputTypeFqn + "_schema.json", (CharSequence)schema);
    }

    @Nullable
    public final JsonSchemaData getOrComputeSchemaData(@NotNull PbMessageDefinition parameterMessageDefinition, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)parameterMessageDefinition, (String)"parameterMessageDefinition");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (JsonSchemaData)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)parameterMessageDefinition, () -> GrpcMessageToJsonSchemaConverter.getOrComputeSchemaData$lambda$0(parameterMessageDefinition, project));
    }

    @Nullable
    public final JsonSchemaData getOrComputeSchemaData(@NotNull HttpRequest grpcRequestPsi, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)grpcRequestPsi, (String)"grpcRequestPsi");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = GrpcResolveUtils.INSTANCE.findRequestMethodFqn$intellij_httpClient_grpc(grpcRequestPsi);
        if (string == null) {
            return null;
        }
        String methodFqn = string;
        PbMessageDefinition pbMessageDefinition = GrpcResolveUtils.INSTANCE.resolveMethodParameter$intellij_httpClient_grpc(methodFqn, project);
        if (pbMessageDefinition == null) {
            return null;
        }
        PbMessageDefinition parameterMessageDefinition = pbMessageDefinition;
        return this.getOrComputeSchemaData(parameterMessageDefinition, project);
    }

    private final JsonSchemaData computeSchemaData(PbMessageDefinition parameterMessageDefinition, Project project) {
        VirtualFile virtualFile = this.computeSchemaFile(parameterMessageDefinition);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile schemaFile = virtualFile;
        JsonSchemaObject jsonSchemaObject = this.computeSchemaObject(schemaFile, project);
        if (jsonSchemaObject == null) {
            return null;
        }
        JsonSchemaObject schemaObject = jsonSchemaObject;
        return new JsonSchemaData(schemaFile, schemaObject);
    }

    private final VirtualFile computeSchemaFile(PbMessageDefinition parameterMessageDefinition) {
        Object object = GrpcJsonSchemaBuilder.Companion.messageToSchema$intellij_httpClient_grpc$default(GrpcJsonSchemaBuilder.Companion, parameterMessageDefinition, null, 2, null);
        if (object == null || (object = ((GrpcJsonSchemaBuilder)object).build()) == null) {
            return null;
        }
        Object schema = object;
        QualifiedName qualifiedName = parameterMessageDefinition.getQualifiedName();
        return (VirtualFile)new LightVirtualFile((qualifiedName != null ? qualifiedName.toString() : null) + "_schema.json", (CharSequence)schema);
    }

    private final JsonSchemaObject computeSchemaObject(VirtualFile schemaFile, Project project) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(schemaFile);
        if (psiFile == null) {
            return null;
        }
        PsiFile schemaPsiFile = psiFile;
        return new JsonSchemaReader(schemaFile).read(schemaPsiFile);
    }

    private static final CachedValueProvider.Result getOrComputeSchemaData$lambda$0(PbMessageDefinition $parameterMessageDefinition, Project $project) {
        Object[] objectArray = new Object[]{ProtoFileUtilsKt.getProtoModificationTracker($project)};
        return new CachedValueProvider.Result((Object)INSTANCE.computeSchemaData($parameterMessageDefinition, $project), objectArray);
    }
}

