/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.refactoring;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.extractSuper.JSCustomExtractInterfaceHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.JSInsertCastFix;
import com.intellij.lang.typescript.refactoring.TypeScriptExtractInterfaceFromTypeHandler;
import com.intellij.lang.typescript.refactoring.TypeScriptExtractNamedTypeHandler;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptExtractInterfaceFromObjectLiteralHandler
implements JSCustomExtractInterfaceHandler {
    private static final String STUB_TYPE_NAME = "_$STUB$_";

    @Override
    public boolean isAvailableOnEditorAndFile(@NotNull Editor editor, @NotNull PsiFile file) {
        JSObjectLiteralExpression literal;
        if (editor == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(1);
        }
        return (literal = TypeScriptExtractInterfaceFromObjectLiteralHandler.findObjectLiteral(editor, file)) != null && PsiTreeUtil.getParentOfType((PsiElement)literal, JSStatement.class) != null;
    }

    @Nullable
    private static JSObjectLiteralExpression findObjectLiteral(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement parent;
        PsiElement element2;
        if (editor == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(2);
        }
        if (file == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(3);
        }
        if ((element2 = file.findElementAt(editor.getCaretModel().getOffset())) != null && TypeScriptExtractInterfaceFromObjectLiteralHandler.isValidElement(element2) && (parent = element2.getParent()) instanceof JSVariable) {
            return (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)JSUtils.unparenthesize((JSExpression)((JSVariable)parent).getInitializer()), JSObjectLiteralExpression.class);
        }
        return (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, JSObjectLiteralExpression.class);
    }

    private static boolean isValidElement(PsiElement element2) {
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)element2);
        if (elementType == JSTokenTypes.IDENTIFIER) {
            return true;
        }
        if (elementType == JSTokenTypes.WHITE_SPACE) {
            return TypeScriptExtractInterfaceFromObjectLiteralHandler.isValidElement(element2.getPrevSibling());
        }
        return false;
    }

    @Override
    public void invoke(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(4);
        }
        if (file == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(5);
        }
        JSObjectLiteralExpression literal = TypeScriptExtractInterfaceFromObjectLiteralHandler.findObjectLiteral(editor, file);
        assert (literal != null);
        String semi = JSCodeStyleSettings.getSemicolon((PsiElement)literal);
        if (StringUtil.isEmptyOrSpaces((String)semi)) {
            semi = "\n";
        }
        StringBuilder typeBuilder = new StringBuilder("{");
        for (JSProperty property : literal.getProperties()) {
            typeBuilder.append(JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)property, (boolean)false));
            if (property instanceof JSFunction) {
                JSParameterList parameterList = ((JSFunction)property).getParameterList();
                if (parameterList != null) {
                    typeBuilder.append(parameterList.getText());
                    PsiElement returnTypeElement = ((JSFunction)property).getReturnTypeElement();
                    if (returnTypeElement != null) {
                        typeBuilder.append(": ").append(returnTypeElement.getText());
                    } else {
                        JSType returnType2 = ((JSFunction)property).getReturnType();
                        if (returnType2 != null) {
                            typeBuilder.append(": ").append(TypeScriptExtractInterfaceFromObjectLiteralHandler.getTypeText(returnType2, (PsiElement)literal));
                        }
                    }
                    typeBuilder.append(semi);
                    continue;
                }
                TypeScriptExtractInterfaceFromObjectLiteralHandler.addTypeTextOrAny(semi, typeBuilder, property);
                continue;
            }
            TypeScriptExtractInterfaceFromObjectLiteralHandler.addTypeTextOrAny(semi, typeBuilder, property);
        }
        typeBuilder.append("}");
        PsiElement parent = literal.getParent();
        while (parent instanceof JSParenthesizedExpression) {
            parent = parent.getParent();
        }
        PsiElement finalParent = parent;
        WriteCommandAction.runWriteCommandAction((Project)file.getProject(), (String)JavaScriptBundle.message((String)"extract.interface.command.name", (Object[])new Object[0]), null, () -> TypeScriptExtractInterfaceFromObjectLiteralHandler.doExtract(editor, typeBuilder.toString(), finalParent, literal), (PsiFile[])new PsiFile[]{file});
    }

    private static void addTypeTextOrAny(String semi, StringBuilder typeBuilder, JSProperty property) {
        typeBuilder.append(": ");
        JSType type2 = JSResolveUtil.getExpressionJSType((JSExpression)property.getValue());
        typeBuilder.append(type2 == null ? "any" : TypeScriptExtractInterfaceFromObjectLiteralHandler.getTypeText(type2, (PsiElement)property)).append(semi);
    }

    @NotNull
    private static String getTypeText(JSType type2, PsiElement context2) {
        Int2ObjectOpenHashMap typeofTypes = new Int2ObjectOpenHashMap();
        IntRef counter = new IntRef(0);
        type2 = type2.transformTypeHierarchy(arg_0 -> TypeScriptExtractInterfaceFromObjectLiteralHandler.lambda$getTypeText$1(context2, counter, (Int2ObjectMap)typeofTypes, arg_0));
        String text = JSTypeUtils.widenLiteralTypes((JSType)type2).getTypeText(JSType.TypeTextFormat.CODE);
        IntIterator intIterator = typeofTypes.keySet().iterator();
        while (intIterator.hasNext()) {
            int key = (Integer)intIterator.next();
            text = text.replace(STUB_TYPE_NAME + key, (CharSequence)typeofTypes.get(key));
        }
        String string = text;
        if (string == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static boolean isSuitableTypeElement(PsiElement typeDeclaration) {
        if (typeDeclaration == null) {
            return true;
        }
        if (!(typeDeclaration instanceof JSTypeDeclaration)) {
            return false;
        }
        JSType parsed = ((JSTypeDeclaration)typeDeclaration).getJSType();
        return parsed instanceof JSAnyType || parsed instanceof JSObjectType || parsed instanceof JSRecordTypeImpl && !((JSRecordTypeImpl)parsed).hasMembers();
    }

    private static boolean isSuitableParent(@NotNull PsiElement parent) {
        if (parent == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(7);
        }
        return parent instanceof JSField || parent instanceof JSVariable && parent.getParent() instanceof JSVarStatement;
    }

    private static void doExtract(@NotNull Editor editor, @NotNull String typeDesc, @NotNull PsiElement parent, @NotNull JSObjectLiteralExpression literal) {
        TypeScriptExtractNamedTypeHandler.Candidate typeCandidate;
        if (editor == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(8);
        }
        if (typeDesc == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(9);
        }
        if (parent == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(10);
        }
        if (literal == null) {
            TypeScriptExtractInterfaceFromObjectLiteralHandler.$$$reportNull$$$0(11);
        }
        JSObjectLiteralExpression scope2 = literal;
        String nameCandidate = null;
        if (TypeScriptExtractInterfaceFromObjectLiteralHandler.isSuitableParent(parent) && TypeScriptExtractInterfaceFromObjectLiteralHandler.isSuitableTypeElement(((JSTypeDeclarationOwner)parent).getTypeElement())) {
            if (parent instanceof JSNamedElement) {
                nameCandidate = ((JSNamedElement)parent).getName();
            }
            JSRefactoringUtil.setType((JSElement)parent, typeDesc);
            JSTypeDeclaration typeElement = (JSTypeDeclaration)((JSTypeDeclarationOwner)parent).getTypeElement();
            assert (typeElement != null);
            typeCandidate = new TypeScriptExtractNamedTypeHandler.Candidate(typeElement, null);
        } else {
            String castText = JSInsertCastFix.getCast(typeDesc, literal.getText(), parent);
            JSExpression expression = JSPsiElementFactory.createJSExpression((String)castText, (PsiElement)parent);
            expression = literal.replace(expression);
            scope2 = expression;
            TypeScriptType type2 = TypeScriptExtractInterfaceFromObjectLiteralHandler.getTypeElementFromCast((PsiElement)expression);
            assert (type2 != null);
            typeCandidate = new TypeScriptExtractNamedTypeHandler.Candidate((JSTypeDeclaration)type2, null);
        }
        final String derivedName = nameCandidate;
        TypeScriptExtractInterfaceFromTypeHandler handler = new TypeScriptExtractInterfaceFromTypeHandler(){

            @Override
            @NotNull
            protected List<String> getNameCandidates(@NotNull JSElement scope2, JSType jsType) {
                if (scope2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (derivedName != null) {
                    List<String> list = Collections.singletonList(JSNameSuggestionsUtil.ensureUniqueVariableName(StringUtil.capitalize((String)derivedName), (PsiElement)scope2, new HashSet<String>(), false));
                    if (list == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                List<String> list = super.getNameCandidates(scope2, jsType);
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/refactoring/TypeScriptExtractInterfaceFromObjectLiteralHandler$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/refactoring/TypeScriptExtractInterfaceFromObjectLiteralHandler$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNameCandidates";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getNameCandidates";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
        typeCandidate = handler.adjustCandidate(typeCandidate);
        Pair<JSElement, TypeScriptExtractNamedTypeHandler.GenericsInfo> scopeAndGenerics = TypeScriptExtractNamedTypeHandler.getScopeAndGenerics(typeCandidate);
        TypeScriptExtractNamedTypeHandler.getScopeAndGenerics((PsiElement)scope2, null, (Ref<PsiElement>)Ref.create(), (TypeScriptExtractNamedTypeHandler.GenericsInfo)scopeAndGenerics.second);
        handler.invokeForOccurrences(editor, typeCandidate, ContainerUtil.emptyList(), (JSElement)scopeAndGenerics.first, (TypeScriptExtractNamedTypeHandler.GenericsInfo)scopeAndGenerics.second);
    }

    private static TypeScriptType getTypeElementFromCast(PsiElement expression) {
        if (expression instanceof JSParenthesizedExpression) {
            expression = ((JSParenthesizedExpression)expression).getInnerExpression();
        }
        assert (expression instanceof TypeScriptCastExpression);
        return ((TypeScriptCastExpression)expression).isConstCast() ? null : ((TypeScriptCastExpression)expression).getType();
    }

    private static /* synthetic */ JSType lambda$getTypeText$1(PsiElement context2, IntRef counter, Int2ObjectMap typeofTypes, JSType t) {
        String desc;
        JSType evaluated;
        if (t instanceof JSTypeofTypeImpl && JSTypeUtils.hasForeignGenericParameter((JSType)(evaluated = t.substitute(context2))) && (desc = ((JSTypeofTypeImpl)t).getTypeofDesc(context2)) != null) {
            int integer = counter.get();
            typeofTypes.put(integer, (Object)desc);
            counter.set(integer + 1);
            return JSNamedTypeFactory.createType((String)(STUB_TYPE_NAME + integer), (JSTypeSource)t.getSource(), (JSContext)JSContext.INSTANCE);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/refactoring/TypeScriptExtractInterfaceFromObjectLiteralHandler";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDesc";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/refactoring/TypeScriptExtractInterfaceFromObjectLiteralHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnEditorAndFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findObjectLiteral";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableParent";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doExtract";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

