/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.destructuring;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.destructuring.JSDestructuringPropagationIntentionBase;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.lang.javascript.refactoring.introduceVariable.ES6IntroduceVariableFromDestructuringHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Triple;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringToReferencesAndIndexersIntention
extends JSDestructuringPropagationIntentionBase
implements LowPriorityAction {
    @Override
    protected void appendDestructuringInitializer(DoubleList indices, List<String> leftHandSides, List<Triple<String, String, String>> propertyData, StringBuilder destructuringString) {
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (project == null) {
            JSDestructuringToReferencesAndIndexersIntention.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            JSDestructuringToReferencesAndIndexersIntention.$$$reportNull$$$0(1);
        }
        final Stack keys = new Stack();
        PsiElement statement = JSDestructuringToReferencesAndIndexersIntention.getSuitableStatement(element2);
        JSDestructuringElement destructuringElement = JSDestructuringToReferencesAndIndexersIntention.findElement(element2, editor, true);
        assert (destructuringElement != null);
        assert (statement != null);
        final LinkedHashMap variables = new LinkedHashMap();
        new JSRecursiveWalkingElementVisitor(this){

            public void visitJSDestructuringElement(@NotNull JSDestructuringElement destructuringElement) {
                if (destructuringElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.pushKey((PsiElement)destructuringElement, destructuringElement.getParent());
                super.visitJSDestructuringElement(destructuringElement);
            }

            private void pushKey(PsiElement destructuringElement, PsiElement parent) {
                JSDestructuringPropagationIntentionBase.Key key = 1.getKey(destructuringElement, parent);
                if (key != null) {
                    keys.push((Object)key);
                }
            }

            @Nullable
            private static JSDestructuringPropagationIntentionBase.Key getKey(PsiElement destructuringElement, PsiElement parent) {
                JSDestructuringPropagationIntentionBase.Key k = null;
                if (parent instanceof JSDestructuringArray) {
                    Object[] elements = ((JSDestructuringArray)parent).getElementsWithRest();
                    int key = ArrayUtil.indexOf((Object[])elements, (Object)destructuringElement);
                    if (key >= 0) {
                        k = JSDestructuringPropagationIntentionBase.Key.from(key, elements[key] instanceof JSDestructuringArrayRestElement);
                    }
                } else if (parent instanceof JSDestructuringProperty) {
                    k = JSDestructuringPropagationIntentionBase.Key.from(JSDestructuringPropagationIntentionBase.getPropertyName((JSDestructuringProperty)parent), ((JSDestructuringProperty)parent).isRest());
                }
                return k;
            }

            public void visitJSVariable(@NotNull JSVariable node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.pushKey((PsiElement)node, node.getParent());
                variables.put(node, new ArrayList(keys));
                super.visitJSVariable(node);
            }

            protected void elementFinished(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((element2 instanceof JSVariable || element2 instanceof JSDestructuringElement) && 1.getKey(element2, element2.getParent()) != null && !keys.isEmpty()) {
                    keys.pop();
                }
                super.elementFinished(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "destructuringElement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/intentions/destructuring/JSDestructuringToReferencesAndIndexersIntention$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSDestructuringElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSVariable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visitElement((PsiElement)destructuringElement);
        JSExpression rhs = destructuringElement.getInitializer();
        boolean hasSideEffects = JSDestructuringToReferencesAndIndexersIntention.hasSideEffects((PsiElement)rhs);
        String newVarName = JSNameSuggestionsUtil.generateUniqueVariableNameAtPlace((PsiElement)(rhs == null ? destructuringElement : rhs));
        List entries = ContainerUtil.reverse(new ArrayList(variables.entrySet()));
        String quote = JSCodeStyleSettings.getQuote((PsiElement)destructuringElement);
        HashMap<JSVariable, Collection> varsToRefs = new HashMap<JSVariable, Collection>();
        boolean hasUsages2 = false;
        for (Map.Entry entry : entries) {
            Collection references;
            try {
                references = (Collection)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (Collection)ReadAction.compute(() -> ReferencesSearch.search((PsiElement)((PsiElement)entry.getKey())).findAll()), JavaScriptBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, project);
            }
            catch (ProcessCanceledException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message((String)"dialog.message.usages.search.was.interrupted", (Object[])new Object[0]), (String)JavaScriptBundle.message((String)"dialog.title.cannot.convert", (Object[])new Object[0]), null);
                return;
            }
            if (JSDestructuringToReferencesAndIndexersIntention.hasSideEffects(references) && ((JSVariable)entry.getKey()).getDeclarationScope() instanceof XmlTag) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message((String)"dialog.message.cannot.proceed.when.having.non.read.usages.in.embedded.expressions", (Object[])new Object[0]), (String)JavaScriptBundle.message((String)"dialog.title.cannot.convert", (Object[])new Object[0]), null);
                return;
            }
            hasUsages2 |= !references.isEmpty();
            varsToRefs.put((JSVariable)entry.getKey(), references);
        }
        if (!hasUsages2) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message((String)"dialog.message.variables.from.destructuring.pattern.have.no.usages", (Object[])new Object[0]), (String)JavaScriptBundle.message((String)"dialog.title.cannot.convert", (Object[])new Object[0]), null);
            return;
        }
        for (Map.Entry entry : entries) {
            JSVariable variable = (JSVariable)entry.getKey();
            Collection references = (Collection)varsToRefs.get(variable);
            List tail = (List)entry.getValue();
            boolean dueToSideEffects = JSDestructuringToReferencesAndIndexersIntention.hasSideEffects(references);
            if (dueToSideEffects || variable.getInitializer() != null) {
                JSDestructuringToReferencesAndIndexersIntention.runWriteAction(() -> JSDestructuringToReferencesAndIndexersIntention.introduceVar(project, variable, tail, statement, destructuringElement, dueToSideEffects && hasSideEffects || rhs == null ? newVarName : rhs.getText(), quote));
                continue;
            }
            for (PsiReference reference : references) {
                assert (reference instanceof JSReferenceExpression);
                StringBuilder builder2 = new StringBuilder();
                builder2.append(hasSideEffects ? newVarName : rhs.getText());
                JSDestructuringToReferencesAndIndexersIntention.appendTail(tail, builder2, project, quote);
                PsiElement parent = ((JSReferenceExpression)reference).getParent();
                if (parent instanceof JSProperty && ((JSProperty)parent).isShorthanded()) {
                    JSDestructuringToReferencesAndIndexersIntention.runWriteAction(() -> ES6ChangeUtil.expandShorthandPropertyWithValue((JSProperty)((JSProperty)parent), (String)builder2.toString()));
                    continue;
                }
                JSExpression newExpression = JSPsiElementFactory.createJSExpression((String)builder2.toString(), (PsiElement)((PsiElement)reference));
                JSDestructuringToReferencesAndIndexersIntention.runWriteAction(() -> ((JSReferenceExpression)reference).replace(newExpression));
            }
        }
        if (!hasSideEffects) {
            JSDestructuringToReferencesAndIndexersIntention.runWriteAction(() -> JSDestructuringToReferencesAndIndexersIntention.deleteDestructuringItem((PsiElement)destructuringElement, (JSDestructuringContainer)ObjectUtils.tryCast((Object)destructuringElement.getParent(), JSDestructuringContainer.class)));
        } else {
            String initializer = rhs == null ? "" : " = " + rhs.getText();
            PsiElement typeElement = destructuringElement.getTypeElement();
            String typeAnnotation = typeElement == null ? "" : ": " + typeElement.getText();
            PsiElement it = JSPsiElementFactory.createParameterOrVariableItem((String)(newVarName + typeAnnotation + initializer), (PsiElement)statement, (boolean)(statement instanceof JSCatchBlock), (boolean)(statement instanceof JSParameterList));
            Ref newVarRef = new Ref();
            JSDestructuringToReferencesAndIndexersIntention.runWriteAction(() -> newVarRef.set((Object)JSDestructuringToReferencesAndIndexersIntention.replaceWithDestructuring((PsiElement)destructuringElement, destructuringElement.getParent(), it, true)));
            PsiElement newVariable = (PsiElement)newVarRef.get();
            if (newVariable instanceof JSVariable && newVariable.isValid()) {
                JSRefactoringUtil.suggestSameFileRename(newVariable.getContainingFile(), editor, (PsiNameIdentifierOwner)((JSVariable)newVariable), ((JSVariable)newVariable).getName());
            }
        }
    }

    @Nullable
    private static JSDestructuringElement findElement(@NotNull PsiElement element2, @NotNull Editor editor, boolean inSelectionScope) {
        if (element2 == null) {
            JSDestructuringToReferencesAndIndexersIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            JSDestructuringToReferencesAndIndexersIntention.$$$reportNull$$$0(3);
        }
        Condition isInRange = Conditions.alwaysTrue();
        SelectionModel model = editor.getSelectionModel();
        if (inSelectionScope && model.hasSelection()) {
            int start = model.getSelectionStart();
            int end = model.getSelectionEnd();
            TextRange selectionRange = new TextRange(start, end);
            isInRange = e -> selectionRange.contains(e.getTextRange());
        }
        JSDestructuringElement destructuringElement = (JSDestructuringElement)PsiTreeUtil.getParentOfType((PsiElement)element2, JSDestructuringElement.class);
        JSDestructuringElement item = (JSDestructuringElement)PsiTreeUtil.getParentOfType((PsiElement)destructuringElement, JSDestructuringElement.class);
        while (item != null && isInRange.value((Object)item)) {
            destructuringElement = item;
            item = (JSDestructuringElement)PsiTreeUtil.getParentOfType((PsiElement)destructuringElement, JSDestructuringElement.class);
        }
        return destructuringElement;
    }

    private static void appendTail(List<JSDestructuringPropagationIntentionBase.Key> tail, StringBuilder builder2, Project project, String quote) {
        for (JSDestructuringPropagationIntentionBase.Key key : tail) {
            String stringKey = key.stringKey;
            if (stringKey != null) {
                if (JSRefactoringUtil.isValidIdentifier(stringKey, project)) {
                    builder2.append(".").append(stringKey);
                    continue;
                }
                Object appendBefore = stringKey.startsWith("[") ? "" : "[" + quote;
                Object appendAfter = stringKey.startsWith("[") ? "" : quote + "]";
                builder2.append((String)appendBefore).append(StringUtil.unquoteString((String)stringKey)).append((String)appendAfter);
                continue;
            }
            builder2.append("[").append(key.numericKey).append("]");
        }
    }

    @NotNull
    private static JSVarStatement.VarKeyword getVarKeyword(JSVariable variable) {
        JSVarStatement.VarKeyword keyword;
        JSVarStatement statement = variable.getStatement();
        if (statement != null && (keyword = statement.getVarKeyword()) != null) {
            JSVarStatement.VarKeyword varKeyword = keyword;
            if (varKeyword == null) {
                JSDestructuringToReferencesAndIndexersIntention.$$$reportNull$$$0(4);
            }
            return varKeyword;
        }
        JSVarStatement.VarKeyword varKeyword = JSVarStatement.VarKeyword.CONST;
        if (varKeyword == null) {
            JSDestructuringToReferencesAndIndexersIntention.$$$reportNull$$$0(5);
        }
        return varKeyword;
    }

    private static void introduceVar(Project project, JSVariable variable, List<JSDestructuringPropagationIntentionBase.Key> value, PsiElement statement, JSDestructuringElement destructuringElement, String newVarName, String quote) {
        StringBuilder builder2 = new StringBuilder(JSDestructuringToReferencesAndIndexersIntention.getVarKeyword(variable).getText()).append(" ").append(variable.getName()).append(" = ").append(newVarName);
        JSDestructuringToReferencesAndIndexersIntention.appendTail(value, builder2, project, quote);
        JSExpression initializer = variable.getInitializer();
        if (initializer != null) {
            builder2.append(" === undefined ? ").append(initializer.getText()).append(" : ").append(newVarName);
            JSDestructuringToReferencesAndIndexersIntention.appendTail(value, builder2, project, quote);
        }
        builder2.append(JSCodeStyleSettings.getSemicolon((PsiElement)variable));
        JSVarStatement newStatement = (JSVarStatement)JSPsiElementFactory.createJSStatement((String)builder2.toString(), (PsiElement)statement, JSVarStatement.class);
        PsiElement parent = destructuringElement.getParent();
        if (parent instanceof JSVarStatement) {
            PsiElement comma = parent.addAfter(JSChangeUtil.createTokenElement((PsiElement)statement, (IElementType)JSTokenTypes.COMMA, (CharSequence)","), (PsiElement)destructuringElement);
            parent.addAfter((PsiElement)newStatement.getVariables()[0], comma);
        } else {
            ES6IntroduceVariableFromDestructuringHandler.addStatement((JSElement)statement, newStatement);
        }
    }

    private static boolean hasSideEffects(Collection<PsiReference> references) {
        for (PsiReference reference : references) {
            if (!(reference instanceof JSReferenceExpression)) {
                return true;
            }
            JSReferenceExpression expression = (JSReferenceExpression)reference;
            if (SideEffectChecker.mayHaveSideEffects((JSExpression)expression)) {
                return true;
            }
            if (JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)expression) == ReadWriteAccessDetector.Access.Read) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSideEffects(PsiElement rhs) {
        if (rhs == null) {
            return true;
        }
        if (!(rhs instanceof JSReferenceExpression)) {
            return true;
        }
        JSExpression qualifier = ((JSReferenceExpression)rhs).getQualifier();
        return qualifier != null && JSDestructuringToReferencesAndIndexersIntention.hasSideEffects((PsiElement)qualifier);
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"refactoring.destructuring.vars.intention.depropagate", (Object[])new Object[0]);
        if (string == null) {
            JSDestructuringToReferencesAndIndexersIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    @IntentionName
    protected String getDescription() {
        String string = JavaScriptBundle.message((String)"refactoring.destructuring.vars.intention.depropagate", (Object[])new Object[0]);
        if (string == null) {
            JSDestructuringToReferencesAndIndexersIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    protected boolean isAvailableOnElement(@NotNull PsiElement element2, Project project, Editor editor) {
        if (element2 == null) {
            JSDestructuringToReferencesAndIndexersIntention.$$$reportNull$$$0(8);
        }
        return JSDestructuringToReferencesAndIndexersIntention.getSuitableStatement(element2) != null && JSDestructuringToReferencesAndIndexersIntention.isValidElement(JSDestructuringToReferencesAndIndexersIntention.findElement(element2, editor, false));
    }

    private static boolean isValidElement(final JSDestructuringElement element2) {
        if (element2 == null) {
            return false;
        }
        final Ref isValid = Ref.create((Object)true);
        final Ref hasUsages2 = Ref.create((Object)false);
        new JSRecursiveWalkingElementVisitor(){

            public void visitJSDestructuringElement(@NotNull JSDestructuringElement destructuringElement) {
                if (destructuringElement == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (destructuringElement != element2 && destructuringElement.getInitializer() != null) {
                    isValid.set((Object)false);
                }
                super.visitJSDestructuringElement(destructuringElement);
            }

            public void visitES6ComputedName(@NotNull ES6ComputedName node) {
                JSExpression expression;
                if (node == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((expression = node.getExpression()) != null && SideEffectChecker.mayHaveSideEffects(expression)) {
                    isValid.set((Object)false);
                }
            }

            public void visitJSDestructuringArrayRestElement(@NotNull JSDestructuringArrayRestElement jsDestructuringArrayRest) {
                if (jsDestructuringArrayRest == null) {
                    2.$$$reportNull$$$0(2);
                }
                isValid.set((Object)false);
                super.visitJSDestructuringArrayRestElement(jsDestructuringArrayRest);
            }

            public void visitJSDestructuringProperty(@NotNull JSDestructuringProperty destructuringProperty) {
                if (destructuringProperty == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (destructuringProperty.isRest()) {
                    isValid.set((Object)false);
                }
                super.visitJSDestructuringProperty(destructuringProperty);
            }

            public void visitJSVariable(@NotNull JSVariable node) {
                if (node == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (!node.isLocal() || ReferencesSearch.search((PsiElement)node, (SearchScope)node.getUseScope()).findFirst() != null) {
                    hasUsages2.set((Object)true);
                }
                super.visitJSVariable(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "destructuringElement";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jsDestructuringArrayRest";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "destructuringProperty";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/intentions/destructuring/JSDestructuringToReferencesAndIndexersIntention$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSDestructuringElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6ComputedName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSDestructuringArrayRestElement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSDestructuringProperty";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSVariable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visitElement((PsiElement)element2);
        return (Boolean)isValid.get() != false && (Boolean)hasUsages2.get() != false;
    }

    @Nullable
    private static PsiElement getSuitableStatement(PsiElement element2) {
        JSElement parent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])new Class[]{JSParameterList.class, JSCatchBlock.class, JSVarStatement.class, JSEmbeddedContent.class});
        if (parent == null) {
            return null;
        }
        return parent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/destructuring/JSDestructuringToReferencesAndIndexersIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/destructuring/JSDestructuringToReferencesAndIndexersIntention";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarKeyword";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

