/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.JSSwitchBranchesProcessor;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSMissingSwitchBranchesInspection
extends JSInspection {
    public boolean ignoreSwitchStatementsWithDefault = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreSwitchStatementsWithDefault", (String)JavaScriptBundle.message((String)"js.missing.switch.branches.ignore.with.default", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    private boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){

            public void visitJSSwitchStatement(@NotNull JSSwitchStatement switchStatement) {
                if (switchStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                List<JSSwitchBranchesProcessor.JSEnumValue> allCases = JSSwitchBranchesProcessor.getAllCaseVariants(switchStatement);
                List<JSSwitchBranchesProcessor.JSCaseClauseValue> existingVariants = JSSwitchBranchesProcessor.getExistingVariants(switchStatement);
                Set<Object> existingValues = JSSwitchBranchesProcessor.getExistingValues(existingVariants);
                List<String> missingCases = allCases.stream().filter(c -> !existingValues.contains(c.value())).map(c -> 1.fixQualifiersAndQuotes(c)).toList();
                if (missingCases.isEmpty()) {
                    return;
                }
                String missingCasesString = StringUtil.join(missingCases, (String)", ");
                ProblemHighlightType highlighting = JSMissingSwitchBranchesInspection.this.ignoreSwitchStatementsWithDefault && JSMissingSwitchBranchesInspection.hasDefault(switchStatement) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                String message = JavaScriptBundle.message((String)"js.missing.switch.branches.inspection.desc", (Object[])new Object[]{missingCasesString});
                List<Pair<Integer, String>> oldFormat = 1.toOffsetsAndValues(allCases, existingVariants);
                JSCreateSwitchBranchesFix fix = new JSCreateSwitchBranchesFix(oldFormat, missingCasesString);
                if (highlighting == ProblemHighlightType.INFORMATION || InspectionProjectProfileManager.isInformationLevel((String)JSMissingSwitchBranchesInspection.this.getShortName(), (PsiElement)switchStatement)) {
                    holder.registerProblem((PsiElement)switchStatement, message, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{fix});
                } else {
                    JSMissingSwitchBranchesInspection.registerOnSwitchStatement(switchStatement, message, (LocalQuickFix)fix, holder, JSMissingSwitchBranchesInspection.this.isOnTheFly());
                }
            }

            @NotNull
            private static List<Pair<Integer, String>> toOffsetsAndValues(@NotNull List<JSSwitchBranchesProcessor.JSEnumValue> allCases, @NotNull List<JSSwitchBranchesProcessor.JSCaseClauseValue> existingVariants) {
                if (allCases == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (existingVariants == null) {
                    1.$$$reportNull$$$0(2);
                }
                HashMap<Object, JSSwitchBranchesProcessor.JSCaseClauseValue> valueToExistingVariantMap = new HashMap<Object, JSSwitchBranchesProcessor.JSCaseClauseValue>(existingVariants.size());
                for (JSSwitchBranchesProcessor.JSCaseClauseValue existingVariant : existingVariants) {
                    Object value = existingVariant.value().value();
                    valueToExistingVariantMap.putIfAbsent(value, existingVariant);
                }
                List list = ContainerUtil.map(allCases, possibleCase -> {
                    String name = possibleCase.asPropertyName('\'');
                    JSSwitchBranchesProcessor.JSCaseClauseValue existingVariant = (JSSwitchBranchesProcessor.JSCaseClauseValue)valueToExistingVariantMap.get(possibleCase.value());
                    if (existingVariant != null) {
                        return Pair.create((Object)existingVariant.clause().getTextOffset(), (Object)name);
                    }
                    return Pair.create((Object)-1, (Object)name);
                });
                if (list == null) {
                    1.$$$reportNull$$$0(3);
                }
                return list;
            }

            @NotNull
            private static String fixQualifiersAndQuotes(@NotNull JSSwitchBranchesProcessor.JSEnumValue enumValue) {
                if (enumValue == null) {
                    1.$$$reportNull$$$0(4);
                }
                String result2 = enumValue.asPropertyName('\'');
                if (enumValue.enumFieldName() != null) {
                    int dot = result2.lastIndexOf(46);
                    if (dot >= 0) {
                        result2 = result2.substring(dot + 1);
                    }
                } else {
                    result2 = StringUtil.unquoteString((String)result2);
                }
                String string = "'" + result2 + "'";
                if (string == null) {
                    1.$$$reportNull$$$0(5);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "switchStatement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "allCases";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "existingVariants";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/inspections/JSMissingSwitchBranchesInspection$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "enumValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMissingSwitchBranchesInspection$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "toOffsetsAndValues";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fixQualifiersAndQuotes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitJSSwitchStatement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "toOffsetsAndValues";
                        break;
                    }
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "fixQualifiersAndQuotes";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 5 -> new IllegalStateException(string);
                };
            }
        };
    }

    static void registerOnSwitchStatement(@NotNull JSSwitchStatement switchStatement, @NotNull @InspectionMessage String message, LocalQuickFix fix, @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (switchStatement == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(3);
        }
        if (message == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(5);
        }
        int length = switchStatement.getFirstChild().getTextLength();
        holder.registerProblem((PsiElement)switchStatement, new TextRange(0, length), message, new LocalQuickFix[]{fix});
        if (onTheFly) {
            holder.registerProblem((PsiElement)switchStatement, message, ProblemHighlightType.INFORMATION, new TextRange(length, switchStatement.getTextLength()), new LocalQuickFix[]{fix});
        }
    }

    static boolean hasDefault(@NotNull JSSwitchStatement switchStatement) {
        if (switchStatement == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(6);
        }
        return ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)switchStatement).forceIgnore(e -> e instanceof JSSwitchStatement)).filter(JSCaseClause.class).filter(c -> c.isDefault()).isNotEmpty();
    }

    static JSCaseClause createCaseClause(@Nullable String variant, @NotNull PsiElement context2) {
        if (context2 == null) {
            JSMissingSwitchBranchesInspection.$$$reportNull$$$0(7);
        }
        Object caseText = variant == null ? "default" : "case " + variant;
        return ((JSSwitchStatement)JSPsiElementFactory.createJSStatement((String)("switch (q) {" + (String)caseText + ": break; }"), (PsiElement)context2, JSSwitchStatement.class)).getCaseClauses()[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSMissingSwitchBranchesInspection";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMissingSwitchBranchesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerOnSwitchStatement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasDefault";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCaseClause";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static final class JSCreateSwitchBranchesFix
    extends PsiUpdateModCommandQuickFix {
        private final List<Pair<Integer, String>> myCases;
        private final String myMissingCasesString;
        private static final int MAX_TEXT_LENGTH = 40;

        private JSCreateSwitchBranchesFix(List<Pair<Integer, String>> cases, String missingCasesString) {
            this.myCases = cases;
            this.myMissingCasesString = missingCasesString.length() > 40 ? JSCreateSwitchBranchesFix.trimDesc(missingCasesString) : missingCasesString;
        }

        @NotNull
        private static String trimDesc(String missingCasesString) {
            int lastFitComma = missingCasesString.indexOf(44, 40);
            String string = (lastFitComma != -1 ? missingCasesString.substring(0, lastFitComma + 1) : missingCasesString.substring(0, 40)) + " ...";
            if (string == null) {
                JSCreateSwitchBranchesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.create.switch.cases", (Object[])new Object[0]);
            if (string == null) {
                JSCreateSwitchBranchesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = JavaScriptBundle.message((String)"js.create.switch.cases.fix", (Object[])new Object[]{this.myMissingCasesString});
            if (string == null) {
                JSCreateSwitchBranchesFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element2, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                JSCreateSwitchBranchesFix.$$$reportNull$$$0(3);
            }
            if (element2 == null) {
                JSCreateSwitchBranchesFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                JSCreateSwitchBranchesFix.$$$reportNull$$$0(5);
            }
            JSSwitchStatement statement = (JSSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, JSSwitchStatement.class, (boolean)false);
            assert (statement != null);
            Int2ObjectOpenHashMap pointers = new Int2ObjectOpenHashMap();
            PsiFile file = element2.getContainingFile();
            for (Pair<Integer, String> variant : this.myCases) {
                JSCaseClause caseClause;
                int first = (Integer)variant.first;
                if (first == -1 || (caseClause = (JSCaseClause)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(first), JSCaseClause.class)) == null) continue;
                pointers.put(first, (Object)SmartPointerManager.createPointer((PsiElement)caseClause));
            }
            PsiElement lBrace = ImportUtils.findLBrace((JSElement)statement);
            if (lBrace == null) {
                String statementText = statement.getText() + "{}";
                statement = (JSSwitchStatement)JSChangeUtil.replaceStatement((JSStatement)statement, (JSStatement)JSPsiElementFactory.createJSStatement((String)statementText, (PsiElement)statement, JSSwitchStatement.class));
                lBrace = ImportUtils.findLBrace((JSElement)statement);
            }
            int anchorOffset = -1;
            PsiElement anchor = lBrace;
            for (Pair<Integer, String> variant : this.myCases) {
                JSCaseClause clause;
                SmartPsiElementPointer pointer;
                if ((Integer)variant.first != -1) {
                    anchorOffset = (Integer)variant.first;
                    continue;
                }
                if (anchorOffset != -1 && (pointer = (SmartPsiElementPointer)pointers.get(anchorOffset)) != null && (clause = (JSCaseClause)pointer.getElement()) != null && JSCreateSwitchBranchesFix.exitsWithBreak(clause)) {
                    anchor = clause;
                }
                anchor = statement.addAfter((PsiElement)JSMissingSwitchBranchesInspection.createCaseClause((String)variant.second, (PsiElement)statement), anchor);
                anchorOffset = -1;
            }
        }

        private static boolean exitsWithBreak(@NotNull JSCaseClause clause) {
            JSSourceElement[] statements;
            if (clause == null) {
                JSCreateSwitchBranchesFix.$$$reportNull$$$0(6);
            }
            return (statements = clause.getStatementListItems()).length >= 1 && statements[statements.length - 1] instanceof JSBreakStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSMissingSwitchBranchesInspection$JSCreateSwitchBranchesFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clause";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "trimDesc";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMissingSwitchBranchesInspection$JSCreateSwitchBranchesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "exitsWithBreak";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

