/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aqua.runners.cypress;

import com.intellij.aqua.runners.cypress.AquaRunnersCypressBundle;
import com.intellij.aqua.runners.cypress.CypressConfigurationType;
import com.intellij.aqua.runners.cypress.CypressConstantsKt;
import com.intellij.aqua.runners.cypress.CypressDetector;
import com.intellij.aqua.runners.cypress.CypressRunConfiguration;
import com.intellij.aqua.runners.cypress.CypressRunSettings;
import com.intellij.aqua.runners.js.core.ExtendedJsTestRunConfigurationProducer;
import com.intellij.aqua.runners.js.core.JsTestRunSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testFramework.util.CypressDetectionUtils;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0002H\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J&\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0002H\u0002J\u0014\u0010\u001f\u001a\u00020\u000b*\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/aqua/runners/cypress/CypressRunConfigurationProducer;", "Lcom/intellij/aqua/runners/js/core/ExtendedJsTestRunConfigurationProducer;", "Lcom/intellij/aqua/runners/cypress/CypressRunSettings;", "Lcom/intellij/aqua/runners/cypress/CypressRunConfiguration;", "<init>", "()V", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getTestFrameworkDetector", "Lcom/intellij/aqua/runners/cypress/CypressDetector;", "setupConfigurationFromCompatibleContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "isConfigurationFromCompatibleContext", "shouldReplace", "self", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "other", "isTestRunnerAvailableFor", "element", "hasCommonTestsDirInAnyPathsOfSettings", "settings", "isCypressRunnerAvailableFor", "buildContextSettings", "Lkotlin/Pair;", "templateRunSettings", "hasPackage", "Lcom/intellij/javascript/nodejs/PackageJsonData;", "packageDescriptor", "Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;", "intellij.aqua.runners.cypress"})
@SourceDebugExtension(value={"SMAP\nCypressRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CypressRunConfigurationProducer.kt\ncom/intellij/aqua/runners/cypress/CypressRunConfigurationProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1869#2,2:109\n*S KotlinDebug\n*F\n+ 1 CypressRunConfigurationProducer.kt\ncom/intellij/aqua/runners/cypress/CypressRunConfigurationProducer\n*L\n98#1:109,2\n*E\n"})
public final class CypressRunConfigurationProducer
extends ExtendedJsTestRunConfigurationProducer<CypressRunSettings, CypressRunConfiguration> {
    public CypressRunConfigurationProducer() {
        super(CypressConstantsKt.getCYPRESS_CONFIG_FILE_NAMES());
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return (ConfigurationFactory)CypressConfigurationType.Companion.getInstance();
    }

    @Override
    @NotNull
    public CypressDetector getTestFrameworkDetector() {
        return CypressDetector.Companion.getInstance();
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull CypressRunConfiguration configuration, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        PsiElement psiElement = context2.getPsiLocation();
        if (psiElement == null) {
            return false;
        }
        PsiElement element2 = psiElement;
        if (!this.isTestRunnerAvailableFor(element2, context2)) {
            return false;
        }
        Pair<CypressRunSettings, PsiElement> pair = this.buildContextSettings(element2, configuration.getSettings());
        if (pair == null) {
            return false;
        }
        Pair<CypressRunSettings, PsiElement> pair2 = pair;
        CypressRunSettings settings = (CypressRunSettings)pair2.component1();
        PsiElement enclosingElement = (PsiElement)pair2.component2();
        switch (WhenMappings.$EnumSwitchMapping$0[settings.getScope().getKind().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                object = enclosingElement.getContainingFile();
                if (object != null && (object = object.getName()) != null) break;
                return false;
            }
            default: {
                return false;
            }
        }
        Object name = object;
        Object[] objectArray = new Object[]{name};
        configuration.setName(AquaRunnersCypressBundle.message("all.tests.in", objectArray));
        configuration.setSettings(settings);
        sourceElement.set((Object)enclosingElement);
        return true;
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull CypressRunConfiguration configuration, @NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement psiElement = context2.getPsiLocation();
        if (psiElement == null) {
            return false;
        }
        PsiElement element2 = psiElement;
        RunConfiguration runConfiguration = this.cloneTemplateConfiguration(context2).getConfiguration();
        CypressRunConfiguration cypressRunConfiguration = runConfiguration instanceof CypressRunConfiguration ? (CypressRunConfiguration)runConfiguration : null;
        if (cypressRunConfiguration == null) {
            return false;
        }
        CypressRunConfiguration templateConfiguration = cypressRunConfiguration;
        Pair<CypressRunSettings, PsiElement> pair = this.buildContextSettings(element2, templateConfiguration.getSettings());
        if (pair == null) {
            return false;
        }
        CypressRunSettings thisRunSettings = (CypressRunSettings)pair.component1();
        CypressRunSettings thatRunSettings = configuration.getSettings();
        return Intrinsics.areEqual((Object)FileUtil.toSystemIndependentName((String)thisRunSettings.getWorkingDir()), (Object)FileUtil.toSystemIndependentName((String)thatRunSettings.getWorkingDir())) && Intrinsics.areEqual((Object)thisRunSettings.getScope(), (Object)thatRunSettings.getScope());
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        RunConfiguration runConfiguration = self.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.aqua.runners.cypress.CypressRunConfiguration");
        CypressRunConfiguration cypressConfig = (CypressRunConfiguration)runConfiguration;
        return this.hasCommonTestsDirInAnyPathsOfSettings(cypressConfig.getSettings());
    }

    @Override
    public boolean isTestRunnerAvailableFor(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return super.isTestRunnerAvailableFor(element2) && this.isCypressRunnerAvailableFor(element2);
    }

    private final boolean hasCommonTestsDirInAnyPathsOfSettings(CypressRunSettings settings) {
        if (CypressDetectionUtils.INSTANCE.hasDefaultTestsDirInFilePath(settings.getWorkingDir())) {
            return true;
        }
        JsTestRunScope scope2 = settings.getScope();
        return switch (WhenMappings.$EnumSwitchMapping$0[scope2.getKind().ordinal()]) {
            case 4 -> CypressDetectionUtils.INSTANCE.hasDefaultTestsDirInFilePath(scope2.getTestDirectoryPath());
            case 1, 2, 3 -> CypressDetectionUtils.INSTANCE.hasDefaultTestsDirInFilePath(scope2.getTestFilePath());
            default -> false;
        };
    }

    private final boolean isCypressRunnerAvailableFor(PsiElement element2) {
        JSFile jsFile;
        PsiFile psiFile = element2.getContainingFile();
        JSFile jSFile = jsFile = psiFile instanceof JSFile ? (JSFile)psiFile : null;
        if (jsFile != null) {
            return CypressDetectionUtils.mightHasCypressApiCall(jsFile);
        }
        PsiDirectory psiDirectory = element2 instanceof PsiDirectory ? (PsiDirectory)element2 : null;
        if (psiDirectory == null) {
            return false;
        }
        PsiDirectory psiDirectory2 = psiDirectory;
        CypressDetector cypressDetector = CypressDetector.Companion.getInstance();
        Project project = ((PsiDirectory)element2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = psiDirectory2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return cypressDetector.hasTestsUnderDirectory(project, virtualFile);
    }

    private final Pair<CypressRunSettings, PsiElement> buildContextSettings(PsiElement element2, CypressRunSettings templateRunSettings) {
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
        if (virtualFile == null) {
            return null;
        }
        ExtendedJsTestRunConfigurationProducer.Context<JsTestRunSettings> context2 = new ExtendedJsTestRunConfigurationProducer.Context<JsTestRunSettings>(element2, element2.getContainingFile(), virtualFile, templateRunSettings);
        Pair<JsTestRunSettings, PsiElement> pair = this.tryBuildSuiteOrTestSettings(context2);
        if (pair != null) {
            Pair<JsTestRunSettings, PsiElement> it = pair;
            boolean bl = false;
            return it;
        }
        return this.tryBuildTestFileSettings(context2);
    }

    private final boolean hasPackage(PackageJsonData $this$hasPackage, NodePackageDescriptor packageDescriptor) {
        List<String> list = packageDescriptor.getPackageNames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPackageNames(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String dependency;
            String packageName = (String)element$iv;
            boolean bl = false;
            if (!$this$hasPackage.isDependencyOfAnyType(packageName) || (dependency = packageDescriptor.getDependencyByPackageName(packageName)) != null && !$this$hasPackage.isDependencyOfAnyType(dependency)) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsTestRunScopeKind.values().length];
            try {
                nArray[JsTestRunScopeKind.TEST_FILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsTestRunScopeKind.SUITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsTestRunScopeKind.TEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsTestRunScopeKind.DIRECTORY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

