/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.javascript.resolve.TSObjectTypePropertyResolverKt;
import com.intellij.javascript.types.TSSymbol;
import com.intellij.javascript.types.TSType;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyBase;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSDestructuringContext;
import com.intellij.lang.javascript.psi.util.JSDestructuringContextElement;
import com.intellij.lang.javascript.psi.util.JSDestructuringContextIndexedAccess;
import com.intellij.lang.javascript.psi.util.JSDestructuringContextProperty;
import com.intellij.lang.javascript.psi.util.JSDestructuringContextRestProperty;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference;", "Lcom/intellij/psi/PsiPolyVariantReferenceBase;", "Lcom/intellij/lang/javascript/psi/JSDestructuringProperty;", "property", "<init>", "(Lcom/intellij/lang/javascript/psi/JSDestructuringProperty;)V", "multiResolve", "", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "", "(Z)[Lcom/intellij/psi/ResolveResult;", "calculateDefaultRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getCanonicalText", "", "isReferenceTo", "element", "Lcom/intellij/psi/PsiElement;", "handleElementRename", "newElementName", "bindToElement", "Companion", "intellij.javascript.psi.impl"})
public final class JSDestructuringPropertyReference
extends PsiPolyVariantReferenceBase<JSDestructuringProperty> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public JSDestructuringPropertyReference(@NotNull JSDestructuringProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        super((PsiElement)property, true);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(((JSDestructuringProperty)this.getElement()).getContainingFile(), (PsiPolyVariantReference)this, JSDestructuringPropertyReference::multiResolve$lambda$0, incompleteCode);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"resolve(...)");
        return resolveResultArray;
    }

    @NotNull
    protected TextRange calculateDefaultRangeInElement() {
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        JSDestructuringProperty element = (JSDestructuringProperty)psiElement;
        if (element instanceof JSDestructuringPropertyBase) {
            PsiElement identifier = ((JSDestructuringPropertyBase)element).getNameIdentifierForPropertyOrNestedElement();
            if (identifier == null) {
                TextRange textRange = ((JSDestructuringProperty)this.getElement()).getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                return textRange;
            }
            int startOffsetInParent = identifier.getStartOffsetInParent();
            return new TextRange(startOffsetInParent, startOffsetInParent + identifier.getTextLength());
        }
        return new TextRange(0, element.getTextLength());
    }

    @NotNull
    public String getCanonicalText() {
        String string = ((JSDestructuringProperty)this.myElement).getName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiFile || element instanceof PsiDirectory) {
            return false;
        }
        return JSReferenceUtil.isReferenceTo((PsiPolyVariantReference)this, this.getCanonicalText(), element);
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        JSDestructuringProperty element = (JSDestructuringProperty)psiElement;
        element.setName(newElementName);
        return (PsiElement)element;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    private static final ResolveResult[] multiResolve$lambda$0(JSDestructuringPropertyReference reference, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)((Object)reference), (String)"reference");
        return JSDestructuringPropertyReference.Companion.doResolve(reference);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\tJ&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference$Companion;", "", "<init>", "()V", "doResolve", "", "Lcom/intellij/psi/ResolveResult;", "reference", "Lcom/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference;", "(Lcom/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference;)[Lcom/intellij/psi/ResolveResult;", "resolveFromInitializer", "", "Lcom/intellij/psi/PsiElement;", "initializer", "Lcom/intellij/lang/javascript/psi/JSExpression;", "destructuringContext", "Lcom/intellij/lang/javascript/psi/util/JSDestructuringContext;", "propertyName", "", "intellij.javascript.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nJSDestructuringPropertyReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSDestructuringPropertyReference.kt\ncom/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,138:1\n30#2,2:139\n30#2,2:141\n13#3:143\n13#3:144\n*S KotlinDebug\n*F\n+ 1 JSDestructuringPropertyReference.kt\ncom/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference$Companion\n*L\n71#1:139,2\n110#1:141,2\n115#1:143\n128#1:144\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ResolveResult[] doResolve(JSDestructuringPropertyReference reference) {
            ResolveResult[] resultsFromType;
            PsiElement psiElement = reference.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            JSDestructuringProperty property = (JSDestructuringProperty)psiElement;
            String propertyName = property.getName();
            if (property.getDestructuringElement() == null || propertyName == null) {
                Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return ResolveResult.EMPTY_ARRAY;
            }
            Project project = property.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<TypeScriptCompilerEvaluationFacade> serviceClass$iv = TypeScriptCompilerEvaluationFacade.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            TypeScriptCompilerEvaluationFacade typeScriptCompilerEvaluationFacade = (TypeScriptCompilerEvaluationFacade)object;
            PsiElement psiElement2 = property.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
            TSType typeFromService = typeScriptCompilerEvaluationFacade.getTSTypeFromService(psiElement2);
            if (typeFromService != null) {
                Object object2 = typeFromService.getProperty(propertyName);
                if (object2 == null || (object2 = object2.findPsiDeclarations()) == null || (object2 = CollectionsKt.toMutableSet((Iterable)((Iterable)object2))) == null) {
                    object2 = new LinkedHashSet();
                }
                Object resultElements = object2;
                JSDestructuringContext jSDestructuringContext = JSDestructuringContext.findDestructuringParents((PsiElement)property, arg_0 -> Companion.doResolve$lambda$1(Companion::doResolve$lambda$0, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jSDestructuringContext, (String)"findDestructuringParents(...)");
                JSDestructuringContext destructuringContext = jSDestructuringContext;
                JSInitializerOwner jSInitializerOwner = destructuringContext.getOuterElement();
                JSTypeDeclarationOwner jSTypeDeclarationOwner = jSInitializerOwner instanceof JSTypeDeclarationOwner ? (JSTypeDeclarationOwner)((Object)jSInitializerOwner) : null;
                if ((jSTypeDeclarationOwner != null ? jSTypeDeclarationOwner.getTypeElement() : null) != null) {
                    JSExpression initializer;
                    JSInitializerOwner jSInitializerOwner2 = destructuringContext.getOuterElement();
                    JSExpression jSExpression = initializer = jSInitializerOwner2 != null ? jSInitializerOwner2.getInitializer() : null;
                    if (initializer != null) {
                        resultElements.addAll((Collection)this.resolveFromInitializer(initializer, destructuringContext, propertyName));
                    }
                }
                ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults((Collection)resultElements);
                Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"toResolveResults(...)");
                return resolveResultArray;
            }
            JSType type = JSResolveUtil.getElementJSType(property.getParent());
            if (type != null && !((resultsFromType = TSObjectTypePropertyResolverKt.resolveObjectTypeProperty(type, propertyName)).length == 0)) {
                return resultsFromType;
            }
            WalkUpResolveProcessor processor = new WalkUpResolveProcessor(reference.getCanonicalText(), property.getContainingFile(), (PsiElement)property);
            processor.forceSetAddOnlyCompleteMatches();
            JSIndexBasedResolveUtil.processAllSymbols(processor);
            ResolveResult[] resolveResultArray = processor.getResults();
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"getResults(...)");
            return resolveResultArray;
        }

        private final List<PsiElement> resolveFromInitializer(JSExpression initializer, JSDestructuringContext destructuringContext, String propertyName) {
            List<PsiElement> list;
            Project project = initializer.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service22 = false;
            Class<TypeScriptCompilerEvaluationFacade> serviceClass$iv = TypeScriptCompilerEvaluationFacade.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            TSType tSType = ((TypeScriptCompilerEvaluationFacade)object).getTSTypeFromService((PsiElement)initializer);
            if (tSType == null) {
                return CollectionsKt.emptyList();
            }
            TSType typeBeforeLast = tSType;
            List<JSDestructuringContextElement> list2 = destructuringContext.getDestructuringContextElements();
            if (list2 == null) {
                return CollectionsKt.emptyList();
            }
            List<JSDestructuringContextElement> destructuringContextElements = list2;
            Object $i$f$service22 = CollectionsKt.last(destructuringContextElements);
            JSDestructuringContextProperty jSDestructuringContextProperty = $i$f$service22 instanceof JSDestructuringContextProperty ? (JSDestructuringContextProperty)$i$f$service22 : null;
            if (!Intrinsics.areEqual((Object)(jSDestructuringContextProperty != null ? jSDestructuringContextProperty.getName() : null), (Object)propertyName)) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(JSDestructuringPropertyReference.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Unexpected destructuring context " + CollectionsKt.last(destructuringContextElements));
                return CollectionsKt.emptyList();
            }
            for (JSDestructuringContextElement destructuringContextElement : CollectionsKt.dropLast(destructuringContextElements, (int)1)) {
                TSType tSType2;
                if (typeBeforeLast == null) break;
                JSDestructuringContextElement jSDestructuringContextElement = destructuringContextElement;
                if (jSDestructuringContextElement instanceof JSDestructuringContextProperty) {
                    TSSymbol tSSymbol = typeBeforeLast.getProperty(((JSDestructuringContextProperty)destructuringContextElement).getName());
                    tSType2 = tSSymbol != null ? tSSymbol.getType() : null;
                } else if (jSDestructuringContextElement instanceof JSDestructuringContextIndexedAccess) {
                    tSType2 = TSObjectTypePropertyResolverKt.getIndexType(typeBeforeLast, ((JSDestructuringContextIndexedAccess)destructuringContextElement).getIndex());
                } else if (jSDestructuringContextElement instanceof JSDestructuringContextRestProperty) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(JSDestructuringPropertyReference.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Unexpected rest destructuring context element");
                    tSType2 = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                typeBeforeLast = tSType2;
            }
            if ((list = typeBeforeLast) == null || (list = list.getProperty(propertyName)) == null || (list = list.findPsiDeclarations()) == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        private static final boolean doResolve$lambda$0(JSInitializerOwner it) {
            return it.hasOwnInitializer() || it instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)((Object)it)).getTypeElement() != null;
        }

        private static final boolean doResolve$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

