/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc.internal;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.ext.toc.SimTocBlock;
import com.vladsch.flexmark.ext.toc.SimTocContent;
import com.vladsch.flexmark.ext.toc.SimTocOption;
import com.vladsch.flexmark.ext.toc.SimTocOptionList;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.ext.toc.internal.SimTocOptionsParser;
import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.options.ParsedOption;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimTocBlockParser
extends AbstractBlockParser {
    static int HAVE_HTML = 1;
    static int HAVE_HEADING = 2;
    static int HAVE_LIST = 4;
    static int HAVE_BLANK_LINE = 8;
    private final SimTocBlock block;
    private final TocOptions options;
    private int haveChildren = 0;
    private BasedSequence blankLineSpacer = BasedSequence.NULL;

    SimTocBlockParser(DataHolder options, BasedSequence tocChars, BasedSequence styleChars, BasedSequence titleChars) {
        this.options = new TocOptions(options, true);
        this.block = new SimTocBlock(tocChars, styleChars, titleChars);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if ((!this.options.isBlankLineSpacer || this.haveChildren != 0) && state.isBlank()) {
            return BlockContinue.none();
        }
        if (state.isBlank()) {
            this.haveChildren |= HAVE_BLANK_LINE;
            this.blankLineSpacer = state.getLine();
        }
        return BlockContinue.atIndex(state.getIndex());
    }

    @Override
    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        if (block instanceof HtmlBlock) {
            if ((this.haveChildren & ~HAVE_BLANK_LINE) == 0) {
                this.haveChildren |= HAVE_HTML;
                return true;
            }
        } else if (block instanceof Heading) {
            if ((this.haveChildren & ~HAVE_BLANK_LINE) == 0) {
                this.haveChildren |= HAVE_HEADING;
                return true;
            }
        } else if (block instanceof ListBlock && (this.haveChildren & (HAVE_HTML | HAVE_LIST)) == 0) {
            this.haveChildren |= HAVE_LIST;
            return true;
        }
        return false;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public void addLine(ParserState state, BasedSequence line) {
    }

    @Override
    public void closeBlock(ParserState state) {
        SimTocOptionsParser optionsParser;
        Pair<TocOptions, List<ParsedOption<TocOptions>>> pair;
        List<ParsedOption<TocOptions>> options;
        if (this.block.hasChildren()) {
            SimTocContent tocContent = new SimTocContent();
            tocContent.takeChildren(this.block);
            tocContent.setCharsFromContent();
            if (this.blankLineSpacer.isNotNull()) {
                tocContent.setChars(Node.spanningChars(this.blankLineSpacer, tocContent.getChars()));
            }
            this.block.appendChild(tocContent);
            this.block.setCharsFromContent();
            state.blockAddedWithChildren(tocContent);
        }
        if (this.options.isAstAddOptions && !this.block.getStyle().isEmpty() && !(options = (pair = (optionsParser = new SimTocOptionsParser()).parseOption(this.block.getStyle(), TocOptions.DEFAULT, null)).getSecond()).isEmpty()) {
            SimTocOptionList optionsNode = new SimTocOptionList();
            for (ParsedOption<TocOptions> option : options) {
                SimTocOption optionNode = new SimTocOption(option.getSource());
                optionsNode.appendChild(optionNode);
            }
            optionsNode.setCharsFromContent();
            this.block.prependChild(optionsNode);
        }
        this.block.setCharsFromContent();
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final TocParsing myParsing;

        BlockFactory(DataHolder options) {
            super(options);
            this.myParsing = new TocParsing(options);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            if (state.getIndent() >= 4) {
                return BlockStart.none();
            }
            BasedSequence line = state.getLine();
            int nextNonSpace = state.getNextNonSpaceIndex();
            BasedSequence trySequence = line.subSequence(nextNonSpace, line.length());
            Matcher matcher = this.myParsing.TOC_BLOCK_START.matcher(line);
            if (matcher.matches()) {
                BasedSequence tocChars = state.getLineWithEOL();
                BasedSequence styleChars = null;
                BasedSequence titleChars = null;
                if (matcher.start(1) != -1) {
                    styleChars = trySequence.subSequence(matcher.start(1), matcher.end(1));
                }
                if (matcher.start(2) != -1) {
                    titleChars = trySequence.subSequence(matcher.start(2), matcher.end(2));
                }
                SimTocBlockParser simTocBlockParser = new SimTocBlockParser(state.getProperties(), tocChars, styleChars, titleChars);
                return BlockStart.of(simTocBlockParser).atIndex(state.getLineEndIndex() + state.getLineEolLength());
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @NotNull
        public BlockParserFactory apply(@NotNull DataHolder options) {
            return new BlockFactory(options);
        }
    }

    static class TocParsing
    extends Parsing {
        final Pattern TOC_BLOCK_START;

        public TocParsing(DataHolder options) {
            super(options);
            this.TOC_BLOCK_START = TocExtension.CASE_SENSITIVE_TOC_TAG.get(options) != false ? Pattern.compile("^\\[TOC(?:\\s+([^\\]]+))?]:\\s*#(?:\\s+(" + this.LINK_TITLE_STRING + "))?\\s*$") : Pattern.compile("^\\[(?i:TOC)(?:\\s+([^\\]]+))?]:\\s*#(?:\\s+(" + this.LINK_TITLE_STRING + "))?\\s*$");
        }
    }
}

