/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.analysis;

import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.analysis.AnalysisUtils;
import com.intellij.coverage.analysis.CoverageInfoCollector;
import com.intellij.coverage.analysis.JavaCoverageClassesAnnotator;
import com.intellij.coverage.analysis.PackageAnnotator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/coverage/analysis/JavaCoverageReportEnumerator;", "", "<init>", "()V", "collectSummaryInReport", "", "bundle", "Lcom/intellij/coverage/CoverageSuitesBundle;", "project", "Lcom/intellij/openapi/project/Project;", "collector", "Lcom/intellij/coverage/analysis/CoverageInfoCollector;", "collectSourceRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.java.coverage"})
@SourceDebugExtension(value={"SMAP\nJavaCoverageReportEnumerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCoverageReportEnumerator.kt\ncom/intellij/coverage/analysis/JavaCoverageReportEnumerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,50:1\n1563#2:51\n1634#2,3:52\n1491#2:55\n1516#2,3:56\n1519#2,3:66\n1252#2,2:71\n1563#2:73\n1634#2,3:74\n1285#2,2:77\n1299#2,4:79\n1255#2:83\n382#3,7:59\n463#3:69\n413#3:70\n382#3,7:85\n382#3,7:92\n216#4:84\n217#4:99\n*S KotlinDebug\n*F\n+ 1 JavaCoverageReportEnumerator.kt\ncom/intellij/coverage/analysis/JavaCoverageReportEnumerator\n*L\n21#1:51\n21#1:52,3\n21#1:55\n21#1:56,3\n21#1:66,3\n24#1:71,2\n24#1:73\n24#1:74,3\n24#1:77,2\n24#1:79,4\n24#1:83\n21#1:59,7\n24#1:69\n24#1:70\n29#1:85,7\n30#1:92,7\n25#1:84\n25#1:99\n*E\n"})
public final class JavaCoverageReportEnumerator {
    @NotNull
    public static final JavaCoverageReportEnumerator INSTANCE = new JavaCoverageReportEnumerator();

    private JavaCoverageReportEnumerator() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void collectSummaryInReport(@NotNull CoverageSuitesBundle bundle, @NotNull Project project, @NotNull CoverageInfoCollector collector) {
        void $this$forEach$iv;
        Map it$iv$iv;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Object $this$mapValues$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        ProjectData projectData = bundle.getCoverageData();
        if (projectData == null) {
            return;
        }
        ProjectData projectData2 = projectData;
        PackageAnnotator packageAnnotator = new PackageAnnotator(bundle, project, projectData2);
        HashMap flattenPackages = new HashMap();
        HashMap flattenDirectories = new HashMap();
        Collection collection = projectData2.getClassesCollection();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getClassesCollection(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Object object2 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassData classData = (ClassData)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object3;
            String vmName;
            String fqn = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)AnalysisUtils.fqnToInternalName(fqn), (String)"fqnToInternalName(...)");
            key$iv$iv = AnalysisUtils.getSourceToplevelFQName(vmName);
            Object object4 = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Object destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$associateWithTo$iv$iv;
            void $this$associateWith$iv;
            Object object5;
            void $this$mapTo$iv$iv2;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry $i$f$getOrPut = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = $this$getOrPut$iv$iv$iv;
            boolean bl3 = false;
            List names = (List)$i$f$getOrPut.getValue();
            Iterable $this$map$iv2 = names;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void p0;
                String string = (String)item$iv$iv;
                object5 = destination$iv$iv2;
                boolean bl4 = false;
                object5.add(StringUtil.getShortName((String)p0));
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            destination$iv$iv2 = $this$associateWith$iv;
            Map destination$iv$iv3 = result$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String bl4 = (String)element$iv$iv;
                Object t = element$iv$iv;
                object5 = destination$iv$iv3;
                boolean bl5 = false;
                Object v = null;
                object5.put(t, v);
            }
            Map map = destination$iv$iv3;
            object.put(k, map);
        }
        $this$mapValues$iv = destination$iv$iv$iv;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Object object6;
            Object object7;
            Map $this$getOrPut$iv;
            PackageAnnotator.Result result;
            String packageVMName;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object2.next();
            boolean bl = false;
            String topLevelName = (String)entry.getKey();
            Map simpleNames = (Map)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)AnalysisUtils.fqnToInternalName(StringUtil.getPackageName((String)topLevelName)), (String)"fqnToInternalName(...)");
            if (packageAnnotator.visitFiles(topLevelName, simpleNames, packageVMName) == null) continue;
            collector.addClass(topLevelName, result.info);
            it$iv$iv = flattenPackages;
            String key$iv = AnalysisUtils.internalNameToFqn(packageVMName);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl6 = false;
                PackageAnnotator.PackageCoverageInfo answer$iv = new PackageAnnotator.PackageCoverageInfo();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object7 = answer$iv;
            } else {
                object7 = value$iv;
            }
            ((PackageAnnotator.PackageCoverageInfo)object7).append(result.info);
            $this$getOrPut$iv = flattenDirectories;
            key$iv = result.directory;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl7 = false;
                PackageAnnotator.PackageCoverageInfo answer$iv = new PackageAnnotator.PackageCoverageInfo();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object6 = answer$iv;
            } else {
                object6 = value$iv;
            }
            ((PackageAnnotator.PackageCoverageInfo)object6).append(result.info);
        }
        JavaCoverageClassesAnnotator.annotatePackages(flattenPackages, collector);
        JavaCoverageClassesAnnotator.annotateDirectories(flattenDirectories, collector, INSTANCE.collectSourceRoots(project));
    }

    private final Set<VirtualFile> collectSourceRoots(Project project) {
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        for (Module module : ModuleManager.Companion.getInstance(project).getModules()) {
            ContentEntry[] contentEntries;
            Intrinsics.checkNotNullExpressionValue((Object)ModuleRootManager.getInstance((Module)module).getContentEntries(), (String)"getContentEntries(...)");
            for (ContentEntry contentEntry : contentEntries) {
                SourceFolder[] sourceFolderArray;
                Intrinsics.checkNotNullExpressionValue((Object)contentEntry.getSourceFolders(), (String)"getSourceFolders(...)");
                for (SourceFolder folder : sourceFolderArray) {
                    VirtualFile file;
                    if (folder.getFile() == null) continue;
                    result.add(file);
                }
            }
        }
        return result;
    }
}

