/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonBinaryWriterBuilder;
import com.intellij.util.ThrowableConsumer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.Supplier;

public final class ToolingStreamApiUtils {
    public static final String OBJECT_ID_FIELD = "objectID";
    public static final String MAP_KEY_FIELD = "key";
    public static final String MAP_VALUE_FIELD = "value";

    @NotNull
    public static IonBinaryWriterBuilder createIonWriter() {
        IonBinaryWriterBuilder ionBinaryWriterBuilder = IonBinaryWriterBuilder.standard().withLocalSymbolTableAppendEnabled().withStreamCopyOptimized(true);
        if (ionBinaryWriterBuilder == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(0);
        }
        return ionBinaryWriterBuilder;
    }

    public static void writeInt(@NotNull IonWriter writer, @NotNull String fieldName, int value) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(1);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(2);
        }
        writer.setFieldName(fieldName);
        writer.writeInt((long)value);
    }

    public static int readInt(@NotNull IonReader reader, @Nullable String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(3);
        }
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        return reader.intValue();
    }

    public static void writeInteger(@NotNull IonWriter writer, @NotNull String fieldName, @Nullable Integer value) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(4);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(5);
        }
        writer.setFieldName(fieldName);
        if (value == null) {
            writer.writeNull(IonType.INT);
        } else {
            writer.writeInt((long)value.intValue());
        }
    }

    @Nullable
    public static Integer readInteger(@NotNull IonReader reader, @Nullable String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(6);
        }
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        if (reader.isNullValue()) {
            return null;
        }
        return reader.intValue();
    }

    public static void writeLong(@NotNull IonWriter writer, @NotNull String fieldName, long value) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(7);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(8);
        }
        writer.setFieldName(fieldName);
        writer.writeInt(value);
    }

    public static long readLong(@NotNull IonReader reader, @Nullable String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(9);
        }
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        return reader.longValue();
    }

    public static void writeBoolean(@NotNull IonWriter writer, @NotNull String fieldName, boolean value) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(10);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(11);
        }
        writer.setFieldName(fieldName);
        writer.writeBool(value);
    }

    public static boolean readBoolean(@NotNull IonReader reader, @Nullable String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(12);
        }
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        return reader.booleanValue();
    }

    public static void writeString(@NotNull IonWriter writer, @NotNull String fieldName, @Nullable String value) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(13);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(14);
        }
        writer.setFieldName(fieldName);
        writer.writeString(value);
    }

    @Nullable
    public static String readString(@NotNull IonReader reader, @Nullable String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(15);
        }
        IonType type = reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        if (type == null) {
            return null;
        }
        return reader.stringValue();
    }

    @Nullable
    public static String readString(@NotNull IonReader reader, @Nullable String fieldName, @NotNull ConcurrentMap<String, String> stringCache) {
        String str;
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(16);
        }
        if (stringCache == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(17);
        }
        if ((str = ToolingStreamApiUtils.readString(reader, fieldName)) == null) {
            return null;
        }
        String old = stringCache.putIfAbsent(str, str);
        if (old != null) {
            return old;
        }
        return str;
    }

    public static void writeFile(@NotNull IonWriter writer, @NotNull String fieldName, @Nullable File file) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(18);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(19);
        }
        ToolingStreamApiUtils.writeString(writer, fieldName, file == null ? null : file.getPath());
    }

    @Nullable
    public static File readFile(@NotNull IonReader reader, @Nullable String fieldName) {
        String filePath;
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(20);
        }
        return (filePath = ToolingStreamApiUtils.readString(reader, fieldName)) == null ? null : new File(filePath);
    }

    public static <E> void writeCollection(@NotNull IonWriter writer, @NotNull String fieldName, @NotNull Collection<E> collection, @NotNull ThrowableConsumer<? super E, ? extends IOException> elementWriter) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(21);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(22);
        }
        if (collection == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(23);
        }
        if (elementWriter == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(24);
        }
        writer.setFieldName(fieldName);
        writer.stepIn(IonType.LIST);
        for (E element : collection) {
            elementWriter.consume(element);
        }
        writer.stepOut();
    }

    public static <E, C extends Collection<E>> C readCollection(@NotNull IonReader reader, @Nullable String fieldName, @NotNull Supplier<? extends C> newCollection, @NotNull Supplier<? extends @Nullable E> elementReader) {
        Object element;
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(25);
        }
        if (newCollection == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(26);
        }
        if (elementReader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(27);
        }
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        reader.stepIn();
        Collection collection = (Collection)newCollection.get();
        while ((element = elementReader.get()) != null) {
            collection.add(element);
        }
        reader.stepOut();
        return (C)collection;
    }

    public static <E> List<E> readList(@NotNull IonReader reader, @Nullable String fieldName, @NotNull Supplier<? extends @Nullable E> elementReader) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(28);
        }
        if (elementReader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(29);
        }
        return (List)ToolingStreamApiUtils.readCollection(reader, fieldName, ArrayList::new, elementReader);
    }

    public static <E> Set<E> readSet(@NotNull IonReader reader, @Nullable String fieldName, @NotNull Supplier<? extends @Nullable E> elementReader) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(30);
        }
        if (elementReader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(31);
        }
        return (Set)ToolingStreamApiUtils.readCollection(reader, fieldName, LinkedHashSet::new, elementReader);
    }

    public static <K, V> void writeMap(@NotNull IonWriter writer, @NotNull String fieldName, @NotNull Map<K, V> map, @NotNull ThrowableConsumer<? super K, ? extends IOException> keyWriter, @NotNull ThrowableConsumer<? super V, ? extends IOException> valueWriter) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(32);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(33);
        }
        if (map == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(34);
        }
        if (keyWriter == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(35);
        }
        if (valueWriter == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(36);
        }
        writer.setFieldName(fieldName);
        writer.stepIn(IonType.LIST);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            writer.stepIn(IonType.STRUCT);
            writer.setFieldName(MAP_KEY_FIELD);
            keyWriter.consume(entry.getKey());
            writer.setFieldName(MAP_VALUE_FIELD);
            valueWriter.consume(entry.getValue());
            writer.stepOut();
        }
        writer.stepOut();
    }

    @NotNull
    public static <K, V> Map<K, V> readMap(@NotNull IonReader reader, @Nullable String fieldName, @NotNull Supplier<? extends K> keyReader, @NotNull Supplier<? extends V> valueReader) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(37);
        }
        if (keyReader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(38);
        }
        if (valueReader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(39);
        }
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        reader.stepIn();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        while (reader.next() != null) {
            reader.stepIn();
            map.put(keyReader.get(), valueReader.get());
            reader.stepOut();
        }
        reader.stepOut();
        HashMap<Object, Object> hashMap = map;
        if (hashMap == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(40);
        }
        return hashMap;
    }

    public static void writeStrings(@NotNull IonWriter writer, @NotNull String fieldName, @NotNull Collection<String> strings) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(41);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(42);
        }
        if (strings == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(43);
        }
        ToolingStreamApiUtils.writeCollection(writer, fieldName, strings, it -> writer.writeString(it));
    }

    @NotNull
    public static List<String> readStringList(@NotNull IonReader reader, @Nullable String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(44);
        }
        List<String> list = ToolingStreamApiUtils.readList(reader, fieldName, () -> ToolingStreamApiUtils.readString(reader, null));
        if (list == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(45);
        }
        return list;
    }

    @NotNull
    public static Set<String> readStringSet(@NotNull IonReader reader, @Nullable String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(46);
        }
        Set<String> set = ToolingStreamApiUtils.readSet(reader, fieldName, () -> ToolingStreamApiUtils.readString(reader, null));
        if (set == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(47);
        }
        return set;
    }

    public static void writeFiles(@NotNull IonWriter writer, @NotNull String fieldName, @NotNull Collection<File> files) throws IOException {
        if (writer == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(48);
        }
        if (fieldName == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(49);
        }
        if (files == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(50);
        }
        ToolingStreamApiUtils.writeCollection(writer, fieldName, files, it -> writer.writeString(it.getPath()));
    }

    @NotNull
    public static List<File> readFileList(@NotNull IonReader reader, @Nullable String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(51);
        }
        List<File> list = ToolingStreamApiUtils.readList(reader, fieldName, () -> ToolingStreamApiUtils.readFile(reader, null));
        if (list == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(52);
        }
        return list;
    }

    @NotNull
    public static Set<File> readFileSet(@NotNull IonReader reader, @Nullable String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(53);
        }
        Set<File> set = ToolingStreamApiUtils.readSet(reader, fieldName, () -> ToolingStreamApiUtils.readFile(reader, null));
        if (set == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(54);
        }
        return set;
    }

    public static void assertFieldName(@NotNull IonReader reader, @Nullable String fieldName) {
        if (reader == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(55);
        }
        String readerFieldName = reader.getFieldName();
        assert (fieldName == null || fieldName.equals(readerFieldName)) : "Expected field name '" + fieldName + "', got `" + readerFieldName + "' ";
    }

    @NotNull
    public static <T> T assertNotNull(@Nullable T t) {
        assert (t != null);
        T t2 = t;
        if (t2 == null) {
            ToolingStreamApiUtils.$$$reportNull$$$0(56);
        }
        return t2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/tooling/serialization/ToolingStreamApiUtils";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 18: 
            case 21: 
            case 32: 
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 19: 
            case 22: 
            case 33: 
            case 42: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 20: 
            case 25: 
            case 28: 
            case 30: 
            case 37: 
            case 44: 
            case 46: 
            case 51: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringCache";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementWriter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCollection";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementReader";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyWriter";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueWriter";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyReader";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueReader";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createIonWriter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/serialization/ToolingStreamApiUtils";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "readMap";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "readStringList";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "readStringSet";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "readFileList";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "readFileSet";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "assertNotNull";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeInt";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readInt";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeInteger";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readInteger";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeLong";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readLong";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeBoolean";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readBoolean";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeString";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readString";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "writeFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readFile";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "writeCollection";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "readCollection";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "readList";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "readSet";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "writeMap";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "readMap";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "writeStrings";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "readStringList";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "readStringSet";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "writeFiles";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "readFileList";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "readFileSet";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "assertFieldName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

