/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.git;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/indexing/shared/ultimate/git/GitBlobKey;", "", "parentNames", "", "filename", "", "<init>", "([ILjava/lang/String;)V", "getParentNames", "()[I", "getFilename", "()Ljava/lang/String;", "hash", "", "hashCode", "equals", "", "other", "toString", "intellij.indexing.shared.ultimate.git"})
public final class GitBlobKey {
    @NotNull
    private final int[] parentNames;
    @NotNull
    private final String filename;
    private final int hash;

    public GitBlobKey(@NotNull int[] parentNames, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)parentNames, (String)"parentNames");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.parentNames = parentNames;
        this.filename = filename;
        this.hash = Arrays.hashCode(this.parentNames) + 31 * this.filename.hashCode();
    }

    @NotNull
    public final int[] getParentNames() {
        return this.parentNames;
    }

    @NotNull
    public final String getFilename() {
        return this.filename;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitBlobKey)) {
            return false;
        }
        if (this.hash != ((GitBlobKey)other).hash) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filename, (Object)((GitBlobKey)other).filename)) {
            return false;
        }
        return Arrays.equals(this.parentNames, ((GitBlobKey)other).parentNames);
    }

    @NotNull
    public String toString() {
        return "Key(filename='" + this.filename + "')";
    }
}

