/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.psi.FtlCompositeElement;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlDirectiveType;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.directives.FtlIfDirective;
import com.intellij.freemarker.psi.directives.FtlIncludeDirective;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FtlXmlTag
extends FtlCompositeElement {
    protected FtlXmlTag(@NotNull ASTNode node) {
        if (node == null) {
            FtlXmlTag.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public boolean isClosed() {
        return this.findChildByType((IElementType)FtlElementTypes.END_DIRECTIVE_START) != null;
    }

    public boolean isOpeningTagClosed() {
        PsiElement dirEnd = this.getStartTagEndElement();
        if (dirEnd == null) {
            dirEnd = this.findChildByType((IElementType)FtlElementTypes.EMPTY_DIRECTIVE_END);
        }
        if (dirEnd == null) {
            return false;
        }
        PsiElement endStart = this.findChildByType((IElementType)FtlElementTypes.END_DIRECTIVE_START);
        return endStart == null || dirEnd.getTextRange().getStartOffset() <= endStart.getTextRange().getStartOffset();
    }

    @Nullable
    public PsiElement getStartTagEndElement() {
        return this.findChildByType((IElementType)FtlElementTypes.DIRECTIVE_END);
    }

    public boolean needsClosing() {
        return this.findChildByType((IElementType)FtlElementTypes.EMPTY_DIRECTIVE_END) == null;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            FtlXmlTag.$$$reportNull$$$0(1);
        }
        if (state == null) {
            FtlXmlTag.$$$reportNull$$$0(2);
        }
        if (place == null) {
            FtlXmlTag.$$$reportNull$$$0(3);
        }
        return this.processDirectiveDeclarations(processor, state, lastParent, lastParent == null);
    }

    public boolean processDirectiveDeclarations(PsiScopeProcessor processor, ResolveState state, @Nullable PsiElement lastParent, boolean honorAssigns) {
        for (PsiElement element = this.getLastChild(); element != null; element = element.getPrevSibling()) {
            if (element != lastParent && element instanceof FtlXmlTag && !FtlIfDirective.isBranch(element)) {
                if (element instanceof FtlSignatureDirective && !processor.execute(element, state)) {
                    return false;
                }
                if (honorAssigns) {
                    if (FtlDirectiveType.isDirective(element, "stop")) {
                        return false;
                    }
                    if (!((FtlXmlTag)element).processDirectiveDeclarations(processor, state, null, true)) {
                        return false;
                    }
                }
                if (element instanceof FtlFileReferenceDirective) {
                    if (!processor.execute(element, state)) {
                        return false;
                    }
                    if (!(element instanceof FtlIncludeDirective && !honorAssigns || ((FtlFileReferenceDirective)element).processDeclarationsInFile(processor, state))) {
                        return false;
                    }
                }
            }
            honorAssigns |= lastParent == element;
        }
        return true;
    }

    public FtlXmlTag[] getSubTags() {
        return (FtlXmlTag[])this.findChildrenByClass(FtlXmlTag.class);
    }

    public FtlDirective[] getSubDirectives() {
        return (FtlDirective[])this.findChildrenByClass(FtlDirective.class);
    }

    public Icon getElementIcon(int flags) {
        return PlatformIcons.XML_TAG_ICON;
    }

    public String getPresentableName() {
        return this.getDirectiveTagName();
    }

    public abstract String getDirectiveTagName();

    @Nullable
    public abstract PsiElement getStartTagNameElement();

    @Nullable
    public abstract PsiElement getEndTagNameElement();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/freemarker/psi/FtlXmlTag";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

