/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.yaml;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigFileAnnotator;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.profiles.QsProfilePsiReference;
import com.intellij.quarkus.config.yaml.QsYamlKeyMetaConfigKeyReference;
import com.intellij.ui.SimpleTextAttributes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLHighlighter;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/quarkus/config/yaml/QsYamlAnnotator;", "Lcom/intellij/quarkus/config/QsConfigFileAnnotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getPlaceholderTextAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "annotateKey", "yamlKeyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "intellij.quarkus.config.yaml"})
public final class QsYamlAnnotator
extends QsConfigFileAnnotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof YAMLKeyValue)) {
            return;
        }
        PsiFile psiFile = holder.getCurrentAnnotationSession().getFile();
        YAMLFile yAMLFile = psiFile instanceof YAMLFile ? (YAMLFile)psiFile : null;
        if (yAMLFile == null) {
            return;
        }
        YAMLFile file = yAMLFile;
        if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary(file.getProject()) || !QsConfigUtils.INSTANCE.isConfigFile((PsiFile)file)) {
            return;
        }
        if (((YAMLKeyValue)element).getKey() == null) {
            return;
        }
        this.annotateKey((YAMLKeyValue)element, holder);
        YAMLValue yamlValue = ((YAMLKeyValue)element).getValue();
        if (yamlValue instanceof YAMLScalar) {
            this.annotateValue((PsiElement)yamlValue, holder);
        } else if (yamlValue instanceof YAMLSequence) {
            for (YAMLSequenceItem item : ((YAMLSequence)yamlValue).getItems()) {
                YAMLScalar value;
                YAMLValue yAMLValue = item.getValue();
                if ((yAMLValue instanceof YAMLScalar ? (YAMLScalar)yAMLValue : null) == null) continue;
                value = value;
                this.annotateValue((PsiElement)value, holder);
            }
        }
    }

    @Override
    @NotNull
    protected TextAttributesKey getPlaceholderTextAttributesKey() {
        TextAttributesKey textAttributesKey = YAMLHighlighter.SCALAR_KEY;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"SCALAR_KEY");
        return textAttributesKey;
    }

    private final void annotateKey(YAMLKeyValue yamlKeyValue, AnnotationHolder holder) {
        int elementStartOffset = yamlKeyValue.getNode().getStartOffset();
        PsiReference[] psiReferenceArray = yamlKeyValue.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        for (PsiReference psiReference : psiReferenceArray) {
            TextRange referenceRange;
            if (psiReference instanceof QsProfilePsiReference) {
                TextRange textRange = ((QsProfilePsiReference)psiReference).getRangeInElement().shiftRight(elementStartOffset);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ITALIC_ATTRIBUTES");
                this.doAnnotateEnforced(holder, textRange, simpleTextAttributes, "REGULAR_ITALIC_ATTRIBUTES");
                continue;
            }
            if (!(psiReference instanceof QsYamlKeyMetaConfigKeyReference)) continue;
            if (((QsYamlKeyMetaConfigKeyReference)psiReference).getKeyData().getPathType() == ConfigKeyPathReference.PathType.ARBITRARY_ENTRY_KEY) {
                Intrinsics.checkNotNullExpressionValue((Object)((QsYamlKeyMetaConfigKeyReference)psiReference).getRangeInElement().shiftRight(elementStartOffset), (String)"shiftRight(...)");
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ITALIC_ATTRIBUTES");
                this.doAnnotateEnforced(holder, referenceRange, simpleTextAttributes, "REGULAR_ITALIC_ATTRIBUTES");
                continue;
            }
            if (((QsYamlKeyMetaConfigKeyReference)psiReference).getKeyData().getParentKey() == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((QsYamlKeyMetaConfigKeyReference)psiReference).getRangeInElement().shiftRight(elementStartOffset), (String)"shiftRight(...)");
            TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.INSTANCE_METHOD;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"INSTANCE_METHOD");
            this.doAnnotate(holder, referenceRange, textAttributesKey);
        }
    }
}

