/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InferenceVariablesOrder {
    public static List<InferenceVariable> resolveOrder(List<InferenceVariable> vars, Map<InferenceVariable, Set<InferenceVariable>> depMap) {
        if (vars.size() < 2) {
            return vars;
        }
        InferenceVariable result = InferenceVariablesOrder.resolveOrderFast(vars, depMap);
        if (result != null) {
            return Collections.singletonList(result);
        }
        Collection<InferenceGraphNode<InferenceVariable>> allNodes = InferenceVariablesOrder.buildInferenceGraph(vars, depMap).values();
        return InferenceGraphNode.merge(InferenceVariablesOrder.tarjan(allNodes, 1).get(0), allNodes).getValue();
    }

    @Nullable
    private static InferenceVariable resolveOrderFast(List<InferenceVariable> vars, Map<InferenceVariable, Set<InferenceVariable>> depMap) {
        InferenceVariable var = vars.get(0);
        if (var.getInstantiation() != PsiTypes.nullType() || depMap.get(var).isEmpty()) {
            return var;
        }
        HashSet<InferenceVariable> visited = new HashSet<InferenceVariable>();
        while (visited.add(var)) {
            if (var.getInstantiation() != PsiTypes.nullType()) {
                return var;
            }
            Set<InferenceVariable> deps = depMap.get(var);
            if (deps.isEmpty()) {
                return var;
            }
            InferenceVariable nextVar = (InferenceVariable)ContainerUtil.find(deps, v -> vars.contains(v));
            if (nextVar == null) {
                return var;
            }
            var = nextVar;
        }
        return null;
    }

    public static Iterator<List<InferenceVariable>> resolveOrderIterator(Collection<? extends InferenceVariable> vars, InferenceSession session) {
        Map<InferenceVariable, InferenceGraphNode<InferenceVariable>> nodes = InferenceVariablesOrder.buildInferenceGraph(vars, session);
        ArrayList<InferenceGraphNode<InferenceVariable>> acyclicNodes = InferenceVariablesOrder.initNodes(nodes.values());
        return ContainerUtil.map(acyclicNodes, node -> node.getValue()).iterator();
    }

    public static Map<InferenceVariable, Set<InferenceVariable>> getDependencies(Collection<? extends InferenceVariable> vars, InferenceSession session) {
        HashMap<InferenceVariable, Set<InferenceVariable>> map2 = new HashMap<InferenceVariable, Set<InferenceVariable>>();
        for (InferenceVariable inferenceVariable : vars) {
            map2.put(inferenceVariable, inferenceVariable.getDependencies(session));
        }
        return map2;
    }

    @NotNull
    private static Map<InferenceVariable, InferenceGraphNode<InferenceVariable>> buildInferenceGraph(Collection<? extends InferenceVariable> vars, InferenceSession session) {
        return InferenceVariablesOrder.buildInferenceGraph(vars, InferenceVariablesOrder.getDependencies(vars, session));
    }

    @NotNull
    private static Map<InferenceVariable, InferenceGraphNode<InferenceVariable>> buildInferenceGraph(Collection<? extends InferenceVariable> vars, Map<InferenceVariable, Set<InferenceVariable>> depMap) {
        LinkedHashMap<InferenceVariable, InferenceGraphNode<InferenceVariable>> nodes = new LinkedHashMap<InferenceVariable, InferenceGraphNode<InferenceVariable>>(vars.size() * 4 / 3);
        for (InferenceVariable inferenceVariable : vars) {
            nodes.put(inferenceVariable, new InferenceGraphNode<InferenceVariable>(inferenceVariable));
        }
        for (Map.Entry entry : nodes.entrySet()) {
            InferenceVariable var = (InferenceVariable)entry.getKey();
            if (var.getInstantiation() != PsiTypes.nullType()) continue;
            InferenceGraphNode node = (InferenceGraphNode)entry.getValue();
            Set<InferenceVariable> dependencies = depMap.get(var);
            for (InferenceVariable dependentVariable : dependencies) {
                InferenceGraphNode dependency = (InferenceGraphNode)nodes.get(dependentVariable);
                if (dependency == null) continue;
                node.addDependency(dependency);
            }
        }
        LinkedHashMap<InferenceVariable, InferenceGraphNode<InferenceVariable>> linkedHashMap = nodes;
        if (linkedHashMap == null) {
            InferenceVariablesOrder.$$$reportNull$$$0(0);
        }
        return linkedHashMap;
    }

    public static <T> List<List<InferenceGraphNode<T>>> tarjan(Collection<? extends InferenceGraphNode<T>> nodes) {
        return InferenceVariablesOrder.tarjan(nodes, Integer.MAX_VALUE);
    }

    public static <T> List<List<InferenceGraphNode<T>>> tarjan(Collection<? extends InferenceGraphNode<T>> nodes, int limit) {
        ArrayList<List<InferenceGraphNode<T>>> result = new ArrayList<List<InferenceGraphNode<T>>>();
        Stack currentStack = new Stack();
        int index = 0;
        for (InferenceGraphNode<T> node : nodes) {
            if (((InferenceGraphNode)node).index != -1) continue;
            index += InferenceGraphNode.strongConnect((InferenceGraphNode)node, index, currentStack, result);
            if (result.size() < limit) continue;
            break;
        }
        return result;
    }

    public static <T> ArrayList<InferenceGraphNode<T>> initNodes(Collection<? extends InferenceGraphNode<T>> allNodes) {
        List<List<InferenceGraphNode<T>>> nodes = InferenceVariablesOrder.tarjan(allNodes);
        ArrayList<InferenceGraphNode<T>> acyclicNodes = new ArrayList<InferenceGraphNode<T>>();
        for (List<InferenceGraphNode<T>> cycle : nodes) {
            acyclicNodes.add(InferenceGraphNode.merge(cycle, allNodes));
        }
        return acyclicNodes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceVariablesOrder", "buildInferenceGraph"));
    }

    public static class InferenceGraphNode<T> {
        private final List<T> myValue = new ArrayList<T>();
        private final Set<InferenceGraphNode<T>> myDependencies = new LinkedHashSet<InferenceGraphNode<T>>();
        private int index = -1;
        private int lowlink;

        public InferenceGraphNode(T value) {
            this.myValue.add(value);
        }

        public List<T> getValue() {
            return this.myValue;
        }

        public Set<InferenceGraphNode<T>> getDependencies() {
            return this.myDependencies;
        }

        public void addDependency(InferenceGraphNode<T> node) {
            this.myDependencies.add(node);
        }

        private static <T> InferenceGraphNode<T> merge(List<? extends InferenceGraphNode<T>> cycle, Collection<? extends InferenceGraphNode<T>> allNodes) {
            assert (!cycle.isEmpty());
            InferenceGraphNode<T> root = cycle.get(0);
            if (cycle.size() > 1) {
                for (int i = 1; i < cycle.size(); ++i) {
                    InferenceGraphNode<T> cycleNode = cycle.get(i);
                    super.copyFrom(cycleNode);
                    super.filterInterCycleDependencies();
                    for (InferenceGraphNode<T> node : allNodes) {
                        if (!node.myDependencies.remove(cycleNode)) continue;
                        node.myDependencies.add(root);
                    }
                }
            }
            return root;
        }

        private void filterInterCycleDependencies() {
            boolean includeSelfDependency = false;
            Iterator<InferenceGraphNode<T>> iterator = this.myDependencies.iterator();
            while (iterator.hasNext()) {
                InferenceGraphNode<T> d = iterator.next();
                assert (!d.myValue.isEmpty());
                T initialNodeValue = d.myValue.get(0);
                if (!this.myValue.contains(initialNodeValue)) continue;
                includeSelfDependency = true;
                iterator.remove();
            }
            if (includeSelfDependency) {
                this.myDependencies.add(this);
            }
        }

        private void copyFrom(InferenceGraphNode<T> cycleNode) {
            this.myValue.addAll(cycleNode.myValue);
            this.myDependencies.addAll(cycleNode.myDependencies);
        }

        private static <T> int strongConnect(InferenceGraphNode<T> currentNode, int index, Stack<InferenceGraphNode<T>> currentStack, ArrayList<? super List<InferenceGraphNode<T>>> result) {
            currentNode.index = index;
            currentNode.lowlink = index++;
            currentStack.push(currentNode);
            for (InferenceGraphNode<T> dependantNode : currentNode.getDependencies()) {
                if (dependantNode.index == -1) {
                    InferenceGraphNode.strongConnect(dependantNode, index, currentStack, result);
                    currentNode.lowlink = Math.min(currentNode.lowlink, dependantNode.lowlink);
                    continue;
                }
                if (!currentStack.contains(dependantNode)) continue;
                currentNode.lowlink = Math.min(currentNode.lowlink, dependantNode.index);
            }
            if (currentNode.lowlink == currentNode.index) {
                InferenceGraphNode cyclicNode;
                ArrayList<InferenceGraphNode> arrayList = new ArrayList<InferenceGraphNode>();
                do {
                    cyclicNode = (InferenceGraphNode)currentStack.pop();
                    arrayList.add(cyclicNode);
                } while (cyclicNode != currentNode);
                result.add(arrayList);
            }
            return index;
        }
    }
}

