/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.java.TextLineBlock;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/intellij/psi/formatter/java/CStyleCommentBlock;", "Lcom/intellij/psi/formatter/common/AbstractBlock;", "comment", "Lcom/intellij/lang/ASTNode;", "indent", "Lcom/intellij/formatting/Indent;", "<init>", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/formatting/Indent;)V", "spacing", "Lcom/intellij/formatting/Spacing;", "getSpacing", "()Lcom/intellij/formatting/Spacing;", "child1", "Lcom/intellij/formatting/Block;", "child2", "skipBackAndUp", "node", "getIndent", "buildChildren", "", "isLeaf", "", "ranges", "Lcom/intellij/openapi/util/TextRange;", "getRanges", "()Ljava/util/List;", "ranges$delegate", "Lkotlin/Lazy;", "intellij.java.frontback.impl"})
public final class CStyleCommentBlock
extends AbstractBlock {
    @Nullable
    private final Indent indent;
    @NotNull
    private final Lazy ranges$delegate;

    public CStyleCommentBlock(@NotNull ASTNode comment, @Nullable Indent indent) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        super(comment, null, null);
        this.indent = indent;
        this.ranges$delegate = LazyKt.lazy(() -> CStyleCommentBlock.ranges_delegate$lambda$0(this));
    }

    @Nullable
    public final Spacing getSpacing() {
        return this.getRanges().isEmpty() ? Spacing.getReadOnlySpacing() : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        if (child1 == null) {
            ASTNode aSTNode = this.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
            if (this.skipBackAndUp(aSTNode) == null) {
                spacing = Spacing.getReadOnlySpacing();
                return spacing;
            }
        }
        spacing = child2.getSpacing(null, (Block)this);
        return spacing;
    }

    private final ASTNode skipBackAndUp(ASTNode node) {
        ASTNode aSTNode;
        ASTNode prev = TreeUtil.skipElementsBack((ASTNode)node.getTreePrev(), (TokenSet)TokenSet.WHITE_SPACE);
        if (prev == null && node.getTreeParent() != null) {
            ASTNode aSTNode2 = node.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"getTreeParent(...)");
            aSTNode = this.skipBackAndUp(aSTNode2);
        } else {
            aSTNode = prev;
        }
        return aSTNode;
    }

    @Nullable
    public Indent getIndent() {
        return this.indent;
    }

    @NotNull
    protected List<Block> buildChildren() {
        List<TextRange> ranges = this.getRanges();
        if (ranges.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList children = new ArrayList(ranges.size());
        int nodeStart = this.getNode().getStartOffset();
        int n = ((Collection)ranges).size();
        for (int i = 0; i < n; ++i) {
            Indent indent = i == 0 ? Indent.getNoneIndent() : Indent.getSpaceIndent((int)1);
            Collection collection = children;
            TextRange textRange = ranges.get(i).shiftRight(nodeStart);
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
            collection.add(new TextLineBlock(textRange, null, indent, null));
        }
        return children;
    }

    public boolean isLeaf() {
        return this.getRanges().isEmpty();
    }

    private final List<TextRange> getRanges() {
        Lazy lazy = this.ranges$delegate;
        return (List)lazy.getValue();
    }

    private static final List ranges_delegate$lambda$0(CStyleCommentBlock this$0) {
        CharSequence charSequence = this$0.getNode().getChars();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getChars(...)");
        CharSequence text = charSequence;
        if (!StringsKt.startsWith$default((CharSequence)text, (CharSequence)"/*", (boolean)false, (int)2, null)) {
            return CollectionsKt.emptyList();
        }
        List result = new ArrayList();
        int start = 0;
        int n = text.length();
        for (int i = 2; i < n; ++i) {
            char c = text.charAt(i);
            if (start < 0) {
                if (Character.isWhitespace(c)) continue;
                if (c != '*') {
                    return CollectionsKt.emptyList();
                }
                start = i;
                continue;
            }
            if (i == text.length() - 1) {
                ((Collection)result).add(new TextRange(start, text.length()));
                continue;
            }
            if (c != '\n') continue;
            int end = i - 1;
            while (Character.isWhitespace(text.charAt(end))) {
                --end;
            }
            ((Collection)result).add(new TextRange(start, end + 1));
            start = -1;
        }
        return result;
    }
}

