/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BlockBraceFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        PsiElement psiElement;
        if (astNode == null) {
            BlockBraceFixer.$$$reportNull$$$0(0);
        }
        if ((psiElement = BasicJavaAstTreeUtil.toPsi(astNode)) == null) {
            return;
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_CODE_BLOCK) && BlockBraceFixer.afterUnmatchedBrace(editor, psiElement.getContainingFile().getFileType())) {
            int stopOffset = astNode.getTextRange().getEndOffset();
            List<ASTNode> statements = BasicJavaAstTreeUtil.getChildren(astNode).stream().filter(node -> BasicJavaAstTreeUtil.is(node, BasicJavaElementType.STATEMENT_SET)).toList();
            if (!statements.isEmpty()) {
                stopOffset = statements.get(0).getTextRange().getEndOffset();
            }
            editor.getDocument().insertString(stopOffset, (CharSequence)"}");
        }
    }

    static boolean afterUnmatchedBrace(Editor editor, FileType fileType) {
        return EnterAfterUnmatchedBraceHandler.isAfterUnmatchedLBrace((Editor)editor, (int)editor.getCaretModel().getOffset(), (FileType)fileType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/codeInsight/editorActions/smartEnter/BlockBraceFixer", "apply"));
    }
}

