/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.DynamicBundle;
import com.intellij.copyright.CopyrightBundle;
import com.intellij.copyright.CopyrightManager;
import com.intellij.copyright.IdeCopyrightManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AdditionalPageAtBottomEditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.pattern.EntityUtil;
import com.maddyhome.idea.copyright.pattern.VelocityHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyrightConfigurable
extends NamedConfigurable<CopyrightProfile> {
    private final CopyrightProfile myCopyrightProfile;
    private boolean myShareProfile;
    private JPanel myWholePanel;
    private final Project myProject;
    private boolean myModified;
    private String myDisplayName;
    private final EditorTextField myEditor;
    private JButton myValidateButton;
    private JTextField myKeywordTf;
    private JTextField myAllowReplaceTextField;
    private JPanel myEditorPanel;
    private final JCheckBox mySharedCheckbox;
    private final JLabel mySharedContextHelp;

    public CopyrightConfigurable(@NotNull Project project, CopyrightProfile copyrightProfile, Runnable updater, boolean shareProfile) {
        if (project == null) {
            CopyrightConfigurable.$$$reportNull$$$0(0);
        }
        super(true, updater);
        this.myProject = project;
        this.myCopyrightProfile = copyrightProfile;
        this.myShareProfile = shareProfile;
        this.$$$setupUI$$$();
        this.myDisplayName = this.myCopyrightProfile.getName();
        HashSet<Object> features = new HashSet<Object>();
        ContainerUtil.addIfNotNull(features, (Object)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization());
        features.add(SoftWrapsEditorCustomization.ENABLED);
        features.add(AdditionalPageAtBottomEditorCustomization.DISABLED);
        this.myEditor = EditorTextFieldProvider.getInstance().getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project, features);
        this.myEditorPanel.add((Component)this.myEditor.getComponent(), "Center");
        this.mySharedCheckbox = new JCheckBox(CopyrightBundle.message("share.profile.checkbox.title", new Object[0]), shareProfile);
        this.mySharedCheckbox.addActionListener(e -> updater.run());
        this.mySharedContextHelp = new JLabel(AllIcons.General.ContextHelp);
        this.mySharedContextHelp.setToolTipText(CopyrightBundle.message("share.profile.context.help", new Object[0]));
        this.mySharedContextHelp.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
    }

    public void setDisplayName(String s) {
        this.myCopyrightProfile.setName(s);
    }

    public CopyrightProfile getEditableObject() {
        return this.myCopyrightProfile;
    }

    public String getBannerSlogan() {
        return this.myCopyrightProfile.getName();
    }

    @Nullable
    protected JComponent createTopRightComponent() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add("West", this.mySharedCheckbox);
        panel2.add("East", this.mySharedContextHelp);
        return panel2;
    }

    public JComponent createOptionsPanel() {
        this.myValidateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    VelocityHelper.verify(CopyrightConfigurable.this.myEditor.getDocument().getText());
                    Messages.showInfoMessage((Project)CopyrightConfigurable.this.myProject, (String)CopyrightBundle.message("dialog.message.velocity.template.is.valid", new Object[0]), (String)CopyrightBundle.message("dialog.title.validation", new Object[0]));
                }
                catch (Exception e1) {
                    Messages.showInfoMessage((Project)CopyrightConfigurable.this.myProject, (String)CopyrightBundle.message("dialog.message.velocity.template.contains.error.0", e1.getMessage()), (String)CopyrightBundle.message("dialog.title.validation", new Object[0]));
                }
            }
        });
        this.myWholePanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)10, (int)10, (int)10));
        return this.myWholePanel;
    }

    @Nls
    public String getDisplayName() {
        return this.myCopyrightProfile.getName();
    }

    public boolean isModified() {
        if (this.mySharedCheckbox.isSelected() != this.myShareProfile) {
            return true;
        }
        return this.myModified || !Comparing.strEqual((String)EntityUtil.encode(this.myEditor.getDocument().getText()), (String)this.myCopyrightProfile.getNotice()) || !Comparing.strEqual((String)this.myKeywordTf.getText().trim(), (String)this.myCopyrightProfile.getKeyword()) || !Comparing.strEqual((String)this.myAllowReplaceTextField.getText().trim(), (String)this.myCopyrightProfile.getAllowReplaceRegexp()) || !Comparing.strEqual((String)this.myDisplayName, (String)this.myCopyrightProfile.getName());
    }

    public void apply() throws ConfigurationException {
        this.myCopyrightProfile.setNotice(EntityUtil.encode(this.myEditor.getDocument().getText()));
        this.myCopyrightProfile.setKeyword(CopyrightConfigurable.validateRegexpAndGet(this.myKeywordTf.getText().trim(), CopyrightBundle.message("detect.copyright.regexp.is.incorrect.configuration.error", new Object[0])));
        this.myCopyrightProfile.setAllowReplaceRegexp(CopyrightConfigurable.validateRegexpAndGet(this.myAllowReplaceTextField.getText().trim(), CopyrightBundle.message("replace.copyright.regexp.is.incorrect.configuration.error", new Object[0])));
        this.myShareProfile = this.mySharedCheckbox.isSelected();
        if (this.myShareProfile) {
            IdeCopyrightManager.getInstance().removeCopyright(this.myCopyrightProfile);
            CopyrightManager.getInstance(this.myProject).replaceCopyright(this.myDisplayName, this.myCopyrightProfile);
        } else {
            CopyrightManager.getInstance(this.myProject).removeCopyright(this.myCopyrightProfile);
            IdeCopyrightManager.getInstance().replaceCopyright(this.myDisplayName, this.myCopyrightProfile);
        }
        this.myDisplayName = this.myCopyrightProfile.getName();
        this.myModified = false;
    }

    @NotNull
    private static String validateRegexpAndGet(String regexp, @NlsContexts.DialogMessage String message) throws ConfigurationException {
        try {
            if (!StringUtil.isEmptyOrSpaces((String)regexp)) {
                Pattern.compile(regexp);
            }
        }
        catch (PatternSyntaxException e) {
            throw new ConfigurationException(message + " " + e.getMessage());
        }
        String string = regexp;
        if (string == null) {
            CopyrightConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void reset() {
        this.myDisplayName = this.myCopyrightProfile.getName();
        this.mySharedCheckbox.setSelected(this.myShareProfile);
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            String notice = this.myCopyrightProfile.getNotice();
            if (notice != null) {
                this.myEditor.getDocument().setText((CharSequence)EntityUtil.decode(notice));
                this.myEditor.setCaretPosition(0);
                this.myEditor.revalidate();
            }
        });
        this.myKeywordTf.setText(this.myCopyrightProfile.getKeyword());
        this.myAllowReplaceTextField.setText(this.myCopyrightProfile.getAllowReplaceRegexp());
    }

    public void setModified(boolean modified) {
        this.myModified = modified;
    }

    public boolean isShareProfile() {
        return this.mySharedCheckbox.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/maddyhome/idea/copyright/ui/CopyrightConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/maddyhome/idea/copyright/ui/CopyrightConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "validateRegexpAndGet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JButton jButton;
        JTextField jTextField2;
        JPanel jPanel2;
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/CopyrightBundle", CopyrightConfigurable.class).getString("label.regexp.to.detect.copyright.in.comments"));
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeywordTf = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myValidateButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/CopyrightBundle", CopyrightConfigurable.class).getString("button.validate"));
        jPanel2.add((Component)jButton, new GridConstraints(2, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/CopyrightBundle", CopyrightConfigurable.class).getString("label.allow.replacing.copyright.if.old.copyright.matches"));
        jPanel2.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAllowReplaceTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/CopyrightBundle", CopyrightConfigurable.class).getString("label.copyright.text.may.contain.velocity.templates"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myEditorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

