/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.gradle;

import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class GradleArtifact
implements Serializable {
    @Nullable
    private final String myGroupId;
    @Nullable
    private final String myArtifactId;
    @Nullable
    private final String myVersion;

    public GradleArtifact(@Nullable String groupId, @Nullable String artifactId, @Nullable String version) {
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myVersion = version;
    }

    public String getIdentifier() {
        StringBuilder builder = new StringBuilder();
        GradleArtifact.append(builder, this.myGroupId);
        GradleArtifact.append(builder, this.myArtifactId);
        GradleArtifact.append(builder, this.myVersion);
        return builder.toString();
    }

    @Nullable
    public String getArtifactId() {
        return this.myArtifactId;
    }

    @Nullable
    public String getGroupId() {
        return this.myGroupId;
    }

    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    public String toString() {
        return this.getIdentifier();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleArtifact artifact = (GradleArtifact)o;
        return Objects.equals(this.myGroupId, artifact.myGroupId) && Objects.equals(this.myArtifactId, artifact.myArtifactId) && Objects.equals(this.myVersion, artifact.myVersion);
    }

    public int hashCode() {
        return Objects.hash(this.myGroupId, this.myArtifactId, this.myVersion);
    }

    private static void append(StringBuilder builder, String part) {
        if (!builder.isEmpty()) {
            builder.append(':');
        }
        builder.append(part == null ? "<unknown>" : part);
    }
}

