/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.providers;

import com.intellij.cdi.constants.CdiClassesConstants;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.CdiNamedBean;
import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.FindClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class CdiGotoSymbolProvider
implements ChooseByNameContributor {
    private static List<Module> getAcceptableModules(@NotNull Project project) {
        if (project == null) {
            CdiGotoSymbolProvider.$$$reportNull$$$0(0);
        }
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create(CdiGotoSymbolProvider.calcAcceptableModules(project), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public String @NotNull [] getNames(Project project, boolean includeNonProjectItems) {
        Stream<CdiNamedBean<?>> beans = CdiGotoSymbolProvider.getAllBeans(project);
        String[] stringArray = (String[])beans.map(CdiNamedBean::getName).distinct().toArray(String[]::new);
        if (stringArray == null) {
            CdiGotoSymbolProvider.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    public NavigationItem @NotNull [] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        Stream<CdiNamedBean<?>> beans = CdiGotoSymbolProvider.getAllBeans(project);
        NavigationItem[] navigationItemArray = (NavigationItem[])beans.map(bean -> {
            PsiNamedElement element = bean.getIdentifyingPsiElement();
            if (element == null) {
                return null;
            }
            String elementName = element.getName();
            if (elementName == null || !elementName.trim().startsWith(name)) {
                return null;
            }
            return GoToSymbolProvider.createNavigationItem((PsiElement)element, (String)elementName, (Icon)JavaUltimateIcons.Cdi.Bean);
        }).filter(Objects::nonNull).distinct().toArray(NavigationItem[]::new);
        if (navigationItemArray == null) {
            CdiGotoSymbolProvider.$$$reportNull$$$0(2);
        }
        return navigationItemArray;
    }

    @NotNull
    private static Stream<CdiNamedBean<?>> getAllBeans(@NotNull Project project) {
        if (project == null) {
            CdiGotoSymbolProvider.$$$reportNull$$$0(3);
        }
        List<Module> modules = CdiGotoSymbolProvider.getAcceptableModules(project);
        Stream<CdiNamedBean<?>> stream = CdiJamModel.getNamedBeans(modules, project);
        if (stream == null) {
            CdiGotoSymbolProvider.$$$reportNull$$$0(4);
        }
        return stream;
    }

    @NotNull
    private static List<Module> calcAcceptableModules(@NotNull Project project) {
        if (project == null) {
            CdiGotoSymbolProvider.$$$reportNull$$$0(5);
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.addAll(FindClassUtil.findModulesWithClass((Project)project, (String)CdiClassesConstants.ENTERPRISE_INJECT_INSTANCE.javax()));
        modules.addAll(FindClassUtil.findModulesWithClass((Project)project, (String)CdiClassesConstants.ENTERPRISE_INJECT_INSTANCE.jakarta()));
        ArrayList<Module> arrayList = modules;
        if (arrayList == null) {
            CdiGotoSymbolProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/providers/CdiGotoSymbolProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/providers/CdiGotoSymbolProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsByName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBeans";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAcceptableModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAcceptableModules";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllBeans";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcAcceptableModules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6 -> new IllegalStateException(string);
        };
    }
}

