/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.lang.jsp;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.xml.behavior.DefaultXmlPsiPolicy;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.Nullable;

public final class JspPsiPolicy
extends DefaultXmlPsiPolicy {
    public ASTNode encodeXmlTextContents(String displayText, PsiElement text) {
        PsiFile containingFile = text.getContainingFile();
        FileElement dummyParent = DummyHolderFactory.createHolder((PsiManager)text.getManager(), null, (CharTable)SharedImplUtil.findCharTableByTree((ASTNode)text.getNode())).getTreeElement();
        if (containingFile instanceof BaseJspFile) {
            boolean wsChars = false;
            int fragmentStart = 0;
            for (int i = 0; i < displayText.length(); ++i) {
                if (wsChars == Character.isWhitespace(displayText.charAt(i))) continue;
                LeafElement next = JspPsiPolicy.createNextToken(fragmentStart, i, wsChars, dummyParent, displayText);
                if (next != null) {
                    dummyParent.rawAddChildren((TreeElement)next);
                    fragmentStart = i;
                }
                wsChars = Character.isWhitespace(displayText.charAt(i));
            }
            LeafElement next = JspPsiPolicy.createNextToken(fragmentStart, displayText.length(), wsChars, dummyParent, displayText);
            if (next != null) {
                dummyParent.rawAddChildren((TreeElement)next);
            }
            dummyParent.acceptTree((TreeElementVisitor)new GeneratedMarkerVisitor());
            return dummyParent.getFirstChildNode();
        }
        return super.encodeXmlTextContents(displayText, text);
    }

    @Nullable
    private static LeafElement createNextToken(int startOffset, int endOffset, boolean isWhitespace, FileElement dummyParent, CharSequence chars) {
        if (startOffset != endOffset) {
            CharSequence text = dummyParent.getCharTable().intern(chars, startOffset, endOffset);
            if (isWhitespace) {
                return ASTFactory.leaf((IElementType)XmlTokenType.XML_WHITE_SPACE, (CharSequence)text);
            }
            return ASTFactory.leaf((IElementType)XmlTokenType.XML_DATA_CHARACTERS, (CharSequence)text);
        }
        return null;
    }
}

