/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.relocated.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.jetbrains.relocated.apache.batik.bridge.AbstractSVGGradientElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.SVGUtilities;
import org.jetbrains.relocated.apache.batik.bridge.UnitProcessor;
import org.jetbrains.relocated.apache.batik.dom.svg.SVGContext;
import org.jetbrains.relocated.apache.batik.ext.awt.MultipleGradientPaint;
import org.jetbrains.relocated.apache.batik.ext.awt.RadialGradientPaint;
import org.jetbrains.relocated.apache.batik.gvt.GraphicsNode;
import org.jetbrains.relocated.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;

public class SVGRadialGradientElementBridge
extends AbstractSVGGradientElementBridge {
    @Override
    public String getLocalName() {
        return "radialGradient";
    }

    @Override
    protected Paint buildGradient(Element paintElement, Element paintedElement, GraphicsNode paintedNode, MultipleGradientPaint.CycleMethodEnum spreadMethod, MultipleGradientPaint.ColorSpaceEnum colorSpace, AffineTransform transform2, Color[] colors, float[] offsets, BridgeContext ctx2) {
        UnitProcessor.Context uctx;
        float r;
        Rectangle2D bbox2;
        String s;
        String fyStr;
        String fxStr;
        String rStr;
        String cyStr;
        String cxStr = SVGUtilities.getChainableAttributeNS(paintElement, null, "cx", ctx2);
        if (cxStr.length() == 0) {
            cxStr = "50%";
        }
        if ((cyStr = SVGUtilities.getChainableAttributeNS(paintElement, null, "cy", ctx2)).length() == 0) {
            cyStr = "50%";
        }
        if ((rStr = SVGUtilities.getChainableAttributeNS(paintElement, null, "r", ctx2)).length() == 0) {
            rStr = "50%";
        }
        if ((fxStr = SVGUtilities.getChainableAttributeNS(paintElement, null, "fx", ctx2)).length() == 0) {
            fxStr = cxStr;
        }
        if ((fyStr = SVGUtilities.getChainableAttributeNS(paintElement, null, "fy", ctx2)).length() == 0) {
            fyStr = cyStr;
        }
        short coordSystemType = (s = SVGUtilities.getChainableAttributeNS(paintElement, null, "gradientUnits", ctx2)).length() == 0 ? (short)2 : (short)SVGUtilities.parseCoordinateSystem(paintElement, "gradientUnits", s, ctx2);
        SVGContext bridge = BridgeContext.getSVGContext(paintedElement);
        if (coordSystemType == 2 && bridge instanceof AbstractGraphicsNodeBridge && (bbox2 = bridge.getBBox()) != null && (bbox2.getWidth() == 0.0 || bbox2.getHeight() == 0.0)) {
            return null;
        }
        if (coordSystemType == 2) {
            transform2 = SVGUtilities.toObjectBBox(transform2, paintedNode);
        }
        if ((r = SVGUtilities.convertLength(rStr, "r", coordSystemType, uctx = UnitProcessor.createContext(ctx2, paintElement))) == 0.0f) {
            return colors[colors.length - 1];
        }
        Point2D c = SVGUtilities.convertPoint(cxStr, "cx", cyStr, "cy", coordSystemType, uctx);
        Point2D f = SVGUtilities.convertPoint(fxStr, "fx", fyStr, "fy", coordSystemType, uctx);
        return new RadialGradientPaint(c, r, f, offsets, colors, spreadMethod, RadialGradientPaint.SRGB, transform2);
    }
}

