/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.guide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendDirection;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendBoxLayout;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendBreak;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeometryUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 42\u00020\u0001:\u000545678B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\u001c\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011002\u0006\u00101\u001a\u00020\u0011H\u0002J\u0010\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\u0011H$R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00058F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000fR\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00058F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000fR\u0010\u0010$\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\u001f0&j\b\u0012\u0004\u0012\u00020\u001f`'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u0012\u0012\u0004\u0012\u00020\u001f0&j\b\u0012\u0004\u0012\u00020\u001f`'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010)\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0013\"\u0004\b+\u0010\u0015\u00a8\u00069"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBoxLayout;", "title", "", "breaks", "", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBreak;", "keySizes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "legendDirection", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendDirection;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendDirection;Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;)V", "getBreaks", "()Ljava/util/List;", "colCount", "", "getColCount", "()I", "setColCount", "(I)V", "graphSize", "getGraphSize", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "isFillByRow", "", "()Z", "setFillByRow", "(Z)V", "keyLabelBoxes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getKeyLabelBoxes", "getKeySizes", "labelBoxes", "getLabelBoxes", "myContentSize", "myKeyLabelBoxes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "myLabelBoxes", "rowCount", "getRowCount", "setRowCount", "doLayout", "", "ensureInited", "indexToPosition", "Lkotlin/Pair;", "i", "labelSize", "index", "Companion", "MyHorizontal", "MyHorizontalMultiRow", "MyMultiRow", "MyVertical", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nLegendComponentLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegendComponentLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1#2:219\n1864#3,3:220\n1855#3,2:223\n*S KotlinDebug\n*F\n+ 1 LegendComponentLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout\n*L\n82#1:220,3\n97#1:223,2\n*E\n"})
public abstract class LegendComponentLayout
extends LegendBoxLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<LegendBreak> breaks;
    @NotNull
    private final List<DoubleVector> keySizes;
    @Nullable
    private DoubleVector myContentSize;
    @NotNull
    private final ArrayList<DoubleRectangle> myKeyLabelBoxes;
    @NotNull
    private final ArrayList<DoubleRectangle> myLabelBoxes;
    private boolean isFillByRow;
    private int rowCount;
    private int colCount;

    public LegendComponentLayout(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendDirection legendDirection, @NotNull LegendTheme theme2) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
        Intrinsics.checkNotNullParameter((Object)((Object)legendDirection), (String)"legendDirection");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        super(title, legendDirection, theme2);
        this.breaks = breaks;
        this.keySizes = keySizes;
        this.myKeyLabelBoxes = new ArrayList();
        this.myLabelBoxes = new ArrayList();
    }

    @NotNull
    protected final List<LegendBreak> getBreaks() {
        return this.breaks;
    }

    @NotNull
    public final List<DoubleVector> getKeySizes() {
        return this.keySizes;
    }

    public final boolean isFillByRow() {
        return this.isFillByRow;
    }

    public final void setFillByRow(boolean bl) {
        this.isFillByRow = bl;
    }

    public final int getRowCount() {
        return this.rowCount;
    }

    public final void setRowCount(int rowCount) {
        if (!(rowCount > 0)) {
            boolean bl = false;
            String string = "Row count must be greater than 0, was " + rowCount;
            throw new IllegalStateException(string.toString());
        }
        this.rowCount = rowCount;
    }

    public final int getColCount() {
        return this.colCount;
    }

    public final void setColCount(int colCount) {
        if (!(colCount > 0)) {
            boolean bl = false;
            String string = "Col count must be greater than 0, was " + colCount;
            throw new IllegalStateException(string.toString());
        }
        this.colCount = colCount;
    }

    @Override
    @NotNull
    public DoubleVector getGraphSize() {
        this.ensureInited();
        DoubleVector doubleVector = this.myContentSize;
        Intrinsics.checkNotNull((Object)doubleVector);
        return doubleVector;
    }

    @NotNull
    public final List<DoubleRectangle> getKeyLabelBoxes() {
        this.ensureInited();
        return this.myKeyLabelBoxes;
    }

    @NotNull
    public final List<DoubleRectangle> getLabelBoxes() {
        this.ensureInited();
        return this.myLabelBoxes;
    }

    private final void ensureInited() {
        if (this.myContentSize == null) {
            this.doLayout();
        }
    }

    private final Pair<Integer, Integer> indexToPosition(int i) {
        Pair pair2;
        if (this.isFillByRow) {
            int row = i / this.colCount;
            int col = i % this.colCount;
            pair2 = TuplesKt.to((Object)row, (Object)col);
        } else {
            int col = i / this.rowCount;
            int row = i % this.rowCount;
            pair2 = TuplesKt.to((Object)row, (Object)col);
        }
        return pair2;
    }

    /*
     * WARNING - void declaration
     */
    private final void doLayout() {
        List list2;
        List list3;
        ArrayList<Object> keySize2;
        int i2;
        int n;
        Object item$iv2;
        LabelSpec labelSpec = PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme());
        double keyLabelGap = labelSpec.width("_") / 2.0;
        double minVerticalDistanceBetweenLabels = labelSpec.height() / 3.0;
        double[] colWidths = new double[this.colCount];
        double[] rowHeights = new double[this.rowCount];
        Iterable $this$forEachIndexed$iv = this.keySizes;
        boolean $i$f$forEachIndexed = false;
        int index$iv22 = 0;
        for (Object item$iv2 : $this$forEachIndexed$iv) {
            if ((n = index$iv22++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DoubleVector doubleVector = (DoubleVector)item$iv2;
            i2 = n;
            boolean bl = false;
            Pair<Integer, Integer> pair2 = this.indexToPosition(i2);
            int row = ((Number)pair2.component1()).intValue();
            int col = ((Number)pair2.component2()).intValue();
            double labelExtraHeight = row == this.rowCount - 1 ? 0.0 : minVerticalDistanceBetweenLabels;
            DoubleVector labelSize = this.labelSize(i2).add(new DoubleVector(0.0, labelExtraHeight));
            DoubleVector labelOffset = new DoubleVector(((DoubleVector)((Object)keySize2)).getX() + keyLabelGap, ((DoubleVector)((Object)keySize2)).getY() / (double)2);
            ((Collection)this.myLabelBoxes).add(new DoubleRectangle(labelOffset, labelSize));
            colWidths[col] = Math.max(colWidths[col], labelOffset.getX() + labelSize.getX());
            rowHeights[row] = Math.max(rowHeights[row], Math.max(((DoubleVector)((Object)keySize2)).getY(), labelSize.getY()));
        }
        DoubleVector spacing = this.getTheme().keySpacing().add(new DoubleVector(keyLabelGap, 0.0));
        double[] index$iv22 = colWidths;
        Object object = 0.0;
        if (index$iv22.length == 0) {
            list3 = CollectionsKt.listOf((Object)object);
        } else {
            Object object2 = item$iv2 = new ArrayList(index$iv22.length + 1);
            ((ArrayList)object2).add((Object)object);
            keySize2 = item$iv2;
            item$iv2 = object;
            i2 = index$iv22.length;
            for (n = 0; n < i2; ++n) {
                void w;
                double bl;
                double row = bl = index$iv22[n];
                double acc = ((Number)item$iv2).doubleValue();
                boolean bl2 = false;
                item$iv2 = acc + w + spacing.getX();
                keySize2.add(item$iv2);
            }
            list3 = keySize2;
        }
        List colX = list3;
        object = rowHeights;
        item$iv2 = 0.0;
        if (((Object)object).length == 0) {
            list2 = CollectionsKt.listOf((Object)item$iv2);
        } else {
            Object object3 = new ArrayList<Object>(((Object)object).length + 1);
            keySize2 = object3;
            keySize2.add(item$iv2);
            ArrayList<Object> i2 = object3;
            object3 = item$iv2;
            int bl = ((Object)object).length;
            for (int keySize2 = 0; keySize2 < bl; ++keySize2) {
                void h;
                Object object4;
                Object col = object4 = object[keySize2];
                double acc = ((Number)object3).doubleValue();
                boolean bl3 = false;
                object3 = acc + h + spacing.getY();
                i2.add(object3);
            }
            list2 = i2;
        }
        List rowY = list2;
        Iterable $this$forEach$iv = (Iterable)CollectionsKt.getIndices((Collection)this.breaks);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int i3 = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Pair<Integer, Integer> pair3 = this.indexToPosition(i3);
            int row = ((Number)pair3.component1()).intValue();
            int col = ((Number)pair3.component2()).intValue();
            DoubleRectangle breakBoxBounds = new DoubleRectangle(((Number)colX.get(col)).doubleValue(), ((Number)rowY.get(row)).doubleValue(), colWidths[col], rowHeights[row]);
            this.myKeyLabelBoxes.add(breakBoxBounds);
        }
        this.myContentSize = GeometryUtil.INSTANCE.union(DoubleRectangle.Companion.getZERO(), (Collection<DoubleRectangle>)this.myKeyLabelBoxes).getDimension();
    }

    @NotNull
    protected abstract DoubleVector labelSize(int var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\rJ2\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\rJ2\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout$Companion;", "", "()V", "horizontal", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout;", "title", "", "breaks", "", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBreak;", "keySizes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "horizontalMultiRow", "vertical", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LegendComponentLayout horizontal(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendTheme theme2) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            return new MyHorizontal(title, breaks, keySizes, theme2);
        }

        @NotNull
        public final LegendComponentLayout horizontalMultiRow(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendTheme theme2) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            return new MyHorizontalMultiRow(title, breaks, keySizes, theme2);
        }

        @NotNull
        public final LegendComponentLayout vertical(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendTheme theme2) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            return new MyVertical(title, breaks, keySizes, theme2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout$MyHorizontal;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout;", "title", "", "breaks", "", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBreak;", "keySizes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;)V", "labelSize", "index", "", "plot-builder"})
    private static final class MyHorizontal
    extends LegendComponentLayout {
        public MyHorizontal(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendTheme theme2) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            super(title, breaks, keySizes, LegendDirection.HORIZONTAL, theme2);
            this.setColCount(breaks.size());
            this.setRowCount(1);
        }

        @Override
        @NotNull
        protected DoubleVector labelSize(int index) {
            String label2 = this.getBreaks().get(index).getLabel();
            return PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(label2, PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout$MyHorizontalMultiRow;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout$MyMultiRow;", "title", "", "breaks", "", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBreak;", "keySizes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;)V", "plot-builder"})
    private static final class MyHorizontalMultiRow
    extends MyMultiRow {
        public MyHorizontalMultiRow(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendTheme theme2) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            super(title, breaks, keySizes, LegendDirection.HORIZONTAL, theme2);
            this.setColCount(breaks.size());
            this.setRowCount(1);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\"\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout$MyMultiRow;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout;", "title", "", "breaks", "", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBreak;", "keySizes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "legendDirection", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendDirection;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendDirection;Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;)V", "labelSize", "index", "", "plot-builder"})
    private static abstract class MyMultiRow
    extends LegendComponentLayout {
        public MyMultiRow(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendDirection legendDirection, @NotNull LegendTheme theme2) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
            Intrinsics.checkNotNullParameter((Object)((Object)legendDirection), (String)"legendDirection");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            super(title, breaks, keySizes, legendDirection, theme2);
        }

        @Override
        @NotNull
        protected DoubleVector labelSize(int index) {
            return PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(this.getBreaks().get(index).getLabel(), PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout$MyVertical;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout$MyMultiRow;", "title", "", "breaks", "", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBreak;", "keySizes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;)V", "plot-builder"})
    private static final class MyVertical
    extends MyMultiRow {
        public MyVertical(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendTheme theme2) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            super(title, breaks, keySizes, LegendDirection.VERTICAL, theme2);
            this.setColCount(1);
            this.setRowCount(breaks.size());
        }
    }
}

