/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.NavigatableVariable;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XSourcePosition;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.VariableImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0019\u001a\u00020\u001aH\u0016R$\u0010\u000b\u001a\u0015\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00060\u00060\f\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R'\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\f0\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/debugger/NavigatableVariableBackedPsiElement;", "Lorg/jetbrains/debugger/VariableImpl;", "Lcom/intellij/javascript/debugger/NavigatableVariable;", "name", "", "element", "Lcom/intellij/psi/PsiElement;", "valueModifier", "Lorg/jetbrains/debugger/ValueModifier;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/debugger/ValueModifier;)V", "elementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getElementPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "inlineReferences", "", "getInlineReferences", "()Ljava/util/List;", "inlineReferences$delegate", "Lkotlin/Lazy;", "addInlineReference", "", "hasSourcePosition", "", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getSourcePosition", "()Lcom/intellij/xdebugger/XSourcePosition;", "navigatableElement", "Lcom/intellij/pom/Navigatable;", "getNavigatableElement", "()Lcom/intellij/pom/Navigatable;", "intellij.javascript.debugger.backend"})
public final class NavigatableVariableBackedPsiElement
extends VariableImpl
implements NavigatableVariable {
    @NotNull
    private final SmartPsiElementPointer<PsiElement> elementPointer;
    @NotNull
    private final Lazy inlineReferences$delegate;

    public NavigatableVariableBackedPsiElement(@NotNull String name, @NotNull PsiElement element, @Nullable ValueModifier valueModifier) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(name, null, valueModifier);
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        this.elementPointer = smartPsiElementPointer;
        this.inlineReferences$delegate = LazyKt.lazy(() -> NavigatableVariableBackedPsiElement.inlineReferences_delegate$lambda$0(this));
    }

    @NotNull
    public final SmartPsiElementPointer<PsiElement> getElementPointer() {
        return this.elementPointer;
    }

    @NotNull
    public final List<SmartPsiElementPointer<PsiElement>> getInlineReferences() {
        Lazy lazy = this.inlineReferences$delegate;
        return (List)lazy.getValue();
    }

    public final void addInlineReference(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        SmartPsiElementPointer pointer = smartPsiElementPointer;
        this.getInlineReferences().add((SmartPsiElementPointer<PsiElement>)pointer);
    }

    @Override
    public boolean hasSourcePosition() {
        return this.getNavigatableElement() != null;
    }

    @Override
    @Nullable
    public XSourcePosition getSourcePosition() {
        Navigatable navigatable = this.getNavigatableElement();
        if (navigatable == null) {
            return null;
        }
        Navigatable navigationElement = navigatable;
        return new XSourcePosition(this, navigationElement){
            final /* synthetic */ NavigatableVariableBackedPsiElement this$0;
            final /* synthetic */ Navigatable $navigationElement;
            {
                this.this$0 = $receiver;
                this.$navigationElement = $navigationElement;
            }

            public int getLine() {
                int n = this.getOffset();
                NavigatableVariableBackedPsiElement navigatableVariableBackedPsiElement = this.this$0;
                int offset = n;
                boolean bl = false;
                VirtualFile virtualFile = navigatableVariableBackedPsiElement.getElementPointer().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                Document document = VirtualFileUtil.findDocument((VirtualFile)virtualFile);
                Integer n2 = document != null ? Integer.valueOf(document.getLineNumber(offset)) : null;
                if (n2 == null) {
                    throw new IllegalStateException();
                }
                return n2;
            }

            public int getOffset() {
                int n;
                Navigatable navigatable = NavigatableVariableBackedPsiElement.access$getNavigatableElement(this.this$0);
                JSReferenceExpression jSReferenceExpression = navigatable instanceof JSReferenceExpression ? (JSReferenceExpression)navigatable : null;
                if (jSReferenceExpression != null && (jSReferenceExpression = jSReferenceExpression.resolve()) != null && (jSReferenceExpression = jSReferenceExpression.getTextRange()) != null) {
                    n = jSReferenceExpression.getStartOffset();
                } else {
                    Segment segment = this.this$0.getElementPointer().getPsiRange();
                    if (segment != null) {
                        n = segment.getStartOffset();
                    } else {
                        throw new IllegalStateException();
                    }
                }
                return n;
            }

            public VirtualFile getFile() {
                return this.this$0.getElementPointer().getVirtualFile();
            }

            public Navigatable createNavigatable(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return this.$navigationElement;
            }
        };
    }

    private final Navigatable getNavigatableElement() {
        PsiElement psiElement = this.elementPointer.getElement();
        return psiElement instanceof Navigatable ? (Navigatable)psiElement : null;
    }

    private static final SmartList inlineReferences_delegate$lambda$0(NavigatableVariableBackedPsiElement this$0) {
        return new SmartList(this$0.elementPointer);
    }

    public static final /* synthetic */ Navigatable access$getNavigatableElement(NavigatableVariableBackedPsiElement $this) {
        return $this.getNavigatableElement();
    }
}

