/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.impl.actions;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.internal.DumpLookupElementWeights;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipOutputStream;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.PathUtilsKt;
import org.jetbrains.completion.full.line.impl.FileTransferable;
import org.jetbrains.completion.full.line.impl.FullLineNotifications;
import org.jetbrains.completion.full.line.impl.UtilsKt;
import org.jetbrains.completion.full.line.impl.ZipKt;
import org.jetbrains.completion.full.line.impl.actions.InternalGenerationAction;
import org.jetbrains.completion.full.line.impl.starter.FullLineInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u000e*\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u000e*\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u000e*\u00020\u0019H\u0002J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lorg/jetbrains/completion/full/line/impl/actions/FullLineGenerateContextAction;", "Lorg/jetbrains/completion/full/line/impl/actions/InternalGenerationAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "root", "Ljava/io/File;", "getRoot", "()Ljava/io/File;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getDescription", "", "language", "contextFile", "markerTemplate", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "completionInfo", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "fullLineDiagnostics", "Lcom/intellij/openapi/project/Project;", "fullLineLastSessionDiagnostics", "createImage", "Ljava/awt/image/BufferedImage;", "Ljavax/swing/JComponent;", "getFile", "project", "intellij.fullLine.core.impl"})
@SourceDebugExtension(value={"SMAP\nFullLineGenerateContextAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineGenerateContextAction.kt\norg/jetbrains/completion/full/line/impl/actions/FullLineGenerateContextAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1#2:155\n360#3,7:156\n*S KotlinDebug\n*F\n+ 1 FullLineGenerateContextAction.kt\norg/jetbrains/completion/full/line/impl/actions/FullLineGenerateContextAction\n*L\n134#1:156,7\n*E\n"})
public final class FullLineGenerateContextAction
extends InternalGenerationAction
implements DumbAware {
    @NotNull
    private final File root = FilesKt.resolve((File)new File(System.getProperty("user.home")), (String)".flcc/issues");

    @NotNull
    public final File getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        File file;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        PsiFile psiFile2 = this.getFile(e, project3);
        if (psiFile2 == null) {
            return;
        }
        PsiFile file2 = psiFile2;
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        int caretOffset = editor3.getCaretModel().getPrimaryCaret().getOffset();
        String string = file2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String context2 = StringsKt.take((String)string, (int)caretOffset);
        String path = PathUtilsKt.projectFilePath(file2);
        String string2 = file2.getLanguage().getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String language = string3;
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)editor3);
        LookupImpl lookup = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
        ByteArrayOutputStream zip = ZipKt.zip((Function1<? super ZipOutputStream, Unit>)((Function1)arg_0 -> FullLineGenerateContextAction.actionPerformed$lambda$0(path, context2, file2, this, caretOffset, lookup, editor3, project3, arg_0)));
        if (!this.root.exists()) {
            this.root.mkdirs();
        }
        File it = file = FilesKt.resolve((File)this.root, (String)("flcc-data-" + System.currentTimeMillis() + ".zip"));
        boolean bl = false;
        Closeable closeable = new FileOutputStream(it);
        Throwable throwable = null;
        try {
            OutputStream p0 = (OutputStream)closeable;
            boolean bl2 = false;
            zip.writeTo(p0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        File contextFile = file;
        String description = this.getDescription(language, contextFile);
        String query = "project=ML&summary=<TBD>&description=" + description + "&c=Full Line. IDE";
        URI uri = new URI("https", "youtrack.jetbrains.com", "/newIssue", query, null);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new FileTransferable(CollectionsKt.listOf((Object)contextFile)), FullLineGenerateContextAction::actionPerformed$lambda$2);
        FullLineNotifications.Internal.INSTANCE.showGenerateFLContextAction(project3, contextFile, uri);
    }

    private final String getDescription(String language, File contextFile) {
        return StringsKt.trimMargin$default((String)("\n      |> Context was auto-generated to `" + contextFile.getName() + "`\n      |\n      |Language: `" + language + "`\n      |\n      |**Problem:**\n      |=TBD=\n      |\n      |**The expected result:**\n      |=TBD=\n      |\n      |**The actual result:**\n      |=TBD=\n    "), null, (int)1, null);
    }

    private final String markerTemplate(PsiFile file, int offset) {
        StringBuilder context2 = new StringBuilder();
        UtilsKt.plusAssign(context2, "# result = <>\n");
        UtilsKt.plusAssign(context2, "# prefix = <>\n");
        String string = file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        UtilsKt.plusAssign(context2, string);
        context2.insert(offset, "<caret>");
        String string2 = context2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String completionInfo(LookupImpl $this$completionInfo) {
        List list2 = DumpLookupElementWeights.getLookupElementWeights((LookupImpl)$this$completionInfo, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLookupElementWeights(...)");
        return CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final String fullLineDiagnostics(Project $this$fullLineDiagnostics) {
        return "";
    }

    private final String fullLineLastSessionDiagnostics(Project $this$fullLineLastSessionDiagnostics) {
        int n;
        List diagnosticLines;
        block3: {
            Regex lastSessionReg = new Regex("\\[.*]\\s*--==New for .*local.* session started==--");
            diagnosticLines = StringsKt.lines((CharSequence)this.fullLineDiagnostics($this$fullLineLastSessionDiagnostics));
            List $this$indexOfFirst$iv = CollectionsKt.reversed((Iterable)diagnosticLines);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                String it = (String)item$iv;
                boolean bl = false;
                if (lastSessionReg.matches((CharSequence)it)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        Integer n2 = n;
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it >= 0 ? n2 : null;
        if (n3 == null) {
            return null;
        }
        int lastSessionIndex = n3;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)diagnosticLines, (int)(lastSessionIndex + 1)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final BufferedImage createImage(JComponent $this$createImage) {
        BufferedImage bufferedImage = UIUtil.createImage((Component)$this$createImage, (int)$this$createImage.getWidth(), (int)$this$createImage.getHeight(), (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage img = bufferedImage;
        Graphics2D g = img.createGraphics();
        $this$createImage.paint(g);
        return img;
    }

    private final PsiFile getFile(AnActionEvent e, Project project2) {
        PsiFile psiFile2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile2 == null) {
            Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor2 != null) {
                Editor it = editor2;
                boolean bl = false;
                psiFile2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(it.getDocument());
            } else {
                psiFile2 = null;
            }
        }
        return psiFile2;
    }

    private static final Unit actionPerformed$lambda$0(String $path, String $context, PsiFile $file, FullLineGenerateContextAction this$0, int $caretOffset, LookupImpl $lookup, Editor $editor, Project $project, ZipOutputStream $this$zip) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$zip, (String)"$this$zip");
            ZipKt.file($this$zip, $path, $context);
            String string = "fl-context." + $file.getVirtualFile().getExtension();
            String string2 = $file.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            ZipKt.file($this$zip, string, string2);
            ZipKt.file($this$zip, "marker-template." + $file.getVirtualFile().getExtension(), this$0.markerTemplate($file, $caretOffset));
            ZipKt.file($this$zip, "system-info.txt", FullLineInfo.INSTANCE.systemInfo());
            ZipKt.file($this$zip, "plugin-info.txt", FullLineInfo.INSTANCE.pluginDescriptor());
            ZipKt.file($this$zip, "languages.txt", FullLineInfo.INSTANCE.languages());
            LookupImpl lookupImpl = $lookup;
            if (lookupImpl != null) {
                LookupImpl $this$actionPerformed_u24lambda_u240_u240 = lookupImpl;
                boolean bl = false;
                ZipKt.file($this$zip, "completion-info.txt", this$0.completionInfo($this$actionPerformed_u24lambda_u240_u240));
                JComponent jComponent = $this$actionPerformed_u24lambda_u240_u240.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                ZipKt.file$default($this$zip, "lookup.jpg", this$0.createImage(jComponent), null, 4, null);
            }
            Editor $this$actionPerformed_u24lambda_u240_u241 = $editor;
            boolean bl = false;
            JComponent jComponent = $this$actionPerformed_u24lambda_u240_u241.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            ZipKt.file$default($this$zip, "editor.jpg", this$0.createImage(jComponent), null, 4, null);
            if (!com.intellij.ml.inline.completion.impl.diagnostic.ui.UtilsKt.isMLCompletionDiagnosticsEnabled()) break block2;
            ZipKt.file($this$zip, "ai-completion-diagnostics.txt", this$0.fullLineDiagnostics($project));
            String string3 = this$0.fullLineLastSessionDiagnostics($project);
            if (string3 != null) {
                String it = string3;
                boolean bl2 = false;
                ZipKt.file($this$zip, "ai-completion-diagnostics-last-section.txt", it);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$2(Clipboard clipboard, Transferable transferable) {
    }
}

