/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.commons.model.jam.SpringRepositoryDefinition;
import com.intellij.spring.data.commons.util.SpringDataPartTreeParserContext;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UMethod;

public final class SpringDataUtil {
    private static final String SPRING_DATA_COMMONS_MAVEN = "org.springframework.data:spring-data-commons";

    public static boolean hasSpringDataSupport(Project project) {
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)SPRING_DATA_COMMONS_MAVEN);
    }

    public static boolean hasSpringDataSupport(Module module) {
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)SPRING_DATA_COMMONS_MAVEN);
    }

    public static boolean isQueryMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            SpringDataUtil.$$$reportNull$$$0(0);
        }
        return SpringDataPartTreeParserContext.create().prefixTemplates()[0].matcher(psiMethod.getName()).find() && !SpringDataUtil.isDefaultMethod(psiMethod);
    }

    public static boolean isQueryMethod(@NotNull String methodName) {
        if (methodName == null) {
            SpringDataUtil.$$$reportNull$$$0(1);
        }
        return SpringDataPartTreeParserContext.create().prefixTemplates()[0].matcher(methodName).find();
    }

    public static boolean isOverridenRepositoryMethod(@NotNull Module module, UMethod method) {
        PsiMethod psiMethod;
        if (module == null) {
            SpringDataUtil.$$$reportNull$$$0(2);
        }
        return SpringDataUtil.hasOverridenMethods(module, psiMethod = method.getJavaPsi(), "org.springframework.data.repository.CrudRepository") || SpringDataUtil.hasOverridenMethods(module, psiMethod, "org.springframework.data.repository.reactive.ReactiveCrudRepository") || SpringDataUtil.hasOverridenMethods(module, psiMethod, "org.springframework.data.jpa.repository.JpaRepository");
    }

    private static boolean hasOverridenMethods(@NotNull Module module, @NotNull PsiMethod psiMethod, @NotNull String repositoryClass) {
        PsiClass libraryClass;
        if (module == null) {
            SpringDataUtil.$$$reportNull$$$0(3);
        }
        if (psiMethod == null) {
            SpringDataUtil.$$$reportNull$$$0(4);
        }
        if (repositoryClass == null) {
            SpringDataUtil.$$$reportNull$$$0(5);
        }
        return (libraryClass = SpringCommonUtils.findLibraryClass((Module)module, (String)repositoryClass)) != null && psiMethod.findSuperMethods(libraryClass).length > 0;
    }

    public static boolean isDefaultMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            SpringDataUtil.$$$reportNull$$$0(6);
        }
        return psiMethod.getModifierList().hasModifierProperty("default");
    }

    public static boolean isRepository(@Nullable PsiClass psiClass) {
        return psiClass != null && (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.data.repository.Repository") || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.springframework.data.repository.RepositoryDefinition", (int)1)) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.springframework.data.repository.NoRepositoryBean", (int)8);
    }

    @Nullable
    public static Pair<PsiClass, ? extends PsiType> substituteRepositoryTypes(@NotNull PsiClass repositoryClass) {
        if (repositoryClass == null) {
            SpringDataUtil.$$$reportNull$$$0(7);
        }
        Project project = repositoryClass.getProject();
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)repositoryClass, (String)"org.springframework.data.repository.RepositoryDefinition", (int)1)) {
            return SpringDataUtil.substituteRepositoryDefinitionTypes(repositoryClass);
        }
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(repositoryClass);
        PsiType psiType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"org.springframework.data.repository.Repository", (int)0, (boolean)false);
        if (psiType instanceof PsiClassType) {
            PsiType idPsiType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"org.springframework.data.repository.Repository", (int)1, (boolean)false);
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            return psiClass == null || idPsiType == null ? null : Pair.create((Object)psiClass, (Object)idPsiType);
        }
        return null;
    }

    @Nullable
    private static Pair<PsiClass, ? extends PsiType> substituteRepositoryDefinitionTypes(@NotNull PsiClass repositoryClass) {
        JamService service;
        SpringRepositoryDefinition repositoryDefinition;
        if (repositoryClass == null) {
            SpringDataUtil.$$$reportNull$$$0(8);
        }
        if ((repositoryDefinition = (SpringRepositoryDefinition)(service = JamService.getJamService((Project)repositoryClass.getProject())).getJamElement((PsiElement)repositoryClass, new JamMemberMeta[]{SpringRepositoryDefinition.META})) != null) {
            PsiClass domainClass = repositoryDefinition.getDomainClass();
            if (domainClass == null) {
                return null;
            }
            PsiClass idClass = repositoryDefinition.getIdClass();
            return Pair.create((Object)domainClass, (Object)(idClass == null ? PsiTypes.nullType() : PsiTypesUtil.getClassType((PsiClass)idClass)));
        }
        return null;
    }

    @NotNull
    public static List<PsiMethod> getRepositoryMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringDataUtil.$$$reportNull$$$0(9);
        }
        List list = ContainerUtil.filter((Object[])psiClass.getMethods(), method -> SpringDataUtil.isQueryMethod(method));
        if (list == null) {
            SpringDataUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    public static Set<String> getProperties(@NotNull PsiClass domainClass) {
        String qualifiedName;
        if (domainClass == null) {
            SpringDataUtil.$$$reportNull$$$0(11);
        }
        if ((qualifiedName = domainClass.getQualifiedName()) == null || qualifiedName.startsWith("java.lang")) {
            return Collections.emptySet();
        }
        HashSet<String> all = new HashSet<String>();
        all.addAll(PropertyUtilBase.getAllProperties((PsiClass)domainClass, (boolean)false, (boolean)true).keySet());
        all.addAll(ContainerUtil.map((Object[])domainClass.getFields(), field -> SpringDataUtil.suggestPropertyName(field, field.getName())));
        return all;
    }

    @NotNull
    private static String suggestPropertyName(@NotNull PsiField field, @NotNull String fieldName) {
        if (field == null) {
            SpringDataUtil.$$$reportNull$$$0(12);
        }
        if (fieldName == null) {
            SpringDataUtil.$$$reportNull$$$0(13);
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)field.getProject());
        VariableKind kind = codeStyleManager.getVariableKind((PsiVariable)field);
        String string = codeStyleManager.variableNameToPropertyName(fieldName, kind);
        if (string == null) {
            SpringDataUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/util/SpringDataUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/util/SpringDataUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryMethods";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestPropertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isQueryMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isOverridenRepositoryMethod";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasOverridenMethods";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultMethod";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "substituteRepositoryTypes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "substituteRepositoryDefinitionTypes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryMethods";
                break;
            }
            case 10: 
            case 14: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "suggestPropertyName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 14 -> new IllegalStateException(string);
        };
    }
}

