/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.modulith.structure;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.structureView.logical.ContainerElementsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.JamPsiClassSpringBean;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import com.intellij.spring.modulith.model.ApplicationModule;
import com.intellij.spring.modulith.model.SpringModulithModelService;
import com.intellij.spring.modulith.structure.SpringModulithStructurePresentationProvider;
import com.intellij.spring.modulith.structure.model.SpringModulithModuleModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Presentation(provider=SpringModulithStructurePresentationProvider.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spring/modulith/structure/SpringModulithStructureProvider;", "Lcom/intellij/ide/structureView/logical/ContainerElementsProvider;", "Lcom/intellij/spring/model/logical/SpringBeanLogicalModel;", "Lcom/intellij/spring/modulith/structure/model/SpringModulithModuleModel;", "<init>", "()V", "isApplicable", "", "parent", "getElements", "", "intellij.spring.modulith"})
@SourceDebugExtension(value={"SMAP\nSpringModulithStructureProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringModulithStructureProvider.kt\ncom/intellij/spring/modulith/structure/SpringModulithStructureProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1056#2:51\n1563#2:52\n1634#2,3:53\n*S KotlinDebug\n*F\n+ 1 SpringModulithStructureProvider.kt\ncom/intellij/spring/modulith/structure/SpringModulithStructureProvider\n*L\n39#1:51\n39#1:52\n39#1:53,3\n*E\n"})
public final class SpringModulithStructureProvider
implements ContainerElementsProvider<SpringBeanLogicalModel, SpringModulithModuleModel> {
    public boolean isApplicable(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        CommonSpringBean commonSpringBean = parent.getSpringBean();
        JamPsiClassSpringBean jamPsiClassSpringBean = commonSpringBean instanceof JamPsiClassSpringBean ? (JamPsiClassSpringBean)commonSpringBean : null;
        if (jamPsiClassSpringBean == null) {
            return false;
        }
        JamPsiClassSpringBean psiClassBean = jamPsiClassSpringBean;
        PsiClass psiClass = psiClassBean.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"getPsiElement(...)");
        PsiClass psiClass2 = psiClass;
        boolean isSpringBootApplication = SpringBootApplicationService.getInstance().isSpringApplication(psiClass2);
        if (!isSpringBootApplication) {
            return false;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)psiClass2));
        if (module == null) {
            return false;
        }
        Module module2 = module;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<ApplicationModule> model = SpringModulithModelService.Companion.getInstance$intellij_spring_modulith(project).getModel$intellij_spring_modulith(module2);
        return !((Collection)model).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<SpringModulithModuleModel> getElements(@NotNull SpringBeanLogicalModel parent) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Module module = parent.getSpringBean().getModule();
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<ApplicationModule> appModules = SpringModulithModelService.Companion.getInstance$intellij_spring_modulith(project).getModel$intellij_spring_modulith(module2);
        Iterable $this$sortedBy$iv = appModules;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ApplicationModule it = (ApplicationModule)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getBasePackage());
                it = (ApplicationModule)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getBasePackage())));
            }
        });
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ApplicationModule applicationModule = (ApplicationModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SpringModulithModuleModel.Companion.fromAppModule((ApplicationModule)it, appModules, module2));
        }
        return (List)destination$iv$iv;
    }
}

