/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.cloudExplorer.CloudDataSourceProviderException;
import com.intellij.database.dataSource.CloudDataSourceInfo;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.view.ui.CloudDatabasesTreeDataSourceNode;
import com.intellij.database.view.ui.CloudDatabasesTreeMetadataNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/view/ui/CloudDatabasesTreeModel;", "Ljavax/swing/tree/DefaultTreeModel;", "myProject", "Lcom/intellij/openapi/project/Project;", "myRoot", "Ljavax/swing/tree/DefaultMutableTreeNode;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultMutableTreeNode;)V", "createModifier", "Lcom/intellij/database/view/ui/CloudDatabasesTreeModel$Companion$ModelModifier;", "Companion", "intellij.database.impl"})
public final class CloudDatabasesTreeModel
extends DefaultTreeModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final DefaultMutableTreeNode myRoot;

    public CloudDatabasesTreeModel(@NotNull Project myProject, @NotNull DefaultMutableTreeNode myRoot) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myRoot, (String)"myRoot");
        super(myRoot);
        this.myProject = myProject;
        this.myRoot = myRoot;
    }

    public /* synthetic */ CloudDatabasesTreeModel(Project project, DefaultMutableTreeNode defaultMutableTreeNode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            defaultMutableTreeNode = new DefaultMutableTreeNode();
        }
        this(project, defaultMutableTreeNode);
    }

    @NotNull
    public final Companion.ModelModifier createModifier() {
        return new Companion.ModelModifier(this);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/view/ui/CloudDatabasesTreeModel$Companion;", "", "<init>", "()V", "ModelModifier", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/view/ui/CloudDatabasesTreeModel$Companion$ModelModifier;", "", "model", "Lcom/intellij/database/view/ui/CloudDatabasesTreeModel;", "<init>", "(Lcom/intellij/database/view/ui/CloudDatabasesTreeModel;)V", "metadataToNode", "", "", "Lcom/intellij/database/view/ui/CloudDatabasesTreeMetadataNode;", "dsWithoutCloudInfo", "", "Lcom/intellij/database/view/ui/CloudDatabasesTreeDataSourceNode;", "isActive", "Ljava/util/concurrent/atomic/AtomicBoolean;", "", "assertModificationState", "", "startModify", "getMetadataNode", "metadataId", "addDataSource", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "collectError", "error", "Lcom/intellij/database/cloudExplorer/CloudDataSourceProviderException;", "modify", "", "intellij.database.impl"})
        @SourceDebugExtension(value={"SMAP\nCloudDatabasesTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudDatabasesTreeModel.kt\ncom/intellij/database/view/ui/CloudDatabasesTreeModel$Companion$ModelModifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1869#2:91\n1869#2,2:92\n1870#2:94\n1869#2,2:95\n*S KotlinDebug\n*F\n+ 1 CloudDatabasesTreeModel.kt\ncom/intellij/database/view/ui/CloudDatabasesTreeModel$Companion$ModelModifier\n*L\n68#1:91\n70#1:92,2\n68#1:94\n76#1:95,2\n*E\n"})
        public static final class ModelModifier {
            @NotNull
            private final CloudDatabasesTreeModel model;
            @NotNull
            private final Map<String, CloudDatabasesTreeMetadataNode> metadataToNode;
            @NotNull
            private final List<CloudDatabasesTreeDataSourceNode> dsWithoutCloudInfo;
            @NotNull
            private final AtomicBoolean isActive;

            public ModelModifier(@NotNull CloudDatabasesTreeModel model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                this.model = model;
                this.metadataToNode = new ConcurrentHashMap();
                this.dsWithoutCloudInfo = new CopyOnWriteArrayList();
                this.isActive = new AtomicBoolean(false);
            }

            public final boolean isActive() {
                return this.isActive.get();
            }

            private final void assertModificationState() {
                if (!this.isActive.get()) {
                    throw new IllegalStateException("Modify is not in progress");
                }
            }

            public final void startModify() {
                if (!this.isActive.compareAndSet(false, true)) {
                    throw new IllegalStateException("Modify is already in progress");
                }
                this.model.myRoot.removeAllChildren();
                this.model.reload();
            }

            private final CloudDatabasesTreeMetadataNode getMetadataNode(String metadataId) {
                CloudDatabasesTreeMetadataNode cloudDatabasesTreeMetadataNode = this.metadataToNode.computeIfAbsent(metadataId, arg_0 -> ModelModifier.getMetadataNode$lambda$1(arg_0 -> ModelModifier.getMetadataNode$lambda$0(this, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)((Object)cloudDatabasesTreeMetadataNode), (String)"computeIfAbsent(...)");
                return cloudDatabasesTreeMetadataNode;
            }

            public final void addDataSource(@NotNull LocalDataSource dataSource) {
                Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                this.assertModificationState();
                CloudDataSourceInfo cloudInfo = CloudDataSourceInfo.Companion.getCloudInfo(dataSource);
                if (cloudInfo != null) {
                    this.getMetadataNode(cloudInfo.getCloudInternalMetadata()).addDataSourceNode(new CloudDatabasesTreeDataSourceNode(this.model.myProject, dataSource));
                } else {
                    this.dsWithoutCloudInfo.add(new CloudDatabasesTreeDataSourceNode(this.model.myProject, dataSource));
                }
            }

            public final void collectError(@NotNull CloudDataSourceProviderException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.assertModificationState();
                String string = error.getCloudInternalMetadata();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCloudInternalMetadata(...)");
                this.getMetadataNode(string).setError(error);
            }

            public final int modify() {
                this.assertModificationState();
                int numberOfDatabases = 0;
                this.model.myRoot.removeAllChildren();
                Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)this.metadataToNode.values(), (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        CloudDatabasesTreeMetadataNode it = (CloudDatabasesTreeMetadataNode)((Object)a);
                        boolean bl = false;
                        Comparable comparable = (Comparable)it.getValue();
                        it = (CloudDatabasesTreeMetadataNode)((Object)b);
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getValue()));
                    }
                });
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CloudDatabasesTreeMetadataNode node = (CloudDatabasesTreeMetadataNode)((Object)element$iv);
                    boolean bl = false;
                    DefaultMutableTreeNode metadataNode = new DefaultMutableTreeNode((Object)node);
                    Iterable $this$forEach$iv2 = CollectionsKt.sortedWith((Iterable)node.getChildren(), (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            AbstractTreeNode it = (AbstractTreeNode)a;
                            boolean bl = false;
                            AbstractTreeNode abstractTreeNode = it;
                            Object object = abstractTreeNode != null ? abstractTreeNode.getValue() : null;
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.database.dataSource.LocalDataSource");
                            it = (AbstractTreeNode)b;
                            Comparable comparable = (Comparable)((Object)((LocalDataSource)object).getDbms().getName());
                            bl = false;
                            AbstractTreeNode abstractTreeNode2 = it;
                            Object object2 = abstractTreeNode2 != null ? abstractTreeNode2.getValue() : null;
                            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.database.dataSource.LocalDataSource");
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)((LocalDataSource)object2).getDbms().getName())));
                        }
                    });
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        AbstractTreeNode it = (AbstractTreeNode)element$iv2;
                        boolean bl2 = false;
                        metadataNode.add(new DefaultMutableTreeNode(it));
                        ++numberOfDatabases;
                    }
                    this.model.myRoot.add(metadataNode);
                }
                $this$forEach$iv = this.dsWithoutCloudInfo;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CloudDatabasesTreeDataSourceNode it = (CloudDatabasesTreeDataSourceNode)((Object)element$iv);
                    boolean bl = false;
                    this.model.myRoot.add(new DefaultMutableTreeNode((Object)it));
                    ++numberOfDatabases;
                }
                this.model.reload();
                this.metadataToNode.clear();
                this.dsWithoutCloudInfo.clear();
                this.isActive.set(false);
                return numberOfDatabases;
            }

            private static final CloudDatabasesTreeMetadataNode getMetadataNode$lambda$0(ModelModifier this$0, String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new CloudDatabasesTreeMetadataNode(this$0.model.myProject, it);
            }

            private static final CloudDatabasesTreeMetadataNode getMetadataNode$lambda$1(Function1 $tmp0, Object p0) {
                return (CloudDatabasesTreeMetadataNode)((Object)$tmp0.invoke(p0));
            }
        }
    }
}

