/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.inspection.fix;

import com.intellij.codeInsight.daemon.impl.quickfix.AddDefaultConstructorFix;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.inspection.LombokBuilderInspectionKt;
import com.intellij.jpa.jpb.model.inspection.fix.AppendSimpleAllArgsConstructorFix;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jpa/jpb/model/inspection/fix/AppendSimpleConstructorsFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "psiClassPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiClass;", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;)V", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "intellij.javaee.jpa.jpb.model"})
public final class AppendSimpleConstructorsFix
implements LocalQuickFix {
    @NotNull
    private final SmartPsiElementPointer<PsiClass> psiClassPointer;

    public AppendSimpleConstructorsFix(@NotNull SmartPsiElementPointer<PsiClass> psiClassPointer) {
        Intrinsics.checkNotNullParameter(psiClassPointer, (String)"psiClassPointer");
        this.psiClassPointer = psiClassPointer;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[1];
        Object object = (PsiClass)this.psiClassPointer.getElement();
        if (object == null || (object = object.getName()) == null) {
            object = "class body";
        }
        objectArray[0] = object;
        String string = JpaModelBundle.message("addSimpleConstructors.fix", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JpaModelBundle.message("addConstructor.family", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiClass psiClass = (PsiClass)this.psiClassPointer.getElement();
        if (psiClass == null) {
            return;
        }
        PsiClass psiClass2 = psiClass;
        LombokBuilderInspectionKt.asQuickFix((ModCommandAction)new AddDefaultConstructorFix(psiClass2)).applyFix(project, (CommonProblemDescriptor)descriptor);
        LombokBuilderInspectionKt.asQuickFix((ModCommandAction)new AppendSimpleAllArgsConstructorFix(psiClass2)).applyFix(project, (CommonProblemDescriptor)descriptor);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }
}

