/*******************************************************************************
 *
 * MIT License
 *
 * Copyright 2024-2025 AMD ROCm(TM) Software
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/

#include <array>
#include <limits>
#include <rocRoller/DataTypes/DataTypes.hpp>

#pragma once

namespace rocRollerTest
{

    inline constexpr double NotANumber = std::numeric_limits<double>::quiet_NaN();
    inline constexpr double Inf        = std::numeric_limits<double>::infinity();
    inline constexpr double NegInf     = -std::numeric_limits<double>::infinity();

    template <typename FloatType>
    struct FloatReference
    {
    };

    template <>
    struct FloatReference<rocRoller::BF8>
    {
        // All values of BF8 (E5M2) with bias 16
        static constexpr std::array ValuesInNaNooMode = {
            // clang-format off
//  --------------------------------------------- Mantissa ------------------------------------------
//           0                          1                         2                        3                  SIGN EXP
      0.000000000000000,        0.000007629394531,        0.000015258789062,        0.000022888183594,  /* 0   0x0  */
      0.000030517578125,        0.000038146972656,        0.000045776367188,        0.000053405761719,  /* 0   0x1  */
      0.000061035156250,        0.000076293945312,        0.000091552734375,        0.000106811523438,  /* 0   0x2  */
      0.000122070312500,        0.000152587890625,        0.000183105468750,        0.000213623046875,  /* 0   0x3  */
      0.000244140625000,        0.000305175781250,        0.000366210937500,        0.000427246093750,  /* 0   0x4  */
      0.000488281250000,        0.000610351562500,        0.000732421875000,        0.000854492187500,  /* 0   0x5  */
      0.000976562500000,        0.001220703125000,        0.001464843750000,        0.001708984375000,  /* 0   0x6  */
      0.001953125000000,        0.002441406250000,        0.002929687500000,        0.003417968750000,  /* 0   0x7  */
      0.003906250000000,        0.004882812500000,        0.005859375000000,        0.006835937500000,  /* 0   0x8  */
      0.007812500000000,        0.009765625000000,        0.011718750000000,        0.013671875000000,  /* 0   0x9  */
      0.015625000000000,        0.019531250000000,        0.023437500000000,        0.027343750000000,  /* 0   0xa  */
      0.031250000000000,        0.039062500000000,        0.046875000000000,        0.054687500000000,  /* 0   0xb  */
      0.062500000000000,        0.078125000000000,        0.093750000000000,        0.109375000000000,  /* 0   0xc  */
      0.125000000000000,        0.156250000000000,        0.187500000000000,        0.218750000000000,  /* 0   0xd  */
      0.250000000000000,        0.312500000000000,        0.375000000000000,        0.437500000000000,  /* 0   0xe  */
      0.500000000000000,        0.625000000000000,        0.750000000000000,        0.875000000000000,  /* 0   0xf  */
      1.000000000000000,        1.250000000000000,        1.500000000000000,        1.750000000000000,  /* 0   0x10 */
      2.000000000000000,        2.500000000000000,        3.000000000000000,        3.500000000000000,  /* 0   0x11 */
      4.000000000000000,        5.000000000000000,        6.000000000000000,        7.000000000000000,  /* 0   0x12 */
      8.000000000000000,       10.000000000000000,       12.000000000000000,       14.000000000000000,  /* 0   0x13 */
     16.000000000000000,       20.000000000000000,       24.000000000000000,       28.000000000000000,  /* 0   0x14 */
     32.000000000000000,       40.000000000000000,       48.000000000000000,       56.000000000000000,  /* 0   0x15 */
     64.000000000000000,       80.000000000000000,       96.000000000000000,      112.000000000000000,  /* 0   0x16 */
    128.000000000000000,      160.000000000000000,      192.000000000000000,      224.000000000000000,  /* 0   0x17 */
    256.000000000000000,      320.000000000000000,      384.000000000000000,      448.000000000000000,  /* 0   0x18 */
    512.000000000000000,      640.000000000000000,      768.000000000000000,      896.000000000000000,  /* 0   0x19 */
   1024.000000000000000,     1280.000000000000000,     1536.000000000000000,     1792.000000000000000,  /* 0   0x1a */
   2048.000000000000000,     2560.000000000000000,     3072.000000000000000,     3584.000000000000000,  /* 0   0x1b */
   4096.000000000000000,     5120.000000000000000,     6144.000000000000000,     7168.000000000000000,  /* 0   0x1c */
   8192.000000000000000,    10240.000000000000000,    12288.000000000000000,    14336.000000000000000,  /* 0   0x1d */
  16384.000000000000000,    20480.000000000000000,    24576.000000000000000,    28672.000000000000000,  /* 0   0x1e */
  32768.000000000000000,    40960.000000000000000,    49152.000000000000000,    57344.000000000000000,  /* 0   0x1f */
             NotANumber,       -0.000007629394531,       -0.000015258789062,       -0.000022888183594,  /* 1   0x0  */
     -0.000030517578125,       -0.000038146972656,       -0.000045776367188,       -0.000053405761719,  /* 1   0x1  */
     -0.000061035156250,       -0.000076293945312,       -0.000091552734375,       -0.000106811523438,  /* 1   0x2  */
     -0.000122070312500,       -0.000152587890625,       -0.000183105468750,       -0.000213623046875,  /* 1   0x3  */
     -0.000244140625000,       -0.000305175781250,       -0.000366210937500,       -0.000427246093750,  /* 1   0x4  */
     -0.000488281250000,       -0.000610351562500,       -0.000732421875000,       -0.000854492187500,  /* 1   0x5  */
     -0.000976562500000,       -0.001220703125000,       -0.001464843750000,       -0.001708984375000,  /* 1   0x6  */
     -0.001953125000000,       -0.002441406250000,       -0.002929687500000,       -0.003417968750000,  /* 1   0x7  */
     -0.003906250000000,       -0.004882812500000,       -0.005859375000000,       -0.006835937500000,  /* 1   0x8  */
     -0.007812500000000,       -0.009765625000000,       -0.011718750000000,       -0.013671875000000,  /* 1   0x9  */
     -0.015625000000000,       -0.019531250000000,       -0.023437500000000,       -0.027343750000000,  /* 1   0xa  */
     -0.031250000000000,       -0.039062500000000,       -0.046875000000000,       -0.054687500000000,  /* 1   0xb  */
     -0.062500000000000,       -0.078125000000000,       -0.093750000000000,       -0.109375000000000,  /* 1   0xc  */
     -0.125000000000000,       -0.156250000000000,       -0.187500000000000,       -0.218750000000000,  /* 1   0xd  */
     -0.250000000000000,       -0.312500000000000,       -0.375000000000000,       -0.437500000000000,  /* 1   0xe  */
     -0.500000000000000,       -0.625000000000000,       -0.750000000000000,       -0.875000000000000,  /* 1   0xf  */
     -1.000000000000000,       -1.250000000000000,       -1.500000000000000,       -1.750000000000000,  /* 1   0x10 */
     -2.000000000000000,       -2.500000000000000,       -3.000000000000000,       -3.500000000000000,  /* 1   0x11 */
     -4.000000000000000,       -5.000000000000000,       -6.000000000000000,       -7.000000000000000,  /* 1   0x12 */
     -8.000000000000000,      -10.000000000000000,      -12.000000000000000,      -14.000000000000000,  /* 1   0x13 */
    -16.000000000000000,      -20.000000000000000,      -24.000000000000000,      -28.000000000000000,  /* 1   0x14 */
    -32.000000000000000,      -40.000000000000000,      -48.000000000000000,      -56.000000000000000,  /* 1   0x15 */
    -64.000000000000000,      -80.000000000000000,      -96.000000000000000,     -112.000000000000000,  /* 1   0x16 */
   -128.000000000000000,     -160.000000000000000,     -192.000000000000000,     -224.000000000000000,  /* 1   0x17 */
   -256.000000000000000,     -320.000000000000000,     -384.000000000000000,     -448.000000000000000,  /* 1   0x18 */
   -512.000000000000000,     -640.000000000000000,     -768.000000000000000,     -896.000000000000000,  /* 1   0x19 */
  -1024.000000000000000,    -1280.000000000000000,    -1536.000000000000000,    -1792.000000000000000,  /* 1   0x1a */
  -2048.000000000000000,    -2560.000000000000000,    -3072.000000000000000,    -3584.000000000000000,  /* 1   0x1b */
  -4096.000000000000000,    -5120.000000000000000,    -6144.000000000000000,    -7168.000000000000000,  /* 1   0x1c */
  -8192.000000000000000,   -10240.000000000000000,   -12288.000000000000000,   -14336.000000000000000,  /* 1   0x1d */
 -16384.000000000000000,   -20480.000000000000000,   -24576.000000000000000,   -28672.000000000000000,  /* 1   0x1e */
 -32768.000000000000000,   -40960.000000000000000,   -49152.000000000000000,   -57344.000000000000000   /* 1   0x1f */
            // clang-format on
        };

        // All values of BF8 (E5M2) with bias 15
        static constexpr std::array ValuesInOCPMode = {
            // clang-format off
//  --------------------------------------------- Mantissa --------------------------------------------
//           0                          1                         2                        3                SIGN EXP
     0.000000000000000,         0.000015258789062,         0.000030517578125,         0.000045776367188,  /* 0   0x0  */
     0.000061035156250,         0.000076293945312,         0.000091552734375,         0.000106811523438,  /* 0   0x1  */
     0.000122070312500,         0.000152587890625,         0.000183105468750,         0.000213623046875,  /* 0   0x2  */
     0.000244140625000,         0.000305175781250,         0.000366210937500,         0.000427246093750,  /* 0   0x3  */
     0.000488281250000,         0.000610351562500,         0.000732421875000,         0.000854492187500,  /* 0   0x4  */
     0.000976562500000,         0.001220703125000,         0.001464843750000,         0.001708984375000,  /* 0   0x5  */
     0.001953125000000,         0.002441406250000,         0.002929687500000,         0.003417968750000,  /* 0   0x6  */
     0.003906250000000,         0.004882812500000,         0.005859375000000,         0.006835937500000,  /* 0   0x7  */
     0.007812500000000,         0.009765625000000,         0.011718750000000,         0.013671875000000,  /* 0   0x8  */
     0.015625000000000,         0.019531250000000,         0.023437500000000,         0.027343750000000,  /* 0   0x9  */
     0.031250000000000,         0.039062500000000,         0.046875000000000,         0.054687500000000,  /* 0   0xa  */
     0.062500000000000,         0.078125000000000,         0.093750000000000,         0.109375000000000,  /* 0   0xb  */
     0.125000000000000,         0.156250000000000,         0.187500000000000,         0.218750000000000,  /* 0   0xc  */
     0.250000000000000,         0.312500000000000,         0.375000000000000,         0.437500000000000,  /* 0   0xd  */
     0.500000000000000,         0.625000000000000,         0.750000000000000,         0.875000000000000,  /* 0   0xe  */
     1.000000000000000,         1.250000000000000,         1.500000000000000,         1.750000000000000,  /* 0   0xf  */
     2.000000000000000,         2.500000000000000,         3.000000000000000,         3.500000000000000,  /* 0   0x10 */
     4.000000000000000,         5.000000000000000,         6.000000000000000,         7.000000000000000,  /* 0   0x11 */
     8.000000000000000,        10.000000000000000,        12.000000000000000,        14.000000000000000,  /* 0   0x12 */
    16.000000000000000,        20.000000000000000,        24.000000000000000,        28.000000000000000,  /* 0   0x13 */
    32.000000000000000,        40.000000000000000,        48.000000000000000,        56.000000000000000,  /* 0   0x14 */
    64.000000000000000,        80.000000000000000,        96.000000000000000,       112.000000000000000,  /* 0   0x15 */
   128.000000000000000,       160.000000000000000,       192.000000000000000,       224.000000000000000,  /* 0   0x16 */
   256.000000000000000,       320.000000000000000,       384.000000000000000,       448.000000000000000,  /* 0   0x17 */
   512.000000000000000,       640.000000000000000,       768.000000000000000,       896.000000000000000,  /* 0   0x18 */
  1024.000000000000000,      1280.000000000000000,      1536.000000000000000,      1792.000000000000000,  /* 0   0x19 */
  2048.000000000000000,      2560.000000000000000,      3072.000000000000000,      3584.000000000000000,  /* 0   0x1a */
  4096.000000000000000,      5120.000000000000000,      6144.000000000000000,      7168.000000000000000,  /* 0   0x1b */
  8192.000000000000000,     10240.000000000000000,     12288.000000000000000,     14336.000000000000000,  /* 0   0x1c */
 16384.000000000000000,     20480.000000000000000,     24576.000000000000000,     28672.000000000000000,  /* 0   0x1d */
 32768.000000000000000,     40960.000000000000000,     49152.000000000000000,     57344.000000000000000,  /* 0   0x1e */
                   Inf,                NotANumber,                NotANumber,                NotANumber,  /* 0   0x1f */
    -0.000000000000000,        -0.000015258789062,        -0.000030517578125,        -0.000045776367188,  /* 1   0x0  */
    -0.000061035156250,        -0.000076293945312,        -0.000091552734375,        -0.000106811523438,  /* 1   0x1  */
    -0.000122070312500,        -0.000152587890625,        -0.000183105468750,        -0.000213623046875,  /* 1   0x2  */
    -0.000244140625000,        -0.000305175781250,        -0.000366210937500,        -0.000427246093750,  /* 1   0x3  */
    -0.000488281250000,        -0.000610351562500,        -0.000732421875000,        -0.000854492187500,  /* 1   0x4  */
    -0.000976562500000,        -0.001220703125000,        -0.001464843750000,        -0.001708984375000,  /* 1   0x5  */
    -0.001953125000000,        -0.002441406250000,        -0.002929687500000,        -0.003417968750000,  /* 1   0x6  */
    -0.003906250000000,        -0.004882812500000,        -0.005859375000000,        -0.006835937500000,  /* 1   0x7  */
    -0.007812500000000,        -0.009765625000000,        -0.011718750000000,        -0.013671875000000,  /* 1   0x8  */
    -0.015625000000000,        -0.019531250000000,        -0.023437500000000,        -0.027343750000000,  /* 1   0x9  */
    -0.031250000000000,        -0.039062500000000,        -0.046875000000000,        -0.054687500000000,  /* 1   0xa  */
    -0.062500000000000,        -0.078125000000000,        -0.093750000000000,        -0.109375000000000,  /* 1   0xb  */
    -0.125000000000000,        -0.156250000000000,        -0.187500000000000,        -0.218750000000000,  /* 1   0xc  */
    -0.250000000000000,        -0.312500000000000,        -0.375000000000000,        -0.437500000000000,  /* 1   0xd  */
    -0.500000000000000,        -0.625000000000000,        -0.750000000000000,        -0.875000000000000,  /* 1   0xe  */
    -1.000000000000000,        -1.250000000000000,        -1.500000000000000,        -1.750000000000000,  /* 1   0xf  */
    -2.000000000000000,        -2.500000000000000,        -3.000000000000000,        -3.500000000000000,  /* 1   0x10 */
    -4.000000000000000,        -5.000000000000000,        -6.000000000000000,        -7.000000000000000,  /* 1   0x11 */
    -8.000000000000000,       -10.000000000000000,       -12.000000000000000,       -14.000000000000000,  /* 1   0x12 */
   -16.000000000000000,       -20.000000000000000,       -24.000000000000000,       -28.000000000000000,  /* 1   0x13 */
   -32.000000000000000,       -40.000000000000000,       -48.000000000000000,       -56.000000000000000,  /* 1   0x14 */
   -64.000000000000000,       -80.000000000000000,       -96.000000000000000,      -112.000000000000000,  /* 1   0x15 */
  -128.000000000000000,      -160.000000000000000,      -192.000000000000000,      -224.000000000000000,  /* 1   0x16 */
  -256.000000000000000,      -320.000000000000000,      -384.000000000000000,      -448.000000000000000,  /* 1   0x17 */
  -512.000000000000000,      -640.000000000000000,      -768.000000000000000,      -896.000000000000000,  /* 1   0x18 */
 -1024.000000000000000,     -1280.000000000000000,     -1536.000000000000000,     -1792.000000000000000,  /* 1   0x19 */
 -2048.000000000000000,     -2560.000000000000000,     -3072.000000000000000,     -3584.000000000000000,  /* 1   0x1a */
 -4096.000000000000000,     -5120.000000000000000,     -6144.000000000000000,     -7168.000000000000000,  /* 1   0x1b */
 -8192.000000000000000,    -10240.000000000000000,    -12288.000000000000000,    -14336.000000000000000,  /* 1   0x1c */
-16384.000000000000000,    -20480.000000000000000,    -24576.000000000000000,    -28672.000000000000000,  /* 1   0x1d */
-32768.000000000000000,    -40960.000000000000000,    -49152.000000000000000,    -57344.000000000000000,  /* 1   0x1e */
                  -Inf,               -NotANumber,               -NotANumber,               -NotANumber   /* 1   0x1f */
            // clang-format on
        };
    };

    template <>
    struct FloatReference<rocRoller::FP8>
    {
        // All values of FP8 (E4M3) with bias 8
        static constexpr std::array ValuesInNaNooMode = {
            // clang-format off
//  -------------------------------------------------------- Mantissa ---------------------------------------------------------
//      0               1              2                3               4               5                6              7        SIGN  EXP
  0.0000000000,   0.0009765625,   0.0019531250,   0.0029296875,   0.0039062500,   0.0048828125,   0.0058593750,   0.0068359375, /* 0   0x0*/
  0.0078125000,   0.0087890625,   0.0097656250,   0.0107421875,   0.0117187500,   0.0126953125,   0.0136718750,   0.0146484375, /* 0   0x1*/
  0.0156250000,   0.0175781250,   0.0195312500,   0.0214843750,   0.0234375000,   0.0253906250,   0.0273437500,   0.0292968750, /* 0   0x2*/
  0.0312500000,   0.0351562500,   0.0390625000,   0.0429687500,   0.0468750000,   0.0507812500,   0.0546875000,   0.0585937500, /* 0   0x3*/
  0.0625000000,   0.0703125000,   0.0781250000,   0.0859375000,   0.0937500000,   0.1015625000,   0.1093750000,   0.1171875000, /* 0   0x4*/
  0.1250000000,   0.1406250000,   0.1562500000,   0.1718750000,   0.1875000000,   0.2031250000,   0.2187500000,   0.2343750000, /* 0   0x5*/
  0.2500000000,   0.2812500000,   0.3125000000,   0.3437500000,   0.3750000000,   0.4062500000,   0.4375000000,   0.4687500000, /* 0   0x6*/
  0.5000000000,   0.5625000000,   0.6250000000,   0.6875000000,   0.7500000000,   0.8125000000,   0.8750000000,   0.9375000000, /* 0   0x7*/
  1.0000000000,   1.1250000000,   1.2500000000,   1.3750000000,   1.5000000000,   1.6250000000,   1.7500000000,   1.8750000000, /* 0   0x8*/
  2.0000000000,   2.2500000000,   2.5000000000,   2.7500000000,   3.0000000000,   3.2500000000,   3.5000000000,   3.7500000000, /* 0   0x9*/
  4.0000000000,   4.5000000000,   5.0000000000,   5.5000000000,   6.0000000000,   6.5000000000,   7.0000000000,   7.5000000000, /* 0   0xa*/
  8.0000000000,   9.0000000000,  10.0000000000,  11.0000000000,  12.0000000000,  13.0000000000,  14.0000000000,  15.0000000000, /* 0   0xb*/
 16.0000000000,  18.0000000000,  20.0000000000,  22.0000000000,  24.0000000000,  26.0000000000,  28.0000000000,  30.0000000000, /* 0   0xc*/
 32.0000000000,  36.0000000000,  40.0000000000,  44.0000000000,  48.0000000000,  52.0000000000,  56.0000000000,  60.0000000000, /* 0   0xd*/
 64.0000000000,  72.0000000000,  80.0000000000,  88.0000000000,  96.0000000000, 104.0000000000, 112.0000000000, 120.0000000000, /* 0   0xe*/
128.0000000000, 144.0000000000, 160.0000000000, 176.0000000000, 192.0000000000, 208.0000000000, 224.0000000000, 240.0000000000, /* 0   0xf*/
    NotANumber,  -0.0009765625,  -0.0019531250,  -0.0029296875,  -0.0039062500,  -0.0048828125,  -0.0058593750,  -0.0068359375, /* 1   0x0*/
 -0.0078125000,  -0.0087890625,  -0.0097656250,  -0.0107421875,  -0.0117187500,  -0.0126953125,  -0.0136718750,  -0.0146484375, /* 1   0x1*/
 -0.0156250000,  -0.0175781250,  -0.0195312500,  -0.0214843750,  -0.0234375000,  -0.0253906250,  -0.0273437500,  -0.0292968750, /* 1   0x2*/
 -0.0312500000,  -0.0351562500,  -0.0390625000,  -0.0429687500,  -0.0468750000,  -0.0507812500,  -0.0546875000,  -0.0585937500, /* 1   0x3*/
 -0.0625000000,  -0.0703125000,  -0.0781250000,  -0.0859375000,  -0.0937500000,  -0.1015625000,  -0.1093750000,  -0.1171875000, /* 1   0x4*/
 -0.1250000000,  -0.1406250000,  -0.1562500000,  -0.1718750000,  -0.1875000000,  -0.2031250000,  -0.2187500000,  -0.2343750000, /* 1   0x5*/
 -0.2500000000,  -0.2812500000,  -0.3125000000,  -0.3437500000,  -0.3750000000,  -0.4062500000,  -0.4375000000,  -0.4687500000, /* 1   0x6*/
 -0.5000000000,  -0.5625000000,  -0.6250000000,  -0.6875000000,  -0.7500000000,  -0.8125000000,  -0.8750000000,  -0.9375000000, /* 1   0x7*/
 -1.0000000000,  -1.1250000000,  -1.2500000000,  -1.3750000000,  -1.5000000000,  -1.6250000000,  -1.7500000000,  -1.8750000000, /* 1   0x8*/
 -2.0000000000,  -2.2500000000,  -2.5000000000,  -2.7500000000,  -3.0000000000,  -3.2500000000,  -3.5000000000,  -3.7500000000, /* 1   0x9*/
 -4.0000000000,  -4.5000000000,  -5.0000000000,  -5.5000000000,  -6.0000000000,  -6.5000000000,  -7.0000000000,  -7.5000000000, /* 1   0xa*/
 -8.0000000000,  -9.0000000000, -10.0000000000, -11.0000000000, -12.0000000000, -13.0000000000, -14.0000000000, -15.0000000000, /* 1   0xb*/
-16.0000000000, -18.0000000000, -20.0000000000, -22.0000000000, -24.0000000000, -26.0000000000, -28.0000000000, -30.0000000000, /* 1   0xc*/
-32.0000000000, -36.0000000000, -40.0000000000, -44.0000000000, -48.0000000000, -52.0000000000, -56.0000000000, -60.0000000000, /* 1   0xd*/
-64.0000000000, -72.0000000000, -80.0000000000, -88.0000000000, -96.0000000000, -104.000000000, -112.000000000, -120.000000000, /* 1   0xe*/
-128.000000000, -144.000000000, -160.000000000, -176.000000000, -192.000000000, -208.000000000, -224.000000000, -240.000000000  /* 1   0xf*/
            // clang-format on
        };

        // All values of FP8 (E4M3) with bias 7
        static constexpr std::array ValuesInOCPMode = {
            // clang-format off
//  -------------------------------------------------------- Mantissa ---------------------------------------------------------
//      0               1              2                3               4               5                6              7        SIGN  EXP
   0.000000000,    0.001953125,    0.003906250,    0.005859375,    0.007812500,    0.009765625,    0.011718750,    0.0136718750, /* 0   0x0*/
   0.015625000,    0.017578125,    0.019531250,    0.021484375,    0.023437500,    0.025390625,    0.027343750,    0.0292968750, /* 0   0x1*/
   0.031250000,    0.035156250,    0.039062500,    0.042968750,    0.046875000,    0.050781250,    0.054687500,    0.0585937500, /* 0   0x2*/
   0.062500000,    0.070312500,    0.078125000,    0.085937500,    0.093750000,    0.101562500,    0.109375000,    0.1171875000, /* 0   0x3*/
   0.125000000,    0.140625000,    0.156250000,    0.171875000,    0.187500000,    0.203125000,    0.218750000,    0.2343750000, /* 0   0x4*/
   0.250000000,    0.281250000,    0.312500000,    0.343750000,    0.375000000,    0.406250000,    0.437500000,    0.4687500000, /* 0   0x5*/
   0.500000000,    0.562500000,    0.625000000,    0.687500000,    0.750000000,    0.812500000,    0.875000000,    0.9375000000, /* 0   0x6*/
   1.000000000,    1.125000000,    1.250000000,    1.375000000,    1.500000000,    1.625000000,    1.750000000,    1.8750000000, /* 0   0x7*/
   2.000000000,    2.250000000,    2.500000000,    2.750000000,    3.000000000,    3.250000000,    3.500000000,    3.7500000000, /* 0   0x8*/
   4.000000000,    4.500000000,    5.000000000,    5.500000000,    6.000000000,    6.500000000,    7.000000000,    7.5000000000, /* 0   0x9*/
   8.000000000,    9.000000000,   10.000000000,   11.000000000,   12.000000000,   13.000000000,   14.000000000,   15.0000000000, /* 0   0xa*/
  16.000000000,   18.000000000,   20.000000000,   22.000000000,   24.000000000,   26.000000000,   28.000000000,   30.0000000000, /* 0   0xb*/
  32.000000000,   36.000000000,   40.000000000,   44.000000000,   48.000000000,   52.000000000,   56.000000000,   60.0000000000, /* 0   0xc*/
  64.000000000,   72.000000000,   80.000000000,   88.000000000,   96.000000000,  104.000000000,  112.000000000,  120.0000000000, /* 0   0xd*/
 128.000000000,  144.000000000,  160.000000000,  176.000000000,  192.000000000,  208.000000000,  224.000000000,  240.0000000000, /* 0   0xe*/
 256.000000000,  288.000000000,  320.000000000,  352.000000000,  384.000000000,  416.000000000,  448.000000000,      NotANumber, /* 0   0xf*/
  -0.000000000,   -0.001953125,   -0.003906250,   -0.005859375,   -0.007812500,   -0.009765625,   -0.011718750,   -0.0136718750, /* 1   0x0*/
  -0.015625000,   -0.017578125,   -0.019531250,   -0.021484375,   -0.023437500,   -0.025390625,   -0.027343750,   -0.0292968750, /* 1   0x1*/
  -0.031250000,   -0.035156250,   -0.039062500,   -0.042968750,   -0.046875000,   -0.050781250,   -0.054687500,   -0.0585937500, /* 1   0x2*/
  -0.062500000,   -0.070312500,   -0.078125000,   -0.085937500,   -0.093750000,   -0.101562500,   -0.109375000,   -0.1171875000, /* 1   0x3*/
  -0.125000000,   -0.140625000,   -0.156250000,   -0.171875000,   -0.187500000,   -0.203125000,   -0.218750000,   -0.2343750000, /* 1   0x4*/
  -0.250000000,   -0.281250000,   -0.312500000,   -0.343750000,   -0.375000000,   -0.406250000,   -0.437500000,   -0.4687500000, /* 1   0x5*/
  -0.500000000,   -0.562500000,   -0.625000000,   -0.687500000,   -0.750000000,   -0.812500000,   -0.875000000,   -0.9375000000, /* 1   0x6*/
  -1.000000000,   -1.125000000,   -1.250000000,   -1.375000000,   -1.500000000,   -1.625000000,   -1.750000000,   -1.8750000000, /* 1   0x7*/
  -2.000000000,   -2.250000000,   -2.500000000,   -2.750000000,   -3.000000000,   -3.250000000,   -3.500000000,   -3.7500000000, /* 1   0x8*/
  -4.000000000,   -4.500000000,   -5.000000000,   -5.500000000,   -6.000000000,   -6.500000000,   -7.000000000,   -7.5000000000, /* 1   0x9*/
  -8.000000000,   -9.000000000,  -10.000000000,  -11.000000000,  -12.000000000,  -13.000000000,  -14.000000000,  -15.0000000000, /* 1   0xa*/
 -16.000000000,  -18.000000000,  -20.000000000,  -22.000000000,  -24.000000000,  -26.000000000,  -28.000000000,  -30.0000000000, /* 1   0xb*/
 -32.000000000,  -36.000000000,  -40.000000000,  -44.000000000,  -48.000000000,  -52.000000000,  -56.000000000,  -60.0000000000, /* 1   0xc*/
 -64.000000000,  -72.000000000,  -80.000000000,  -88.000000000,  -96.000000000, -104.000000000, -112.000000000, -120.0000000000, /* 1   0xd*/
-128.000000000, -144.000000000, -160.000000000, -176.000000000, -192.000000000, -208.000000000, -224.000000000, -240.0000000000, /* 1   0xe*/
-256.000000000, -288.000000000, -320.000000000, -352.000000000, -384.000000000, -416.000000000, -448.000000000,     -NotANumber  /* 1   0xf*/
            // clang-format on
        };
    };
}
