/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fr_CA extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "heure d\u2019Afrique centrale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "heure normale de Moscou",
               "",
               "heure avanc\u00e9e de Moscou",
               "",
               "heure de Moscou",
               "",
            };
        final String[] Japan = new String[] {
               "heure normale du Japon",
               "",
               "heure avanc\u00e9e du Japon",
               "",
               "heure du Japon",
               "",
            };
        final String[] Pakistan = new String[] {
               "heure normale du Pakistan",
               "",
               "heure avanc\u00e9e du Pakistan",
               "",
               "heure du Pakistan",
               "",
            };
        final String[] Taipei = new String[] {
               "heure normale de Taipei",
               "",
               "heure avanc\u00e9e de Taipei",
               "",
               "heure de Taipei",
               "",
            };
        final String[] Hovd = new String[] {
               "heure normale de Hovd",
               "",
               "heure avanc\u00e9e de Hovd",
               "",
               "heure de Hovd",
               "",
            };
        final String[] Magadan = new String[] {
               "heure normale de Magadan",
               "",
               "heure avanc\u00e9e de Magadan",
               "",
               "heure de Magadan",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "heure normale du centre-ouest de l\u2019Australie",
               "",
               "heure avanc\u00e9e du centre-ouest de l\u2019Australie",
               "",
               "heure du centre-ouest de l\u2019Australie",
               "",
            };
        final String[] Europe_Central = new String[] {
               "heure normale d\u2019Europe centrale",
               "",
               "heure avanc\u00e9e d\u2019Europe centrale",
               "",
               "heure d\u2019Europe centrale",
               "",
            };
        final String[] Sakhalin = new String[] {
               "heure normale de Sakhaline",
               "",
               "heure avanc\u00e9e de Sakhaline",
               "",
               "heure de Sakhaline",
               "",
            };
        final String[] Paraguay = new String[] {
               "heure normale du Paraguay",
               "",
               "heure avanc\u00e9e du Paraguay",
               "",
               "heure du Paraguay",
               "",
            };
        final String[] Acre = new String[] {
               "heure normale de l\u2019Acre",
               "",
               "heure avanc\u00e9e de l\u2019Acre",
               "",
               "heure de l\u2019Acre",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "temps universel coordonn\u00e9",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Eastern = new String[] {
               "heure normale de l\u2019Est",
               "HNE",
               "heure avanc\u00e9e de l\u2019Est",
               "HAE",
               "heure de l\u2019Est",
               "HE",
            };
        final String[] Lord_Howe = new String[] {
               "heure normale de Lord Howe",
               "",
               "heure avanc\u00e9e de Lord Howe",
               "",
               "heure de Lord Howe",
               "",
            };
        final String[] New_Zealand = new String[] {
               "heure normale de la Nouvelle-Z\u00e9lande",
               "",
               "heure avanc\u00e9e de la Nouvelle-Z\u00e9lande",
               "",
               "heure de la Nouvelle-Z\u00e9lande",
               "",
            };
        final String[] Yakutsk = new String[] {
               "heure normale de Iakoutsk",
               "",
               "heure avanc\u00e9e de Iakoutsk",
               "",
               "heure de Iakoutsk",
               "",
            };
        final String[] Mauritius = new String[] {
               "heure normale de Maurice",
               "",
               "heure avanc\u00e9e de Maurice",
               "",
               "heure de Maurice",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "heure d\u2019Afrique orientale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "heure normale d\u2019Europe de l\u2019Est",
               "",
               "heure avanc\u00e9e d\u2019Europe de l\u2019Est",
               "",
               "heure d\u2019Europe de l\u2019Est",
               "",
            };
        final String[] Newfoundland = new String[] {
               "heure normale de Terre-Neuve",
               "HNT",
               "heure avanc\u00e9e de Terre-Neuve",
               "HAT",
               "heure de Terre-Neuve",
               "HT",
            };
        final String[] Hong_Kong = new String[] {
               "heure normale de Hong Kong",
               "",
               "heure avanc\u00e9e de Hong Kong",
               "",
               "heure de Hong Kong",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "heure normale de l\u2019Ouest argentin",
               "",
               "heure avanc\u00e9e de l\u2019Ouest argentin",
               "",
               "heure de l\u2019Ouest argentin",
               "",
            };
        final String[] Atlantic = new String[] {
               "heure normale de l\u2019Atlantique",
               "",
               "heure avanc\u00e9e de l\u2019Atlantique",
               "",
               "heure de l\u2019Atlantique",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "heure normale de Saint-Pierre-et-Miquelon",
               "",
               "heure avanc\u00e9e de Saint-Pierre-et-Miquelon",
               "",
               "heure de Saint-Pierre-et-Miquelon",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "heure normale d\u2019Ekaterinbourg",
               "",
               "heure avanc\u00e9e d\u2019Ekaterinbourg",
               "",
               "heure d\u2019Ekaterinbourg",
               "",
            };
        final String[] Israel = new String[] {
               "heure normale d\u2019Isra\u00ebl",
               "",
               "heure avanc\u00e9e d\u2019Isra\u00ebl",
               "",
               "heure d\u2019Isra\u00ebl",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "heure normale d\u2019Afrique du Sud",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "heure normale de l\u2019Ouzb\u00e9kistan",
               "",
               "heure avanc\u00e9e de l\u2019Ouzb\u00e9kistan",
               "",
               "heure de l\u2019Ouzb\u00e9kistan",
               "",
            };
        final String[] Omsk = new String[] {
               "heure normale d\u2019Omsk",
               "",
               "heure avanc\u00e9e d\u2019Omsk",
               "",
               "heure d\u2019Omsk",
               "",
            };
        final String[] Uruguay = new String[] {
               "heure normale de l\u2019Uruguay",
               "",
               "heure avanc\u00e9e de l\u2019Uruguay",
               "",
               "heure de l\u2019Uruguay",
               "",
            };
        final String[] Mongolia = new String[] {
               "heure normale d\u2019Oulan-Bator",
               "",
               "heure avanc\u00e9e d\u2019Oulan-Bator",
               "",
               "heure d\u2019Oulan-Bator",
               "",
            };
        final String[] America_Central = new String[] {
               "heure normale du Centre",
               "HNC",
               "heure avanc\u00e9e du Centre",
               "HAC",
               "heure du Centre",
               "HC",
            };
        final String[] Falkland = new String[] {
               "heure normale des \u00eeles Malouines",
               "",
               "heure avanc\u00e9e des \u00eeles Malouines",
               "",
               "heure des \u00eeles Malouines",
               "",
            };
        final String[] Vanuatu = new String[] {
               "heure normale du Vanuatu",
               "",
               "heure avanc\u00e9e de Vanuatu",
               "",
               "heure du Vanuatu",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "heure normale de Novossibirsk",
               "",
               "heure avanc\u00e9e de Novossibirsk",
               "",
               "heure de Novossibirsk",
               "",
            };
        final String[] Azores = new String[] {
               "heure normale des A\u00e7ores",
               "",
               "heure avanc\u00e9e des A\u00e7ores",
               "",
               "heure des A\u00e7ores",
               "",
            };
        final String[] Apia = new String[] {
               "heure normale d\u2019Apia",
               "",
               "heure avanc\u00e9e d\u2019Apia",
               "",
               "heure d\u2019Apia",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "heure normale de Krasno\u00efarsk",
               "",
               "heure avanc\u00e9e de Krasno\u00efarsk",
               "",
               "heure de Krasno\u00efarsk",
               "",
            };
        final String[] Amazon = new String[] {
               "heure normale de l\u2019Amazonie",
               "",
               "heure avanc\u00e9e de l\u2019Amazonie",
               "",
               "heure de l\u2019Amazonie",
               "",
            };
        final String[] Fiji = new String[] {
               "heure normale des \u00eeles Fidji",
               "",
               "heure avanc\u00e9e des \u00eeles Fidji",
               "",
               "heure des \u00eeles Fidji",
               "",
            };
        final String[] Reunion = new String[] {
               "heure de la R\u00e9union",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "heure normale des \u00celes Chatham",
               "",
               "heure avanc\u00e9e des \u00celes Chatham",
               "",
               "heure des \u00eeles Chatham",
               "",
            };
        final String[] Argentina = new String[] {
               "heure normale d\u2019Argentine",
               "",
               "heure avanc\u00e9e de l\u2019Argentine",
               "",
               "heure de l\u2019Argentine",
               "",
            };
        final String[] Kamchatka = new String[] {
               "heure normale de Petropavlovsk-Kamchatski",
               "",
               "heure avanc\u00e9e de Petropavlovsk-Kamchatski",
               "",
               "heure de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "heure normale d\u2019Hawa\u00ef-Al\u00e9outiennes",
               "",
               "heure avanc\u00e9e d\u2019Hawa\u00ef-Al\u00e9outiennes",
               "",
               "heure d\u2019Hawa\u00ef-Al\u00e9outiennes",
               "",
            };
        final String[] Australia_Central = new String[] {
               "heure normale du centre de l\u2019Australie",
               "",
               "heure avanc\u00e9e du centre de l\u2019Australie",
               "",
               "heure du centre de l\u2019Australie",
               "",
            };
        final String[] America_Pacific = new String[] {
               "heure normale du Pacifique",
               "HNP",
               "heure avanc\u00e9e du Pacifique",
               "HAP",
               "heure du Pacifique",
               "HP",
            };
        final String[] Turkmenistan = new String[] {
               "heure normale du Turkm\u00e9nistan",
               "",
               "heure avanc\u00e9e du Turkm\u00e9nistan",
               "",
               "heure du Turkm\u00e9nistan",
               "",
            };
        final String[] Europe_Western = new String[] {
               "heure normale d\u2019Europe de l\u2019Ouest",
               "",
               "heure avanc\u00e9e d\u2019Europe de l\u2019Ouest",
               "",
               "heure d\u2019Europe de l\u2019Ouest",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "heure normale du Cap-Vert",
               "",
               "heure avanc\u00e9e du Cap-Vert",
               "",
               "heure du Cap-Vert",
               "",
            };
        final String[] Samoa = new String[] {
               "heure normale des Samoa",
               "",
               "heure avanc\u00e9e des Samoa",
               "",
               "heure des Samoa",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "heure normale de l\u2019Azerba\u00efdjan",
               "",
               "heure avanc\u00e9e d\u2019Azerba\u00efdjan",
               "",
               "heure de l\u2019Azerba\u00efdjan",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "heure normale du Pacifique mexicain",
               "",
               "heure avanc\u00e9e du Pacifique mexicain",
               "",
               "heure du Pacifique mexicain",
               "",
            };
        final String[] Cuba = new String[] {
               "heure normale de Cuba",
               "",
               "heure avanc\u00e9e de Cuba",
               "",
               "heure de Cuba",
               "",
            };
        final String[] Africa_Western = new String[] {
               "heure normale d\u2019Afrique de l\u2019Ouest",
               "",
               "heure avanc\u00e9e d\u2019Afrique de l\u2019Ouest",
               "",
               "heure d\u2019Afrique de l\u2019Ouest",
               "",
            };
        final String[] Philippines = new String[] {
               "heure normale des Philippines",
               "",
               "heure avanc\u00e9e des Philippines",
               "",
               "heure des Philippines",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "heure normale de la Nouvelle-Cal\u00e9donie",
               "",
               "heure avanc\u00e9e de Nouvelle-Cal\u00e9donie",
               "",
               "heure de la Nouvelle-Cal\u00e9donie",
               "",
            };
        final String[] Iran = new String[] {
               "heure normale d\u2019Iran",
               "",
               "heure avanc\u00e9e d\u2019Iran",
               "",
               "heure de l\u2019Iran",
               "",
            };
        final String[] Easter = new String[] {
               "heure normale de l\u2019\u00eele de P\u00e2ques",
               "",
               "heure avanc\u00e9e de l\u2019\u00eele de P\u00e2ques",
               "",
               "heure de l\u2019\u00eele de P\u00e2ques",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "heure normale du Nord-Ouest du Mexique",
               "",
               "heure avanc\u00e9e du Nord-Ouest du Mexique",
               "",
               "heure du Nord-Ouest du Mexique",
               "",
            };
        final String[] Tonga = new String[] {
               "heure normale des Tonga",
               "",
               "heure avanc\u00e9e de Tonga",
               "",
               "heure des Tonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "heure normale du Bangladesh",
               "",
               "heure avanc\u00e9e du Bangladesh",
               "",
               "heure du Bangladesh",
               "",
            };
        final String[] Peru = new String[] {
               "heure normale du P\u00e9rou",
               "",
               "heure avanc\u00e9e du P\u00e9rou",
               "",
               "heure du P\u00e9rou",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "heure normale de l\u2019Ouest du Groenland",
               "",
               "heure avanc\u00e9e de l\u2019Ouest du Groenland",
               "",
               "heure de l\u2019Ouest du Groenland",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "heure normale de l\u2019Est du Groenland",
               "",
               "heure avanc\u00e9e de l\u2019Est du Groenland",
               "",
               "heure de l\u2019Est du Groenland",
               "",
            };
        final String[] Korea = new String[] {
               "heure normale de la Cor\u00e9e",
               "",
               "heure avanc\u00e9e de Cor\u00e9e",
               "",
               "heure de la Cor\u00e9e",
               "",
            };
        final String[] Australia_Western = new String[] {
               "heure normale de l\u2019Ouest de l\u2019Australie",
               "",
               "heure avanc\u00e9e de l\u2019Ouest de l\u2019Australie",
               "",
               "heure de l\u2019Ouest de l\u2019Australie",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "heure normale de l\u2019Est de l\u2019Australie",
               "",
               "heure avanc\u00e9e de l\u2019Est de l\u2019Australie",
               "",
               "heure de l\u2019Est de l\u2019Australie",
               "",
            };
        final String[] French_Guiana = new String[] {
               "heure de Guyane fran\u00e7aise",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "heure normale de Colombie",
               "",
               "heure avanc\u00e9e de Colombie",
               "",
               "heure de Colombie",
               "",
            };
        final String[] Chile = new String[] {
               "heure normale du Chili",
               "",
               "heure avanc\u00e9e du Chili",
               "",
               "heure du Chili",
               "",
            };
        final String[] America_Mountain = new String[] {
               "heure normale des Rocheuses",
               "HNR",
               "heure avanc\u00e9e des Rocheuses",
               "HAR",
               "heure des Rocheuses",
               "HR",
            };
        final String[] Arabian = new String[] {
               "heure normale de l\u2019Arabie",
               "",
               "heure avanc\u00e9e de l\u2019Arabie",
               "",
               "heure de l\u2019Arabie",
               "",
            };
        final String[] Alaska = new String[] {
               "heure normale de l\u2019Alaska",
               "",
               "heure avanc\u00e9e de l\u2019Alaska",
               "",
               "heure de l\u2019Alaska",
               "",
            };
        final String[] Vladivostok = new String[] {
               "heure normale de Vladivostok",
               "",
               "heure avanc\u00e9e de Vladivostok",
               "",
               "heure de Vladivostok",
               "",
            };
        final String[] Irkutsk = new String[] {
               "heure normale d\u2019Irkoutsk",
               "",
               "heure avanc\u00e9e d\u2019Irkoutsk",
               "",
               "heure d\u2019Irkoutsk",
               "",
            };
        final String[] Georgia = new String[] {
               "heure normale de la G\u00e9orgie",
               "",
               "heure avanc\u00e9e de G\u00e9orgie",
               "",
               "heure de la G\u00e9orgie",
               "",
            };
        final String[] Noronha = new String[] {
               "heure normale de Fernando de Noronha",
               "",
               "heure avanc\u00e9e de Fernando de Noronha",
               "",
               "heure de Fernando de Noronha",
               "",
            };
        final String[] Choibalsan = new String[] {
               "heure normale de Choibalsan",
               "",
               "heure avanc\u00e9e de Choibalsan",
               "",
               "heure de Choibalsan",
               "",
            };
        final String[] Brasilia = new String[] {
               "heure normale de Brasilia",
               "",
               "heure avanc\u00e9e de Brasilia",
               "",
               "heure de Brasilia",
               "",
            };
        final String[] China = new String[] {
               "heure normale de Chine",
               "",
               "heure avanc\u00e9e de Chine",
               "",
               "heure de Chine",
               "",
            };
        final String[] Armenia = new String[] {
               "heure normale de l\u2019Arm\u00e9nie",
               "",
               "heure avanc\u00e9e d\u2019Arm\u00e9nie",
               "",
               "heure de l\u2019Arm\u00e9nie",
               "",
            };
        final String[] Anadyr = new String[] {
               "heure normale d\u2019Anadyr",
               "",
               "heure avanc\u00e9e d\u2019Anadyr",
               "",
               "heure d\u2019Anadyr",
               "",
            };
        final String[] Cook = new String[] {
               "heure normale des \u00eeles Cook",
               "",
               "heure avanc\u00e9e des \u00eeles Cook",
               "",
               "heure des \u00eeles Cook",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/El_Salvador", America_Central },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "",
                    "",
                    "heure avanc\u00e9e britannique",
                    "",
                    "",
                    "",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah [Dakota du Nord]" },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "JST", Japan },
            { "Europe/Warsaw", Europe_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Africa/Kigali", Africa_Central },
            { "BET", Brasilia },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "\u00eele de P\u00e2ques" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Indian/Comoro", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Atlantic/Canary", "\u00eeles Canaries" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.Europe/Vatican", "Vatican" },
            { "timezone.excity.America/North_Dakota/Center", "Center [Dakota du Nord]" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/Curacao", Atlantic },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", Africa_Western },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "SystemV/AST4", Atlantic },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "CNT", Newfoundland },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Africa/Tripoli", "Tripoli [Libye]" },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota du Nord" },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Kralendijk", Atlantic },
            { "America/Antigua", Atlantic },
            { "NET", Armenia },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Yakutat", Alaska },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "America/Mazatlan", Mexico_Pacific },
            { "Europe/Tirane", Europe_Central },
            { "SystemV/MST7", America_Mountain },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "timezone.excity.America/St_Kitts", "Saint-Christophe-et-Ni\u00e9v\u00e8s" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "CST", America_Central },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "",
                    "",
                    "heure avanc\u00e9e irlandaise",
                    "",
                    "",
                    "",
                }
            },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Atlantic/Stanley", Falkland },
            { "SystemV/CST6", America_Central },
            { "CTT", China },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Europe/Isle_of_Man", "\u00eele de Man" },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Hovd", Hovd },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "Asia/Manila", Philippines },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Europe/Andorra", Europe_Central },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Resolute", America_Central },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "",
                    "",
                    "heure avanc\u00e9e britannique",
                    "",
                    "",
                    "",
                }
            },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "timezone.excity.America/St_Johns", "St. John\u2019s" },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Detroit", America_Eastern },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "NST", New_Zealand },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Johannesburg", Africa_Southern },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.America/Cayman", "\u00eeles Ca\u00efmans" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbade (La)" },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.Atlantic/Faeroe", "\u00eeles F\u00e9ro\u00e9" },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "ECT", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Europe/Bratislava", Europe_Central },
            { "America/Argentina/Tucuman", Argentina },
            { "Pacific/Tongatapu", Tonga },
            { "SystemV/YST9YDT", Alaska },
            { "timezone.excity.Asia/Thimphu", "Thimphou" },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Asia/Ust-Nera", Vladivostok },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Anadyr },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "SystemV/AST4ADT", Atlantic },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "SystemV/EST5EDT", America_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
