/*
 * SSMFlagbyteDefinitions_tr.cpp - SSM flagbyte definitions (tr)
 *
 * Copyright (C) 2008-2019 Comer352L
 * Copyright (C) 2019 madanadam (Turkish translation)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "SSMFlagbyteDefinitions_tr.h"


// Measuring Blocks (data):
const QStringList SSMFlagbyteDefinitions_tr::_MB_defs_tr =
	QStringList()
	<< "1;1;3;00000F;00000E;Motor Hızı;rpm;/4;0"
	<< "1;2;1;00000D;;Manifold Mutlak Basıncı;kPa;*1;0"
	<< "1;3;1;00000C;;Hava/Yakıt Öğrenme #2;%;-128/128*100;1"
	<< "1;4;1;00000B;;Hava/Yakıt Düzeltme #2;%;-128/128*100;1"
	<< "1;5;1;00000A;;Hava/Yakıt Öğrenme #1;%;-128/128*100;1"
	<< "1;6;1;000009;;Hava/Yakıt Düzeltme #1;%;-128/128*100;1"
	<< "1;7;1;000008;;Soğutucu Sıcaklığı;°C;-40;0"
	<< "1;8;1;000007;;Motor yükü;%;/255*100;1"
	<< "2;1;1;00001B;00001A;Ön O2 Sensörü #2 Gerilimi;V;/200;3"
	<< "2;2;1;000019;000018;Arka O2 Sensörü Gerilimi;V;/200;3"
	<< "2;3;1;000017;000016;Ön O2 Sensörü #1 Gerilimi;V;/200;3"
	<< "2;4;1;000015;;Gaz Kelebeği Açma Açısı;%;/255*100;1"
	<< "2;5;1;000014;000013;Kütle Hava Akışı;g/s;/100;2"
	<< "2;6;1;000012;;Emme Havası Sıcaklığı;°C;-40;0"
	<< "2;7;1;000011;;Ateşleme Zamanlaması;deg;-128/2;1"
	<< "2;8;1;000010;;Araç Hızı;km/h;*1;0"
	<< "3;1;1;000023;;Atmosfer Basıncı;kPa;*1;0"
	<< "3;2;1;000022;;Tekleme Düzeltmesi;deg;-128/2;1"
	<< "3;3;1;000021;;Yakıt Enjeksiyonu #2 Vuruşu;ms;*256/1000;2"
	<< "3;4;1;000020;;Yakıt Enjeksiyonu #1 Vuruşu;ms;*256/1000;2"
	<< "3;5;1;00001F;;Diferansiyel Basınç Sensörü Gerilimi;V;/50;2"
	<< "3;6;3;00001E;;Gaz Kelebeği Sensörü Gerilimi;V;/50;2"
	<< "3;7;3;00001D;;Hava Akış Sensörü Gerilimi;V;/50;2"
	<< "3;8;3;00001C;;Akü Gerilimi;V;*2/25;1"
	<< "4;1;1;00002B;;Ön O2 Sensörü #1 Isıtıcı Akımı;A;/255*10;2"
	<< "4;2;1;00002A;;Yakıt Sıcaklığı;°C;-40;0"
	<< "4;3;3;000029;;Gaz Pedalı Açısı;%;/255*100;1"
	<< "4;4;1;000028;;Öğrenilmiş Ateşleme Zamanlaması;deg;-128/2;1"
	<< "4;5;1;000027;;CO Ayarlama Gerilimi;V;/50;2"
	<< "4;6;1;000026;;Yakıt Deposu Basıncı;kPa;-128/40;2"
	<< "4;7;1;000025;;Basınç Diferansiyel Sensörü;kPa;-128;0"
	<< "4;8;1;000024;;Manifold Bağıl Basınç;kPa;-128;0"
	<< "5;1;1;000033;;Tumble Jeneratör Valfi (TGV) Pozisyon Sensörü (Sağ);V;/50;2"
	<< "5;2;1;000032;;Kanister Boşaltma Kontrolü (CPC) Valf Görev Döngüsü;%;/255*100;0"
	<< "5;3;1;000031;;İkincil Wastegate Görev Döngüsü;%;/255*100;1"
	<< "5;4;1;000030;;Birincil Wastegate Görev Döngüsü;%;/255*100;1"
	<< "5;5;1;00002F;;Radyatör Fan Kontrolü;%;*1;0"
	<< "5;6;1;00002E;;Yakıt Seviyesi Sensörü Gerilimi;V;/50;2"
	<< "5;7;1;00002D;;Ön O2 Sensörü # 2 Isıtıcı Akımı;A;/255*10;2"
	<< "5;8;1;00002C;;Arka O2 Sensörü Isıtıcı Akımı;A;/255*10;2"
	<< "6;1;1;00003B;;Yakıt Pompası Görevi;%;/255*100;0"
	<< "6;2;1;00003A;;Alternatör Görevi;%;*1;0"
	<< "6;3;1;000039;;Egzoz Gazı Devridaimi (EGR) Adım Sayısı;steps;*1;0"
	<< "6;4;1;000038;;Rölanti Devri Kontrol (ISC) Valfi Adım Sayısı;steps;*1;0"
	<< "6;5;1;000037;;Hava/Yakıt Isıtıcı Görevi;%;/255*100;1"
	<< "6;6;1;000036;;Hava/Yakıt Oranı Fakirliği Düzeltmesi;%;/255*100;0"
	<< "6;7;1;000035;;Rölanti Devri Kontrolü (ISC) Valfi Görev Oranı;%;/2;1"
	<< "6;8;1;000034;;Tumble Jeneratör Valfi (TGV) Pozisyon Sensörü (Sol);V;/50;2"
	<< "7;1;1;000043;;Hava/Yakıt Sensörü #2 Akımı;mA;-128/8;2"
	<< "7;2;1;000042;;Hava/Yakıt Sensörü #1 Akımı;mA;-128/8;2"
	<< "7;3;1;000041;;Yağ Akışı Kontrol Solenoid Valfi (OCV) Akımı (Sol, Emiş);mA;*32;0"
	<< "7;4;1;000040;;Yağ Akışı Kontrol Solenoid Valfi (OCV) Akımı (Sağ, Emiş);mA;*32;0"
	<< "7;5;1;00003F;;Yağ Akışı Kontrol Solenoid Valfı (OCV) Görevi (Sol, Emiş);%;/255*100;1"
	<< "7;6;1;00003E;;Yağ Akışı Kontrol Solenoid Valfi (OCV) Görevi (Sağ, Emiş);%;/255*100;1"
	<< "7;7;1;00003D;;Değişken Valf Zamanlaması (VVT) Ön Açı Miktarı (Sol, Emiş);deg;-50;0"
	<< "7;8;1;00003C;;Değişken Valf Zamanlaması (VVT) Ön Açı Miktarı (Sağ, Emiş);deg;-50;0"
	<< "8;1;1;0000D3;;Hava/Yakıt Ayar Gerilimi;V;/50;2"
	<< "8;2;1;0000D2;;Arka O2 Sensörü Isıtıcı Gerilimi;V;/50;2"
	<< "8;3;1;0000D1;;Hava/Yakıt Öğrenmesi #3;%;-128/128*100;2"
	<< "8;4;1;0000D0;;Hava/Yakıt Düzeltmesi #3;%;-64/128*10;2"
	<< "8;5;1;000047;;Hava/Yakıt Sensörü #2 Lambda;;/128;2"
	<< "8;6;1;000046;;Hava/Yakıt Sensörü #1 Lambda;;/128;2"
	<< "8;7;1;000045;;Hava/Yakıt Sensörü #2 Direnci;ohms;*1;0"
	<< "8;8;1;000044;;Hava/Yakıt Sensörü #1 Direnci;ohms;*1;0"
	<< "9;1;2;00004F;;Türbin Devir Hızı;rpm;*32;0"
	<< "9;2;2;00004E;;Gaz Kelebeği Sensörü Gerilimi;V;/45;2"
	<< "9;3;2;00004D;;Transferi Görev Oranı;%;/2;1"
	<< "9;4;2;00004C;;Kilitlenme Görev Oranı;%;/2;1"
	<< "9;5;2;00004B;;Hat Basıncı Görev Oranı;%;/2;1"
	<< "9;6;3;00004A;;Vites Konumu;gear;+1;0"
	<< "9;7;2;000049;;ATF Sıcaklığı;°C;0=-60,1=-60,2=-51,3=-45,4=-40,5=-37,6=-34,7=-31,8=-29,9=-27,10=-25,11=-23,12=-22,13=-20,14=-19,15=-17,16=-16,17=-15,18=-14,19=-13,20=-12,21=-10,22=-9,23=-9,24=-8,25=-7,26=-6,27=-5,28=-4,29=-3,30=-2,31=-2,32=-1,33=0,34=1,35=1,36=2,37=3,38=3,39=4,40=5,41=5,42=6,43=7,44=7,45=8,46=8,47=9,48=10,49=10,50=11,51=11,52=12,53=12,54=13,55=13,56=14,57=15,58=15,59=16,60=16,61=17,62=17,63=18,64=18,65=19,66=19,67=20,68=20,69=21,70=21,71=22,72=22,73=23,74=23,75=23,76=24,77=24,78=25,79=25,80=26,81=26,82=27,83=27,84=28,85=28,86=29,87=29,88=29,89=30,90=30,91=31,92=31,93=32,94=32,95=33,96=33,97=33,98=34,99=34,100=35,101=35,102=36,103=36,104=37,105=37,106=37,107=38,108=38,109=39,110=39,111=40,112=40,113=41,114=41,115=41,116=42,117=42,118=43,119=43,120=44,121=44,122=45,123=45,124=45,125=46,126=46,127=47,128=47,129=48,130=48,131=49,132=49,133=50,134=50,135=50,136=51,137=51,138=52,139=52,140=53,141=53,142=54,143=54,144=55,145=55,146=56,147=56,148=57,149=57,150=58,151=58,152=59,153=59,154=60,155=60,156=61,157=61,158=62,159=62,160=63,161=63,162=64,163=65,164=65,165=66,166=66,167=67,168=67,169=68,170=68,171=69,172=70,173=70,174=71,175=71,176=72,177=73,178=73,179=74,180=75,181=75,182=76,183=77,184=77,185=78,186=79,187=79,188=80,189=81,190=81,191=82,192=83,193=84,194=84,195=85,196=86,197=87,198=88,199=88,200=89,201=90,202=91,203=92,204=93,205=94,206=95,207=96,208=97,209=98,210=99,211=100,212=101,213=102,214=103,215=104,216=105,217=107,218=108,219=109,220=110,221=112,222=113,223=115,224=116,225=118,226=119,227=121,228=123,229=125,230=127,231=129,232=131,233=133,234=135,235=138,236=140,237=143,238=146,239=149,240=152,241=156,242=159,243=164,244=168,245=173,246=179,247=186,248=193,249=202,250=212,251=225,252=241,253=264,254=300,255=373;0"
	<< "9;8;2;000048;;Ön Teker Hızı;km/h;*1;0"
	<< "10;1;2;000057;;Düşük Debriyaj Görevi;%;/2;1"
	<< "10;2;2;000056;;ATF Sıcaklığı;°C;-50;0"
	<< "10;3;2;000055;;Yanal G Sensör Gerilimi;V;/50;2"
	<< "10;4;1;000054;;Hava/Yakıt Sensörü #2 Isıtıcı Akımı;A;/10;1"
	<< "10;5;1;000053;;Hava/Yakıt Sensörü #1 Isıtıcı Akımı;A;/10;1"
	<< "10;6;2;000052;;Manifold Basınç Sensörü Gerilimi;V;/50;2"
	<< "10;7;2;000051;;Arka Teker Hızı;km/h;*1;0"
	<< "10;8;2;000050;;Brake Clutch Duty Ratio;%;/2;1"
	<< "11;1;2;00005F;;Merkezi Diferansiyel Gösterge Akımı;A;/32;2"
	<< "11;2;2;00005E;;Merkezi Diferansiyel Gerçek Akımı;A;/32;2"
	<< "11;3;2;00005D;;AT Türbin Hızı 2;rpm;*32;0"
	<< "11;4;2;00005C;;AT Türbin Hızı 1;rpm;*32;0"
	<< "11;5;2;00005B;;Merkezi Diferansiyel Şalter Gerilimi;V;/51;2"
	<< "11;6;2;00005A;;ATF Sıcaklığı 2;°C;-50;0"
	<< "11;7;2;000059;;Düşük & Geri Freni (L&R B) Duty;%;/2;1"
	<< "11;8;2;000058;;Yüksek Debriyaj Görevi;%;/2;1"
	<< "31;5;1;0000FB;;Boğaz Kelebeği Motor Voltajı;V;*2/25;1"
	<< "31;6;1;0000FA;;Boğaz Kelebeği Motor Görevi;%;-128/128*100;0"
	<< "31;7;1;00016B;;Gaz Kelebeği Sensörü Kapalı Gerilim;V;/50;2"
	<< "31;8;3;00016A;;SI-Sürücü Modu;;0=---,1=S,2=S#,3=I,8=S#,16=I;"
	<< "33;1;1;000107;;Egzoz Gazı Sıcaklığı 2;°C;*5+200;0"
	<< "33;2;1;000106;;Egzoz Gazı Sıcaklığı;°C;*5+200;0"
	<< "33;3;1;000105;;Yakıt Basıncı;kPa;*2;0"
	//<< "33;4;1;1;000104;;Brake Booster Pressure;kPa;*1;0"			// UNCONFIRMED !!!
	<< "33;5;1;000103;;Ana Hızlandırıcı Sensörü Gerilimi;V;/50;2"
	<< "33;6;3;000102;;Alt Hızlandırıcı Sensör Gerilimi;V;/50;2"
	<< "33;7;1;000101;;Ana Gaz Kelebeği Sensörü Gerilimi;V;/50;2"
	<< "33;8;1;000100;;Alt Gaz Kelebeği Sensörü Gerilimi;V;/50;2"
	<< "34;1;1;000173;000172;Yakıt Deposu Hava Pompası Basıncı;MPa;/100;1"
	<< "34;2;1;00010F;00010E;Kilometre sayacı;km;*2;0"
	<< "34;3;1;00010D;;Yakıt Seviyesi Sensörü Direnci;ohms;*4/2;1"
	<< "34;4;1;00010C;;Hava/Yakıt Öğrenmesi #4;%;-128/128*100;2"
	<< "34;5;1;00010B;;Hava/Yakıt Düzeltmesi #4;%;-64/128*10;2"
	<< "34;6;1;00010A;;Bellekteki Sabit Hız;km/h;*1;0"
	<< "34;7;1;000183;000182;İkincil Hava Akışı;g/s;/100;2"
	<< "34;8;1;000108;;İkincil Hava Borusu Basıncı;kPa;*1;0"
	<< "35;1;1;000117;;Yağ Değiştirme Solenoid Valfi (OSV) Akımı (Sol);mA;*32;0"
	<< "35;2;1;000116;;Yağ Değiştirme Solenoid Valfi (OSV) Akımı (Sağ);mA;*32;0"
	<< "35;3;1;000115;;Yağ Değiştirme Solenoid Valfi (OSV) Görevi (Sol);%;/255*100;1"
	<< "35;4;1;000114;;Yağ Değiştirme Solenoid Valfı (OSV) Görevi (Sağ);%;/255*100;1"
	<< "35;5;1;000113;;Yağ Sıcaklığı;°C;-40;0"
	<< "36;2;1;00011E;;VVL Kaldırma Modu;;*1;0"
	<< "36;3;1;00011D;;Yağ Akışı Kontrol Solenoid Valfı (OCV) Akımı (Sol, Egzoz);mA;*32;0"
	<< "36;4;1;00011C;;Yağ Akışı Kontrol Solenoid Valfı (OCV) Akımı (Sağ, Egzoz);mA;*32;0"
	<< "36;5;1;00011B;;Yağ Akışı Kontrol Solenoid Valfı (OCV) Görevi (Sol, Egzoz);%;/255*100;1"
	<< "36;6;1;00011A;;Yağ Akışı Kontrol Solenoid Valfı (OCV) Görevi (Sağ, Egzoz);%;/255*100;1"
	<< "36;7;1;000119;;Değişken Valf Zamanlaması (VVT) Gecikme Açısı (Sol, Egzoz);deg;-50;0"
	<< "36;8;1;000118;;Değişken Valf Zamanlaması (VVT) Gecikme Açısı (Sağ, Egzoz);deg;-50;0"
	<< "43;1;2;000147;;Sapma Oranı Sensörü Gerilimi;V;/51;2"
	<< "43;2;2;000146;;AWD Solenoid Valfi Akımı;A;/255;2"
	<< "43;3;2;000145;;L/U Solenoid Valfi Akımı;A;/255;2"
	<< "43;4;2;000144;;P/L Solenoid Valfi Akımı;A;/255;2"
	<< "43;5;2;000143;;I/C Solenoid Valfi Akımı;A;/255;2"
	<< "43;6;2;000142;;F/B Solenoid Valfi Akımı;A;/255;2"
	<< "43;7;2;000141;;D/C Solenoid Valfi Akımı;A;/255;2"
	<< "43;8;2;000140;;H&LR/C Solenoid Valfi Akımı;A;/255;2"
	<< "44;1;2;00014F;;Sapma Hızı ve G Sensörü Referans Gerilimi;V;/51;2"
	<< "44;2;2;00014E;;AWD Solenoid Valfi Basıncı;kPa;*10;0"
	<< "44;3;2;00014D;;L/U Solenoid Valfi Basıncı;kPa;*10;0"
	<< "44;4;2;00014C;;P/L Solenoid Valfi Basıncı;kPa;*10;0"
	<< "44;5;2;00014B;;I/C Solenoid Valfi Basıncı;kPa;*10;0"
	<< "44;6;2;00014A;;F/B Solenoid Valfi Basıncı;kPa;*10;0"
	<< "44;7;2;000149;;D/C Solenoid Valfi Basıncı;kPa;*10;0"
	<< "44;8;2;000148;;H&LR/C Solenoid Valfi Basıncı;kPa;*10;0"
	<< "45;1;2;000186;;Fwd/B Solenoid Valfi Hedef Basıncı;kPa;*10;0"
	<< "45;2;2;000185;;Fwd/B Solenoid Valfi Akımı;A;/255;2"
	<< "45;4;2;00015A;00008D;Direksiyon Açı Sensörü;deg;s16*1;0"
	<< "45;5;2;00013F;;Teker Hızı Arka Sol;km/h;*1;0"
	<< "45;6;2;00013E;;Teker Hızı Arka Sağ;km/h;*1;0"
	<< "45;7;2;00013D;;Teker Hızı Ön Sol;km/h;*1;0"
	<< "45;8;2;00013C;;Teker Hızı Ön Sağ;km/h;*1;0"
	<< "48;1;1;000199;;Tekleme Düzeltmesi;deg;-128/4;1"
	<< "48;2;1;0000F9;;Öğrenilmiş Ateşleme Zamanlaması Düzeltmesi;deg;/16;1"
	<< "48;3;1;0000F8;;Pürüzlülük Monitörü Silindir #6;;*1;0"
	<< "48;4;1;0000EF;;Pürüzlülük Monitörü Silindir #5;;*1;0"
	<< "48;5;1;0000D9;;Pürüzlülük Monitörü Silindir #4;;*1;0"
	<< "48;6;1;0000D8;;Pürüzlülük Monitörü Silindir #3;;*1;0"
	<< "48;7;1;0000CF;;Pürüzlülük Monitörü Silindir #2;;*1;0"
	<< "48;8;1;0000CE;;Pürüzlülük Monitörü Silindir #1;;*1;0"
	<< "52;8;1;00019A;;Yakıt Deposu Basıncı;kPa;-128/20;2"
	<< "53;1;1;0001E9;;Egzoz Gazı Devridaimi (EGR) Valfi Açma Açısı;deg;-50;0"
	<< "53;2;1;0001E8;;Egzoz Gazı Devridaimi (EGR) Hedef Valfi Açma Açısı;deg;-50;0"
	<< "53;3;1;0001E7;;Hava Kütlesi;mg/cyl;*10;0"
	<< "53;4;1;0001E6;;Hedef Emiş Hava Miktarı;mg/cyl;*10;0"
	<< "53;5;1;0001E5;;Hedef Emme Manifoldu Basıncı;kPa;*1;0"
	<< "53;6;1;0001E4;;Enjeksiyon Sayısı;;*1;0"
	<< "53;7;1;0001E3;0001E2;Nihai Enjeksiyon Miktarı;mm³;/256;4"
	<< "53;8;1;0001E1;;Ana Enjeksiyon Süresi;°CA;/5-15;1"
	<< "54;1;1;0001F7;0001F6;Hedef Yakıt Pompası Akımı;mA;*1;0"
	<< "54;2;1;0001F5;;Elektrik Destekli Direksiyon Akımı;A;*1;0"
	<< "54;3;1;0001F0;;Güçlendirme Basıncı Geri Beslemesi;%;-128;0"
	<< "54;4;1;0001EF;0001EE;Hedef Motor Hızı;rpm;/4;0"
	<< "54;5;1;0001ED;;Emme Havası Sıcaklığı (kombine);°C;-40;0"
	<< "54;6;1;0001EC;;Common Rail Basıncı;MPa;*1;0"
	<< "54;7;1;0001EB;;Common Rail Hedef Basıncı;MPa;*1;0"
	<< "54;8;1;0001EA;;Egzoz Gazı Devridaimi (EGR) Görevi;%;*1;0"
	<< "55;5;2;0001F4;;Sürücü Kontrollü Merkezi Diferansiyel (DCCD) Modu;;*1;0"
	<< "55;6;2;0001F3;;Sürücü Kontrollü Merkezi Diferansiyel (DCCD) Tork Dağılımı;;*1;0"
	<< "55;7;2;0001F2;;Yanal G;m/s²;s8*1.0862;2"
	<< "55;8;2;0001F1;;Sapma Oranı;deg/s;s8*0.19118;0"
	<< "56;1;1;000260;;Miktar Düzeltme Silindir #4;ms;-100/100;2"
	<< "56;2;1;00025F;;Miktar Düzeltme Silindir #3;ms;-100/100;2"
	<< "56;3;1;00025E;;Miktar Düzeltme Silindir #2;ms;-100/100;2"
	<< "56;4;1;00025D;;Miktar Düzeltme Silindir #1;ms;-100/100;2"
	<< "56;5;1;000270;;İç Isıtıcı;Steps;*1;0"
	<< "56;6;1;000205;000204;Enjektör Değişiminden Sonra Kilometre;km;*5;0"
	<< "56;7;1;0001FB;0001FA;Enjektör Öğrenmeden Sonra Kilometre;km;*5;0"
	<< "56;8;1;0001F9;0001F8;Yakıt Pompası Gerçek Akımı;mA;*1;0"
	<< "57;6;1;000272;;Alternatör Kontrol Modu;;0=Yüksek,1=Aşırı,2=Düşük,3=Orta;0"
	<< "57;7;1;000273;;Batarya Sıcaklığı;°C;-40;0"
	<< "57;8;1;000271;;Batarya Akımı;A;-128;0"
	<< "63;1;1;00027C;;Yağ Seyreltme Oranı;%;*1;0"
	<< "63;2;1;00027B;;Kurum Birikim Oranı;%;*1;0"
	<< "63;3;1;00027A;;Dizel Partikül Filtresinin (DPF) Tahmini Sıcaklığı;°C;*5-40;0"
	<< "63;4;1;000279;;Tahmini Katalizatör Sıcaklığı;°C;*5-40;0"
	<< "63;5;1;000278;;Dizel Partikül Filtresi (DPF) Girişindeki Egzoz Gazı Sıcaklığı;°C;*5-40;0"
	<< "63;6;1;000277;;Katalizör Girişindeki Egzoz Gazı Sıcaklığı;°C;*5-40;0"
	<< "63;7;1;000276;;Dizel Partikül Filtresi (DPF) Giriş ve Çıkış Arasındaki Basınç Farkı;kPa;*1;0"
	<< "63;8;1;000275;;Birikmiş Kül Oranı;%;*1;0"
	<< "64;5;2;000297;000296;Otomatik Şanzıman Yağı (ATF) Bozulma Derecesi;%;*40/13107;0"
	<< "64;6;2;000295;;ABS/VDC Arka Teker Ortalama Teker Hızı;km/h;*230/255;0"
	<< "64;7;2;000294;;ABS/VDC Ön Teker Ortalama Teker Hızı;km/h;*230/255;0"
	<< "64;8;2;000293;;Ön-Arka Teker Dönme Oranı;;/128;3"
	<< "65;1;1;00023E;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 1-2;ms;-128/200;3"
	<< "65;2;1;00023D;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 1-1;ms;-128/200;3"
	<< "65;3;1;00029E;00029D;Dizel Partikül Filtresi (DPF) Rejenerasyon Sayısı;Times;*1;0"
	<< "65;4;1;00029C;00029B;Son Dizel Partikül Filtresi (DPF) Rejenerasyonundan Sonra Çalışma Uzaklığı;km;*1;0"
	<< "65;5;1;00029A;;Yağ Değişimine Kalan Tahmini Mesafe;km;*100;0"
	<< "65;6;1;00021F;;Gerçek Common Rail Basıncı (Zaman Senkronize);MPa;*1;0"
	<< "65;7;1;000299;;Birikmiş Aşırı Hız Örneklerinin Sayısı (Yüksek RPM);Time;*1;0"
	<< "65;8;1;000298;;Birikmiş Aşırı Hız Örneklerinin Sayısı (Çok Yüksek Devir);Time;*1;0"
	<< "66;1;1;000246;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 3-2;ms;-128/200;3"
	<< "66;2;1;000245;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 3-1;ms;-128/200;3"
	<< "66;3;1;000244;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 2-4;ms;-128/200;3"
	<< "66;4;1;000243;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 2-3;ms;-128/200;3"
	<< "66;5;1;000242;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 2-2;ms;-128/200;3"
	<< "66;6;1;000241;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 2-1;ms;-128/200;3"
	<< "66;7;1;000240;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 1-4;ms;-128/200;3"
	<< "66;8;1;00023F;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 1-3;ms;-128/200;3"
	<< "67;1;1;00024E;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 5-2;ms;-128/200;3"
	<< "67;2;1;00024D;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 5-1;ms;-128/200;3"
	<< "67;3;1;00024C;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 4-4;ms;-128/200;3"
	<< "67;4;1;00024B;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 4-3;ms;-128/200;3"
	<< "67;5;1;00024A;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 4-2;ms;-128/200;3"
	<< "67;6;1;000249;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 4-1;ms;-128/200;3"
	<< "67;7;1;000248;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 3-4;ms;-128/200;3"
	<< "67;8;1;000247;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 3-3;ms;-128/200;3"
	<< "69;5;1;000258;000257;Nihai Ana Enjeksiyon Süresi;ms;/1000;3"
	<< "69;6;1;000239;000238;Ayrı Pompa Farkı Öğrenme Değeri;mA;-1000;0"
	<< "69;7;1;000250;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 5-4;ms;-128/200;3"
	<< "69;8;1;00024F;;Mikro-Miktar Enjeksiyon Son Öğrenme Değeri 5-3;ms;-128/200;3";


// Switches:
const QStringList SSMFlagbyteDefinitions_tr::_SW_defs_tr =
	QStringList()
	<< "12;1;1;000061;Bellek Terminalini Temizle;Kapalı/Açık"
	<< "12;2;1;000061;Dağıtım Modu (Test Modu) Bağlantısı;Kapalı/Açık"
	<< "12;3;1;000061;D-Kontrol Gerekli Etiketi;Kapalı/Açık"
	<< "12;5;1;000061;Hafıza Sinyali Okuma;Kapalı/Açık"
	<< "12;6;1;000061;Test Modu Sinyali;Kapalı/Açık"
	<< "12;7;1;000061;AT Araç Kimliği;Kapalı/Açık"
	<< "13;2;1;000062;Klima Düğmesi;Kapalı/Açık"
	<< "13;3;1;000062;Hidrolik Direksiyon Düğmesi;Kapalı/Açık"
	<< "13;4;3;000062;Kontak Anahtarı;Kapalı/Açık"
	<< "13;5;1;000062;Intercooler Otomatik Yıkama Düğmesi;Kapalı/Açık"
	<< "13;7;1;000062;Boşta Düğmesi;Kapalı/Açık"
	<< "13;8;3;000062;Nötr Konum Düğmesi;Kapalı/Açık"
	<< "14;1;1;000063;Elektriksel Yük Sinyali;Kapalı/Açık"
	<< "14;2;1;000063;Vuruntu Sinyali #2;Kapalı/Açık"
	<< "14;3;1;000063;Vuruntu Sinyali #1;Kapalı/Açık"
	<< "14;4;1;000063;Ön O2 Sensörü #2 Zengin Sinyali;Kapalı/Açık"
	<< "14;5;1;000063;Arka O2 Sensörü Zengin Sinyali;Kapalı/Açık"
	<< "14;6;1;000063;Ön O2 Sensörü #1 Zengin Sinyal;Kapalı/Açık"
	<< "14;7;1;000063;Marş Anahtarı;Kapalı/Açık"
	<< "14;8;1;000063;Tutacak Düğmesi;Yüksek Giriş\\Düşük Giriş"
	<< "15;1;1;000064;Klima Orta Basınç Düğmesi;Kapalı/Açık"
	<< "15;2;1;000064;Klima Kilit Sinyali;Kapalı/Açık"
	<< "15;3;1;000064;Silecek Düğmesi;Kapalı/Açık"
	<< "15;4;1;000064;Lamba Düğmesi;Kapalı/Açık"
	<< "15;5;1;000064;Üfleyici Fan Düğmesi;Kapalı/Açık"
	<< "15;6;1;000064;Arka Buğu Çözücü Düğmesi;Kapalı/Açık"
	<< "15;7;1;000064;Eksantrik (Kam) Mili Konum Sinyali;Kapalı/Açık"
	<< "15;8;1;000064;Krank Mili Konum Sinyali;Kapalı/Açık"
	<< "16;1;1;000065;Blow-By Leak Bağlantısı;Kapalı/Açık"
	<< "16;2;1;000065;Kanister Boşaltım Kontrolü (CPC) Solenoid Valfi;Kapalı/Açık"
	<< "16;3;1;000065;Intercooler Otomatik Yıkayıcı Rölesi;Kapalı/Açık"
	<< "16;4;1;000065;Yakıt Pompası Rölesi;Kapalı/Açık"
	<< "16;5;1;000065;Radyatör Fan Rölesi #2;Kapalı/Açık"
	<< "16;6;1;000065;Radyatör Fan Rölesi #1;Kapalı/Açık"
	<< "16;7;1;000065;Radyatör Fan Rölesi #3;Kapalı/Açık"
	<< "16;8;1;000065;Klima Kompresörü Sinyali;Kapalı/Açık"
	<< "17;1;1;000066;Yardımcı Hava Solenoid Valfi;Kapalı/Açık"
	<< "17;2;1;000066;Hidrolik Direksiyon Solenoid Valfi;Kapalı/Açık"
	<< "17;3;1;000066;Havalandırma Solenoid Valfi;Kapalı/Açık"
	<< "17;4;1;000066;Basınç Kaynakları Değişimi;Kapalı/Açık"
	<< "17;5;1;000066;Değişken Hava Emme Solenoidi;Kapalı/Açık"
	<< "17;6;1;000066;Tumble Jeneratör Vanası (TGV) Sürücü;Kapalı/Açık"
	<< "17;7;1;000066;Tumble Jeneratör Vanası (TGV) Çıkışı;Kapalı/Açık"
	<< "17;8;1;000066;Pozitif Karter Havalandırması (PCV) Solenoid Valfi;Kapalı/Açık"
	<< "18;1;1;000067;Susturucu kontrolü;Kapalı/Açık"
	<< "18;2;1;000067;Emme Hava Solenoidi;Kapalı/Açık"
	<< "18;3;1;000067;Egzoz Gazı Negatif Basıncı;Kapalı/Açık"
	<< "18;4;1;000067;Egzoz Gazı Pozitif Basıncı;Kapalı/Açık"
	<< "18;5;1;000067;Çekiş Kontrol Sistemi (TCS) Tahliye Vanası Solenoidi;Kapalı/Açık"
	<< "18;6;1;000067;Emniyet Valfi Solenoidi #2;Kapalı/Açık"
	<< "18;7;1;000067;Emniyet Valfi Solenoidi #1;Kapalı/Açık"
	<< "18;8;1;000067;Tank Sensörü Kontrol Vanası;Kapalı/Açık"
	<< "19;1;1;000068;Tork Düşürme Talebi VDC;Kapalı/Açık"
	<< "19;2;1;000068;Tork Düşürme Yasağı;Açık\\Kapalı"
	<< "19;3;1;000068;AT'den Yakıt Kesme Sinyali;Kapalı/Açık"
	<< "19;4;1;000068;AT'den Geciktirme Sinyal;Kapalı/Açık"
	<< "19;5;1;000068;Kanister Boşaltım Kontrolü (CPC) Solenoid Valfi #2;Kapalı/Açık"
	<< "19;6;1;000068;Motor Yağı Basınç Şalteri #2;Kapalı/Açık"
	<< "19;7;1;000068;Motor Yağı Basınç Şalteri #1;Kapalı/Açık"
	<< "19;8;1;000068;Egzoz By-Pass Vanası;Kapalı/Açık"
	<< "20;1;1;000069;AT Motor Tork İsteği (AET) Sinyali;Yüksek\\Düşük"
	<< "20;2;1;000069;AT Destek Zengin Spike Sinyali;Kapalı/Açık"
	<< "20;3;1;000069;AT Destek Fakir Yanma Sinyali;Kapalı/Açık"
	<< "20;4;1;000069;AT Destek Kilitleme Sinyali;Kapalı/Açık"
	<< "20;5;1;000069;Motor AT Maskeleme Etiketi (EAM) Sinyali;Yüksek\\Düşük"
	<< "20;6;1;000069;Tork Yetki Sinyali;Kapalı/Açık"
	<< "20;7;1;000069;Tork Kontrol Sinyali #2;Kapalı/Açık"
	<< "20;8;1;000069;Tork Kontrol Sinyali #1;Kapalı/Açık"
	<< "21;1;2;00006A;Önden Çekiş (FWD) Düğmesi;Kapalı/Açık"
	<< "21;2;3;00006A;Kick Down Düğmesi;Kapalı/Açık"
	<< "21;3;2;00006A;Vites Yükseltme Düğmesi;Kapalı/Açık"
	<< "21;4;2;00006A;Stop Lambası Düğmesi;Kapalı/Açık"
	<< "21;5;2;00006A;Vites Düşürme Düğmesi;Kapalı/Açık"
	<< "21;6;2;00006A;ABS Sinyali;Kapalı/Açık"
	<< "21;7;2;00006A;Hız Sabitleyici;Kapalı/Açık"
	<< "21;8;2;00006A;Tiptronik Mod Düğmesi;Kapalı/Açık"
	<< "22;1;2;00006B;N/P Durumu Sinyali;Kapalı/Açık"
	<< "22;2;2;00006B;R Durumu Sinyali;Kapalı/Açık"
	<< "22;3;2;00006B;D Durumu Sinyali;Kapalı/Açık"
	<< "22;4;2;00006B;3. Durum Sinyali;Kapalı/Açık"
	<< "22;5;2;00006B;2. Durum Sinyali;Kapalı/Açık"
	<< "22;6;2;00006B;1. Durum Sinyali;Kapalı/Açık"
	<< "22;7;2;00006B;Hold Modu Düğmesi;Kapalı/Açık"
	<< "22;8;2;00006B;Power Modu Düğmesi;Kapalı/Açık"
	<< "23;1;2;00006C;Vites Değiştirme Solenoidi #1;Kapalı/Açık"
	<< "23;2;2;00006C;Vites Değiştirme Solenoidi #2;Kapalı/Açık"
	<< "23;3;2;00006C;Düşük Debriyaj Zamanlaması Solenoidi;Kapalı/Açık"
	<< "23;4;2;00006C;2-4 Fren Zamanlaması Solenoidi;Kapalı/Açık"
	<< "23;5;2;00006C;Tork Kontrol Sinyali #2;Kapalı/Açık"
	<< "23;6;2;00006C;Tork Kontrol Sinyali #1;Kapalı/Açık"
	<< "23;7;2;00006C;Tiptronik Solenoid;Kapalı/Açık"
	<< "23;8;2;00006C;4. Durum Sinyali;Kapalı/Açık"
	<< "24;1;2;00006D;Vites Kilidi Solenoidi;Kapalı/Açık"
	<< "24;2;2;00006D;ATF Sıcaklık Lambası;Kapalı/Açık"
	<< "24;3;2;00006D;Arka Diferansiyel Yağ Sıcaklık Düğmesi;Kapalı/Açık"
	<< "24;4;2;00006D;Tanı Lambası;Kapalı/Açık"
	<< "24;5;2;00006D;Vites Çıkışı 1;Kapalı/Açık"
	<< "24;6;2;00006D;Vites Çıkışı 2;Kapalı/Açık"
	<< "24;7;2;00006D;Vites Çıkışı 3;Kapalı/Açık"
	<< "24;8;2;00006D;Vites Çıkışı 4;Kapalı/Açık"
	<< "25;1;2;00006E;N Durumu;Kapalı/Açık"
	<< "25;2;2;00006E;Hold Lambası;Kapalı/Açık"
	<< "25;3;2;00006E;Çekiş Kontrol Sistemi (TCS) Düğmesi;Kapalı/Açık"
	<< "25;4;2;00006E;P/N Sinyali;Kapalı/Açık"
	<< "25;5;2;00006E;Tork Kontrolü Kesme Sinyali;Kapalı/Açık"
	<< "25;6;2;00006E;P Durumu;Kapalı/Açık"
	<< "25;7;2;00006E;Power Modu Lambası;Kapalı/Açık"
	<< "25;8;3;00006E;Ekonomi Düğmesi;Kapalı/Açık"
	<< "28;1;2;0000D4;AT Güç Rölesi;Kapalı/Açık"
	<< "28;2;2;0000D4;Geri Lambası Rölesi;Kapalı/Açık"
	<< "28;3;2;0000D4;Engelleyici Düğme #3 Monitorü;Düşük/Yüksek"
	<< "28;4;2;0000D4;Engelleyici Düğme #4;Düşük/Yüksek"
	<< "28;5;2;0000D4;Engelleyici Düğme #3;Düşük/Yüksek"
	<< "28;6;2;0000D4;Engelleyici Düğme #2;Düşük/Yüksek"
	<< "28;7;2;0000D4;Engelleyici Düğme #1;Düşük/Yüksek"
	<< "28;8;2;0000D4;Dört Tekerten Çekiş (AWD) Kararı;Kapalı/Açık"
	<< "32;1;2;0000D5;Tanımlanmış Elektronik Kontrol Modülünün (ECM) Sinyali;Kapalı/Açık"
	<< "32;2;2;0000D5;LC/B Sıvı Basıncı;Kapalı/Açık"
	<< "32;3;2;0000D5;I/C Sıvı Basıncı;Kapalı/Açık"
	<< "32;4;2;0000D5;F/B Sıvı Basıncı;Kapalı/Açık"
	<< "32;5;2;0000D5;D/C Sıvı Basıncı;Kapalı/Açık"
	<< "32;6;2;0000D5;H&LR/C Sıvı Basıncı;Kapalı/Açık"
	<< "37;6;1;000120;Enjektör Sürücü Rölesi;Kapalı/Açık"
	<< "37;7;1;000120;Elektronik Gaz Kelebeği Kontrolü (ETC) Motor Rölesi;Kapalı/Açık"
	<< "37;8;1;000120;Boşta Düğmesi;Kapalı/Açık"
	<< "38;1;3;000121;Hız Sabitleyici Durumu;Kapalı/Açık"
	<< "38;2;1;000121;Ana (Hız Sabitleyici) Düğmesi;Kapalı/Açık"
	<< "38;3;1;000121;Engelleyici Düğme;Kapalı/Açık"
	<< "38;4;1;000121;Bırak Düğmesi;Kapalı/Açık"
	<< "38;5;1;000121;Devam/Hızlandırma Düğmesi;Kapalı/Açık"
	<< "38;6;1;000121;Ayarla/Yavaşla Düğmesi;Kapalı/Açık"
	<< "38;7;1;000121;Stop Lambası Düğmesi;Kapalı/Açık"
	<< "38;8;1;000121;Debriyaj Düğmesi;Kapalı/Açık"
	<< "39;1;2;000122;Merkezi Diferansiyel Lambası 6;Kapalı/Açık"
	<< "39;2;2;000122;Merkezi Diferansiyel Lambası 5;Kapalı/Açık"
	<< "39;3;2;000122;Merkezi Diferansiyel Lambası 4;Kapalı/Açık"
	<< "39;4;2;000122;Merkezi Diferansiyel Lambası 3;Kapalı/Açık"
	<< "39;5;2;000122;Merkezi Diferansiyel Lambası 2;Kapalı/Açık"
	<< "39;6;2;000122;Merkezi Diferansiyel Lambası 1;Kapalı/Açık"
	<< "39;7;2;000122;LU&FWD/B Solenoid Valfi;Kapalı/Açık"
	<< "39;8;2;000122;LC/B Solenoid Valfi;Kapalı/Açık"
	<< "46;3;2;0000D6;Otomatik Şanzıman Öğrenme Süreci;Tamamlanmadı/Tamamlandı"
	<< "46;4;2;0000D6;Fwd/B Hidrolik Basınç Düğmesi;Kapalı/Açık"
	<< "46;5;2;0000D6;AUTO Modu Lambası;Kapalı/Açık"
	<< "46;6;2;0000D6;AUTO/MANUAL Mod Düğmesi;Kapalı/Açık"
	<< "46;7;2;0000D6;Merkez Diferansiyel Rölesi;Kapalı/Açık"
	<< "46;8;2;0000D6;Park Pozisyonu Düğmesi;Kapalı/Açık"
	<< "47;1;1;0000D7;Hız Sabitleyici İptal Düğmesi;Kapalı/Açık"
	<< "47;2;1;0000D7;Mesafe Değişim Düğmesi;Kapalı/Açık"
	<< "47;3;1;0000D7;İkincil Hava Kombi Valfi Rölesi #1;Kapalı/Açık"
	<< "47;4;1;0000D7;İkincil Hava Pompası Rölesi;Kapalı/Açık"
	<< "47;5;1;0000D7;İkincil Hava Kombi Valfi Rölesi #2;Kapalı/Açık"
	<< "47;7;1;0000D7;Gövde Entegre Ünite Sayısı;Açık\\Kapalı"
	<< "47;8;1;0000D7;Gövde Entegre Ünite Verisi;Açık\\Kapalı"
	<< "49;6;1;000196;Yağ Seviyesi Durumu;Düşük Seviye/Yüksek Seviye"
	<< "49;7;1;000196;Yakıt Basıncı Değişimi Solenoid Valfi;Kapalı/Açık"
	<< "49;8;1;000196;Arıza Gösterge Işığı (MIL) AÇIK Göstergesi;Kapalı/Açık"
	<< "50;1;1;000197;Enjektör Öğrenmesi;Tamamlanmadı/Tamamlandı"
	<< "50;2;1;000197;Yakıt Pompası Öğrenmesi;Tamamlanmadı/Tamamlandı"
	<< "50;3;1;000197;''Kompresör AÇIK'' İsteği;Kapalı/Açık"
	<< "50;4;1;000197;Yardımcı Yakıt Pompası Rölesi;Kapalı/Açık"
	<< "50;5;1;000197;Girdap Kontrol Valfi;Açık\\Kapalı"
	<< "50;6;1;000197;Kızdırma Rölesi;Kapalı/Açık"
	<< "50;7;1;000197;Egzoz Gazı Devridaimi (EGR) Kontrol Modu;Açık/Geribesleme"
	<< "50;8;1;000197;Takviye Basıncı Kontrol Modu;Açık/Geri Besleme"
	<< "60;7;2;0001CD;Kilitlenme AÇIK/ APALI Solenoid Valfi;Kapalı/Açık"
	<< "60;8;2;0001CD;Kendinden Kapanma Röle Çıkışı;Kapalı/Açık"
	<< "62;4;1;0001CE;Dizel Partikül Filtresi (DPF) Rejenerasyon;İşlemde Değil/İşlemde"
	<< "62;5;1;0001CE;Akıllı Sistem İçin Debriyaj Düğmesi;Kapalı/Açık"
	<< "62;6;1;0001CE;Yakıt Pompası Modu;Açık/Geribesleme"
	<< "62;7;1;0001CE;Yakıt Kesmesi;İstenmedi/İstendi"
	<< "62;8;1;0001CE;Egzoz Gazı Devridaimi (EGR) Öğrenmesi;Tamamlanmadı/Tamamlandı";


// SUBARU-Trouble Codes:
const QStringList SSMFlagbyteDefinitions_tr::_DTC_SUBARU_defs_tr =
	QStringList()
	<< "00008E;0000A4;1;24;Rölanti Kontrol Sistemi Arızası"
	<< "00008E;0000A4;2;23;Kütle Hava Akış Sensörü"
	<< "00008E;0000A4;3;22;Vuruntu Sensörü"
	<< "00008E;0000A4;4;21;Motor Soğutucu Sıcaklık Sensörü"
	<< "00008E;0000A4;5;18;Elektrik Yükü Sinyali"
	<< "00008E;0000A4;6;13;Eksantrik (KAM) Mili Konum Sensörü"
	<< "00008E;0000A4;7;12;Marş Sinyali"
	<< "00008E;0000A4;8;11;Krank Mili Konum Sensörü"
	<< "00008F;0000A5;1;37;Arka O2 Sensörü Devresi - Hava/Yakıt Sensörü Devresi Arızası"
	<< "00008F;0000A5;2;35;Kanister Temizleme Kontrolü (CPC) Sistemi"
	<< "00008F;0000A5;3;33;Araç Hız Sensörü (Ön)"
	<< "00008F;0000A5;4;32;Oksijen Sensörü"
	<< "00008F;0000A5;5;31;Gaz Kelebeği Konum Sensörü"
	<< "00008F;0000A5;6;29;Krank Mili Konum Sensörü 2"
	<< "00008F;0000A5;7;28;Vuruntu Sensörü #2"
	<< "00008F;0000A5;8;26;Emme Hava Sıcaklığı Sensörü"
	<< "000090;0000A6;1;45;Basınç Sensörü"
	<< "000090;0000A6;2;44;Turboşarj Basınç Kontrol Çıkış Sinyali"
	<< "000090;0000A6;3;43;Gaz Pedalı Düğmesi"
	<< "000090;0000A6;4;42;Boşta Düğmesi"
	<< "000090;0000A6;5;39;Çekiş Kontrol Sistemi (TCS)"
	<< "000090;0000A6;6;38;Tork Yetki Sinyali"
	<< "000090;0000A6;7;38;Tork Kontrol Sinyali #2"
	<< "000090;0000A6;8;38;Tork Kontrol Sinyali #1"
	<< "000091;0000A7;1;62;Egzoz Manifoldu Negatif Basınç Kontrolü Solenoid Valfi"
	<< "000091;0000A7;2;61;Hava Emiş Kontrolü Solenoid Valfi"
	<< "000091;0000A7;3;56;Egzoz Gazı Devridaim (EGR) Sistemi"
	<< "000091;0000A7;4;55;EGR Valfi Kaldırma Sensörü"
	<< "000091;0000A7;5;54;Hava Emiş Sistemi"
	<< "000091;0000A7;6;51;Nötr Konum Düğmesi"
	<< "000091;0000A7;7;49;CO Direnci"
	<< "000091;0000A7;8;48;Fakir Yanma Sistemi"
	<< "000092;0000A8;1;53;Anti-Hızlı Çalışma Modu"
	<< "000092;0000A8;2;66;İkiz Turboşarj Sistemi (T)"
	<< "000092;0000A8;3;66;İkiz Turboşarj Sistemi (S)"
	<< "000092;0000A8;4;66;İkiz Turboşarj Sistemi (H)"
	<< "000092;0000A8;5;66;İki Aşamalı İkiz Turboşarj Sistemi"
	<< "000092;0000A8;6;65;Diferansiyel Basınç Sensörü"
	<< "000092;0000A8;7;64;Tahliye Vanası Kontrol Solenoid Valfi 1"
	<< "000092;0000A8;8;63;Tahliye Vanası Kontrol Solenoid Valfi 2"
	<< "000093;0000A9;1;53;İmmobilizer Kontrol Modülü EEPROM"
	<< "000093;0000A9;2;53;Elektronik Benzinli Enjeksiyon (EGI) Kontrol Modülü EEPROM"
	<< "000093;0000A9;3;53;Yanlış/Kayıtsız İmmobilizer Anahtarı"
	<< "000093;0000A9;4;53;Anahtar İletişim Hatası"
	<< "000093;0000A9;5;53;İletişim Hatası (Zaman Aşımı)"
	<< "000093;0000A9;6;53;İmmobilizer Devre Arızası (Anten Devresi Hariç)"
	<< "000093;0000A9;7;53;Referans Kodu Uyumsuzluğu"
	<< "000093;0000A9;8;53;Anten"
	<< "000094;0000AA;1;89;Değişken Valf Zamanlaması (VVT) Sistemleri (sağ)"
	<< "000094;0000AA;2;88;Yakıt Pompası Devre Arızası"
	<< "000094;0000AA;3;87;Değişken İndüksiyon Solenoid Valfı Devresi Arızası"
	<< "000094;0000AA;4;86;CAN İletişim Sistemi"
	<< "000094;0000AA;5;85;Şarj Sistemi Devre Arızası"
	<< "000094;0000AA;6;81;Tork Artırma Kontrol Valfi"
	<< "000094;0000AA;7;68;Turboşarj Basınç Kontrol Çıkışı Sinyali #2"
	<< "000094;0000AA;8;67;Egzoz Manifoldu Pozitif Basınç Kontrolü Solenoid Valfi"
	<< "000095;0000AB;1;89;Değişken Valf Zamanlaması (VVT) Sistemleri (sol)"
	<< "000095;0000AB;3;24;Rölanti Devri Kontrolü (ISC) Valfi Sıkışmış"
	<< "000095;0000AB;4;24;Rölanti Devri Kontrolü (ISC) Valf Devresi Açık/KısaDevre"
	<< "000095;0000AB;5;32;Hava/Yakıt Sensörü #2 Sistemi"
	<< "000095;0000AB;6;32;Hava/Yakıt Sensörü #2 Sistemi"
	<< "000095;0000AB;7;92;Elektrik Üretimi Kontrol Sinyali Devresi Arızası"
	<< "000095;0000AB;8;91;Çekiş Kontrol Sistemi (TCS) Emniyet Valfi"
	<< "000096;0000AC;1;71;Vites Değiştirme Solenoid Valfi #1"
	<< "000096;0000AC;2;72;Vites Değiştirme Solenoid Valfi #2"
	<< "000096;0000AC;3;73;Düşük Debriyaj Zamanlaması Solenoid Valfi"
	<< "000096;0000AC;4;74;Fren Debriyaj Zamanlaması Solenoid Valfi"
	<< "000096;0000AC;5;77;Kilitleme Görevi Solenoid Valfi"
	<< "000096;0000AC;6;75;Hat Basıncı Görevi Solenoid Valfi"
	<< "000096;0000AC;7;76;Fren Kavrama Basıncı Görevi Solenoid Valfı"
	<< "000096;0000AC;8;79;Aktarım Kavrama Görevi Solenoid Valfi"
	<< "000097;0000AD;1;93;Araç Hızı Sensörü # 1 (arka)"
	<< "000097;0000AD;2;27;ATF Sıcaklık Sensörü"
	<< "000097;0000AD;3;94;Yanal G Sensörü Sinyal Devresi Arızası"
	<< "000097;0000AD;4;11;Motor Hızı Sinyali"
	<< "000097;0000AD;5;5-11;Koordinasyon Sinyal Hattı"
	<< "000097;0000AD;6;38;Tork Kontrol Sinyal Sistemi"
	<< "000097;0000AD;7;36;Tork Konvertörü Türbin Hızı Sinyali"
	<< "000097;0000AD;8;78;Tiptronik Solenoid Valf Sistemi";


// OBD Trouble Codes:
const QStringList SSMFlagbyteDefinitions_tr::_DTC_OBD_defs_tr =
	QStringList()
	<< "00008E;0000AE;1;P0335;Krank Mili Konum Sensörü A Devresi Arızası"
	<< "00008E;0000AE;3;P0336;Krank Mili Konum Sensörü A Aralık/Performans Sorunu"
	<< "00008E;0000AE;4;P0341;Eksantrik (KAM) Mili Konum Sensörü A Devre Aralık/Performans"
	<< "00008E;0000AE;5;P0340;Eksantrik (KAM) Mili Konum Sensörü A Devresi"
	<< "00008E;0000AE;7;P0604;Dahili Kontrol Modülü Rasgele Erişim Belleği (RAM) Hatası"
	<< "00008E;0000AE;8;P0601;Dahili Kontrol Modülü Bellek Doğrulama Kontrolü Hatası"
	<< "00008F;0000AF;1;P0102;Kütle veya Hacim Hava Akışı Devresi Düşük"
	<< "00008F;0000AF;2;P0103;Kütle veya Hacim Hava Akışı Devresi Yüksek"
	<< "00008F;0000AF;3;P1141;Kütle veya Hacim Hava Akışı Devresi Aralık/Performans (Düşük)"
	<< "00008F;0000AF;4;P0101;Kütle veya Hacim Hava Akışı Devresi Aralık/Performans (Yüksek)"
	<< "00008F;0000AF;5;P0500;Araç Hız Sensörü"
	<< "00008F;0000AF;6;P1540;Düşük Hızda Araç Hızı Sensörü Arızası"
	<< "00008F;0000AF;7;P0332;Vuruntu Sensörü 2. Devre Arızası (Düşük Giriş)"
	<< "00008F;0000AF;8;P0333;Vuruntu Sensörü 2. Devre Arızası (Yüksek Giriş)"
	<< "000090;0000B0;1;P0325;Vuruntu Sensörü 1. Devre Arızası "
	<< "000090;0000B0;2;P0330;Vuruntu Sensörü 2. Devre Arızası "
	<< "000090;0000B0;3;P0327;Vuruntu Sensörü 1. Devre Arızası (Düşük Giriş)"
	<< "000090;0000B0;4;P0328;Vuruntu Sensörü 1. Devre Arızası (Yüksek Giriş)"
	<< "000090;0000B0;5;P0122;Gaz Kelebeği Konum Sensörü Düşük Giriş"
	<< "000090;0000B0;6;P0123;Gaz Kelebeği Konum Sensörü Yüksek Giriş"
	<< "000090;0000B0;7;P1142;Gaz Kelebeği Konum Sensörü Devresi Performans (Düşük Giriş)"
	<< "000090;0000B0;8;P0121;Gaz Kelebeği Konum Sensörü Devresi Performans (Yüksek Giriş)"
	<< "000091;0000B1;1;P0117;Motor Soğutucu Sıcaklık Sensörü Devresi Düşük Giriş"
	<< "000091;0000B1;2;P0118;Motor Soğutucu Sıcaklık Sensörü Devresi Yüksek Giriş"
	<< "000091;0000B1;3;P0464;Yakıt Seviyesi Sensörü Devresi Aralıklı"
	<< "000091;0000B1;4;P0125;Kapalı Çevrim Yakıt Kontrolü için Yetersiz Soğutucu Sıcaklığı"
	<< "000091;0000B1;5;P0462;Yakıt Seviyesi Sensörü Devresi Düşük Giriş"
	<< "000091;0000B1;6;P0463;Yakıt Seviyesi Sensörü Devresi Yüksek Giriş"
	<< "000091;0000B1;7;P0461;Yakıt Seviyesi Sensörü Performans Sorunu"
	<< "000091;0000B1;8;P1442;Yakıt Seviyesi Sensörü Performans Sorunu (Seyahat Mesafesi)"
	<< "000092;0000B2;1;P0107;Basınç Sensörü Devresi Düşük Giriş"
	<< "000092;0000B2;2;P0108;Basınç Sensörü Devresi Yüksek Giriş"
	<< "000092;0000B2;3;P1143;Basınç Sensörü Devresi Aralık/Performans (Düşük)"
	<< "000092;0000B2;4;P1144;Basınç Sensörü Devresi Aralık/Performans (Yüksek)"
	<< "000092;0000B2;5;P0106;Basınç Sensörü Devresi Aralık/Performans"
	<< "000092;0000B2;6;P0350;Ateşleme Bobini Ana/İkincil Devresi"
	<< "000092;0000B2;7;P1518;Marş Anahtarı Devresi Düşük Giriş"
	<< "000092;0000B2;8;P0512;Marş Anahtarı Devresi Yüksek Giriş"
	<< "000093;0000B3;1;P0452;Yakıt Deposu Basınç Sensörü Devresi Düşük Giriş"
	<< "000093;0000B3;2;P0453;Yakıt Deposu Basınç Sensörü Devresi Yüksek Giriş"
	<< "000093;0000B3;4;P0451;Yakıt Deposu Basınç Sensörü Performans Sorunu"
	<< "000093;0000B3;5;P1237;Egzoz Kontrol Valfı Solenoidi Devresi Düşük (Pozitif Basınç)"
	<< "000093;0000B3;6;P1238;Egzoz Kontrol Valfı Solenoidi Devresi Yüksek (Pozitif Basınç)"
	<< "000093;0000B3;7;P1239;Egzoz Kontrol Valfı Solenoidi Devresi Düşük (Negatif Basınç)"
	<< "000093;0000B3;8;P1240;Egzoz Kontrol Valfı Solenoidi Devresi Yüksek (Negatif Basınç)"
	<< "000094;0000B4;1;P1590;AT için Nötr Konum Düğmesi Devresi Yüksek Giriş"
	<< "000094;0000B4;2;P1591;AT için Nötr Konum Düğmesi Devresi Düşük Giriş"
	<< "000094;0000B4;3;P1592;MT için Nötr Konum Düğmesi Devresi Arızası"
	<< "000094;0000B4;4;P0851;Nötr Konum Düğmesi Giriş Devresi Düşük"
	<< "000094;0000B4;5;P0182;Yakıt Sıcaklık Sensörü A Devresi Düşük Giriş"
	<< "000094;0000B4;6;P0183;Yakıt Sıcaklık Sensörü A Devresi Yüksek Giriş"
	<< "000094;0000B4;7;P0181;Yakıt Sıcaklık Sensörü A Performans Sorunu"
	<< "000094;0000B4;8;P0852;Nötr Konum Düğmesi Giriş Devresi Yüksek"
	<< "000095;0000B5;1;P1510;ISC Solenoid Valfı Sinyali #1 Devre Arızası (Düşük Giriş)"
	<< "000095;0000B5;2;P1511;ISC Solenoid Valfı Sinyali #1 Devre Arızası (Yüksek Giriş)"
	<< "000095;0000B5;3;P1512;ISC Solenoid Valfı Sinyali #2 Devre Arızası (Düşük Giriş)"
	<< "000095;0000B5;4;P1513;ISC Solenoid Valfı Sinyali #2 Devre Arızası (Yüksek Giriş)"
	<< "000095;0000B5;5;P1514;ISC Solenoid Valfı Sinyali #3 Devre Arızası (Düşük Giriş)"
	<< "000095;0000B5;6;P1515;ISC Solenoid Valfı Sinyali #3 Devre Arızası (Yüksek Giriş)"
	<< "000095;0000B5;7;P1516;ISC Solenoid Valfı Sinyali #4 Devre Arızası (Düşük Giriş)"
	<< "000095;0000B5;8;P1517;ISC Solenoid Valfı Sinyali #4 Devre Arızası (Yüksek Giriş)"
	<< "000096;0000B6;1;P1492;EGR Solenoid Valfı Sinyali #1 Devre Arızası (Düşük Giriş)"
	<< "000096;0000B6;2;P1493;EGR Solenoid Valfı Sinyali #1 Devre Arızası (Yüksek Giriş)"
	<< "000096;0000B6;3;P1494;EGR Solenoid Valfı Sinyali #2 Devre Arızası (Düşük Giriş)"
	<< "000096;0000B6;4;P1495;EGR Solenoid Valfı Sinyali #2 Devre Arızası (Yüksek Giriş)"
	<< "000096;0000B6;5;P1496;EGR Solenoid Valfı Sinyali #3 Devre Arızası (Düşük Giriş)"
	<< "000096;0000B6;6;P1497;EGR Solenoid Valfı Sinyali #3 Devre Arızası (Yüksek Giriş)"
	<< "000096;0000B6;7;P1498;EGR Solenoid Valfı Sinyali #4 Devre Arızası (Düşük Giriş)"
	<< "000096;0000B6;8;P1499;EGR Solenoid Valfı Sinyali #4 Devre Arızası (Yüksek Giriş)"
	<< "000097;0000B7;1;P1102;Basınç Kaynakları Değişimi Solenoid Valfi Devresi Düşük"
	<< "000097;0000B7;2;P1122;Basınç Kaynakları Değişimi Solenoid Valfi Devresi Yüksek"
	<< "000097;0000B7;3;P1446;Yakıt Deposu Sensörü Kontrol Vanası Devresi Düşük"
	<< "000097;0000B7;4;P1447;Yakıt Deposu Sensörü Kontrol Vanası Devresi Yüksek"
	<< "000097;0000B7;5;P1090;Tumble Jeneratör Valfi (TGV) Sistem 1 (Valf Açık)"
	<< "000097;0000B7;6;P1091;Tumble Jeneratör Valfi (TGV) Sistem 1 (Valf Kapalı)"
	<< "000097;0000B7;7;P1092;Tumble Jeneratör Valfi (TGV) Sistem 2 (Valf Açık)"
	<< "000097;0000B7;8;P1093;Tumble Jeneratör Valfi (TGV) Sistem 2 (Valf Kapalı)"
	<< "000098;0000B8;1;P0508;Rölanti Kontrol Sistemi Devresi Düşük"
	<< "000098;0000B8;2;P0509;Rölanti Kontrol Sistemi Devresi Yüksek"
	<< "000098;0000B8;3;P1507;Rölanti Kontrol Sistemi Arızası (Tedbirli)"
	<< "000098;0000B8;4;P0506;Rölanti Kontrol Sistemi RPM Beklenenden Düşük"
	<< "000098;0000B8;5;P0507;Rölanti Kontrol Sistemi RPM Beklenenden Yüksek"
	<< "000098;0000B8;6;P1698;Motor Tork Kontrolü Kesme Sinyali Devresi Arızası (Düşük Giriş)"
	<< "000098;0000B8;7;P1699;Motor Tork Kontrolü Kesme Sinyali Devresi Arızası (Yüksek Giriş)"
	<< "000098;0000B8;8;P1448;Yakıt Deposu Sensörü Kontrol Valfi Aralık/Performans"
	<< "000099;0000B9;1;P0444;Kanister Boşaltma Kontrolü (CPC) Solenoid Valfi Devresi Düşük"
	<< "000099;0000B9;2;P0445;Kanister Boşaltma Kontrolü (CPC) Solenoid Valfi Devresi Yüksek"
	<< "000099;0000B9;3;P0691;Soğutma Fanı Rölesi 1 Devresi Düşük"
	<< "000099;0000B9;4;P0692;Soğutma Fanı Rölesi 1 Devresi Yüksek"
	<< "000099;0000B9;5;P0480;Soğutma Fanı Rölesi 1 Devresi Düşük"
	<< "000099;0000B9;6;P1480;Soğutma Fanı Rölesi 1 Devresi Yüksek"
	<< "000099;0000B9;7;P0483;Soğutma Fanı Rasyonellik Kontrolü Arızası"
	<< "000099;0000B9;8;P0864;Şanzıman Kontrol Modülü (TCM) İletişim Devresi Aralık/Performans"
	<< "00009A;0000BA;1;P0365;Eksantrik (KAM) Mili Konum Sensörü B Devresi (Sıra 1)"
	<< "00009A;0000BA;2;P0390;Eksantrik (KAM) Mili Konum Sensörü B Devresi (Sıra 2)"
	<< "00009A;0000BA;3;P0011;Eksantrik Mili Konum Sistemi Performans Hatası (Sıra 1)"
	<< "00009A;0000BA;4;P0021;Eksantrik Mili Konum Sistemi Performans Hatası (Sıra 2)"
	<< "00009A;0000BA;5;P1400;Yakıt Deposu Basınç Kontrol Solenoid Valfı Devresi Düşük"
	<< "00009A;0000BA;6;P1420;Yakıt Deposu Basınç Kontrol Solenoid Valfı Devresi Yüksek"
	<< "00009A;0000BA;7;P0458;Kanister Boşaltma Kontrolü (CPC) Solenoid Valfı Devresi Düşük"
	<< "00009A;0000BA;8;P0459;Kanister Boşaltma Kontrolü (CPC) Solenoid Valfı Devresi Yüksek"
	<< "00009B;0000BB;1;P0865;Şanzıman Kontrol Modülü (TCM) İletişim Devresi Düşük"
	<< "00009B;0000BB;2;P0866;Şanzıman Kontrol Modülü (TCM) İletişim Devresi Yüksek"
	<< "00009B;0000BB;3;P1443;Havalandırma Kontrol Solenoid Valfi İşlev Sorunu"
	<< "00009B;0000BB;4;P1559;Hava Emiş Sistemi"
	<< "00009B;0000BB;5;P0661;Emme Manifoldu Ayar Valfı Devresi Düşük"
	<< "00009B;0000BB;6;P0662;Emme Manifoldu Ayar Valfı Devresi Yüksek"
	<< "00009B;0000BB;7;P0447;Buharlaştırıcı Emisyon Kontrol Sistemi Havalandırma Kontrol Devresi Açık"
	<< "00009B;0000BB;8;P0448;Buharlaştırıcı Emisyon Kontrol Sistemi Havalandırma Kontrol Devresi Kısadevre"
	<< "00009C;0000BC;1;P0720;AT Araç Hızı Sensörü Devre Arızası"
	<< "00009C;0000BC;2;P0725;Motor Hızı Giriş Devresi Arızası"
	<< "00009C;0000BC;3;P1700;AT için Gaz Kelebeği Konum Sensörü Devresi Arızası"
	<< "00009C;0000BC;4;P0710;Otomatik Şanzıman Yağı (ATF) Sıcaklık Sensörü Devresi Arızası"
	<< "00009C;0000BC;5;P0705;AT Durak Düğmesi Devresi Arızası"
	<< "00009C;0000BC;6;P1701;AT için Hız Sabitleyici Set Sinyal Devresi Arızası"
	<< "00009C;0000BC;7;P0703;AT için Fren Düğmesi Devresi Arızası"
	<< "00009C;0000BC;8;P0741;Tork Konvertörü Kavrama Devresi Arızası"
	<< "00009D;0000BD;1;P0753;Vites Değiştirme Solenoidi A Elektrik"
	<< "00009D;0000BD;2;P0758;Vites Değiştirme Solenoidi B Elektrik"
	<< "00009D;0000BD;3;P1706;AT Araç Hızı Sensörü Devre Arızası (Arka Teker)"
	<< "00009D;0000BD;4;P0748;Basınç Kontrol Solenoidi Elektriksel (Görev Solenoidi A)"
	<< "00009D;0000BD;5;P0743;Tork Konvertörü Kavrama Devresi Elektriksel (Görev Solenoidi B)"
	<< "00009D;0000BD;6;P0731;Vites 1 Yanlış Oran"
	<< "00009D;0000BD;7;P0732;Vites 2 Yanlış Oran"
	<< "00009D;0000BD;8;P0733;Vites 3 Yanlış Oran"
	<< "00009E;0000BE;1;P0734;Vites 4 Yanlış Oran"
	<< "00009E;0000BE;2;P1707;AT AWD Solenoid Valf Devresi Arızası"
	<< "00009E;0000BE;3;P1595;AT Tanı Giriş Sinyali Devresi Düşük Giriş"
	<< "00009E;0000BE;4;P1596;AT Tanı Giriş Sinyali Devresi Yüksek Giriş"
	<< "00009E;0000BE;5;P0135;O2 Sensörü Isıtıcı Devresi (Sıra 1 Sensör 1)"
	<< "00009E;0000BE;6;P0141;O2 Sensörü Isıtıcı Devresi (Sıra 1 Sensör 2)"
	<< "00009E;0000BE;7;P1593;Şanzıman Kontrol Modülü (TCM) İletişim Devresi Arızası"
	<< "00009E;0000BE;8;P1594;AT Tanı Giriş Sinyali Devre Arızası"
	<< "00009F;0000BF;1;P0133;O2 Sensör Devresi Yavaş Yanıt (Sıra 1 Sensör 1)"
	<< "00009F;0000BF;2;P0130;O2 Sensör Devresi (Sıra 1 Sensör 1)"
	<< "00009F;0000BF;3;P0139;O2 Sensör Devresi Yavaş Yanıt (Sıra 1 Sensör 2)"
	<< "00009F;0000BF;4;P0136;O2 Sensör Devresi (Sıra 1 Sensör 2)"
	<< "00009F;0000BF;5;P1152;O2 Sensör Devresi Aralık/Performans (Düşük) (Sıra 1 Sensör 1)"
	<< "00009F;0000BF;6;P1153;O2 Sensör Devresi Aralık/Performans (Yüksek) (Sıra 1 Sensör 1)"
	<< "00009F;0000BF;7;P0174;Sistem Çok Fakir (Sıra 2)"
	<< "00009F;0000BF;8;P0175;Sistem Çok Zengin (Sıra 2)"
	<< "0000A0;0000C0;1;P0420;Katalizör Sistemi Verimliliği Eşiğin Altında"
	<< "0000A0;0000C0;2;P0442;Buharlaşıcı Emisyon Kontrol Sistemi Kaçak Tespiti (Küçük Kaçak)"
	<< "0000A0;0000C0;3;P0170;Yakıt Ayarı (Sıra 1)"
	<< "0000A0;0000C0;4;P0456;Buharlaşıcı Emisyon Kontrol Sistemi Kaçak Tespiti (Çok Küçük Kaçak)"
	<< "0000A0;0000C0;5;P0400;Egzoz Gazı Devridaimi (EGR) Sistemi Arızası"
	<< "0000A0;0000C0;6;P1230;Yakıt Pompası Kontrolörü"
	<< "0000A0;0000C0;7;P0171;Sistem Çok Fakir (Sıra 1)"
	<< "0000A0;0000C0;8;P0172;Sistem Çok Zengin (Sıra 1)"
	<< "0000A1;0000C1;1;P0301;Silindir 1 Tekleme Tespiti"
	<< "0000A1;0000C1;2;P0302;Silindir 2 Tekleme Tespiti"
	<< "0000A1;0000C1;3;P0303;Silindir 3 Tekleme Tespiti"
	<< "0000A1;0000C1;4;P0304;Silindir 4 Tekleme Tespiti"
	<< "0000A1;0000C1;5;P0305;Silindir 5 Tekleme Tespiti"
	<< "0000A1;0000C1;6;P0306;Silindir 6 Tekleme Tespiti"
	<< "0000A1;0000C1;7;P1301;Tekleme Tespiti (Yüksek Sıcaklıkta Egzoz Gazı)"
	<< "0000A1;0000C1;8;P0457;Buharlaşıcı Emisyon Kontrol Sistemi Kaçak Tespiti (Yakıt Kapağı Gevşek/Kapalı)"
	<< "0000A2;0000C2;1;;"	// => IGNORE
	<< "0000A2;0000C2;2;;"	// => IGNORE
	<< "0000A2;0000C2;3;P1235;Emme Kontrol Valfi Solenoidi Devresi Düşük"
	<< "0000A2;0000C2;4;P1236;Emme Kontrol Valfi Solenoidi Devresi Yüksek"
	<< "0000A2;0000C2;5;P1597;Çekiş Kontrol Sistemi (TCS) Sinyal Devresi Düşük Giriş"
	<< "0000A2;0000C2;6;P1598;Çekiş Kontrol Sistemi (TCS) Sinyal Devresi Yüksek Giriş"
	<< "0000A2;0000C2;7;P0034;Turbo Şarj Baypas Valfi Kontrol Devresi Düşük"
	<< "0000A2;0000C2;8;P0035;Turbo Şarj Baypas Valfi Kontrol Devresi Yüksek"
	<< "0000A3;0000C3;1;P0137;O2 Sensör Devresi Düşük Gerilimi (Sıra 1 Sensör 2)"
	<< "0000A3;0000C3;2;P1134;Hava/Yakıt Sensörü Mikro-Bilgisayar Sorunu"
	<< "0000A3;0000C3;3;P0131;O2 Sensör Devresi Düşük Gerilim (Sıra 1 Sensör 1)"
	<< "0000A3;0000C3;4;P0151;O2 Sensör Devresi Düşük Gerilim (Sıra 2 Sensör 1)"
	<< "0000A3;0000C3;5;P0132;O2 Sensör Devresi Yüksek Gerilim (Sıra 1 Sensör 1)"
	<< "0000A3;0000C3;6;P0152;O2 Sensör Devresi Yüksek Gerilim (Sıra 2 Sensör 1)"
	<< "0000A3;0000C3;7;P0138;O2 Sensör Devresi Yüksek Gerilim (Sıra 1 Sensör 2)"
	<< "0000A3;0000C3;8;P0153;O2 Sensör Devresi Yavaş Tepki (Sıra 2 Sensör 1)"
	<< "0000A4;0000C4;1;P0112;Emme Havası Sıcaklık Sensörü Devre Arızası (Düşük Giriş)"
	<< "0000A4;0000C4;2;P0113;Emme Havası Sıcaklık Sensörü Devre Arızası (Yüksek Giriş)"
	<< "0000A4;0000C4;3;P0111;Emme Hava Sıcaklığı Sensörü Aralık/Performans Sorunu"
	<< "0000A4;0000C4;4;P1546;Egzoz Gazı Sıcaklık Sensörü 2 Devre Arızası (Yüksek Giriş)"
	<< "0000A4;0000C4;5;P0038;HO2S Isıtıcı Kontrol Devresi Yüksek (Sıra 1 Sensör 2)"
	<< "0000A4;0000C4;6;P0032;HO2S Isıtıcı Kontrol Devresi Yüksek (Sıra 1 Sensör 1)"
	<< "0000A4;0000C4;7;P0037;HO2S Isıtıcı Kontrol Devresi Düşük (Sıra 1 Sensör 2)"
	<< "0000A4;0000C4;8;P0031;HO2S Isıtıcı Kontrol Devresi Düşük (Sıra 1 Sensör 1)"
	<< "0000A5;0000C5;1;P1110;Atmosferik Basınç Sensörü Devre Arızası (Düşük Giriş)"
	<< "0000A5;0000C5;2;P1111;Atmosferik Basınç Sensörü Devre Arızası (Yüksek Giriş)"
	<< "0000A5;0000C5;3;P1112;Atmosferik Basınç Sensörü Devre Aralık/Performans"
	<< "0000A5;0000C5;4;P0106;Manifold Basınç Sensörü Devre Aralık/Performans Sorunu (Düşük)"
	<< "0000A5;0000C5;5;P0107;Manifold Basınç Sensörü Devre Arızası (Düşük Giriş)"
	<< "0000A5;0000C5;6;P0108;Manifold Basınç Sensörü Devre Arızası (Yüksek Giriş)"
	<< "0000A5;0000C5;7;P1545;Egzoz Gazı Sıcaklık Sensörü 2 Devre Arızası (Düşük Giriş)"
	<< "0000A5;0000C5;8;P1146;Manifold Basınç Sensörü Devresi Aralık/Performans Sorunu (Yüksek)"
	<< "0000A6;0000C6;1;P1139;O2 Sensör Isıtıcı Devresi Aralık/Performans (Sıra 1 Sensör 1)"
	<< "0000A6;0000C6;2;P1140;O2 Sensör Isıtıcı Devresi Aralık/Performans (Sıra 2 Sensör 1)"
	<< "0000A6;0000C6;3;P1711;Motor Tork Kontrol Sinyali #1 Devre Arızası"
	<< "0000A6;0000C6;4;P1712;Motor Tork Kontrol Sinyali #2 Devre Arızası"
	<< "0000A6;0000C6;5;P0715;Tork Konvertörü Türbin Hızı Sinyali Devre Arızası"
	<< "0000A6;0000C6;6;P1703;AT Düşük Kavrama Zamanlaması Solenoid Valfi Devresi Arızası"
	<< "0000A6;0000C6;7;P0785;AT 2-4 Fren Zamanlaması Solenoid Valfi Devresi Arızası"
	<< "0000A6;0000C6;8;P0778;AT 2-4 Fren Basıncı Solenoid Valfi Devresi Arızası"
	<< "0000A7;0000C7;1;P1130;O2 Sensör Devresi (Açık) (Sıra 1 Sensör 1)"
	<< "0000A7;0000C7;2;P1135;O2 Sensör Devresi (Açık) (Sıra 2 Sensör 1)"
	<< "0000A7;0000C7;3;P1131;O2 Sensör Devresi (Kısadevre) (Sıra 1 Sensör 1)"
	<< "0000A7;0000C7;4;P1136;O2 Sensör Devresi (Kısadevre) (Sıra 2 Sensör 1)"
	<< "0000A7;0000C7;5;P1154;O2 Sensör Devresi Aralık/Performans (Düşük) (Sıra 2 Sensör 1)"
	<< "0000A7;0000C7;6;P1155;O2 Sensör Devresi Aralık/Performans (Yüksek) (Sıra 2 Sensör 1)"
	<< "0000A7;0000C7;7;P0052;HO2S Isıtıcı Kontrol Devresi Yüksek (Sıra 2 Sensör 1)"
	<< "0000A7;0000C7;8;P0051;HO2S Isıtıcı Kontrol Devresi Düşük (Sıra 2 Sensör 1)"
	<< "0000A8;0000C8;1;P0128;Soğutucu Termostat"
	<< "0000A8;0000C8;2;P1491;Pozitif Karter Havalandırma (PCV) Fonksiyonu Problemi (Blow-by)"
	<< "0000A8;0000C8;3;P0066;Hava Destekli Enjektör (AAI) Kontrol Devresi veya Düşük Devre Hatası"
	<< "0000A8;0000C8;4;P0067;Hava Destekli Enjektör (AAI) Kontrol Devresi Yüksek Hatası"
	<< "0000A8;0000C8;5;P0065;Hava Destekli Enjektör (AAI) Kontrol Aralık/Performans"
	<< "0000A8;0000C8;6;P0130;O2 Sensör Devresi (Fakir) (Sıra 1 Sensör 1)"
	<< "0000A8;0000C8;7;P1137;O2 Sensör Devresi (Lambda=1) (Sıra 1 Sensör 1)"
	<< "0000A8;0000C8;8;P1137;O2 Sensör Devresi (Orta) (Sıra 1 Sensör 1)"
	<< "0000A9;0000C9;1;P1248;Tahliye Vanası Kontrol Solenoidi 1 Devresi Yüksek"
	<< "0000A9;0000C9;2;P1249;Tahliye Vanası Kontrol Solenoidi 2 Devresi Yüksek"
	<< "0000A9;0000C9;3;P1250;Tahliye Vanası Kontrol Solenoidi 2 Devresi Yüksek"
	<< "0000A9;0000C9;4;P1560;Yedek Gerilim Devresi Arızası"
	<< "0000A9;0000C9;5;P0192;Yakıt Hattı Basınç Sensörü Devresi Düşük"
	<< "0000A9;0000C9;6;P0193;Yakıt Hattı Basınç Sensörü Devresi Yüksek"
	<< "0000A9;0000C9;7;P0562;Sistem Voltajı Düşük"
	<< "0000A9;0000C9;8;P0563;Sistem Voltajı Yüksek"
	<< "0000AA;0000CA;1;P0245;Turboşarj Westgate Solenoidi A Düşük"
	<< "0000AA;0000CA;2;P0246;Turboşarj Westgate Solenoidi A Yüksek"
	<< "0000AA;0000CA;3;P1244;Turboşarj Westgate Solenoidi A Aralık/Performans (Düşük Giriş)"
	<< "0000AA;0000CA;4;P0244;Turboşarj Westgate Solenoidi A Aralık/Performans (Yüksek Giriş)"
	<< "0000AA;0000CA;5;P1245;Turboşarj Westgate Solenoidi A Aralık/Performans (Tedbirli)"
	<< "0000AA;0000CA;6;P0249;Turboşarj Westgate Solenoidi B Düşük"
	<< "0000AA;0000CA;7;P0250;Turboşarj Westgate Solenoidi B Yüksek"
	<< "0000AA;0000CA;8;P1247;Emniyet Valfi Kontrol Solenoidi 1 Devresi Düşük"
	<< "0000AB;0000CB;1;P1577;İmmobilizer Kontrol Modülü EEPROM Hatası"
	<< "0000AB;0000CB;2;P1576;Elektronik Benzinli Enjeksiyon (EGI) Kontrol Modülü EEPROM Hatası"
	<< "0000AB;0000CB;3;P0513;Yanlış İmmobilizer Anahtarı"
	<< "0000AB;0000CB;4;P1574;Anahtar İletişim Hatası"
	<< "0000AB;0000CB;5;P1578;Sayaç Hatası"
	<< "0000AB;0000CB;6;P1572;İmmobilizer Devre Arızası (Anten Devresi Hariç)"
	<< "0000AB;0000CB;7;P1571;Referans Kodu Uyumsuzluğu"
	<< "0000AB;0000CB;8;P1570;Anten"
	<< "0000AC;0000CC;1;P1095;Tumble Jeneratör Valfi (TGV) 1 Sinyal Devresi Arızası (Kısadevre)"
	<< "0000AC;0000CC;2;P1097;Tumble Jeneratör Valfi (TGV) 2 Sinyal Devresi Arızası (Kısadevre)"
	<< "0000AC;0000CC;3;P1094;Tumble Jeneratör Valfi (TGV) 1 Sinyal Devresi Arızası (Açık)"
	<< "0000AC;0000CC;4;P1096;Tumble Jeneratör Valfi (TGV) 2 Sinyal Devresi Arızası (Açık)"
	<< "0000AC;0000CC;5;P0261;Yakıt Enjektörü Silindir #1 Devresi Düşük"
	<< "0000AC;0000CC;6;P0264;Yakıt Enjektörü Silindir #2 Devresi Düşük"
	<< "0000AC;0000CC;7;P0267;Yakıt Enjektörü Silindir #3 Devresi Düşük"
	<< "0000AC;0000CC;8;P0270;Yakıt Enjektörü Silindir #4 Devresi Düşük"
	<< "0000AD;0000CD;1;P0545;Egzoz Gazı Sıcaklık Sensörü Devre Arızası (Düşük Giriş)"
	<< "0000AD;0000CD;2;P0546;Egzoz Gazı Sıcaklık Sensörü Devre Arızası (Yüksek Giriş)"
	<< "0000AD;0000CD;3;P1312;Egzoz Gazı Sıcaklık Sensörü Arızası"
	<< "0000AD;0000CD;4;P1544;Egzoz Gazı Sıcaklığı Çok Yüksek"
	<< "0000AD;0000CD;5;P1306;Yağ Akışı Kontrol Solenoid Valfı (OCV) 1 Sinyal Devresi Arızası (Açık)"
	<< "0000AD;0000CD;6;P1308;Yağ Akışı Kontrol Solenoid Valfı (OCV) 2 Sinyal Devresi Arızası (Açık)"
	<< "0000AD;0000CD;7;P1307;Yağ Akışı Kontrol Solenoid Valfı (OCV) 1 Sinyal Devresi Arızası (Kısadevre)"
	<< "0000AD;0000CD;8;P1309;Yağ Akışı Kontrol Solenoid Valfı (OCV) 2 Sinyal Devresi Arızası (Kısadevre)"
	<< "0000F0;0000F4;1;P1719;ECU İletişim Devresi Hatası"
	<< "0000F0;0000F4;2;P1242;2 Aşamalı İkiz Turbo Sistemi (İkiz)"
	<< "0000F0;0000F4;3;P1241;2 Aşamalı İkiz Turbo Sistemi (Tek)"
	<< "0000F0;0000F4;4;P1199;Diferansiyel Basınç Sensörü"
	<< "0000F0;0000F4;5;P1086;Tumble Jeneratör Valfi (TGV) Konum Sensörü 2 Devresi Düşük"
	<< "0000F0;0000F4;6;P1087;Tumble Jeneratör Valfi (TGV) Konum Sensörü 2 Devresi Yüksek"
	<< "0000F0;0000F4;7;P1088;Tumble Jeneratör Valfi (TGV) Konum Sensörü 1 Devresi Düşük"
	<< "0000F0;0000F4;8;P1089;Tumble Jeneratör Valfi (TGV) Konum Sensörü 1 Devresi Yüksek"
	<< "0000F1;0000F5;1;P0801;Ters Inhibit Kontrol Devresi"
	<< "0000F1;0000F5;2;P0768;Vites Değiştirme Solenoidi D Elektrik"
	<< "0000F1;0000F5;3;P0763;Vites Değiştirme Solenoidi C Elektrik"
	<< "0000F1;0000F5;4;P0736;Ters Yanlış Oran"
	<< "0000F1;0000F5;5;P0724;Fren Düğmesi Devresi Yüksek"
	<< "0000F1;0000F5;6;P0719;Fren Düğmesi Devresi Düşük"
	<< "0000F1;0000F5;7;P0713;ATF Sıcaklık Sensörü Devresi Yüksek"
	<< "0000F1;0000F5;8;P0712;ATF Sıcaklık Sensörü Devresi Düşük"
	<< "0000F2;0000F6;1;P1817;Spor Modu Düğme Devresi (Manuel Düğme)"
	<< "0000F2;0000F6;2;P1762;Yanal Hızlanma Sensörü Devresi Yüksek"
	<< "0000F2;0000F6;3;P1761;Yanal Hızlanma Sensörü Devresi Düşük"
	<< "0000F2;0000F6;4;P1760;Yanal Hızlanma Sensörü Performans Sorunu"
	<< "0000F2;0000F6;5;P1718;AT CAN İletişim Devresi"
	<< "0000F2;0000F6;6;P1714;Gaz Kelebeği Konum Sensörü Güç Kaynağı Devresi"
	<< "0000F2;0000F6;7;P1709;Gaz Kelebeği Konum Sensörü Devresi Yüksek Giriş"
	<< "0000F2;0000F6;8;P1708;Gaz Kelebeği Konum Sensörü Devresi Düşük Giriş"
	<< "0000F3;0000F7;1;P1600;Uygunsuz CAN İletişimi"
	<< "0000F3;0000F7;2;P2709;Vites Değiştirme Solenoidi F Elektrik"
	<< "0000F3;0000F7;3;P0773;Vites Değiştirme Solenoidi F Elektrik"
	<< "0000F3;0000F7;4;P0735;Vites 5 Yanlış Oran"
	<< "0000F3;0000F7;5;P1799;Kilitlenme"
	<< "0000F3;0000F7;6;P1798;Vites 1 Motor Kırılması"
	<< "0000F3;0000F7;7;P1314;Ateşleme Arızası Sinyal Devresi Düşük Giriş"
	<< "0000F3;0000F7;8;P1313;Ateşleme Arızası Sinyal Devresi Yüksek Giriş"
	<< "000123;00012B;1;P1710;Tork Konvertörü Türbin 2 Hız Sinyali Devresi Arızası"
	<< "000123;00012B;2;P1717;Otomatik Şanzıman Yağı (ATF) Sıcaklık Sensörü 2 Devresi Yüksek"
	<< "000123;00012B;3;P1716;Otomatik Şanzıman Yağı (ATF) Sıcaklık Sensörü 2 Devresi Düşük"
	<< "000123;00012B;4;P0771;AT Düşük Kavrama Zamanlaması Solenoid Valfi Devresi Arızası"
	<< "000123;00012B;5;P0716;Tork Konvertörü Türbin Hızı Sinyali Devre Arızası"
	<< "000123;00012B;6;P0726;Motor Hızı Giriş Devresi Arızası"
	<< "000123;00012B;7;P0720;AT Araç Hızı Sensörü Devresi Yüksek"
	<< "000123;00012B;8;P0722;AT Araç Hızı Sensörü Devresi Düşük"
	<< "000124;00012C;1;P2707;Vites Değiştirme Solenoidi F Arızası"
	<< "000124;00012C;2;P0771;Vites Değiştirme Solenoidi E Arızası"
	<< "000124;00012C;3;P0766;Vites Değiştirme Solenoidi D Arızası"
	<< "000124;00012C;4;P0761;Vites Değiştirme Solenoidi C Arızası"
	<< "000124;00012C;5;P0756;Vites Değiştirme Solenoidi B Arızası"
	<< "000124;00012C;6;P0751;Vites Değiştirme Solenoidi A Arızası"
	<< "000124;00012C;7;P1769;Sapma Oranı ve Yanal G Sensörü Hatası"
	<< "000124;00012C;8;P1282;Pozitif Karter Havalandırması (PCV) Sistem Devresi (Açık)"
	<< "000125;00012D;1;P1844;Şanzıman Yağ Basıncı Sensörü Düğmesi E Devresi"
	<< "000125;00012D;2;P1843;Şanzıman Yağ Basıncı Sensörü Düğmesi D Devresi"
	<< "000125;00012D;3;P1842;Şanzıman Yağ Basıncı Sensörü Düğmesi C Devresi"
	<< "000125;00012D;4;P1841;Şanzıman Yağ Basıncı Sensörü Düğmesi B Devresi"
	<< "000125;00012D;5;P1840;Şanzıman Yağ Basıncı Sensörü Düğmesi A Devresi"
	<< "000125;00012D;6;P1875;Merkez Diferansiyel Devresi"
	<< "000125;00012D;7;P0558;Alternatör Devresi Düşük"
	<< "000125;00012D;8;P0559;Alternatör Devresi Yüksek"
	<< "000126;00012E;1;P0502;Araç Hızı Sensörü Düşük Giriş"
	<< "000126;00012E;2;P0230;Yakıt Pompası Denetleyicisi"
	<< "000126;00012E;3;P0565;Hız Sabitleyici Devrede Sinyali"
	<< "000126;00012E;4;P0068;Manifold Basınç Sensörü Aralık/Performans"
	<< "000126;00012E;5;P0129;Atmosferik Basınç Sensörü Aralık/Performans"
	<< "000126;00012E;6;P0519;Rölanti Kontrol Sistemi Arızası (Tedbirli)"
	<< "000126;00012E;7;P0345;Eksantrik (KAM) Mili Konum Sensörü A Devresi (Sıra 2)"
	<< "000126;00012E;8;P0101;Kütle veya Hacim Hava Akışı Devresi Aralık/Performans"
	<< "000127;00012F;1;P0154;O2 Sensör Devresi Açık (Sıra 2 Sensör 1)"
	<< "000127;00012F;2;P0134;O2 Sensör Devresi Açık (Sıra 1 Sensör 1)"
	<< "000127;00012F;3;P0150;O2 Sensör Devresi (Sıra 2 Sensör 1)"
	<< "000127;00012F;4;P0130;O2 Sensör Devresi (Sıra 1	Sensör 1))"
	<< "000127;00012F;5;P0050;O2 Sensör Isıtıcı Devresi Aralık/Performans (Sıra 2 Sensör 1)"
	<< "000127;00012F;6;P0030;O2 Sensör Isıtıcı Devresi Aralık/Performans (Sıra 1 Sensör 1)"
	<< "000127;00012F;7;P0501;Düşük Hızda Araç Hızı Sensörü Arızası"
	<< "000127;00012F;8;P0503;Araç Hızı Sensörü Yüksek Hız"
	<< "000128;000130;1;P0142;O2 Sensörü Devresi (Sıra 1 Sensör 3)"
	<< "000128;000130;2;P0145;O2 Sensör Devresi Yavaş Yanıt (Sıra 1 Sensör 3)"
	<< "000128;000130;3;P0156;O2 Sensör Devresi (Sıra 2 Sensör 2)"
	<< "000128;000130;4;P0159;O2 Sensör Devresi Yavaş Yanıt (Sıra 2 Sensör 2)"
	<< "000128;000130;5;P0162;O2 Sensör Devresi (Sıra 2 Sensör 3)"
	<< "000128;000130;6;P0165;O2 Sensör Devresi Yavaş Yanıt (Sıra 2 Sensör 3)"
	<< "000128;000130;7;P0043;HO2S Isıtıcı Kontrol Devresi Düşük (Sıra 1 Sensör 3)"
	<< "000128;000130;8;P0044;H02S Isıtıcı Kontrol Devresi Yüksek (Sıra 1 Sensör 3)"
	<< "000129;000131;1;P0057;HO2S Isıtıcı Kontrol Devresi Düşük (Sıra 2 Sensör 2)"
	<< "000129;000131;2;P0058;HO2S Isıtıcı Kontrol Devresi Yüksek (Sıra 2 Sensör 2)"
	<< "000129;000131;3;P0063;HO2S Isıtıcı Kontrol Devresi Düşük (Sıra 2 Sensör 3)"
	<< "000129;000131;4;P0064;HO2S Isıtıcı Kontrol Devresi Yüksek (Sıra 2 Sensör 3)"
	<< "000129;000131;5;P0157;O2 Sensör Devresi Düşük Gerilimi (Sıra 2 Sensör 2)"
	<< "000129;000131;6;P0158;O2 Sensör Devresi Yüksek Gerilimi (Sıra 2 Sensör 2)"
	<< "000129;000131;7;P0143;O2 Sensör Devresi Düşük Gerilimi (Sıra 1 Sensör 3)"
	<< "000129;000131;8;P0144;O2 Sensör Devresi Yüksek Gerilimi (Sıra 1 Sensör 3)"
	<< "00012A;000132;1;P2109;Gaz Kelebeği Açı Sensörü Kapalı Konum Hatası"
	<< "00012A;000132;2;P1759;Yanal G Sensör Sistemi Devresi"
	<< "00012A;000132;3;P1873;Arka Sağ ABS Sensörü Sinyali"
	<< "00012A;000132;4;P1872;Arka Sol ABS Sensörü Sinyali"
	<< "00012A;000132;5;P1871;Ön Sağ ABS Sensörü Sinyali"
	<< "00012A;000132;6;P1870;Ön Sol ABS Sensörü Sinyali"
	<< "00012A;000132;7;P2125;Gaz Pedalı Konum Sensörü E"
	<< "00012A;000132;8;P1700;Gaz Kelebeği Konum Sensörü Devresi Arızası"
	<< "000150;000155;1;P0222;Gaz Kelebeği Konum Sensörü B Düşük Giriş"
	<< "000150;000155;2;P0223;Gaz Kelebeği Konum Sensörü B Yüksek Giriş"
	<< "000150;000155;3;P1160;Dönüş Yayı Hatası"
	<< "000150;000155;4;P2102;Gaz Kelebeği Kontrol Motoru Devresi Düşük Giriş"
	<< "000150;000155;5;P2103;Gaz Kelebeği Kontrol Motoru Devresi Yüksek Giriş"
	<< "000150;000155;6;P2101;Gaz Kelebeği Kontrol Motoru Devresi Aralık/Performans"
	<< "000150;000155;7;P2096;Katalizatör Sonrası Yakıt Trim Sistemi Çok Fakir (Sıra 1)"
	<< "000150;000155;8;P0638;Gaz Kelebeği Kontrol Devresi Aralık/Performans Sorunu"
	<< "000151;000156;1;P0607;Gaz Kelebeği Kontrol Sistemi Devresi Aralık/Performans"
	<< "000151;000156;2;P2138;Hızlandırıcı Konum Sensörü Devre Menzil/Performans"
	<< "000151;000156;3;P2127;Hızlandırıcı Konum Sensörü E Düşük Giriş"
	<< "000151;000156;4;P2128;Hızlandırıcı Konum Sensörü E Yüksek Giriş"
	<< "000151;000156;5;P2122;Hızlandırıcı Konum Sensörü D Düşük Giriş"
	<< "000151;000156;6;P2123;Hızlandırıcı Konum Sensörü D Yüksek Giriş"
	<< "000151;000156;7;P2135;Gaz Kelebeği Konum Sensörü Devre Aralık/Performans"
	<< "000151;000156;8;P2097;Katalizatör Sonrası Yakıt Trim Sistemi Çok Zengin (Sıra 1)"
	<< "000152;000157;1;P0600;Uygunsuz CAN İletişimi"
	<< "000152;000157;2;P0390;Eksantrik Mili Konum Sensörü B Devresi (Sıra 2)"
	<< "000152;000157;3;P0365;Eksantrik Mili Konum Sensörü B Devresi (Sıra 1)"
	<< "000152;000157;4;P0345;Eksantrik Mili Konum Sensörü A Devresi (Sıra 2)"
	<< "000152;000157;5;P0340;Eksantrik Mili Konum Sensörü A Devresi (Sıra 1)"
	<< "000152;000157;6;P0605;Dahili Kontrol Modülü Salt Okunur Bellek Hatası"
	<< "000152;000157;7;P1521;Fren Düğmesi Devresi Aralık/Performans Sorunu (Yüksek Giriş)"
	<< "000152;000157;8;P0579;Hız Sabitleyici Düğmesi Devresi Aralık/Performans Sorunu (Yüksek Giriş)"
	<< "000153;000158;1;P2095;OCV Solenoid Valf Sinyali B Devresi Kısadevre (Sıra 2)"
	<< "000153;000158;2;P2094;OCV Solenoid Valf Sinyali B Devresi Açık (Sıra 2)"
	<< "000153;000158;3;P2091;OCV Solenoid Valf Sinyali B Devresi Kısadevre (Sıra 2)"
	<< "000153;000158;4;P2090;OCV Solenoid Valf Sinyali B Devresi Açık (Sıra 1)"
	<< "000153;000158;5;P2093;OCV Solenoid Valf Sinyali A Devresi Kısadevre (Sıra 2)"
	<< "000153;000158;6;P2092;OCV Solenoid Valf Sinyali A Devresi Açık (Sıra 2)"
	<< "000153;000158;7;P2089;OCV Solenoid Valf Sinyali A Devresi Kısadevre (Sıra 1)"
	<< "000153;000158;8;P2088;OCV Solenoid Valf Sinyali A Devresi Açık (Sıra 1)"
	<< "000154;000159;1;P0197;Yağ Sıcaklığı Sensör Devresi Arızası (Düşük)"
	<< "000154;000159;2;P1547;Egzoz Gazı Sıcaklık Sensörü Arızası"
	<< "000154;000159;3;P1476;Egzoz Baypas Valfi Solenoidi Arızası (Yüksek)"
	<< "000154;000159;4;P1475;Egzoz Baypas Valfi Solenoidi Arızası (Düşük)"
	<< "000154;000159;5;P1477;Egzoz By-pass Valf İşlevi"
	<< "000154;000159;6;P2099;Katalizör Sonrası Yakıt Trim Sistemi Çok Zengin (Sıra 2)"
	<< "000154;000159;7;P2098;Katalizör Sonrası Yakıt Trim Sistemi Çok Fakir (Sıra 2)"
	<< "000154;000159;8;P0700;AT Arıza Gösterge Işığı İsteği (MIL) Açık"
	<< "000160;000165;1;P0028;OSV Solenoid Valf (Sol) Arızası"
	<< "000160;000165;2;P0083;OSV Solenoid Valf (Sol) Devre Arızası (Yüksek)"
	<< "000160;000165;3;P0082;OSV Solenoid Valf (Sol) Devre Arızası (Düşük)"
	<< "000160;000165;4;P0026;OSV Solenoid Valf (Sağ) Arızası"
	<< "000160;000165;5;P0077;OSV Solenoid Valf (Sağ) Devre Arızası (Yüksek)"
	<< "000160;000165;6;P0076;OSV Solenoid Valf (Sağ) Devre Arızası (Düşük)"
	<< "000160;000165;7;P0196;Yağ Sıcaklığı Sensör Devresi Aralık/Performans Sorunu"
	<< "000160;000165;8;P0198;Yağ Sıcaklığı Sensör Devresi Arızası (Yüksek)"
	<< "000161;000166;1;P2100;Gaz Kelebeği Kontrol Motoru Devresi Açık"
	<< "000161;000166;2;P2111;Gaz Kelebeği Valfı Açık Halde Yapışık"
	<< "000161;000166;3;P2504;Alternatör Devresi Yüksek"
	<< "000161;000166;4;P2503;Alternatör Devresi Düşük"
	<< "000161;000166;5;P1462;Silindir Arası Yakıt Basıncı Sensör Sistemi Devresi (Düşük)"
	<< "000161;000166;6;P1463;Silindir Arası Yakıt Basıncı Sensör Sistemi Devresi (Yüksek)"
	<< "000161;000166;7;P1028;Değişken Valf Lift (VVL) Sistemleri 2 Performansı"
	<< "000161;000166;8;P1026;Değişken Valf Lift (VVL) Sistemleri 1 Performansı"
	<< "000162;000167;1;P0958;Yedek Lamba Rölesi Çıkışı (Yüksek)"
	<< "000162;000167;2;P0957;Yedek Lamba Rölesi Çıkışı (Düşük)"
	<< "000162;000167;3;P0955;Yedek Lamba Rölesi Çıkışı (Açık)"
	<< "000162;000167;4;P0883;PIVGN Güç Kaynağı (Yüksek)"
	<< "000162;000167;5;P0882;PIVGN Güç Kaynağı (Düşük)"
	<< "000162;000167;6;P0880;PIVGN Güç Kaynağı Devresi"
	<< "000162;000167;7;P0817;PN Sinyal Çıkış Devresi"
	<< "000162;000167;8;P1601;Şanzıman Kontrol Ünitesi (TCU) İletişim Arızası"
	<< "000163;000168;1;P2004;Tumble Jeneratör Valfi (TGV) Sistem 1 (Valf Açık)"
	<< "000163;000168;2;P2006;Tumble Jeneratör Valfi (TGV) Sistem 1 (Valf Kapalı)"
	<< "000163;000168;3;P2005;Tumble Jeneratör Valfi (TGV) Sistem 2 (Valf Açık)"
	<< "000163;000168;4;P2007;Tumble Jeneratör Valfi (TGV) Sistem 2 (Valf Kapalı)"
	<< "000163;000168;5;P2227;Atmosferik Basınç Sensörü Aralık/Performans"
	<< "000163;000168;6;P0126;Su Sıcaklığı"
	<< "000163;000168;7;P2229;Atmosferik Basınç Sensörü Devre Arızası (Yüksek Giriş)"
	<< "000163;000168;8;P2228;Atmosferik Basınç Sensörü Devre Arızası (Düşük Giriş)"
	<< "000164;000169;1;P2016;Tumble Jeneratör Valfi (TGV) Konum Sensörü 1 Devresi Düşük"
	<< "000164;000169;2;P2017;Tumble Jeneratör Valfi (TGV) Konum Sensörü 1 Devresi Yüksek"
	<< "000164;000169;3;P2021;Tumble Jeneratör Valfi (TGV) Konum Sensörü 2 Devresi Düşük"
	<< "000164;000169;4;P2022;Tumble Jeneratör Valfi (TGV) Konum Sensörü 2 Devresi Yüksek"
	<< "000164;000169;5;P2009;Tumble Jeneratör Valfi (TGV) Sinyal 1 Devre Arızası (Kısadevre)"
	<< "000164;000169;6;P2012;Tumble Jeneratör Valfi (TGV) Sinyal 2 Devre Arızası (Kısadevre)"
	<< "000164;000169;7;P2008;Tumble Jeneratör Valfi (TGV) Sinyal 1 Devre Arızası (Açık)"
	<< "000164;000169;8;P2011;Tumble Jeneratör Valfi (TGV) Sinyal 2 Devre Arızası (Açık)"
	<< "000174;00017B;1;P1579;Uzaktan Kumandayla Marş Anormal"
	<< "000175;00017C;1;P0850;Nötr Pozisyon Düğmesi Devresi"
	<< "000175;00017C;2;P1721;DCCD Motor RPM Sinyal Sistemi Devresi"
	<< "000175;00017C;3;P1720;DCCD CAN Sistem Devresi"
	<< "000175;00017C;4;P1765;Sapma Oranı & Yan G Sensör Referans Sistemi Devresi"
	<< "000175;00017C;5;P1764;Sapma Oranı Sensör Sistemi Devresi"
	<< "000175;00017C;6;P1767;DCCD Direksiyon Açısı Sensörü Devresi"
	<< "000175;00017C;7;P1723;Otomatik Şanzıman Yağı (ATF) Sıcaklık Sensörü 2 Devresi Aralık/Performans"
	<< "000175;00017C;8;P0711;Otomatik Şanzıman Yağı (ATF) Sıcaklık Sensörü Devresi Aralık/Performans"
	<< "000176;00017D;1;P2444;İkincil Hava Pompası AÇIK Arızası"
	<< "000176;00017D;2;P0411;İkincil Hava Akışı Anormal"
	<< "000176;00017D;3;P0410;İkincil Hava Sistemi İşlevi"
	<< "000176;00017D;4;P2431;İkincil Hava Basıncı Sensör Özelliği"
	<< "000176;00017D;5;P2433;İkincil Hava Basıncı Sensörü (Yüksek)"
	<< "000176;00017D;6;P2432;İkincil Hava Basıncı Sensörü (Düşük)"
	<< "000176;00017D;7;P0413;İkincil Hava Kombi Valfi Röle Devresi 1 (Düşük)"
	<< "000176;00017D;8;P0418;İkincil Hava Pompası Rölesi (Düşük)"
	<< "000177;00017E;1;P0140;O2 Sensör Devresi Aralık/Performans (Sıra 1 Sensör 2)"
	<< "000177;00017E;2;P0160;O2 Sensör Devresi Aralık/Performans (Sıra 2 Sensör 2)"
	<< "000177;00017E;3;P0146;O2 Sensör Devresi Aralık/Performans (Sıra 1 Sensör 3)"
	<< "000177;00017E;4;P1602;Kontrol Modülü Programlama Hatası"
	<< "000177;00017E;5;P0414;Sekonder Hava Kombi Valfi Röle Devresi 1 (Yüksek)"
	<< "000177;00017E;6;P1418;İkincil Hava Pompası Rölesi (Yüksek)"
	<< "000177;00017E;7;P0018;Krank ve Kam Zamanlaması A Hatası (Sıra 2)"
	<< "000177;00017E;8;P0016;Krank ve Kam Zamanlaması A Hatası (Sıra 1)"
	<< "000178;00017F;1;P0602;Kontrol Modülü Programlama Hatası"
	<< "000178;00017F;2;P1410;İkincil Hava Kombi Valfı Açık Kalmış"
	<< "000178;00017F;3;P2443;İkincil Hava Sistemi Kapalı Kalmış (Sıra 2)"
	<< "000178;00017F;4;P2442;İkincil Hava Sistemi Açık Kalmış (Sıra 2)"
	<< "000178;00017F;5;P2441;İkincil Hava Sistemi Kapalı Kalmış (Sıra 1)"
	<< "000178;00017F;6;P2440;İkincil Hava Sistemi Açık Kalmış (Sıra 1)"
	<< "000178;00017F;7;P0417;İkincil Hava Kombi Valfı Röle Devresi 2 (Yüksek)"
	<< "000178;00017F;8;P0416;İkincil Hava Kombi Valfı Röle Devresi 2 (Düşük)"
	<< "000179;000180;1;P0024;Egzoz Aktif Valf Kontrol Sistemi (AVCS) Sistem 2 (Aralık/Performans)"
	<< "000179;000180;2;P0014;Egzoz Aktif Valf Kontrol Sistemi (AVCS) Sistem 1 (Aralık/Performans)"
	<< "000179;000180;3;P1616;Marş Kesme Röle Sistem Devresi (DÜŞÜK)"
	<< "000179;000180;4;P1520;Marş Anahtarı 2 Sistem Devresi (AÇIK)"
	<< "000179;000180;5;P1519;Marş Anahtarı 2 Sistem Devresi (KAPALI)"
	<< "000179;000180;6;P0441;Buharlaşıcı Emisyon Kontrol Sistemi Yanlış Tahliye Akışı"
	<< "000179;000180;7;P2419;Kanister Boşaltma Kontrolü (CPC) Solenoid Valf Devresi Düşük"
	<< "000179;000180;8;P2420;Kanister Boşaltma Kontrolü (CPC) Solenoid Valf Devresi Yüksek"
	<< "00017A;000181;1;P2634;Alt Yakıt Pompası Rölesi (Yüksek)"
	<< "00017A;000181;2;P2633;Alt Yakıt Pompası Rölesi (Düşük)"
	<< "00017A;000181;5;P0091;Yakıt Basıncı Değişim Solenoidi (Devre Düşük)"
	<< "00017A;000181;6;P0092;Yakıt Basıncı Değişim Solenoidi (Devre Yüksek)"
	<< "00017A;000181;7;P0019;Krank ve Kam Zamanlama B Sistemi Arızası (Sıra 2)"
	<< "00017A;000181;8;P0017;Krank ve Kam Zamanlama B Sistemi Arızası (Sıra 1)"
	<< "0001C5;0001CB;1;P0201;Enjektör #1 Devre Arızası"
	<< "0001C5;0001CB;2;P1213;Enjektör Sürücüsü (Düşük Şarj)"
	<< "0001C5;0001CB;3;P2148;Enjektör Sürücüsü (Pozitif Kutba Kısadevre)"
	<< "0001C5;0001CB;4;P0704;Debriyaj Düğmesi Devre Arızası"
	<< "0001C5;0001CB;5;P0096;Emme Havası Sıcaklık Sensörü #2 Aralık/Performans Sorunu"
	<< "0001C5;0001CB;6;P0097;Emme Havası Sıcaklık Sensörü #2 Devresi (Düşük)"
	<< "0001C5;0001CB;7;P0098;Emme Havası Sıcaklık Sensörü #2 Devresi (Yüksek)"
	<< "0001C5;0001CB;8;P0116;Motor Soğutma Suyu Sıcaklık Sensörü Devresi Aralık/Performans"
	<< "0001C6;0001CC;1;P0088;Yakıt Hat Basıncı Anormal (Çok Yüksek)"
	<< "0001C6;0001CC;2;P0191;Yakıt Hat Basınç Sensörü Devresi Aralık/Performans"
	<< "0001C6;0001CC;3;P1214;Enjektör Sürücüsü (Aşırı Şarj)"
	<< "0001C6;0001CC;4;P2149;Yakıt Enjektörü Güç Kaynağı B - Açık Devre"
	<< "0001C6;0001CC;5;P2146;Yakıt Enjektörü Güç Kaynağı A - Açık Devre"
	<< "0001C6;0001CC;6;P0204;Enjektör #4 Devre Arızası"
	<< "0001C6;0001CC;7;P0203;Enjektör #3 Devre Arızası"
	<< "0001C6;0001CC;8;P0202;Enjektör #2 Devre Arızası"
	<< "00020A;00020E;1;P0093;Yakıt Sistemi Kaçak Tespiti (Büyük Kaçak)"
	<< "00020A;00020E;2;P1234;Yakıt Basıncı Anormal (Yakıt Pompası Arızası 2)"
	<< "00020A;00020E;3;P1233;Yakıt Basıncı Anormal (Yakıt Pompası Arızası 1)"
	<< "00020A;00020E;4;P1232;Yakıt Pompası Arızası"
	<< "00020A;00020E;5;P2635;Yakıt Pompası Emme Kontrol Valf Yapışıklıkları"
	<< "00020A;00020E;6;P0628;Yakıt Pompası Emme Kontrol Valf Devresi (Şasiye Kısadevre)"
	<< "00020A;00020E;7;P0629;Yakıt Pompası Emme Kontrol Valf Devresi (Pozitif Kutba Kısadevre)"
	<< "00020A;00020E;8;P0089;Yakıt Basınç Regülatörü Performansı (Sınırlayıcı Valf Açma Problemi)"
	<< "00020B;00020F;1;P0401;Egzoz Gazı Devridaimi (EGR) Yetersiz Akışı Algılandı"
	<< "00020B;00020F;2;P0402;Egzoz Gazı Devridaimi (EGR) Aşırı Akışı Algılandı"
	<< "00020B;00020F;3;P0299;Takviye Basınç Anormal (Takviye Altı)"
	<< "00020B;00020F;4;P0234;Takviye Basınç Anormal (Takviye Üstü)"
	<< "00020B;00020F;5;P0606;Kontrol Ünitesi İşlemcisi (CPU) Hatası"
	<< "00020B;00020F;6;P1203;Enjektör Kodu Giriş Hatası"
	<< "00020B;00020F;7;P1202;Enjektör Kodu Verileri Anormal"
	<< "00020B;00020F;8;P1201;Enjektör Kodu Hatası (Kayıtlı Değil)"
	<< "00020C;000210;1;P1382;Isıtıcı Röle Devresi (Yüksek)"
	<< "00020C;000210;2;P0219;Motor Aşırı Hız Durumu"
	<< "00020C;000210;3;P0046;Turboşarjer Takviye Kontrol Solenoidi Valf Devresi Aralık/Performans"
	<< "00020C;000210;4;P0404;Egzoz Gazı Devridaimi (EGR) Çalışma Devresi Anormal"
	<< "00020C;000210;5;P0403;Egzoz Gazı Devridaimi (EGR) Sistem Arızası (Devre Görevi)"
	<< "00020C;000210;6;P0409;Egzoz Gazı Devridaimi (EGR) Pozisyon Sensörü Performans"
	<< "00020C;000210;7;P0405;Egzoz Gazı Devridaimi (EGR) Konum Sensör Devresi (Düşük)"
	<< "00020C;000210;8;P0406;Egzoz Gazı Devridaimi (EGR) Konum Sensör Devresi (Yüksek)"
	<< "00020D;000211;2;P2413;Egzoz Gazı Devridaimi (EGR) Valf Yapışması"
	<< "00020D;000211;3;P1009;Girdap Kontrol Valfi Devresi (Düşük)"
	<< "00020D;000211;4;P1607;İzleme Devresi Anormal"
	<< "00020D;000211;5;P2147;Enjektör Sürücüsü (Şasiye Kısadevre)"
	<< "00020D;000211;6;P2010;Girdap Kontrol Valfi Devresi (Yüksek)"
	<< "00020D;000211;7;P0687;Motor/Güç Aktarma Organı Kontrol Modülü (ECM/PCM) Otomatik Kapanma Rölesi Hatası"
	<< "00020D;000211;8;P1380;Kızdırma Rölesi Devresi (Düşük)"
	<< "000263;000268;4;P1532;Şarj Kontrol Sistemi Anormal"
	<< "000263;000268;5;P1531;Akü Akım Sensör Devresi (Yüksek)"
	<< "000263;000268;6;P1530;Akü Akım Sensör Devresi (Düşük)"
	<< "000263;000268;7;P0517;Akü Sıcaklığı Sensör Devresi (Yüksek)"
	<< "000263;000268;8;P0516;Akü Sıcaklığı Sensör Devresi (Düşük)"
	<< "000264;000269;8;P0161;Oxygen O2 Sensör Isıtıcı Devresi (Sıra 2 Sensör 2)"
	<< "000265;00026A;1;P1468;Yağ Seyreltme"
	<< "000265;00026A;2;P1467;Dizel Partikül Filtresi (DPF) Aşırı Kül Dolması"
	<< "000265;00026A;3;P1466;Dizel Partikül Filtresi (DPF) Substrat Hasarlı"
	<< "000265;00026A;4;P1465;Dizel Partikül Filtresi (DPF) Aşırı Partikül Dolumu"
	<< "000265;00026A;5;P1473;Dizel Partikül Filtresi (DPF) Giriş/Çıkış Basıncı Sapma Sensörü (Yüksek)"
	<< "000265;00026A;6;P1472;Dizel Partikül Filtresi (DPF) Giriş/Çıkış Basıncı Sapma Sensörü (Düşük)"
	<< "000265;00026A;7;P2033;Egzoz Sıcaklığı Sensör 2 (Yüksek)"
	<< "000265;00026A;8;P2032;Egzoz Sıcaklığı Sensör 2 (Düşük)"
	<< "000266;00026B;7;P1471;Dizel Partikül Filtresi (DPF) Diferansiyel Basınç Sensörü Upstream Borusu Sorunu"
	<< "000266;00026B;8;P1469;Dizel Partikül Filtresi (DPF) Limp-Home Modu";


// Cancel codes of the integrated Cruise Control:
const QStringList SSMFlagbyteDefinitions_tr::_CC_defs_tr =
	QStringList()
	<< "000133;000137;1;22;Araç Hızındaki Değişim Anormalliği"
	<< "000133;000137;2;21;Kontak AÇIK Konumdayken Düğmelerin Anormalliği"
	<< "000133;000137;3;16;Kontak Düğmesi"
	<< "000133;000137;4;15;İptal Düğmesi"
	<< "000133;000137;5;14;Nötr Düğmesi"
	<< "000133;000137;6;13;Debriyaj Düğmesi"
	<< "000133;000137;7;12;Durdurma ve Fren Düğmesi"
	<< "000133;000137;8;11;Ana Düğme"
	<< "000134;000138;1;35;Araç Hızı F/B Arızasında Hız Kontrolünün Engellenmesi"
	<< "000134;000138;2;34;Yüksek ve Sürekli Gaz Pedalı Açısında Hız Sabitleyicinin Engellenmesi"
	<< "000134;000138;3;33;Gaz Pedalı İşlemi BEKLE Durumuna Alınmasının Engellenmesi"
	<< "000134;000138;4;32;Hız Sabitleyici Aralık Dışında"
	<< "000134;000138;5;31;Anormal Motor Hızı Sinyali"
	<< "000134;000138;6;25;Fren Düğmesi Giriş Devresinde Anormallik"
	<< "000134;000138;7;24;Hız Sabitleme ile İlgili Düğmelerde Anormallik"
	<< "000134;000138;8;23;Motorla İlgili Sensör Anormalliği"
	<< "000135;000139;1;52;Aktif Sürüş Yardımı (ADA) Hedef Araç Hızı Arızası"
	<< "000135;000139;2;51;Aktif Sürüş Yardımı (ADA) Zorla İptal"
	<< "000135;000139;3;46;Güç Aktarma Sistemi Kontrol Ünitesi (PCU) Arızası"
	<< "000135;000139;4;45;Sayaç Hatası"
	<< "000135;000139;5;44;Gövdeye Entegre Ünite Hatası"
	<< "000135;000139;6;43;ABS/VDC Hatası"
	<< "000135;000139;7;42;Uygunsuz Yüksek Hızlı CAN İletişimi"
	<< "000135;000139;8;41;VDC/TCS İşletimi"
	<< "000136;00013A;1;66;Hız Sabitleyici Hesaplama Hatası"
	<< "000136;00013A;2;25;Fren Düğmesi Giriş Devresinde Anormallik"
	<< "000136;00013A;3;65;Hız Sabitleme ile İlgili 1 Düğmede Anormallik"
	<< "000136;00013A;4;64;Motor Sensörü Arızası 1"
	<< "000136;00013A;5;63;Araç Hızındaki Değişim Anormallik 1"
	<< "000136;00013A;6;21;Kontak AÇIK konumdayken Düğmelerin Anormalliği"
	<< "000136;00013A;7;62;Nötr Düğmesi Arızası"
	<< "000136;00013A;8;61;Fren Düğmesi Arızası";


// Actuators:
const QStringList SSMFlagbyteDefinitions_tr::_actuator_defs_tr =
	QStringList()
	<< "29;7;000089;8;Yakıt Pompası Rölesi"
	<< "29;7;000089;7;Kanister Boşaltma Kontrolü (CPC) Solenoid Valfi"
	<< "29;7;000089;6;Radyatör Fanı Rölesi"
	<< "29;7;000089;5;Klima Kompresörü Rölesi"
	<< "29;7;000089;4;Egzoz Gazı Devridaimi (EGR) Solenoid Valfi"
	<< "29;7;000089;3;Hava Emiş Solenoid Valfi (ASV)"
	<< "29;7;000089;2;Pozitif Karter Havalandırması (PCV) Solenoid Valfi"
	<< "29;7;000089;1;Havalandırma Kontrol Solenoid Valfi"
	<< "29;7;00008A;8;Hızlı Rölanti Kontrol Cihazı (FICD) Solenoidi"
	<< "29;7;00008A;7;Basınç Değişim Solenoidi 1"
	<< "29;7;00008A;6;Basınç Değişim Solenoidi 2"
	<< "29;7;00008A;5;Hava Destek Enjektörü (AAI) Solenoid Valfi"
	<< "29;7;00008A;4;Yakıt Deposu Sensörü Kontrol Valfi"
	<< "29;7;00008A;3;Turbo Wastegate Solenoid Valfi"
	<< "29;7;00008A;2;Egzoz Baypas Kontrol İzni İşareti"
	<< "29;7;00008A;1;İkincil Hava Kombi Valfi 1"
	<< "42;2;00018D;8;İkincil Hava Kombi Valfi 2"
	<< "42;2;00018D;7;İkincil Hava Pompası Rölesi"
	<< "42;2;00018D;6;Kanister Boşaltma Kontrolü (CPC) Solenoid Valfı 2"
	<< "42;2;00018D;5;Alt Yakıt Pompası Rölesi"
	<< "42;2;00018D;4;Yakıt Basınç Değişimi Solenoidi";


// Adjustments:
const QStringList SSMFlagbyteDefinitions_tr::_adjustment_defs_tr =
	QStringList()
	<< "26-5;0;6F;;Ateşleme Zamanlaması Düzeltmesi;deg;0;5;0;*-1;0"
	<< "26-4;0;70;;Rölanti Hızı Düzeltme (Klima Kapalı);rpm;124;140;128;-128*25;0"
	<< "26-3;0;71;;Rölanti Hızı Düzeltme (Klima Açık);rpm;124;140;128;-128*25;0"
	<< "26-1;1;72;;Hat Basıncı Düzeltmesi;%;90;110;100;-100;0"
	<< "A11020;1;73;;Vites Değiştirme Hattı Basıncı Düzeltme - 1. ila 2.;kgf;90;110;100;-100/50;2"
	<< "A11020;1;74;;Vites Değiştirme Hattı Basıncı Düzeltme - 2. ila 3.;kgf;90;110;100;-100/50;2"
	<< "A11020;1;75;;Vites Değiştirme Hattı Basıncı Düzeltme - 3. ila 4.;kgf;90;110;100;-100/50;2"
	<< "A11020;1;76;;Vites Değiştirme Hattı Basıncı Düzeltme - 4. ila 3.;kgf;90;110;100;-100/50;2"
	<< "A11020;1;77;;Vites Değiştirme Hattı Basıncı Düzeltme - 4. ila 2.;kgf;90;110;100;-100/50;2"
	<< "A11020;1;78;;Vites Değiştirme Hattı Basıncı Düzeltme - 3. ila 2.;kgf;90;110;100;-100/50;2"
	<< "27-8;1;79;;2-4-Fren Basıncı 1 Düzeltme;%;90;110;100;-100;0"
	<< "27-7;1;7A;;2-4-Fren Basıncı 2 Düzeltme - 1. ila 2.;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7B;;2-4-Fren Basıncı 2 Düzeltme - 2. ila 3.;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7C;;2-4-Fren Basıncı 2 Düzeltme - 3. ila 4.;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7D;;2-4-Fren Basıncı 2 Düzeltme - 4. ila 3.;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7E;;2-4-Fren Basıncı 2 Düzeltme - 4. ila 2.;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7F;;2-4-Fren Basıncı 2 Düzeltme - 3. ila 2.;kgf;90;110;100;-100/50;2"
	<< "27-6;1;80;;Transfer Yük Oranının Düzeltilmesi;%;90;110;100;-100;0"
	<< "27-5;1;81;;Meyil Kontrolü;;0;1;0;0=Allowance,1=No Access;"
	<< "27-4;1;82;;Merkezi Diferansiyel;%;50;150;100;*1;0"
	<< "27-3;1;171;170;AWD Kavraması Tork Düzeltmesi;Nm;63535;2000;0;s16/50;0";


const QStringList SSMFlagbyteDefinitions_tr::MBrawDefs()
{
	return _MB_defs_tr;
}


const QStringList SSMFlagbyteDefinitions_tr::SWrawDefs()
{
	return _SW_defs_tr;
}


const QStringList SSMFlagbyteDefinitions_tr::SUBDTCrawDefs()
{
	return _DTC_SUBARU_defs_tr;
}


const QStringList SSMFlagbyteDefinitions_tr::OBDDTCrawDefs()
{
	return _DTC_OBD_defs_tr;
}


const QStringList SSMFlagbyteDefinitions_tr::CCCCrawDefs()
{
	return _CC_defs_tr;
}


const QStringList SSMFlagbyteDefinitions_tr::ActuatorRawDefs()
{
	return _actuator_defs_tr;
}


const QStringList SSMFlagbyteDefinitions_tr::AdjustmentRawDefs()
{
	return _adjustment_defs_tr;
}

