"use strict";
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.isInputReplyMsg = exports.isInputRequestMsg = exports.isDebugReplyMsg = exports.isDebugRequestMsg = exports.isExecuteReplyMsg = exports.isInfoRequestMsg = exports.isCommMsgMsg = exports.isCommCloseMsg = exports.isCommOpenMsg = exports.isDebugEventMsg = exports.isClearOutputMsg = exports.isStatusMsg = exports.isErrorMsg = exports.isExecuteResultMsg = exports.isExecuteInputMsg = exports.isUpdateDisplayDataMsg = exports.isDisplayDataMsg = exports.isStreamMsg = exports.createMessage = void 0;
const coreutils_1 = require("@lumino/coreutils");
function createMessage(options) {
    var _a, _b, _c, _d, _e;
    return {
        buffers: (_a = options.buffers) !== null && _a !== void 0 ? _a : [],
        channel: options.channel,
        content: options.content,
        header: {
            date: new Date().toISOString(),
            msg_id: (_b = options.msgId) !== null && _b !== void 0 ? _b : coreutils_1.UUID.uuid4(),
            msg_type: options.msgType,
            session: options.session,
            username: (_c = options.username) !== null && _c !== void 0 ? _c : '',
            version: '5.2'
        },
        metadata: (_d = options.metadata) !== null && _d !== void 0 ? _d : {},
        parent_header: (_e = options.parentHeader) !== null && _e !== void 0 ? _e : {}
    };
}
exports.createMessage = createMessage;
/**
 * Test whether a kernel message is a `'stream'` message.
 */
function isStreamMsg(msg) {
    return msg.header.msg_type === 'stream';
}
exports.isStreamMsg = isStreamMsg;
/**
 * Test whether a kernel message is an `'display_data'` message.
 */
function isDisplayDataMsg(msg) {
    return msg.header.msg_type === 'display_data';
}
exports.isDisplayDataMsg = isDisplayDataMsg;
/**
 * Test whether a kernel message is an `'update_display_data'` message.
 */
function isUpdateDisplayDataMsg(msg) {
    return msg.header.msg_type === 'update_display_data';
}
exports.isUpdateDisplayDataMsg = isUpdateDisplayDataMsg;
/**
 * Test whether a kernel message is an `'execute_input'` message.
 */
function isExecuteInputMsg(msg) {
    return msg.header.msg_type === 'execute_input';
}
exports.isExecuteInputMsg = isExecuteInputMsg;
/**
 * Test whether a kernel message is an `'execute_result'` message.
 */
function isExecuteResultMsg(msg) {
    return msg.header.msg_type === 'execute_result';
}
exports.isExecuteResultMsg = isExecuteResultMsg;
/**
 * Test whether a kernel message is an `'error'` message.
 */
function isErrorMsg(msg) {
    return msg.header.msg_type === 'error';
}
exports.isErrorMsg = isErrorMsg;
/**
 * Test whether a kernel message is a `'status'` message.
 */
function isStatusMsg(msg) {
    return msg.header.msg_type === 'status';
}
exports.isStatusMsg = isStatusMsg;
/**
 * Test whether a kernel message is a `'clear_output'` message.
 */
function isClearOutputMsg(msg) {
    return msg.header.msg_type === 'clear_output';
}
exports.isClearOutputMsg = isClearOutputMsg;
/**
 * Test whether a kernel message is an experimental `'debug_event'` message.
 *
 * @hidden
 *
 * #### Notes
 * Debug messages are experimental messages that are not in the official
 * kernel message specification. As such, this is *NOT* considered
 * part of the public API, and may change without notice.
 */
function isDebugEventMsg(msg) {
    return msg.header.msg_type === 'debug_event';
}
exports.isDebugEventMsg = isDebugEventMsg;
/**
 * Test whether a kernel message is a `'comm_open'` message.
 */
function isCommOpenMsg(msg) {
    return msg.header.msg_type === 'comm_open';
}
exports.isCommOpenMsg = isCommOpenMsg;
/**
 * Test whether a kernel message is a `'comm_close'` message.
 */
function isCommCloseMsg(msg) {
    return msg.header.msg_type === 'comm_close';
}
exports.isCommCloseMsg = isCommCloseMsg;
/**
 * Test whether a kernel message is a `'comm_msg'` message.
 */
function isCommMsgMsg(msg) {
    return msg.header.msg_type === 'comm_msg';
}
exports.isCommMsgMsg = isCommMsgMsg;
/**
 * Test whether a kernel message is a `'kernel_info_request'` message.
 */
function isInfoRequestMsg(msg) {
    return msg.header.msg_type === 'kernel_info_request';
}
exports.isInfoRequestMsg = isInfoRequestMsg;
/**
 * Test whether a kernel message is an `'execute_reply'` message.
 */
function isExecuteReplyMsg(msg) {
    return msg.header.msg_type === 'execute_reply';
}
exports.isExecuteReplyMsg = isExecuteReplyMsg;
/**
 * Test whether a kernel message is an experimental `'debug_request'` message.
 *
 * @hidden
 *
 * #### Notes
 * Debug messages are experimental messages that are not in the official
 * kernel message specification. As such, this is *NOT* considered
 * part of the public API, and may change without notice.
 */
function isDebugRequestMsg(msg) {
    return msg.header.msg_type === 'debug_request';
}
exports.isDebugRequestMsg = isDebugRequestMsg;
/**
 * Test whether a kernel message is an experimental `'debug_reply'` message.
 *
 * @hidden
 *
 * #### Notes
 * Debug messages are experimental messages that are not in the official
 * kernel message specification. As such, this is *NOT* considered
 * part of the public API, and may change without notice.
 */
function isDebugReplyMsg(msg) {
    return msg.header.msg_type === 'debug_reply';
}
exports.isDebugReplyMsg = isDebugReplyMsg;
/**
 * Test whether a kernel message is an `'input_request'` message.
 */
function isInputRequestMsg(msg) {
    return msg.header.msg_type === 'input_request';
}
exports.isInputRequestMsg = isInputRequestMsg;
/**
 * Test whether a kernel message is an `'input_reply'` message.
 */
function isInputReplyMsg(msg) {
    return msg.header.msg_type === 'input_reply';
}
exports.isInputReplyMsg = isInputReplyMsg;
//# sourceMappingURL=messages.js.map