//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-quartz-core")]
#[cfg(not(target_os = "watchos"))]
use objc2_quartz_core::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uifocuseffect?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIFocusEffect;
);

extern_conformance!(
    unsafe impl NSCopying for UIFocusEffect {}
);

unsafe impl CopyingHelper for UIFocusEffect {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIFocusEffect {}
);

impl UIFocusEffect {
    extern_methods!(
        /// Creates a default system effect using metrics inferred from the focus item.
        #[unsafe(method(effect))]
        #[unsafe(method_family = none)]
        pub unsafe fn effect() -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uifocushaloeffectposition?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIFocusHaloEffectPosition(pub NSInteger);
impl UIFocusHaloEffectPosition {
    /// Automatically detects the best position depending on the the focus item and its containing view hierarchy.
    #[doc(alias = "UIFocusHaloEffectPositionAutomatic")]
    pub const Automatic: Self = Self(0);
    /// Draws the halo around the given shape.
    #[doc(alias = "UIFocusHaloEffectPositionOutside")]
    pub const Outside: Self = Self(1);
    /// Draws the halo inside the given shape.
    #[doc(alias = "UIFocusHaloEffectPositionInside")]
    pub const Inside: Self = Self(2);
}

unsafe impl Encode for UIFocusHaloEffectPosition {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIFocusHaloEffectPosition {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uifocushaloeffect?language=objc)
    #[unsafe(super(UIFocusEffect, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIFocusHaloEffect;
);

extern_conformance!(
    unsafe impl NSCopying for UIFocusHaloEffect {}
);

unsafe impl CopyingHelper for UIFocusHaloEffect {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIFocusHaloEffect {}
);

impl UIFocusHaloEffect {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        /// Creates a rectangular halo.
        #[unsafe(method(effectWithRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn effectWithRect(rect: CGRect) -> Retained<Self>;

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-quartz-core"))]
        #[cfg(not(target_os = "watchos"))]
        /// Creates a rounded rect halo using the specified corner radius and corner curve.
        #[unsafe(method(effectWithRoundedRect:cornerRadius:curve:))]
        #[unsafe(method_family = none)]
        pub unsafe fn effectWithRoundedRect_cornerRadius_curve(
            rect: CGRect,
            corner_radius: CGFloat,
            curve: &CALayerCornerCurve,
        ) -> Retained<Self>;

        #[cfg(feature = "UIBezierPath")]
        /// Creates a halo with the given bezier path.
        #[unsafe(method(effectWithPath:))]
        #[unsafe(method_family = none)]
        pub unsafe fn effectWithPath(bezier_path: &UIBezierPath) -> Retained<Self>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Container view in which to place the effect. When not set, the container is determined automatically
        /// from the focus item that provided this effect and the
        /// `referenceView`(if present).
        #[unsafe(method(containerView))]
        #[unsafe(method_family = none)]
        pub unsafe fn containerView(&self, mtm: MainThreadMarker) -> Option<Retained<UIView>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`containerView`][Self::containerView].
        #[unsafe(method(setContainerView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContainerView(&self, container_view: Option<&UIView>);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// When set, the halo is placed above this view. If a
        /// `containerView`is also set, the
        /// `referenceView`must be a descendant
        /// of the
        /// `containerView.`The system will ensure that the halo is in the container but visually above the
        /// `referenceView.`
        #[unsafe(method(referenceView))]
        #[unsafe(method_family = none)]
        pub unsafe fn referenceView(&self, mtm: MainThreadMarker) -> Option<Retained<UIView>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`referenceView`][Self::referenceView].
        #[unsafe(method(setReferenceView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setReferenceView(&self, reference_view: Option<&UIView>);

        /// Position of the halo relative to the specified shape. Defaults to
        /// `UIFocusHaloEffectPositionAutomatic.`
        #[unsafe(method(position))]
        #[unsafe(method_family = none)]
        pub unsafe fn position(&self) -> UIFocusHaloEffectPosition;

        /// Setter for [`position`][Self::position].
        #[unsafe(method(setPosition:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPosition(&self, position: UIFocusHaloEffectPosition);
    );
}

/// Methods declared on superclass `UIFocusEffect`.
impl UIFocusHaloEffect {
    extern_methods!(
        /// Creates a default system effect using metrics inferred from the focus item.
        #[unsafe(method(effect))]
        #[unsafe(method_family = none)]
        pub unsafe fn effect() -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
