// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::update_shard_count::_update_shard_count_output::UpdateShardCountOutputBuilder;

pub use crate::operation::update_shard_count::_update_shard_count_input::UpdateShardCountInputBuilder;

impl crate::operation::update_shard_count::builders::UpdateShardCountInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::update_shard_count::UpdateShardCountOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_shard_count::UpdateShardCountError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.update_shard_count();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `UpdateShardCount`.
///
/// <p>Updates the shard count of the specified stream to the specified number of shards. This API is only supported for the data streams with the provisioned capacity mode.</p><note>
/// <p>When invoking this API, you must use either the <code>StreamARN</code> or the <code>StreamName</code> parameter, or both. It is recommended that you use the <code>StreamARN</code> input parameter when you invoke this API.</p>
/// </note>
/// <p>Updating the shard count is an asynchronous operation. Upon receiving the request, Kinesis Data Streams returns immediately and sets the status of the stream to <code>UPDATING</code>. After the update is complete, Kinesis Data Streams sets the status of the stream back to <code>ACTIVE</code>. Depending on the size of the stream, the scaling action could take a few minutes to complete. You can continue to read and write data to your stream while its status is <code>UPDATING</code>.</p>
/// <p>To update the shard count, Kinesis Data Streams performs splits or merges on individual shards. This can cause short-lived shards to be created, in addition to the final shards. These short-lived shards count towards your total shard limit for your account in the Region.</p>
/// <p>When using this operation, we recommend that you specify a target shard count that is a multiple of 25% (25%, 50%, 75%, 100%). You can specify any target value within your shard limit. However, if you specify a target that isn't a multiple of 25%, the scaling action might take longer to complete.</p>
/// <p>This operation has the following default limits. By default, you cannot do the following:</p>
/// <ul>
/// <li>
/// <p>Scale more than ten times per rolling 24-hour period per stream</p></li>
/// <li>
/// <p>Scale up to more than double your current shard count for a stream</p></li>
/// <li>
/// <p>Scale down below half your current shard count for a stream</p></li>
/// <li>
/// <p>Scale up to more than 10000 shards in a stream</p></li>
/// <li>
/// <p>Scale a stream with more than 10000 shards down unless the result is less than 10000 shards</p></li>
/// <li>
/// <p>Scale up to more than the shard limit for your account</p></li>
/// <li>
/// <p>Make over 10 TPS. TPS over 10 will trigger the LimitExceededException</p></li>
/// </ul>
/// <p>For the default limits for an Amazon Web Services account, see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>. To request an increase in the call rate limit, the shard limit for this API, or your overall shard limit, use the <a href="https://console.aws.amazon.com/support/v1#/case/create?issueType=service-limit-increase&amp;limitType=service-code-kinesis">limits form</a>.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct UpdateShardCountFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::update_shard_count::builders::UpdateShardCountInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::update_shard_count::UpdateShardCountOutput,
        crate::operation::update_shard_count::UpdateShardCountError,
    > for UpdateShardCountFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::update_shard_count::UpdateShardCountOutput,
            crate::operation::update_shard_count::UpdateShardCountError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl UpdateShardCountFluentBuilder {
    /// Creates a new `UpdateShardCountFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the UpdateShardCount as a reference.
    pub fn as_input(&self) -> &crate::operation::update_shard_count::builders::UpdateShardCountInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::update_shard_count::UpdateShardCountOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_shard_count::UpdateShardCountError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::update_shard_count::UpdateShardCount::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::update_shard_count::UpdateShardCount::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::update_shard_count::UpdateShardCountOutput,
        crate::operation::update_shard_count::UpdateShardCountError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The name of the stream.</p>
    pub fn stream_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.stream_name(input.into());
        self
    }
    /// <p>The name of the stream.</p>
    pub fn set_stream_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_stream_name(input);
        self
    }
    /// <p>The name of the stream.</p>
    pub fn get_stream_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_stream_name()
    }
    /// <p>The new number of shards. This value has the following default limits. By default, you cannot do the following:</p>
    /// <ul>
    /// <li>
    /// <p>Set this value to more than double your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value below half your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value to more than 10000 shards in a stream (the default limit for shard count per stream is 10000 per account per region), unless you request a limit increase.</p></li>
    /// <li>
    /// <p>Scale a stream with more than 10000 shards down unless you set this value to less than 10000 shards.</p></li>
    /// </ul>
    pub fn target_shard_count(mut self, input: i32) -> Self {
        self.inner = self.inner.target_shard_count(input);
        self
    }
    /// <p>The new number of shards. This value has the following default limits. By default, you cannot do the following:</p>
    /// <ul>
    /// <li>
    /// <p>Set this value to more than double your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value below half your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value to more than 10000 shards in a stream (the default limit for shard count per stream is 10000 per account per region), unless you request a limit increase.</p></li>
    /// <li>
    /// <p>Scale a stream with more than 10000 shards down unless you set this value to less than 10000 shards.</p></li>
    /// </ul>
    pub fn set_target_shard_count(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_target_shard_count(input);
        self
    }
    /// <p>The new number of shards. This value has the following default limits. By default, you cannot do the following:</p>
    /// <ul>
    /// <li>
    /// <p>Set this value to more than double your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value below half your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value to more than 10000 shards in a stream (the default limit for shard count per stream is 10000 per account per region), unless you request a limit increase.</p></li>
    /// <li>
    /// <p>Scale a stream with more than 10000 shards down unless you set this value to less than 10000 shards.</p></li>
    /// </ul>
    pub fn get_target_shard_count(&self) -> &::std::option::Option<i32> {
        self.inner.get_target_shard_count()
    }
    /// <p>The scaling type. Uniform scaling creates shards of equal size.</p>
    pub fn scaling_type(mut self, input: crate::types::ScalingType) -> Self {
        self.inner = self.inner.scaling_type(input);
        self
    }
    /// <p>The scaling type. Uniform scaling creates shards of equal size.</p>
    pub fn set_scaling_type(mut self, input: ::std::option::Option<crate::types::ScalingType>) -> Self {
        self.inner = self.inner.set_scaling_type(input);
        self
    }
    /// <p>The scaling type. Uniform scaling creates shards of equal size.</p>
    pub fn get_scaling_type(&self) -> &::std::option::Option<crate::types::ScalingType> {
        self.inner.get_scaling_type()
    }
    /// <p>The ARN of the stream.</p>
    pub fn stream_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.stream_arn(input.into());
        self
    }
    /// <p>The ARN of the stream.</p>
    pub fn set_stream_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_stream_arn(input);
        self
    }
    /// <p>The ARN of the stream.</p>
    pub fn get_stream_arn(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_stream_arn()
    }
}
