<?php

declare(strict_types=1);

/**
 * This code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/codegen/codegen.rb]
 */

namespace Cucumber\Messages;

use JsonSerializable;
use Cucumber\Messages\DecodingException\SchemaViolationException;

/**
 * Represents the TestCaseFinished message in Cucumber's message protocol
 * @see https://github.com/cucumber/messages
 *
 */
final class TestCaseFinished implements JsonSerializable
{
    use JsonEncodingTrait;

    /**
     * Construct the TestCaseFinished with all properties
     *
     */
    public function __construct(
        public readonly string $testCaseStartedId = '',
        public readonly Timestamp $timestamp = new Timestamp(),
        public readonly bool $willBeRetried = false,
    ) {
    }

    /**
     * @throws SchemaViolationException
     *
     * @internal
     */
    public static function fromArray(array $arr): self
    {
        self::ensureTestCaseStartedId($arr);
        self::ensureTimestamp($arr);
        self::ensureWillBeRetried($arr);

        return new self(
            (string) $arr['testCaseStartedId'],
            Timestamp::fromArray($arr['timestamp']),
            (bool) $arr['willBeRetried'],
        );
    }

    /**
     * @psalm-assert array{testCaseStartedId: string|int|bool} $arr
     */
    private static function ensureTestCaseStartedId(array $arr): void
    {
        if (!array_key_exists('testCaseStartedId', $arr)) {
            throw new SchemaViolationException('Property \'testCaseStartedId\' is required but was not found');
        }
        if (array_key_exists('testCaseStartedId', $arr) && is_array($arr['testCaseStartedId'])) {
            throw new SchemaViolationException('Property \'testCaseStartedId\' was array');
        }
    }

    /**
     * @psalm-assert array{timestamp: array} $arr
     */
    private static function ensureTimestamp(array $arr): void
    {
        if (!array_key_exists('timestamp', $arr)) {
            throw new SchemaViolationException('Property \'timestamp\' is required but was not found');
        }
        if (array_key_exists('timestamp', $arr) && !is_array($arr['timestamp'])) {
            throw new SchemaViolationException('Property \'timestamp\' was not array');
        }
    }

    /**
     * @psalm-assert array{willBeRetried: string|int|bool} $arr
     */
    private static function ensureWillBeRetried(array $arr): void
    {
        if (!array_key_exists('willBeRetried', $arr)) {
            throw new SchemaViolationException('Property \'willBeRetried\' is required but was not found');
        }
        if (array_key_exists('willBeRetried', $arr) && is_array($arr['willBeRetried'])) {
            throw new SchemaViolationException('Property \'willBeRetried\' was array');
        }
    }
}
