/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ps extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "نایرو";
        final String metaValue_TR = "ترکي";
        final String metaValue_ar = "عربي";
        final String metaValue_ccp = "چکما";
        final String metaValue_el = "یوناني";
        final String metaValue_gu = "ګجراتي";
        final String metaValue_he = "عبراني";
        final String metaValue_ja = "جاپاني";
        final String metaValue_km = "خمر";
        final String metaValue_kn = "کناډا";
        final String metaValue_ko = "کوریایی";
        final String metaValue_ta = "تامل";
        final String metaValue_bo = "تبتي";
        final String metaValue_vai = "وای";
        final Object[][] data = new Object[][] {
            { "001", "نړۍ" },
            { "002", "افريقا" },
            { "003", "شمالی امریکا" },
            { "005", "سويلي امريکا" },
            { "009", "اوقيانوسيه" },
            { "011", "لویدیځ افریقا" },
            { "013", "منخنۍ امريکا" },
            { "014", "ختیځ افریقا" },
            { "015", "شمالي افریقا" },
            { "017", "منځنۍ افریقا" },
            { "018", "سويلي افريقا" },
            { "019", "امريکې" },
            { "021", "شمالي امریکا" },
            { "029", "کیریبین" },
            { "030", "ختیځ آسیا" },
            { "034", "سويلي آسيا" },
            { "035", "سويلي ختيځ آسيا" },
            { "039", "سويلي اروپا" },
            { "053", "آسترالیا" },
            { "054", "ملانشیا" },
            { "057", "د مایکرونیسینین سیمه" },
            { "061", "پولنيسيا" },
            { "142", "آسيا" },
            { "143", "منځنۍ آسيا" },
            { "145", "لویدیځ آسیا" },
            { "150", "اروپا" },
            { "151", "ختيځ اروپا" },
            { "154", "شمالي اروپا" },
            { "155", "لوېديځ اروپا" },
            { "202", "سب سهارن افريقا" },
            { "419", "لاتیني امریکا" },
            { "AC", "اسينشان ټاپو" },
            { "AD", "اندورا" },
            { "AE", "متحده عرب امارات" },
            { "AF", "افغانستان" },
            { "AG", "انټيګوا او باربودا" },
            { "AI", "انګیلا" },
            { "AL", "البانیه" },
            { "AM", "ارمنستان" },
            { "AO", "انګولا" },
            { "AQ", "انتارکتیکا" },
            { "AR", "ارجنټاين" },
            { "AS", "امریکایی ساماوا" },
            { "AT", "اتریش" },
            { "AU", "آسټرالیا" },
            { "AW", "آروبا" },
            { "AX", "الاند ټاپوان" },
            { "AZ", "اذربايجان" },
            { "BA", "بوسنيا او هېرزګوينا" },
            { "BB", "باربادوس" },
            { "BD", "بنگله دېش" },
            { "BE", "بیلجیم" },
            { "BF", "بورکینا فاسو" },
            { "BG", "بلغاریه" },
            { "BH", "بحرين" },
            { "BI", "بروندي" },
            { "BJ", "بینن" },
            { "BL", "سينټ بارتيلمي" },
            { "BM", "برمودا" },
            { "BN", "برونائي" },
            { "BO", "بولیویا" },
            { "BQ", "کیریبین هالینډ" },
            { "BR", "برازیل" },
            { "BS", "باهماس" },
            { "BT", "بهوټان" },
            { "BV", "بوویټ ټاپو" },
            { "BW", "بوتسوانه" },
            { "BY", "بیلاروس" },
            { "BZ", "بلیز" },
            { "CA", "کاناډا" },
            { "CC", "کوکوز (کيلنګ) ټاپوګان" },
            { "CD", "کانګو - کینشاسا" },
            { "CF", "وسطي افريقا جمهور" },
            { "CG", "کانګو - بروزوییل" },
            { "CH", "سویس" },
            { "CI", "د عاج ساحل" },
            { "CK", "کوک ټاپوګان" },
            { "CL", "چیلي" },
            { "CM", "کامرون" },
            { "CN", "چین" },
            { "CO", "کولمبیا" },
            { "CP", "د کلپرټون ټاپو" },
            { "CR", "کوستاریکا" },
            { "CU", "کیوبا" },
            { "CV", "کیپ ورد" },
            { "CW", "کوراکاو" },
            { "CX", "د کريسمس ټاپو" },
            { "CY", "قبرس" },
            { "CZ", "چکیا" },
            { "DE", "المان" },
            { "DG", "ډایګو ګارسیا" },
            { "DJ", "جبوتي" },
            { "DK", "ډنمارک" },
            { "DM", "دومینیکا" },
            { "DO", "جمهوريه ډومينيکن" },
            { "DZ", "الجزایر" },
            { "EA", "سيوتا او ماليلا" },
            { "EC", "اکوادور" },
            { "EE", "استونیا" },
            { "EG", "مصر" },
            { "EH", "لويديځ صحارا" },
            { "ER", "اریتره" },
            { "ES", "هسپانیه" },
            { "ET", "حبشه" },
            { "EU", "اروپايي اتحاديه" },
            { "EZ", "اروپايي سيمه" },
            { "FI", "فنلینډ" },
            { "FJ", "فجي" },
            { "FK", "فاکلينډ ټاپوګان" },
            { "FM", "میکرونیزیا" },
            { "FO", "فارو ټاپو" },
            { "FR", "فرانسه" },
            { "GA", "ګابن" },
            { "GB", "برتانیه" },
            { "GD", "ګرنادا" },
            { "GE", "گورجستان" },
            { "GF", "فرانسوي ګانا" },
            { "GG", "ګرنسي" },
            { "GH", "ګانا" },
            { "GI", "جبل الطارق" },
            { "GL", "ګرینلینډ" },
            { "GM", "ګامبیا" },
            { "GN", "ګینه" },
            { "GP", "ګوادلوپ" },
            { "GQ", "استوایی ګیني" },
            { "GR", "یونان" },
            { "GS", "سويلي جارجيا او سويلي سېنډوچ ټاپوګان" },
            { "GT", "ګواتیمالا" },
            { "GU", "ګوام" },
            { "GW", "ګینه بیسو" },
            { "GY", "ګیانا" },
            { "HK", "هانګ کانګ SAR چین" },
            { "HM", "هارډ او ميکډانلډ ټاپوګان" },
            { "HN", "هانډوراس" },
            { "HR", "کرواشيا" },
            { "HT", "هایټي" },
            { "HU", "مجارستان" },
            { "IC", "د کناري ټاپوګان" },
            { "ID", "اندونیزیا" },
            { "IE", "آيرلېنډ" },
            { "IL", "اسراييل" },
            { "IM", "د آئل آف مین" },
            { "IN", "هند" },
            { "IO", "د برتانوي هند سمندري سيمه" },
            { "IQ", "عراق" },
            { "IR", "ايران" },
            { "IS", "آیسلینډ" },
            { "IT", "ایټالیه" },
            { "JE", "جرسی" },
            { "JM", "جمیکا" },
            { "JO", "اردن" },
            { "JP", "جاپان" },
            { "KE", "کینیا" },
            { "KG", "قرغزستان" },
            { "KH", "کمبودیا" },
            { "KI", "کیري باتي" },
            { "KM", "کوموروس" },
            { "KN", "سینټ کټس او نیویس" },
            { "KP", "شمالی کوریا" },
            { "KR", "سویلي کوریا" },
            { "KW", "کويت" },
            { "KY", "کیمان ټاپوګان" },
            { "KZ", "قزاقستان" },
            { "LA", "لاوس" },
            { "LB", "لبنان" },
            { "LC", "سینټ لوسیا" },
            { "LI", "لیختن اشتاین" },
            { "LK", "سريلنکا" },
            { "LR", "لايبيريا" },
            { "LS", "لسوتو" },
            { "LT", "لیتوانیا" },
            { "LU", "لوګزامبورګ" },
            { "LV", "ليتهويا" },
            { "LY", "لیبیا" },
            { "MA", "مراکش" },
            { "MC", "موناکو" },
            { "MD", "مولدوا" },
            { "ME", "مونټینیګرو" },
            { "MF", "سینټ مارټن" },
            { "MG", "مدغاسکر" },
            { "MH", "مارشل ټاپوګان" },
            { "MK", "شمالي مقدونيه" },
            { "ML", "مالي" },
            { "MM", "ميانمار (برما)" },
            { "MN", "منګوليا" },
            { "MO", "مکاو SAR چین" },
            { "MP", "شمالي ماريانا ټاپوګان" },
            { "MQ", "مارټینیک" },
            { "MR", "موریتانیا" },
            { "MS", "مانټیسیرت" },
            { "MT", "مالټا" },
            { "MU", "موریشیس" },
            { "MV", "مالديپ" },
            { "MW", "مالاوي" },
            { "MX", "میکسیکو" },
            { "MY", "مالیزیا" },
            { "MZ", "موزمبيق" },
            { "NA", "نیمبیا" },
            { "NC", "نوی کالیډونیا" },
            { "NE", "نايجير" },
            { "NF", "نارفولک ټاپوګان" },
            { "NG", "نایجیریا" },
            { "NI", "نکاراګوا" },
            { "NL", "هالېنډ" },
            { "NO", "ناروۍ" },
            { "NP", "نیپال" },
            { "NR", metaValue_NR },
            { "NU", "نیوو" },
            { "NZ", "نیوزیلنډ" },
            { "OM", "عمان" },
            { "PA", "پاناما" },
            { "PE", "پیرو" },
            { "PF", "فرانسوي پولينيسيا" },
            { "PG", "پاپوا نيو ګيني" },
            { "PH", "فلپين" },
            { "PK", "پاکستان" },
            { "PL", "پولنډ" },
            { "PM", "سینټ پییر او میکولون" },
            { "PN", "پيټکيرن ټاپوګان" },
            { "PR", "پورتو ریکو" },
            { "PS", "فلسطیني سيمې" },
            { "PT", "پورتګال" },
            { "PW", "پلاؤ" },
            { "PY", "پاراګوی" },
            { "QA", "قطر" },
            { "QO", "بهرنۍ اوسيانه" },
            { "RE", "ریونین" },
            { "RO", "رومانیا" },
            { "RS", "سربيا" },
            { "RU", "روسیه" },
            { "RW", "روندا" },
            { "SA", "سعودي عربستان" },
            { "SB", "سليمان ټاپوګان" },
            { "SC", "سیچیلیس" },
            { "SD", "سوډان" },
            { "SE", "سویډن" },
            { "SG", "سينگاپور" },
            { "SH", "سینټ هیلینا" },
            { "SI", "سلوانیا" },
            { "SJ", "سوالبارد او جان ميين" },
            { "SK", "سلواکیا" },
            { "SL", "سییرا لیون" },
            { "SM", "سان مارینو" },
            { "SN", "سينيګال" },
            { "SO", "سومالیا" },
            { "SR", "سورینام" },
            { "SS", "سويلي سوډان" },
            { "ST", "ساو ټیم او پرنسیپ" },
            { "SV", "سالوېډور" },
            { "SX", "سینټ مارټین" },
            { "SY", "سوریه" },
            { "SZ", "اسواټيني" },
            { "TA", "تریستان دا کنها" },
            { "TC", "د ترکیې او کیکاسو ټاپو" },
            { "TD", "چاډ" },
            { "TF", "د فرانسې جنوبي سیمې" },
            { "TG", "ټوګو" },
            { "TH", "تهايلنډ" },
            { "TJ", "تاجکستان" },
            { "TK", "توکیلو" },
            { "TL", "تيمور-ليسټ" },
            { "TM", "تورکمنستان" },
            { "TN", "تونس" },
            { "TO", "تونګا" },
            { "TR", metaValue_TR },
            { "TT", "ټرينيډاډ او ټوباګو" },
            { "TV", "توالیو" },
            { "TW", "تائيوان" },
            { "TZ", "تنزانیا" },
            { "UA", "اوکراین" },
            { "UG", "یوګانډا" },
            { "UM", "د متحده ایالاتو ټاپوګان" },
            { "UN", "ملگري ملتونه" },
            { "US", "متحده آيالات" },
            { "UY", "یوروګوی" },
            { "UZ", "اوزبکستان" },
            { "VA", "واتیکان ښار" },
            { "VC", "سینټ ویسنټینټ او ګرینډینز" },
            { "VE", "وینزویلا" },
            { "VG", "بریتانوی ویګور ټاپوګان" },
            { "VI", "د متحده آيالاتو ورجن ټاپوګان" },
            { "VN", "وېتنام" },
            { "VU", "واناتو" },
            { "WF", "والیس او فوتونا" },
            { "WS", "ساماوا" },
            { "XA", "جعلي خج" },
            { "XB", "سیډو بیډی" },
            { "XK", "کوسوو" },
            { "YE", "یمن" },
            { "YT", "مايوټ" },
            { "ZA", "سویلي افریقا" },
            { "ZM", "زیمبیا" },
            { "ZW", "زیمبابوی" },
            { "ZZ", "نامعلومه سيمه" },
            { "aa", "افري" },
            { "ab", "ابخازي" },
            { "af", "افریکانسي" },
            { "ak", "اکاني" },
            { "am", "امهاري" },
            { "an", "اراگونېسي" },
            { "ar", metaValue_ar },
            { "as", "اسامي" },
            { "av", "اواري" },
            { "ay", "ایماري" },
            { "az", "اذربایجاني" },
            { "ba", "باشکير" },
            { "be", "بېلاروسي" },
            { "bg", "بلغاري" },
            { "bi", "بسلاما" },
            { "bm", "بمبارا" },
            { "bn", "بنگالي" },
            { "bo", metaValue_bo },
            { "br", "برېتون" },
            { "bs", "بوسني" },
            { "ca", "کټلاني" },
            { "ce", "چيچني" },
            { "ch", "چمورو" },
            { "co", "کورسيکاني" },
            { "cs", "چېکي" },
            { "cu", "د کليسا سلاوي" },
            { "cv", "چوواشي" },
            { "cy", "ويلشي" },
            { "da", "ډنمارکي" },
            { "de", "الماني" },
            { "dv", "ديویهی" },
            { "dz", "ژونگکه" },
            { "ee", "ايو" },
            { "el", metaValue_el },
            { "en", "انګليسي" },
            { "eo", "اسپرانتو" },
            { "es", "هسپانوي" },
            { "et", "حبشي" },
            { "eu", "باسکي" },
            { "fa", "فارسي" },
            { "ff", "فولاح" },
            { "fi", "فینلنډي" },
            { "fj", "فجیان" },
            { "fo", "فاروئې" },
            { "fr", "فرانسوي" },
            { "fy", "لوېديځ فريشي" },
            { "ga", "ائيرلېنډي" },
            { "gd", "سکاټلېنډي ګېلک" },
            { "gl", "ګلېشيايي" },
            { "gn", "ګوراني" },
            { "gu", metaValue_gu },
            { "gv", "مینکس" },
            { "ha", "هوسا" },
            { "he", metaValue_he },
            { "hi", "هندي" },
            { "hr", "کروايشيايي" },
            { "ht", "هيټي کريول" },
            { "hu", "هنګري" },
            { "hy", "آرمينيايي" },
            { "hz", "هیرورو" },
            { "ia", "انټرلنګوا" },
            { "id", "انډونېزي" },
            { "ie", "آسا نا جبة" },
            { "ig", "اګبو" },
            { "ii", "سیچیان یی" },
            { "io", "اڊو" },
            { "is", "ايسلنډي" },
            { "it", "ایټالوي" },
            { "iu", "انوکتیتوت" },
            { "ja", metaValue_ja },
            { "jv", "جاوايي" },
            { "ka", "جورجيائي" },
            { "ki", "ککوؤو" },
            { "kj", "کواناما" },
            { "kk", "قازق" },
            { "kl", "کالالیست" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "کنوری" },
            { "ks", "کشمیري" },
            { "ku", "کردي" },
            { "kv", "کومی" },
            { "kw", "کورنيشي" },
            { "ky", "کرغيزي" },
            { "la", "لاتیني" },
            { "lb", "لوګزامبورګي" },
            { "lg", "ګانده" },
            { "li", "لمبرگیانی" },
            { "ln", "لنګالا" },
            { "lo", "لاو" },
            { "lt", "ليتواني" },
            { "lu", "لوبا-کټنګا" },
            { "lv", "لېټواني" },
            { "mg", "ملغاسي" },
            { "mh", "مارشلیز" },
            { "mi", "ماوري" },
            { "mk", "مقدوني" },
            { "ml", "مالايالم" },
            { "mn", "منګولیایی" },
            { "mr", "مراټهي" },
            { "ms", "ملایا" },
            { "mt", "مالټايي" },
            { "my", "برمایی" },
            { "na", metaValue_NR },
            { "nb", "ناروېئي (بوکمال)" },
            { "nd", "شمالي نديبل" },
            { "ne", "نېپالي" },
            { "ng", "ندونگا" },
            { "nl", "هالېنډي" },
            { "nn", "ناروېئي (نائنورسک)" },
            { "no", "ناروېئي" },
            { "nr", "سويلي نديبيل" },
            { "nv", "نواجو" },
            { "ny", "نیانجا" },
            { "oc", "اوکسيټاني" },
            { "om", "اورومو" },
            { "or", "اوڊيا" },
            { "os", "اوسيټک" },
            { "pa", "پنجابي" },
            { "pl", "پولنډي" },
            { "ps", "پښتو" },
            { "pt", "پورتګالي" },
            { "qu", "کېچوا" },
            { "rm", "رومانیش" },
            { "rn", "رونډی" },
            { "ro", "رومانیایی" },
            { "ru", "روسي" },
            { "rw", "کینیارونډا" },
            { "sa", "سنسکریټ" },
            { "sc", "سارڊيني" },
            { "sd", "سندهي" },
            { "se", "شمالي سامي" },
            { "sg", "سانګو" },
            { "si", "سينهالي" },
            { "sk", "سلوواکي" },
            { "sl", "سلوواني" },
            { "sm", "ساموآن" },
            { "sn", "شونا" },
            { "so", "سومالي" },
            { "sq", "الباني" },
            { "sr", "سربيائي" },
            { "ss", "سواتی" },
            { "st", "سويلي سوتو" },
            { "su", "سوډاني" },
            { "sv", "سویډنی" },
            { "sw", "سواهېلي" },
            { "ta", metaValue_ta },
            { "te", "تېليګو" },
            { "tg", "تاجکي" },
            { "th", "تايلېنډي" },
            { "ti", "تيګريني" },
            { "tk", "ترکمني" },
            { "tn", "سووانا" },
            { "to", "تونګان" },
            { "tr", metaValue_TR },
            { "ts", "سونګا" },
            { "tt", "تاتار" },
            { "ty", "تاهیتي" },
            { "ug", "اويغوري" },
            { "uk", "اوکرايني" },
            { "ur", "اردو" },
            { "uz", "اوزبکي" },
            { "ve", "ویندا" },
            { "vi", "وېتنامي" },
            { "vo", "والاپوک" },
            { "wa", "والون" },
            { "wo", "ولوف" },
            { "xh", "خوسا" },
            { "yi", "يديش" },
            { "yo", "یوروبا" },
            { "za", "ژوانګ" },
            { "zh", "چیني" },
            { "zu", "زولو" },
            { "ace", "اچيني" },
            { "ada", "ادانگمي" },
            { "ady", "اديغي" },
            { "agq", "اغیمي" },
            { "ain", "اينويي" },
            { "ale", "اليوتي" },
            { "alt", "سویل الټای" },
            { "ann", "Obo" },
            { "anp", "انگيکي" },
            { "arn", "ماپوچه" },
            { "arp", "اراپاهوي" },
            { "ars", "نجدی عربی" },
            { "asa", "اسويي" },
            { "ast", "استورياني" },
            { "atj", "اتیکامیکو" },
            { "awa", "اوادي" },
            { "bal", "بلوڅي" },
            { "ban", "بالنی" },
            { "bas", "باسا" },
            { "bem", "بيمبا" },
            { "bez", "بينا" },
            { "bgc", "هریانوی" },
            { "bho", "بهوجپوري" },
            { "bin", "بینی" },
            { "bla", "سکسيکا" },
            { "blo", "انۍ" },
            { "brx", "بودو" },
            { "bug", "بگنيايي" },
            { "byn", "بلین" },
            { "cay", "Ca" },
            { "ccp", metaValue_ccp },
            { "ceb", "سیبوانوي" },
            { "cgg", "چيگايي" },
            { "chk", "چواوکي" },
            { "chm", "ماري" },
            { "cho", "چوکټاوي" },
            { "chp", "Ch" },
            { "chr", "چېروکي" },
            { "chy", "شيني" },
            { "ckb", "منځنۍ کوردي" },
            { "clc", "چیلکوټین" },
            { "crg", "mc" },
            { "crj", "سویل ختیځ کری" },
            { "crk", "پلینز کری" },
            { "crl", "شمالي ختیځ کری" },
            { "crm", "mcr" },
            { "crr", "Car Alg" },
            { "crs", "سسيلوا ڪروئل فرانسوي" },
            { "csw", "سومپی کری" },
            { "dak", "داکوتا" },
            { "dar", "درگوا" },
            { "dav", "ټایټا" },
            { "dgr", "داگرب" },
            { "dje", "زرما" },
            { "doi", "ډوګري" },
            { "dsb", "کښته سربيايي" },
            { "dua", "دوالا" },
            { "dyo", "جولا فوني" },
            { "dzg", "ډزاګا" },
            { "ebu", "ايمبو" },
            { "efi", "افک" },
            { "eka", "اکجک" },
            { "ewo", "اوونڊو" },
            { "fil", "فلیپیني" },
            { "fon", "فان" },
            { "frc", "کاجون فرانسوی" },
            { "frr", "شمالي فریسیان" },
            { "fur", "فرائیلیین" },
            { "gaa", "Ga" },
            { "gez", "ګیز" },
            { "gil", "گلبرتي" },
            { "gor", "ګورن ټالو" },
            { "gsw", "سویس جرمن" },
            { "guz", "ګوسي" },
            { "gwi", "ګیچین" },
            { "hai", "ha" },
            { "haw", "هوایی" },
            { "hax", "جنوبي هایدا" },
            { "hil", "ھلیګینون" },
            { "hmn", "همونګ" },
            { "hsb", "پورته سربيايي" },
            { "hup", "ھوپا" },
            { "hur", "هلکومیلم" },
            { "iba", "ابن" },
            { "ibb", "ابیبیو" },
            { "ikt", "مغربی کینیډین انوکټیټ" },
            { "ilo", "الوکو" },
            { "inh", "انگش" },
            { "jbo", "لوجبان" },
            { "jgo", "نګومبا" },
            { "jmc", "ماچمی" },
            { "kab", "کیبیل" },
            { "kac", "کاچین" },
            { "kaj", "ججو" },
            { "kam", "کامبا" },
            { "kbd", "کابیرین" },
            { "kcg", "تایپ" },
            { "kde", "ميکونډي" },
            { "kea", "کابوورډیانو" },
            { "kfo", "کورو" },
            { "kgp", "کینګا" },
            { "kha", "خاسې" },
            { "khq", "کویرا چینی" },
            { "kkj", "کاکو" },
            { "kln", "کلینجن" },
            { "kmb", "کیمبوندو" },
            { "kok", "کونکاني" },
            { "kpe", "کیلي" },
            { "krc", "کراچی بالکر" },
            { "krl", "کاریلین" },
            { "kru", "کورخ" },
            { "ksb", "شمبالا" },
            { "ksf", "بفیا" },
            { "ksh", "کولوګنيايي" },
            { "kum", "کومک" },
            { "kwk", "Vote kwk" },
            { "kxv", "کووئ" },
            { "lad", "لاډینو" },
            { "lag", "لنګی" },
            { "lez", "لیګغیان" },
            { "lij", "لینګورین" },
            { "lil", "lill" },
            { "lkt", "لکوټا" },
            { "lmo", "لومبارډ" },
            { "lou", "Louis" },
            { "loz", "لوزی" },
            { "lrc", "شمالي لوری" },
            { "lsm", "سامیه" },
            { "lua", "لبا لولوا" },
            { "lun", "لندا" },
            { "luo", "لو" },
            { "lus", "ميزو" },
            { "luy", "لویا" },
            { "mad", "مدراسی" },
            { "mag", "مګهي" },
            { "mai", "مایتھلي" },
            { "mak", "مکاسار" },
            { "mas", "ماسائي" },
            { "mdf", "موکشا" },
            { "men", "مینڊي" },
            { "mer", "ميرو" },
            { "mfe", "ماریسیسن" },
            { "mgh", "مکھوامیتو" },
            { "mgo", "ميټا" },
            { "mic", "ممکق" },
            { "min", "مينيگاباو" },
            { "mni", "مانی پوری" },
            { "moe", "mo" },
            { "moh", "محاواک" },
            { "mos", "ماسي" },
            { "mua", "مندانګ" },
            { "mul", "متعدد ژبې" },
            { "mus", "کريکي" },
            { "mwl", "مرانديز" },
            { "myv", "ارزيا" },
            { "mzn", "مزاندراني" },
            { "nap", "نيپالين" },
            { "naq", "ناما" },
            { "nds", "کښته آلماني" },
            { "new", "نيواري" },
            { "nia", "نياس" },
            { "niu", "نیان" },
            { "nmg", "کواسیو" },
            { "nnh", "نایجیمون" },
            { "nog", "نوګی" },
            { "nqo", "نکو" },
            { "nso", "شمالي سوتو" },
            { "nus", "نویر" },
            { "nyn", "نینکول" },
            { "ojb", "شمال لویدیځ اوجیبوا" },
            { "ojc", "مرکزي اوجیبوا" },
            { "ojs", "اوجي-کري" },
            { "ojw", "لویدیځ اوجیبوا" },
            { "oka", "اوکاګان" },
            { "pag", "پانګاسین" },
            { "pam", "پمپانگا" },
            { "pap", "پاپيامينتو" },
            { "pau", "پالان" },
            { "pcm", "نائجیریا پیدجن" },
            { "pis", "پیجین" },
            { "pqm", "mpq" },
            { "prg", "پروشين" },
            { "quc", "کچی" },
            { "raj", "راجستھانی" },
            { "rap", "رپانوئي" },
            { "rar", "راروټانګان" },
            { "rhg", "روهینګیا" },
            { "rof", "رومبو" },
            { "rup", "اروماني" },
            { "rwk", "روا" },
            { "sad", "سنډاوی" },
            { "sah", "سخا" },
            { "saq", "سمبورو" },
            { "sat", "سنتالي" },
            { "sba", "نګبای" },
            { "sbp", "سانګوو" },
            { "scn", "سیلیسي" },
            { "sco", "سکاټس" },
            { "seh", "سینا" },
            { "ses", "کوییرابورو سینی" },
            { "shi", "تاکلهیټ" },
            { "shn", "شان" },
            { "slh", "سویلي لوشوټسید" },
            { "sma", "سویلي سامی" },
            { "smj", "لول سامي" },
            { "smn", "اناري سميع" },
            { "sms", "سکولټ سمیع" },
            { "snk", "سونینګ" },
            { "srn", "سوران ټونګو" },
            { "ssy", "سهو" },
            { "str", "سټریټ سیلش" },
            { "suk", "سکوما" },
            { "swb", "کومورياني" },
            { "syr", "سوریاني" },
            { "szl", "سیلیسیان" },
            { "tce", "جنوبي توچون" },
            { "tem", "تیمني" },
            { "teo", "تیسو" },
            { "tet", "تتوم" },
            { "tgx", "ټګش" },
            { "tht", "طهلتان" },
            { "tig", "تیګر" },
            { "tlh", "کلينګاني" },
            { "tli", "ټلینګیت" },
            { "tok", "توکی پونا" },
            { "tpi", "توک پیسین" },
            { "trv", "تاروکو" },
            { "ttm", "شمالي ټچون" },
            { "tum", "تامبوکا" },
            { "tvl", "تووالو" },
            { "twq", "تساواق" },
            { "tyv", "توینیان" },
            { "tzm", "مرکزی اطلس تمازائيٹ" },
            { "udm", "ادمورت" },
            { "umb", "امبوندو" },
            { "und", "نامعلومه ژبه" },
            { "vai", metaValue_vai },
            { "vec", "وینټیان" },
            { "vmw", "مکوه" },
            { "vun", "وونجو" },
            { "wae", "ولسیر" },
            { "wal", "ولایټا" },
            { "war", "وارۍ" },
            { "wuu", "وو چینایی" },
            { "xal", "کالمک" },
            { "xnr", "کانګرو" },
            { "xog", "سوګا" },
            { "yav", "ینګبین" },
            { "ybb", "یمبا" },
            { "yrl", "نینګاتو" },
            { "yue", "کانټوني" },
            { "zgh", "معياري مراکشي تمازيټ" },
            { "zun", "زوني" },
            { "zxx", "نه ژبني منځپانګه" },
            { "zza", "زازا" },
            { "Adlm", "اډلام" },
            { "Arab", metaValue_ar },
            { "Aran", "نستعلیق" },
            { "Armn", "ارمانیایي" },
            { "Beng", "بنګله" },
            { "Bopo", "بوپوموفو" },
            { "Brai", "بریلي" },
            { "Cakm", metaValue_ccp },
            { "Cans", "متحد کاناډایی ابوریجینل سلیبکس" },
            { "Cher", "چیروکي" },
            { "Cyrl", "سیریلیک" },
            { "Deva", "دیواناګري" },
            { "Ethi", "ایتوپي" },
            { "Geor", "ګرجستاني" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "ګرومي" },
            { "Hanb", "هن او بوپوفومو" },
            { "Hang", "هنګولي" },
            { "Hani", "هن" },
            { "Hans", "ساده شوی" },
            { "Hant", "دودیزه" },
            { "Hebr", metaValue_he },
            { "Hira", "هیراګانا" },
            { "Hrkt", "د جاپاني سیلابري" },
            { "Jamo", "جامو" },
            { "Jpan", metaValue_ja },
            { "Kana", "کاتاکانا" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", "لاوو" },
            { "Latn", "لاتين/لاتيني" },
            { "Mlym", "مالایالم" },
            { "Mong", "منګولیایي" },
            { "Mtei", "میټي مایک" },
            { "Mymr", "میانمار" },
            { "Nkoo", "ناکو" },
            { "Olck", "اول چکی۔" },
            { "Orya", "اوديا" },
            { "Rohg", "حنفی" },
            { "Sinh", "سنهالا" },
            { "Sund", "سنڈانی" },
            { "Syrc", "سریانی" },
            { "Taml", metaValue_ta },
            { "Telu", "تیلیګو" },
            { "Tfng", "ٹیفناګ" },
            { "Thaa", "تهانا" },
            { "Thai", "تایلنډي" },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "یی" },
            { "Zmth", "د ریاضیاتو نوټیشن" },
            { "Zsye", "ایموجي" },
            { "Zsym", "سمبولونه" },
            { "Zxxx", "ناليکلی" },
            { "Zyyy", "عام" },
            { "Zzzz", "نامعلومه سکرېپټ" },
            { "de_AT", "اتريشي آلماني" },
            { "de_CH", "سویس های جرمن" },
            { "en_AU", "آسټرالياوي انګليسي" },
            { "en_CA", "کاناډايي انګلیسي" },
            { "en_GB", "بريتانوی انګلیسي" },
            { "es_ES", "اروپايي هسپانوي" },
            { "es_MX", "ميکسيکي هسپانوي" },
            { "fa_AF", "دری (افغانستان)" },
            { "fr_CA", "کاناډايي فرانسوي" },
            { "fr_CH", "سويسي فرانسوي" },
            { "nl_BE", "فلېمېشي" },
            { "pt_BR", "برازیلي پرتګالي" },
            { "pt_PT", "اروپايي پرتګالي" },
            { "ro_MD", "مولداویایی" },
            { "sw_CD", "کانګو سواهلی" },
            { "ar_001", "نوې معياري عربي" },
            { "es_419", "لاتيني امريکايي هسپانوي" },
            { "key.ca", "جنتري" },
            { "key.cf", "اسعارو بڼه" },
            { "key.co", "ترتيب" },
            { "key.cu", "اسعارو" },
            { "key.hc", "د ساعت چکر (۱۲ پرتله ۲۴)" },
            { "key.lb", "د ماتې کرښې ډول" },
            { "key.ms", "د ناپ نظام" },
            { "key.nu", "شمېرې" },
            { "hi_Latn", "هندي (لاتيني)" },
            { "zh_Hant", "دوديزه چيني" },
            { "type.ca.roc", "منگوو جنتري" },
            { "type.hc.h11", "د ۱۲ ساعتو نظام (۰ـ۱۱)" },
            { "type.hc.h12", "د ۱۲ ساعتو نظام (۱ ـ ۱۲)" },
            { "type.hc.h23", "د ۲۴ ساعتو نظام (۰ـ۲۳)" },
            { "type.hc.h24", "د ساعتو نظام (۱ـ۲۴)" },
            { "type.nu.arab", "عربي - انډیک عددونه" },
            { "type.nu.armn", "آرمينيايي اعداد" },
            { "type.nu.beng", "د بنګلا اعداد" },
            { "type.nu.cakm", "د چکما عددونه" },
            { "type.nu.deva", "ديوانګري اعداد" },
            { "type.nu.ethi", "ايتهوپيايي اعداد" },
            { "type.nu.geor", "ګريګورين اعداد" },
            { "type.nu.grek", "يوناني اعداد" },
            { "type.nu.gujr", "ګوجراتي اعداد" },
            { "type.nu.guru", "ګرمخې اعداد" },
            { "type.nu.hans", "ساده چيني اعداد" },
            { "type.nu.hant", "دوديز چيني اعداد" },
            { "type.nu.hebr", "عبراني اعداد" },
            { "type.nu.java", "جاوانی ډیجیټل" },
            { "type.nu.jpan", "جاپاني اعداد" },
            { "type.nu.khmr", "خمري اعداد" },
            { "type.nu.knda", "کاناډا يي اعداد" },
            { "type.nu.laoo", "لاوي اعداد" },
            { "type.nu.latn", "لويديځ عددونه" },
            { "type.nu.mlym", "ملاي لام اعداد" },
            { "type.nu.mtei", "میټې مایک اعداد" },
            { "type.nu.mymr", "د ميانمار اعداد" },
            { "type.nu.olck", "ال چکي اعداد" },
            { "type.nu.orya", "د اوډيا اعداد" },
            { "type.nu.taml", "دوديز تامل اعداد" },
            { "type.nu.telu", "تيلوګو اعداد" },
            { "type.nu.thai", "تايي اعداد" },
            { "type.nu.tibt", "تبتي اعداد" },
            { "type.nu.vaii", "وای اعداد" },
            { "type.ca.dangi", "ډانګي جنتري" },
            { "type.co.ducet", "ډيفالټ يونيکوډ ترتيب" },
            { "type.lb.loose", "د غړندې ماتې کرښې ډول" },
            { "type.nu.roman", "رومن اعداد" },
            { "type.ca.coptic", "کاپټیک کیلنډر" },
            { "type.ca.hebrew", "جورجویان جنتري" },
            { "type.co.search", "د عمومي موخي لټون" },
            { "type.lb.normal", "د عادي ماتې کرښې ډول" },
            { "type.lb.strict", "د سختې ماتې کرښې ډول" },
            { "type.ms.metric", "ميټرک نظام" },
            { "type.ca.chinese", "د چين جنتري" },
            { "type.ca.islamic", "اسلامي جنتري" },
            { "type.ca.iso8601", "ISO-8601 جنتري" },
            { "type.ca.persian", "فارسي جنتري" },
            { "type.cf.account", "محاسبه اسعارو بڼه" },
            { "type.nu.arabext", "غځېدلې عربي ۔ اينډيک عدد" },
            { "type.nu.armnlow", "آرمينيايي کوچني اعداد" },
            { "type.nu.greklow", "يوناني کوچني اعداد" },
            { "type.nu.hanidec", "چايني اعشاري اعداد" },
            { "type.nu.hansfin", "ساده چيني مالي اعداد" },
            { "type.nu.hantfin", "دوديز چيني مالي اعداد" },
            { "type.nu.jpanfin", "جاپاني مالي اعداد" },
            { "type.nu.tamldec", "تامل اعداد" },
            { "type.ca.buddhist", "بودايي جنتري" },
            { "type.ca.ethiopic", "ایتوپيک جنتري" },
            { "type.ca.japanese", "جاپاني جنتري" },
            { "type.cf.standard", "معياري اسعارو بڼه" },
            { "type.co.standard", "د معیاري لټي ترتیب" },
            { "type.ms.uksystem", "امپيريل د ناپ نظام" },
            { "type.ms.ussystem", "د متحده آيالاتو د ناپ نظام" },
            { "type.nu.fullwide", "د بشپړه پراختيا اعداد" },
            { "type.nu.romanlow", "رومن کوچني اعداد" },
            { "type.ca.gregorian", "ګريګورين جنتري" },
            { "type.ca.islamic-tbla", "اسلامي جنتري (جدولي، ستورپوهنيز عصر)" },
            { "type.ca.islamic-civil", "اسلامي جنتري (جدولي، مدني عصر)" },
            { "type.ca.islamic-umalqura", "اسلامي کلیزه (ام القری)" },
            { "type.ca.ethiopic-amete-alem", "د ایتوپیک امیټ ایلم تقویم" },
        };
        return data;
    }
}
