var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React, { useState } from 'react';
import { Message } from '../Messages/Message';
import { Security } from '../Servers/Security';
import { Markdown, Schema, Bindings, Tags, Extensions, CollapseButton, } from '../../components';
import { Href } from '../../components/Href';
import { useConfig, useSpec } from '../../contexts';
import { CommonHelpers, SchemaHelpers } from '../../helpers';
import { EXTERAL_DOCUMENTATION_TEXT } from '../../constants';
import { PayloadType } from '../../types';
export var Operation = function (props) {
    var _a = props.type, type = _a === void 0 ? PayloadType.SEND : _a, operation = props.operation, channelName = props.channelName, channel = props.channel;
    var config = useConfig();
    if (!operation || !channel) {
        return null;
    }
    var servers = typeof channel.servers === 'function' && channel.servers().all();
    var security = typeof operation.security === 'function' && operation.security();
    var parameters = channel.parameters() !== undefined
        ? SchemaHelpers.parametersToSchema(channel.parameters())
        : undefined;
    return (React.createElement("div", null,
        React.createElement("div", { className: "panel-item--center px-8" },
            React.createElement(OperationInfo, __assign({}, props)),
            servers && servers.length > 0 ? (React.createElement("div", { className: "mt-2 text-sm" },
                React.createElement("p", null, "Available only on servers:"),
                React.createElement("ul", { className: "flex flex-wrap leading-normal" }, servers.map(function (server) { return (React.createElement("li", { className: "inline-block mt-2 mr-2", key: server.id() },
                    React.createElement("a", { href: "".concat(window.location.pathname, "#").concat(CommonHelpers.getIdentifier('server-' + server.id(), config)), className: "border border-solid border-blue-300 hover:bg-blue-300 hover:text-blue-600 text-blue-500 font-bold no-underline text-xs rounded px-3 py-1 cursor-pointer" },
                        React.createElement("span", { className: "underline" }, server.id())))); })))) : null,
            parameters && (React.createElement("div", { className: "mt-2", id: CommonHelpers.getIdentifier("operation-".concat(type, "-").concat(channelName, "-parameters"), config) },
                React.createElement(Schema, { schemaName: "Parameters", schema: parameters, expanded: true }))),
            security && (React.createElement("div", { className: "mt-2", id: CommonHelpers.getIdentifier("operation-".concat(type, "-").concat(channelName, "-security"), config) },
                React.createElement(Security, { security: security, header: "Additional security requirements" }))),
            channel.bindings() && (React.createElement("div", { className: "mt-2" },
                React.createElement(Bindings, { name: "Channel specific information", bindings: channel.bindings() }))),
            React.createElement(Extensions, { name: "Channel Extensions", item: channel }),
            operation.bindings() && (React.createElement("div", { className: "mt-2" },
                React.createElement(Bindings, { name: "Operation specific information", bindings: operation.bindings() }))),
            React.createElement(Extensions, { name: "Operation Extensions", item: operation }),
            operation.tags() && (React.createElement("div", { className: "mt-2" },
                React.createElement(Tags, { tags: operation.tags() })))),
        React.createElement("div", { className: "w-full mt-4", id: CommonHelpers.getIdentifier("operation-".concat(type, "-").concat(channelName, "-message"), config) }, operation.messages().length > 1 ? (React.createElement("div", { className: "mt-2" },
            React.createElement("p", { className: "px-8" },
                "Accepts ",
                React.createElement("strong", null, "one of"),
                " the following messages:"),
            React.createElement("ul", null, operation
                .messages()
                .all()
                .map(function (msg, idx) { return (React.createElement("li", { className: "mt-4", key: msg.id() },
                React.createElement(Message, { message: msg, index: idx, showExamples: true }))); })))) : (React.createElement("div", { className: "mt-2" },
            React.createElement("p", { className: "px-8" }, "Accepts the following message:"),
            React.createElement("div", { className: "mt-2" },
                React.createElement(Message, { message: operation.messages().all()[0], showExamples: true }))))),
        React.createElement(OperationReplyInfo, __assign({}, props))));
};
export var OperationInfo = function (props) {
    var _a = props.type, type = _a === void 0 ? PayloadType.SEND : _a, operation = props.operation, channelName = props.channelName, channel = props.channel;
    var config = useConfig();
    var operationSummary = operation.summary();
    var externalDocs = operation.externalDocs();
    var operationId = operation.id();
    var specV = useSpec().version();
    var version = specV.localeCompare('2.6.0', undefined, { numeric: true });
    var isAsyncAPIv2 = version === 0;
    var _b = CommonHelpers.getOperationDesignInformation({
        type: type,
        config: config,
        isAsyncAPIv2: isAsyncAPIv2,
    }), backgroundColor = _b.backgroundColor, typeLabel = _b.typeLabel;
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: "mb-4" },
            React.createElement("h3", null,
                React.createElement("span", { className: "font-mono text-white uppercase p-1 rounded mr-2 ".concat(backgroundColor), title: type }, typeLabel),
                ' ',
                React.createElement("span", { className: "font-mono text-base" }, channelName))),
        channel.hasDescription() && (React.createElement("div", { className: "mt-2" },
            React.createElement(Markdown, null, channel.description()))),
        operationSummary && (React.createElement("p", { className: "text-gray-600 text-sm mt-2" }, operationSummary)),
        operation.hasDescription() && (React.createElement("div", { className: "mt-2" },
            React.createElement(Markdown, null, operation.description()))),
        externalDocs && (React.createElement("ul", { className: "leading-normal mt-2 mb-4 space-x-2 space-y-2" }, externalDocs && (React.createElement("li", { className: "inline-block" },
            React.createElement(Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: externalDocs.url() },
                React.createElement("span", null, EXTERAL_DOCUMENTATION_TEXT)))))),
        operationId && (React.createElement("div", { className: "border bg-gray-100 rounded px-4 py-2 mt-2" },
            React.createElement("div", { className: "text-sm text-gray-700" },
                "Operation ID",
                React.createElement("span", { className: "bg-orange-600 text-white rounded text-xs ml-2 py-0 px-2" }, operationId))))));
};
export var OperationReplyInfo = function (props) {
    var _a;
    var _b = props.type, type = _b === void 0 ? PayloadType.SEND : _b, operation = props.operation;
    var _c = useState(false), showMessages = _c[0], setShowMessages = _c[1];
    var _d = useState(false), showChannel = _d[0], setShowChannel = _d[1];
    if (type !== PayloadType.REPLY && type !== PayloadType.REQUEST) {
        return React.createElement(React.Fragment, null);
    }
    var reply = operation.reply();
    if (reply === undefined) {
        return React.createElement(React.Fragment, null);
    }
    var replyMessages = reply.messages();
    var explicitChannel = reply.channel();
    var replyAddress = (_a = reply.address()) === null || _a === void 0 ? void 0 : _a.location();
    return (React.createElement("div", { className: "panel-item" },
        React.createElement("div", { className: "panel-item--center" },
            React.createElement("div", { className: "font-mono px-8 py-4" },
                React.createElement("div", { className: "border rounded" },
                    React.createElement("div", { className: "w-full ".concat(type === PayloadType.REPLY
                            ? 'bg-green-600 border-green-600'
                            : 'bg-blue-600 border-blue-600', " text-sm rounded-t h-8 px-4 border text-white flex items-center") },
                        React.createElement("strong", null, "REPLY INFORMATION")),
                    React.createElement("div", { className: "flex" },
                        React.createElement("div", { className: "w-1 h-11 ".concat(type === PayloadType.REPLY ? 'bg-green-600' : 'bg-blue-600', " mt-4") }),
                        React.createElement("div", { className: "p-4" },
                            React.createElement("h3", { className: "text-xs" },
                                React.createElement("span", { className: "mr-2", title: type }, "REPLY CHANNEL INFORMATION")),
                            (explicitChannel === null || explicitChannel === void 0 ? void 0 : explicitChannel.address()) ? (React.createElement("div", { className: "text-xs text-gray-700" },
                                "Reply will be provided via this designated address:",
                                ' ',
                                React.createElement("span", { className: "border text-orange-600 rounded text-xs ml-2 py-0 px-2" },
                                    explicitChannel.address(),
                                    ' '))) : (replyAddress != null && (React.createElement("div", { className: "text-xs text-gray-700" },
                                "Reply will be directed to the address specified at this location:",
                                ' ',
                                React.createElement("span", { className: "border text-orange-600 rounded text-xs ml-2 py-0 px-2" }, replyAddress)))),
                            React.createElement("div", { className: "mt-2" },
                                explicitChannel && (React.createElement(CollapseButton, { onClick: function () { return setShowChannel(function (prev) { return !prev; }); }, expanded: showChannel },
                                    React.createElement("span", { className: "inline-block py-0.5 mr-1 text-gray-500 text-xs text-center rounded focus:outline-none" }, "View channel details"))),
                                explicitChannel && (React.createElement("div", { className: "w-full mt-4 ".concat(showChannel ? 'block' : 'hidden') },
                                    React.createElement(OperationReplyChannelInfo, __assign({}, props)),
                                    ' '))))),
                    React.createElement(OperationReplyAddressInfo, __assign({}, props)),
                    replyMessages.isEmpty() === false && (React.createElement("div", { className: "p-4" },
                        React.createElement(CollapseButton, { onClick: function () { return setShowMessages(function (prev) { return !prev; }); }, expanded: showMessages },
                            React.createElement("span", { className: "inline-block py-0.5 mr-1 text-gray-500 text-xs text-center rounded focus:outline-none" },
                                "Expected Reply",
                                ' ',
                                replyMessages.length > 1 ? 'Messages' : 'Message')),
                        React.createElement("div", { className: "w-full mt-4 ".concat(showMessages ? 'block' : 'hidden') }, replyMessages.length > 1 ? (React.createElement("div", { className: "mt-2" },
                            React.createElement("ul", null, replyMessages.all().map(function (msg, idx) { return (React.createElement("li", { className: "mt-4", key: msg.id() },
                                React.createElement(Message, { message: msg, index: idx, showExamples: true }))); })))) : (React.createElement("div", { className: "mt-2" },
                            React.createElement("div", { className: "mt-2" },
                                React.createElement(Message, { message: replyMessages.all()[0], showExamples: true }))))))))),
            React.createElement(Extensions, { name: "Operation Reply Extensions", item: reply }))));
};
export var OperationReplyChannelInfo = function (_a) {
    var _b;
    var _c = _a.type, type = _c === void 0 ? PayloadType.SEND : _c, operation = _a.operation;
    var reply = operation.reply();
    var channel = reply === null || reply === void 0 ? void 0 : reply.channel();
    var channelName = (_b = channel === null || channel === void 0 ? void 0 : channel.address()) !== null && _b !== void 0 ? _b : '';
    var config = useConfig();
    var servers = typeof (channel === null || channel === void 0 ? void 0 : channel.servers) === 'function' && channel.servers().all();
    var parameters = (channel === null || channel === void 0 ? void 0 : channel.parameters()) !== undefined
        ? SchemaHelpers.parametersToSchema(channel.parameters())
        : undefined;
    if (!channel) {
        return React.createElement(React.Fragment, null);
    }
    return (React.createElement("div", null,
        channel.address() && (React.createElement("div", { className: "mt-2 text-xs text-gray-700" },
            "Address:",
            ' ',
            React.createElement("span", { className: "border text-orange-600 rounded text-xs py-0 px-2" }, channel.address()))),
        channel.hasDescription() && (React.createElement("div", { className: "mt-2" },
            React.createElement(Markdown, null, channel.description()))),
        servers && servers.length > 0 ? (React.createElement("div", { className: "mt-2 text-sm" },
            React.createElement("p", null, "Available only on servers:"),
            React.createElement("ul", { className: "flex flex-wrap leading-normal" }, servers.map(function (server) { return (React.createElement("li", { className: "inline-block mt-2 mr-2", key: server.id() },
                React.createElement("a", { href: "".concat(window.location.pathname, "#").concat(CommonHelpers.getIdentifier('server-' + server.id(), config)), className: "border border-solid border-blue-300 hover:bg-blue-300 hover:text-blue-600 text-blue-500 font-bold no-underline text-xs rounded px-3 py-1 cursor-pointer" },
                    React.createElement("span", { className: "underline" }, server.id())))); })))) : null,
        channel.messages().all().length > 1 ? (React.createElement("div", { className: "mt-2" },
            React.createElement("span", { className: "text-xs text-gray-700" }, "Messages:"),
            React.createElement("ul", null, channel
                .messages()
                .all()
                .map(function (msg, idx) { return (React.createElement("li", { className: "mt-4", key: msg.id() },
                React.createElement(Message, { message: msg, index: idx, showExamples: true }))); })))) : (React.createElement("div", { className: "mt-2" },
            React.createElement("span", { className: "text-xs text-gray-700" }, "Message:"),
            React.createElement("div", { className: "mt-2" },
                React.createElement(Message, { message: channel.messages().all()[0], showExamples: true })))),
        parameters && (React.createElement("div", { className: "mt-2", id: CommonHelpers.getIdentifier("operation-".concat(type, "-").concat(channelName, "-parameters"), config) },
            React.createElement(Schema, { schemaName: "Parameters", schema: parameters, expanded: true }))),
        channel.bindings() && (React.createElement("div", { className: "mt-2" },
            React.createElement(Bindings, { name: "Bindings", bindings: channel.bindings() })))));
};
export var OperationReplyAddressInfo = function (_a) {
    var _b = _a.type, type = _b === void 0 ? PayloadType.SEND : _b, operation = _a.operation;
    if (type !== PayloadType.REPLY && type !== PayloadType.REQUEST) {
        return React.createElement(React.Fragment, null);
    }
    var reply = operation.reply();
    if (!(reply === null || reply === void 0 ? void 0 : reply.address)) {
        return React.createElement(React.Fragment, null);
    }
    var replyAddress = reply.address();
    if (!replyAddress) {
        return React.createElement(React.Fragment, null);
    }
    var replyAddressLocation = replyAddress.location();
    return (React.createElement("div", { className: "flex" },
        React.createElement("div", { className: "w-1 h-11 ".concat(type === PayloadType.REPLY ? 'bg-green-600' : 'bg-blue-600', " mt-4") }),
        React.createElement("div", { className: "p-4" },
            React.createElement("h3", { className: "text-xs" },
                React.createElement("span", { className: "mr-2 uppercase", title: type }, "REPLY address information")),
            replyAddressLocation && (React.createElement("div", { className: "text-xs text-gray-700" },
                "REPLY will be sent to the address provided in:",
                React.createElement("span", { className: "border text-orange-600 rounded text-xs ml-2 py-0 px-2" }, replyAddressLocation))),
            replyAddress.hasDescription() && (React.createElement("div", { className: "mt-2" },
                React.createElement(Markdown, null, replyAddress.description()))),
            React.createElement(Extensions, { name: "Operation Reply Address Extensions", item: reply }))));
};
//# sourceMappingURL=Operation.js.map