"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filterObjectsByTags = void 0;
function filterObjectsByTags(tags, objects) {
    var taggedObjects = new Set();
    var tagged = new Map();
    tags.forEach(function (tag) {
        var taggedForTag = [];
        objects.forEach(function (obj) {
            var _a;
            var objTags = obj.tags;
            var nameTags = ((_a = objTags.all()) !== null && _a !== void 0 ? _a : []).map(function (t) { return t.name(); });
            var hasTag = nameTags.includes(tag);
            if (hasTag) {
                taggedForTag.push(obj);
                taggedObjects.add(obj);
            }
        });
        if (taggedForTag.length > 0) {
            tagged.set(tag, taggedForTag);
        }
    });
    var untagged = [];
    objects.forEach(function (obj) {
        if (!taggedObjects.has(obj)) {
            untagged.push(obj);
        }
    });
    return { tagged: tagged, untagged: untagged };
}
exports.filterObjectsByTags = filterObjectsByTags;
//# sourceMappingURL=sidebar.js.map