/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.vfs;

import com.intellij.kubernetes.view.vfs.UtilsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/view/vfs/KubernetesVirtualFileBaseContentProvider;", "Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isSupported", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBaseRevision", "Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider$BaseContent;", "intellij.clouds.kubernetes.backend"})
public final class KubernetesVirtualFileBaseContentProvider
implements VcsBaseContentProvider {
    @NotNull
    private final Project project;

    public KubernetesVirtualFileBaseContentProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    public boolean isSupported(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilsKt.isKubernetesFile(file, this.project);
    }

    @NotNull
    public VcsBaseContentProvider.BaseContent getBaseRevision(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new VcsBaseContentProvider.BaseContent(file){
            private final TextRevisionNumber revisionNumber;
            final /* synthetic */ VirtualFile $file;
            {
                this.$file = $file;
                this.revisionNumber = new TextRevisionNumber(String.valueOf($file.getModificationStamp()));
            }

            public VcsRevisionNumber getRevisionNumber() {
                return (VcsRevisionNumber)this.revisionNumber;
            }

            public String loadContent() {
                String string = VfsUtilCore.loadText((VirtualFile)this.$file);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
                return string;
            }
        };
    }
}

