/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.portForwarding;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b'\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J@\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0004\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/CreatePortForwardingDialogBase;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getConstraintsForCell", "Ljavax/swing/SpringLayout$Constraints;", "row", "", "col", "parent", "Ljava/awt/Container;", "cols", "createGridConstraints", "", "rows", "initialX", "initialY", "xPad", "yPad", "Companion", "intellij.platform.split"})
@ApiStatus.Internal
public abstract class CreatePortForwardingDialogBase
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CreatePortForwardingDialogBase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    private final SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        LayoutManager layoutManager = parent.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type javax.swing.SpringLayout");
        SpringLayout layout = (SpringLayout)layoutManager;
        Component c = parent.getComponent(row * cols + col);
        SpringLayout.Constraints constraints = layout.getConstraints(c);
        Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"getConstraints(...)");
        return constraints;
    }

    protected final void createGridConstraints(@NotNull Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (!(parent.getLayout() instanceof SpringLayout)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        LayoutManager layoutManager = parent.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type javax.swing.SpringLayout");
        SpringLayout layout = (SpringLayout)layoutManager;
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < cols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, this.getConstraintsForCell(r, c, parent, cols).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = this.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        Spring y = Spring.constant(initialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < cols; ++c) {
                height = Spring.max(height, this.getConstraintsForCell(r, c, parent, cols).getHeight());
            }
            for (c = 0; c < cols; ++c) {
                SpringLayout.Constraints constraints = this.getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J?\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\f\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/CreatePortForwardingDialogBase$Companion;", "", "<init>", "()V", "getPortTextBoxWithValidation", "Lcom/intellij/ui/components/JBTextField;", "alreadyForwardedPorts", "", "", "validatorDisposable", "Lcom/intellij/openapi/Disposable;", "validatorCallback", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "okEnabled", "", "intellij.platform.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JBTextField getPortTextBoxWithValidation(@NotNull Set<Integer> alreadyForwardedPorts, @NotNull Disposable validatorDisposable, @NotNull Function1<? super Boolean, Unit> validatorCallback) {
            Intrinsics.checkNotNullParameter(alreadyForwardedPorts, (String)"alreadyForwardedPorts");
            Intrinsics.checkNotNullParameter((Object)validatorDisposable, (String)"validatorDisposable");
            Intrinsics.checkNotNullParameter(validatorCallback, (String)"validatorCallback");
            JBTextField textField = new JBTextField();
            ComponentValidator validator = new ComponentValidator(validatorDisposable).withValidator(() -> Companion.getPortTextBoxWithValidation$lambda$0(textField, alreadyForwardedPorts)).installOn((JComponent)textField);
            textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(validator, validatorCallback){
                final /* synthetic */ ComponentValidator $validator;
                final /* synthetic */ Function1<Boolean, Unit> $validatorCallback;
                {
                    this.$validator = $validator;
                    this.$validatorCallback = $validatorCallback;
                }

                protected void textChanged(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$validator.revalidate();
                    ValidationInfo validationInfo = this.$validator.getValidationInfo();
                    this.$validatorCallback.invoke((Object)(validationInfo != null ? validationInfo.okEnabled : true));
                }
            });
            return textField;
        }

        private static final ValidationInfo getPortTextBoxWithValidation$lambda$0(JBTextField $textField, Set $alreadyForwardedPorts) {
            String pt = $textField.getText();
            if (StringUtil.isNotEmpty((String)pt)) {
                try {
                    Intrinsics.checkNotNull((Object)pt);
                    int portValue = Integer.parseInt(pt);
                    boolean bl = 1 <= portValue ? portValue < 65536 : false;
                    if (bl) {
                        if ($alreadyForwardedPorts.contains(portValue)) {
                            Object[] objectArray = new Object[]{String.valueOf(portValue)};
                            return new ValidationInfo(PlatformSplitBundle.INSTANCE.message("portForwarding.createPortForwardingDialog.portNumber.alreadyForwarded", objectArray), (JComponent)$textField);
                        }
                        return null;
                    }
                    return new ValidationInfo(PlatformSplitBundle.INSTANCE.message("portForwarding.createPortForwardingDialog.portNumber.validationError", new Object[0]), (JComponent)$textField);
                }
                catch (NumberFormatException nfe) {
                    return new ValidationInfo(PlatformSplitBundle.INSTANCE.message("portForwarding.createPortForwardingDialog.portNumber.validationError", new Object[0]), (JComponent)$textField);
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

