/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.snapshot;

import java.util.Collection;
import liquibase.exception.DatabaseException;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.ext.intellij.snapshot.IntellijSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;

public class SchemaSnapshotGenerator
extends IntellijSnapshotGenerator {
    public SchemaSnapshotGenerator() {
        super(Schema.class, new Class[]{Catalog.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (example.getSnapshotId() != null || !(example instanceof Schema)) {
            return example;
        }
        Schema exSchema = (Schema)example;
        if ("JPA_BUDDY".equals(exSchema.getName())) {
            return new Schema(snapshot.getDatabase().getDefaultCatalogName(), null).setDefault(Boolean.valueOf(true));
        }
        return new Schema(exSchema.getCatalog(), exSchema.getName());
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Schema.class)) {
            return;
        }
        if (!(foundObject instanceof Catalog)) {
            return;
        }
        Catalog catalog = (Catalog)foundObject;
        IntellijDatabase database = (IntellijDatabase)snapshot.getDatabase();
        Collection<String> allSchemaNames = database.getAllSchemaNames();
        for (String schemaName : allSchemaNames) {
            catalog.addDatabaseObject((DatabaseObject)new Schema(catalog, schemaName));
        }
    }
}

