/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff;

import com.intellij.jpa.jpb.model.backend.ed.EntityDesignHelper;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.service.JpabGeneratorManager;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.config.DatabaseMigrationState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.AddNotNullConstraintChange;
import liquibase.change.core.UpdateDataChange;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.ext.intellij.LiquibaseUtils;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingColumnChangeGenerator
extends liquibase.diff.output.changelog.core.MissingColumnChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Column.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        IntellijDatabase intellijdatabase = LiquibaseUtils.getIntellijDatabase(referenceDatabase, comparisonDatabase);
        MissingColumnChangeGenerator.checkColumnType(missingObject, intellijdatabase);
        Change[] superChanges = super.fixMissing(missingObject, control, referenceDatabase, comparisonDatabase, chain);
        if (intellijdatabase == null) {
            return superChanges;
        }
        Database rdbmsDatabase = intellijdatabase == referenceDatabase ? comparisonDatabase : referenceDatabase;
        ArrayList<Object> result = new ArrayList<Object>();
        if (superChanges != null) {
            for (Change change : superChanges) {
                result.add(change);
                if (!(change instanceof AddColumnChange)) continue;
                result.addAll(this.generateAdditionalChanges(intellijdatabase, rdbmsDatabase, control, (Column)missingObject, (AddColumnChange)change));
                MissingColumnChangeGenerator.addNotNullConstraintIfNeed(missingObject, rdbmsDatabase, (AddColumnChange)change);
            }
        }
        return result.toArray(new Change[0]);
    }

    private static void addNotNullConstraintIfNeed(DatabaseObject missingObject, Database rdbmsDatabase, AddColumnChange change) {
        if (LiquibaseUtils.getDatabaseType(rdbmsDatabase) != DbType.H2) {
            return;
        }
        for (AddColumnConfig column : change.getColumns()) {
            if (!MissingColumnChangeGenerator.isNeedNotNullConstraint(missingObject, column)) continue;
            ConstraintsConfig columnConstraints = column.getConstraints();
            if (columnConstraints == null) {
                columnConstraints = new ConstraintsConfig();
                column.setConstraints(columnConstraints);
            }
            columnConstraints.setNullable(Boolean.valueOf(false));
        }
    }

    private static boolean isNeedNotNullConstraint(DatabaseObject missingObject, AddColumnConfig addColumnConfig) {
        PrimaryKey primaryKey;
        if (!(missingObject instanceof Column)) {
            return false;
        }
        Column column = (Column)missingObject;
        if (!StringUtil.equalsIgnoreCase((CharSequence)addColumnConfig.getName(), (CharSequence)column.getName())) {
            return false;
        }
        Relation relation = column.getRelation();
        PrimaryKey primaryKey2 = primaryKey = relation instanceof Table ? ((Table)relation).getPrimaryKey() : null;
        if (primaryKey == null || primaryKey.getColumns() == null) {
            return false;
        }
        return ContainerUtil.or((Iterable)primaryKey.getColumns(), pkColumn -> StringUtil.equalsIgnoreCase((CharSequence)pkColumn.getName(), (CharSequence)column.getName()));
    }

    protected Collection<? extends Change> generateAdditionalChanges(@NotNull IntellijDatabase intellijDatabase, @NotNull Database rdbmsDatabase, @NotNull DiffOutputControl control, @NotNull Column column, @NotNull AddColumnChange addColumnChange) {
        String tableName;
        if (intellijDatabase == null) {
            MissingColumnChangeGenerator.$$$reportNull$$$0(0);
        }
        if (rdbmsDatabase == null) {
            MissingColumnChangeGenerator.$$$reportNull$$$0(1);
        }
        if (control == null) {
            MissingColumnChangeGenerator.$$$reportNull$$$0(2);
        }
        if (column == null) {
            MissingColumnChangeGenerator.$$$reportNull$$$0(3);
        }
        if (addColumnChange == null) {
            MissingColumnChangeGenerator.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)(tableName = addColumnChange.getTableName()))) {
            return Collections.emptyList();
        }
        return ((StreamEx)StreamEx.of((Collection)addColumnChange.getColumns()).flatMap(addColumnConfig -> this.generateAdditionalColumnChange(intellijDatabase, rdbmsDatabase, control, column, (AddColumnConfig)addColumnConfig)).peek(change -> change.setChangeSet(addColumnChange.getChangeSet()))).toList();
    }

    private Stream<Change> generateAdditionalColumnChange(IntellijDatabase intellijDatabase, Database rdbmsDatabase, DiffOutputControl control, Column column, AddColumnConfig addColumnConfig) {
        String tableName = column.getRelation().getName();
        UpdateDataChange updateDiscriminatorValue = MissingColumnChangeGenerator.createUpdateDiscriminatorValue(intellijDatabase, addColumnConfig, tableName);
        AddNotNullConstraintChange addNotNullConstraintChange = this.createAddNotNullConstraintChange(intellijDatabase, rdbmsDatabase, control, column, addColumnConfig);
        return StreamEx.of((Object[])new Change[]{updateDiscriminatorValue, addNotNullConstraintChange}).nonNull();
    }

    @Nullable
    private AddNotNullConstraintChange createAddNotNullConstraintChange(IntellijDatabase intellijDatabase, Database rdbmsDatabase, DiffOutputControl control, Column column, AddColumnConfig addColumnConfig) {
        PrimaryKey primaryKey;
        DbType rdbmsDatabaseType;
        ConstraintsConfig constraints = addColumnConfig.getConstraints();
        if (constraints == null || constraints.isNullable() != Boolean.FALSE) {
            return null;
        }
        Relation columnRelation = column.getRelation();
        String tableName = columnRelation.getName();
        AddNotNullConstraintChange change = new AddNotNullConstraintChange();
        change.setTableName(tableName);
        change.setColumnName(addColumnConfig.getName());
        change.setConstraintName(constraints.getNotNullConstraintName());
        change.setDefaultNullValue(this.getDefaultNullValue(intellijDatabase, column));
        if (control.getIncludeCatalog()) {
            change.setCatalogName(column.getRelation().getSchema().getCatalogName());
        }
        if (control.getIncludeSchema()) {
            change.setSchemaName(column.getRelation().getSchema().getName());
        }
        if ((rdbmsDatabaseType = LiquibaseUtils.getDatabaseType(rdbmsDatabase)) == DbType.MSSQL || rdbmsDatabaseType == DbType.MYSQL || rdbmsDatabaseType == DbType.MARIA || MissingColumnChangeGenerator.isSupportedAnyDbType(intellijDatabase, DbType.MSSQL, DbType.MYSQL)) {
            change.setColumnDataType(addColumnConfig.getType());
        }
        constraints.setNullable((Boolean)null);
        constraints.setNotNullConstraintName(null);
        if (MissingColumnChangeGenerator.isEmptyConstraint(constraints)) {
            addColumnConfig.setConstraints(null);
        }
        if (columnRelation instanceof Table && rdbmsDatabaseType != DbType.MSSQL && rdbmsDatabaseType != DbType.DB2 && (primaryKey = ((Table)columnRelation).getPrimaryKey()) != null && primaryKey.getColumns().contains(column)) {
            return null;
        }
        return change;
    }

    private static boolean isSupportedAnyDbType(IntellijDatabase database, DbType ... dbTypes) {
        Project project = database.getProject();
        DatabaseMigrationState migrationConfigState = DatabaseMigrationConfig.getInstance(project).getState();
        return ContainerUtil.or(migrationConfigState.getDatabaseInfos(), databaseInfo -> databaseInfo.isEnabled() && ContainerUtil.or((Object[])dbTypes, dbType -> dbType.getId().equals(databaseInfo.getDbmsId())));
    }

    @Nullable
    protected String getDefaultNullValue(IntellijDatabase database, Column column) {
        return null;
    }

    private static boolean isEmptyConstraint(ConstraintsConfig constraints) {
        try {
            for (String serializableField : constraints.getSerializableFields()) {
                Object serializableFieldValue = constraints.getSerializableFieldValue(serializableField);
                if (serializableFieldValue == null) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Nullable
    private static UpdateDataChange createUpdateDiscriminatorValue(IntellijDatabase database, AddColumnConfig addColumnConfig, String tableName) {
        String dtypeValue;
        Entity foundEntity = Optional.ofNullable(database.findOrmEntityByTableName(tableName)).map(arg_0 -> ((OrmUtil)OrmUtil.INSTANCE).getEntityByOrmEntity(arg_0)).orElse(null);
        if (foundEntity == null) {
            return null;
        }
        Project project = database.getProject();
        JpabGeneratorManager ddlGeneratorManager = JpabGeneratorManager.getInstance((Project)project);
        String discriminatorColumnName = ddlGeneratorManager.getDiscriminatorColumnName(foundEntity);
        if (!DbIdentifierHelper.compareIdentifier((String)discriminatorColumnName, (String)addColumnConfig.getName())) {
            return null;
        }
        if (!EntityDesignHelper.existPersistentChild((Entity)foundEntity, (Project)project)) {
            return null;
        }
        if (!ddlGeneratorManager.discriminatorToCreate(foundEntity, Collections.emptyList())) {
            return null;
        }
        UpdateDataChange updateDataChange = new UpdateDataChange();
        updateDataChange.setTableName(tableName);
        ColumnConfig updateColumnConfig = new ColumnConfig();
        updateColumnConfig.setName(discriminatorColumnName);
        String string = dtypeValue = StringUtils.isNotBlank((CharSequence)foundEntity.getDiscriminator()) ? foundEntity.getDiscriminator() : foundEntity.getName();
        if (StringUtils.isBlank((CharSequence)dtypeValue)) {
            dtypeValue = foundEntity.getClassName();
        }
        updateColumnConfig.setValue(dtypeValue);
        updateDataChange.addColumn(updateColumnConfig);
        updateDataChange.setWhere(discriminatorColumnName + " is null");
        return updateDataChange;
    }

    private static void checkColumnType(DatabaseObject object, IntellijDatabase intellijdatabase) {
        if (!(object instanceof Column)) {
            return;
        }
        Column column = (Column)object;
        if (column.getRelation() instanceof View || column.getRelation().getSnapshotId() == null) {
            return;
        }
        if (column.getType() == null) {
            LiquibaseUtils.setColumnDatatype(column, intellijdatabase);
            if (column.getType() == null) {
                throw new IllegalStateException("The column type is undefined. Table - " + column.getRelation().getName() + "; Column - " + column.getName());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "intellijDatabase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rdbmsDatabase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "control";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "column";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "addColumnChange";
                break;
            }
        }
        objectArray[1] = "liquibase/ext/intellij/diff/MissingColumnChangeGenerator";
        objectArray[2] = "generateAdditionalChanges";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

