/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.ssh;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;

public final class RelayHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = Logger.getInstance(RelayHandler.class);
    private final Channel relayChannel;

    public RelayHandler(Channel relayChannel) {
        this.relayChannel = relayChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.relayChannel.isActive()) {
            this.relayChannel.writeAndFlush(msg);
        } else {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.relayChannel.isActive()) {
            this.relayChannel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error("Close channel", cause);
        ctx.close();
    }
}

