/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.ssh;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.console.ssh.SocksServerInitializer;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.database.view.DatabaseCoreUiService;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/console/ssh/DatabaseProxyServer;", "", "hostPort", "Lcom/intellij/database/dataSource/url/HostPort;", "closeAction", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "<init>", "(Lcom/intellij/database/dataSource/url/HostPort;Ljava/lang/Runnable;)V", "getHostPort", "()Lcom/intellij/database/dataSource/url/HostPort;", "stop", "", "Companion", "intellij.database.connectivity"})
public final class DatabaseProxyServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HostPort hostPort;
    @NotNull
    private final Runnable closeAction;

    private DatabaseProxyServer(HostPort hostPort, Runnable closeAction) {
        this.hostPort = hostPort;
        this.closeAction = closeAction;
    }

    @NotNull
    public final HostPort getHostPort() {
        return this.hostPort;
    }

    public final void stop() {
        this.closeAction.run();
    }

    @JvmStatic
    @NotNull
    public static final DatabaseProxyServer startProxyServer(@NotNull Function<HostPort, Integer> localTunnelProvider) {
        return Companion.startProxyServer(localTunnelProvider);
    }

    public /* synthetic */ DatabaseProxyServer(HostPort hostPort, Runnable closeAction, DefaultConstructorMarker $constructor_marker) {
        this(hostPort, closeAction);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0007J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/console/ssh/DatabaseProxyServer$Companion;", "", "<init>", "()V", "startProxyServer", "Lcom/intellij/database/console/ssh/DatabaseProxyServer;", "localTunnelProvider", "Ljava/util/function/Function;", "Lcom/intellij/database/dataSource/url/HostPort;", "", "closeSilently", "", "action", "Lkotlin/Function0;", "intellij.database.connectivity"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DatabaseProxyServer startProxyServer(@NotNull Function<HostPort, Integer> localTunnelProvider) {
            Intrinsics.checkNotNullParameter(localTunnelProvider, (String)"localTunnelProvider");
            EventLoopGroup baseGroup = (EventLoopGroup)new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory());
            EventLoopGroup workedGroup = (EventLoopGroup)new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
            ServerBootstrap bootstrap = new ServerBootstrap();
            SocksServerInitializer socketInitializer = new SocksServerInitializer(localTunnelProvider);
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group(baseGroup, workedGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)socketInitializer).localAddress("localhost", 0);
            Channel channel = bootstrap.bind().sync().channel();
            SocketAddress socketAddress = channel.localAddress();
            Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
            InetSocketAddress address = (InetSocketAddress)socketAddress;
            HostPort hostPort = new HostPort(address.getHostString(), Integer.valueOf(address.getPort()));
            socketInitializer.setProxyHostPort(hostPort);
            DatabaseCoreUiService databaseCoreUiService = DatabaseCoreUiService.getInstance();
            String string = hostPort.getHost();
            int n = hostPort.getPortAsInt();
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            databaseCoreUiService.setProxyServerCredentials(string, n, new Credentials("DataGripProxyServer", new OneTimeString(string2)));
            return new DatabaseProxyServer(hostPort, () -> Companion.startProxyServer$lambda$0(channel, baseGroup, workedGroup), null);
        }

        private final void closeSilently(Function0<Unit> action) {
            try {
                action.invoke();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private static final void startProxyServer$lambda$0(Channel $channel, EventLoopGroup $baseGroup, EventLoopGroup $workedGroup) {
            Companion.closeSilently((Function0<Unit>)((Function0)() -> Companion.startProxyServer$lambda$0$0($channel)));
            Companion.closeSilently((Function0<Unit>)((Function0)() -> Companion.startProxyServer$lambda$0$1($baseGroup)));
            Companion.closeSilently((Function0<Unit>)((Function0)() -> Companion.startProxyServer$lambda$0$2($workedGroup)));
        }

        private static final Unit startProxyServer$lambda$0$0(Channel $channel) {
            $channel.close();
            return Unit.INSTANCE;
        }

        private static final Unit startProxyServer$lambda$0$1(EventLoopGroup $baseGroup) {
            $baseGroup.shutdownGracefully();
            return Unit.INSTANCE;
        }

        private static final Unit startProxyServer$lambda$0$2(EventLoopGroup $workedGroup) {
            $workedGroup.shutdownGracefully();
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

