/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.el;

import com.intellij.javaee.el.providers.ELContextProvider;
import com.intellij.javaee.el.util.ElTemplateParser;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.el.MicronautELLanguage;
import com.intellij.micronaut.el.MnElContextProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;

final class MnELInjector
implements MultiHostInjector {
    MnELInjector() {
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        Project project;
        if (registrar == null) {
            MnELInjector.$$$reportNull$$$0(0);
        }
        if (host == null) {
            MnELInjector.$$$reportNull$$$0(1);
        }
        if ((project = host.getProject()).isDefault() || !MicronautUtils.hasMicronautLibrary(project)) {
            return;
        }
        UExpression uInjectionHost = (UExpression)UastContextKt.toUElement((PsiElement)host, UInjectionHost.class);
        if (uInjectionHost != null && MnELInjector.isMicronautElAnnotation((UAnnotation)UastUtils.getParentOfType((UElement)uInjectionHost, UAnnotation.class))) {
            MnELInjector.doRegister(registrar, host);
        }
    }

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<? extends PsiElement>> list = Arrays.asList(XmlAttributeValue.class, PsiLanguageInjectionHost.class);
        if (list == null) {
            MnELInjector.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static boolean isMicronautElAnnotation(@Nullable UAnnotation uAnnotation) {
        if (uAnnotation == null) {
            return false;
        }
        String qualifiedName = uAnnotation.getQualifiedName();
        return qualifiedName != null && qualifiedName.startsWith("io.micronaut");
    }

    private static void doRegister(MultiHostRegistrar registrar, PsiElement host) {
        String text = host.getText();
        List ranges = ElTemplateParser.parse((String)text);
        if (ranges.isEmpty()) {
            return;
        }
        for (TextRange textRange : ranges) {
            registrar.startInjecting((Language)MicronautELLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)host, textRange).doneInjecting();
        }
        host.putUserData(ELContextProvider.ourContextProviderKey, (Object)new MnElContextProvider(host));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/el/MnELInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/el/MnELInjector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

