/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor.surroundWith;

import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.editor.surroundWith.SqlSurrounderBase;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u001b\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ+\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/editor/surroundWith/SqlSelectSurrounder;", "Lcom/intellij/sql/editor/surroundWith/SqlSurrounderBase;", "<init>", "()V", "getTemplateDescription", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isApplicable", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/psi/PsiElement;)Z", "surroundElements", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;[Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/util/TextRange;", "getExpression", "Lcom/intellij/sql/psi/SqlExpression;", "([Lcom/intellij/psi/PsiElement;)Lcom/intellij/sql/psi/SqlExpression;", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlSelectSurrounder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlSelectSurrounder.kt\ncom/intellij/sql/editor/surroundWith/SqlSelectSurrounder\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n67#2:39\n1#3:40\n*S KotlinDebug\n*F\n+ 1 SqlSelectSurrounder.kt\ncom/intellij/sql/editor/surroundWith/SqlSelectSurrounder\n*L\n34#1:39\n*E\n"})
public final class SqlSelectSurrounder
extends SqlSurrounderBase {
    @NotNull
    public static final SqlSelectSurrounder INSTANCE = new SqlSelectSurrounder();

    private SqlSelectSurrounder() {
    }

    @NotNull
    public String getTemplateDescription() {
        String string = SqlBundle.message((String)"surround.with.select.template", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return this.getExpression(elements) != null;
    }

    @NotNull
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        SqlExpression sqlExpression = this.getExpression(elements);
        if (sqlExpression == null) {
            TextRange textRange = SurroundWithHandler.CARET_IS_OK;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"CARET_IS_OK");
            return textRange;
        }
        SqlExpression expression = sqlExpression;
        boolean needParentheses = expression instanceof SqlResultSetExpression;
        Object open = "select * from ";
        if (needParentheses) {
            open = (String)open + "(";
        }
        Object close = "";
        if (needParentheses) {
            close = (String)close + ") " + SqlNamesGenerator.suggestAliasName((SqlExpression)expression);
        }
        TextRange textRange = SqlSurrounderBase.surroundElementsWith(project, editor, (String)open, (String)close, true);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"surroundElementsWith(...)");
        return textRange;
    }

    /*
     * WARNING - void declaration
     */
    private final SqlExpression getExpression(PsiElement[] elements) {
        SqlExpression sqlExpression;
        void $this$parentOfType$iv;
        PsiElement e;
        PsiElement psiElement = (PsiElement)ArraysKt.singleOrNull((Object[])elements);
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = e = psiElement;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        SqlExpression sqlExpression2 = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, SqlExpression.class, (boolean)false);
        if (sqlExpression2 == null) {
            return null;
        }
        SqlExpression expression = sqlExpression2;
        if (!Intrinsics.areEqual((Object)expression.getTextRange(), (Object)e.getTextRange())) {
            return null;
        }
        SqlExpression it = sqlExpression = expression;
        boolean bl = false;
        return it instanceof SqlReferenceExpression || it instanceof SqlResultSetExpression ? sqlExpression : null;
    }
}

