/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.GenericFileName;

public class URLFileName
extends GenericFileName {
    private static final int BUFFER_SIZE = 250;
    private final String queryString;

    public URLFileName(String scheme, String hostName, int port, int defaultPort, String userName, String password, String path, FileType type, String queryString) {
        super(scheme, hostName, port, defaultPort, userName, password, path, type);
        this.queryString = queryString;
    }

    public URLFileName(String scheme, String hostName, int port, int defaultPort, String path, FileType type, String queryString) {
        super(scheme, hostName, port, defaultPort, path, type);
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPathQuery() {
        return this.getPath() + "?" + this.getQueryString();
    }

    @Override
    public FileName createName(String absPath, FileType type) {
        return new URLFileName(this.getScheme(), this.getHostName(), this.getPort(), this.getDefaultPort(), this.getUserName(), this.getPassword(), absPath, type, this.getQueryString());
    }

    @Override
    protected String createURI() {
        if (this.getQueryString() != null) {
            return super.createURI() + "?" + this.getQueryString();
        }
        return super.createURI();
    }
}

