/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.amper;

import com.intellij.amper.FileUtilsKt;
import com.intellij.amper.ModuleUtilsKt;
import com.intellij.amper.codeInsight.PsiUtilsKt;
import com.intellij.amper.project.entities.AmperModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.amper.AmperPackageCheckerUtilKt;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.model.Package;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J0\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u001e0\u001d2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lcom/intellij/packageChecker/amper/AmperBuildFileProvider;", "Lcom/intellij/packageChecker/api/BuildFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "id", "", "getId", "()Ljava/lang/String;", "supports", "", "file", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "importedPackages", "", "Lcom/intellij/packageChecker/model/Package;", "findPackagesForFragment", "fragment", "Lcom/intellij/amper/project/entities/AmperModel$Fragment;", "declaredDependencies", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "updatePackageDeclaration", "", "pkg", "version", "getRoots", "", "", "pkgs", "Companion", "intellij.packageChecker.amper"})
@SourceDebugExtension(value={"SMAP\nAmperBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmperBuildFileProvider.kt\ncom/intellij/packageChecker/amper/AmperBuildFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,86:1\n808#2,11:87\n808#2,11:99\n1#3:98\n13#4:110\n*S KotlinDebug\n*F\n+ 1 AmperBuildFileProvider.kt\ncom/intellij/packageChecker/amper/AmperBuildFileProvider\n*L\n42#1:87,11\n74#1:99,11\n83#1:110\n*E\n"})
public final class AmperBuildFileProvider
implements BuildFileProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String id;
    @NotNull
    private static final Logger LOG;

    public AmperBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.id = "amper";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public boolean supports(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileUtilsKt.isAmperFile((PsiElement)((PsiElement)file));
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ModuleUtilsKt.isAmperModule((Module)module);
    }

    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        AmperModel.Module module = ModuleUtilsKt.findAmperModuleForModuleFile((PsiFile)file);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        AmperModel.Module amperModule = module;
        List result = new ArrayList();
        for (AmperModel.Fragment fragment : amperModule.getFragments()) {
            result.addAll((Collection)this.findPackagesForFragment(fragment));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Package> findPackagesForFragment(AmperModel.Fragment fragment) {
        void $this$filterIsInstanceTo$iv$iv;
        List result = new ArrayList();
        Iterable $this$filterIsInstance$iv = fragment.getExternalDependencies();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AmperModel.Fragment.Notation.MavenDependency)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (AmperModel.Fragment.Notation.MavenDependency dependency : (List)destination$iv$iv) {
            Package pkg;
            if (AmperPackageCheckerUtilKt.createPackage(this.project, dependency) == null) continue;
            result.add(pkg);
        }
        return result;
    }

    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        AmperModel.Fragment fragment = ModuleUtilsKt.findFragmentForPlatformModule((Module)module);
        if (fragment == null) {
            return CollectionsKt.emptyList();
        }
        AmperModel.Fragment fragment2 = fragment;
        return this.findPackagesForFragment(fragment2);
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return AmperPackageCheckerUtilKt.getOrFindDeclaredDependenciesInFileOnly(file);
    }

    @Override
    public void updatePackageDeclaration(@NotNull PsiFile file, @NotNull Package pkg, @NotNull String version) {
        PsiElement oldElement;
        PackageDeclaration dependency;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Iterable iterable = AmperPackageCheckerUtilKt.getOrFindDeclaredDependenciesInFileOnly(file);
            for (Object t : iterable) {
                PackageDeclaration it = (PackageDeclaration)t;
                boolean bl = false;
                if (!it.getPkg().matches(pkg)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        PackageDeclaration packageDeclaration = dependency = (PackageDeclaration)v0;
        Object object = oldElement = packageDeclaration != null ? packageDeclaration.getPsiElement() : null;
        if (oldElement == null) {
            LOG.warn("Dependency " + dependency + " not found in " + file);
            return;
        }
        String newCoordinates = pkg.getNamespace() + ":" + pkg.getName() + ":" + version;
        PsiUtilsKt.replaceWithDependency$default((PsiElement)oldElement, (String)newCoordinates, null, null, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Package, Set<Package>> getRoots(@NotNull PsiFile file, @NotNull List<Package> pkgs2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        AmperModel.Module module = ModuleUtilsKt.findAmperModuleForModuleFile((PsiFile)file);
        if (module == null) {
            return MapsKt.emptyMap();
        }
        AmperModel.Module amperModule = module;
        Map result = new LinkedHashMap();
        for (AmperModel.Fragment fragment : amperModule.getFragments()) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = fragment.getExternalDependencies();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof AmperModel.Fragment.Notation.MavenDependency)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (AmperModel.Fragment.Notation.MavenDependency dependency : (List)destination$iv$iv) {
                Package pkg;
                if (AmperPackageCheckerUtilKt.createPackage(this.project, dependency) == null) continue;
                result.put(pkg, SetsKt.emptySet());
            }
        }
        return result;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AmperBuildFileProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/packageChecker/amper/AmperBuildFileProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.packageChecker.amper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

