/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap;

import com.intellij.openapi.progress.ProgressIndicator;
import com.jetbrains.nodejs.NodeJSBundle;
import org.jetbrains.annotations.Nls;

public class TimeReporter {
    private final long myStart;
    @Nls
    private final String myName;
    private final ProgressIndicator myIndicator;
    private long myStage;

    public TimeReporter(@Nls String name, ProgressIndicator indicator) {
        this.myName = name;
        this.myIndicator = indicator;
        this.myStage = this.myStart = System.currentTimeMillis();
    }

    private void report(@Nls String s) {
        if (this.myIndicator != null) {
            this.myIndicator.setText(s);
        } else {
            System.out.println(s);
        }
    }

    public void reportTotal() {
        this.report(NodeJSBundle.message("profile.action_took_time.text", this.myName, TimeReporter.formatDuration(System.currentTimeMillis() - this.myStart)));
    }

    public void reportStage(String name) {
        long time = System.currentTimeMillis();
        this.report(NodeJSBundle.message("profile.action_took_time.text", name, TimeReporter.formatDuration(time - this.myStage)));
        this.myStage = time;
    }

    private static String formatDuration(long time) {
        if (time < 1000L) {
            return time + " ms";
        }
        return time / 1000L + " sec " + time % 1000L + " ms";
    }
}

