/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.pixels;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.util.pngj.Zip;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/pixels/DeflaterEstimatorLz4;", "", "()V", "compressEstim", "", "src", "", "srcOff", "srcLen", "Companion", "plot-api"})
public final class DeflaterEstimatorLz4 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MEMORY_USAGE = 14;
    private static final int NOT_COMPRESSIBLE_DETECTION_LEVEL = 6;
    private static final int MIN_MATCH = 4;
    private static final int HASH_LOG = 12;
    public static final int HASH_TABLE_SIZE = 4096;
    private static final int SKIP_STRENGTH = Math.max(6, 2);
    private static final int COPY_LENGTH = 8;
    private static final int LAST_LITERALS = 5;
    private static final int MF_LIMIT = 12;
    private static final int MIN_LENGTH = 13;
    public static final int MAX_DISTANCE = 65536;
    private static final int ML_BITS = 4;
    private static final int ML_MASK = 15;
    private static final int RUN_BITS = 4;
    private static final int RUN_MASK = 15;
    public static final int LZ4_64K_LIMIT = 65547;
    private static final int HASH_LOG_64K = 13;
    private static final int HASH_TABLE_SIZE_64K = 8192;
    private static final int HASH_LOG_HC = 15;
    public static final int HASH_TABLE_SIZE_HC = 32768;
    public static final int OPTIMAL_ML = 18;

    @JvmOverloads
    public final int compressEstim(@NotNull byte[] src, int srcOff, int srcLen) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int srcOff2 = srcOff;
        if (srcLen < 10) {
            return srcLen;
        }
        int stride = 65546;
        int segments = (srcLen + stride - 1) / stride;
        if ((stride = srcLen / segments) >= 65546 || stride * segments > srcLen || segments < 1 || stride < 1) {
            throw new IllegalStateException(("?? " + srcLen).toString());
        }
        int bytesIn = 0;
        int bytesOut = 0;
        int len = srcLen;
        while (len > 0) {
            if (len > stride) {
                len = stride;
            }
            bytesOut += Companion.compress64k(src, srcOff2, len);
            srcOff2 += len;
            len = srcLen - (bytesIn += len);
        }
        double ratio = (double)bytesOut / (double)bytesIn;
        return bytesIn == srcLen ? bytesOut : (int)(ratio * (double)srcLen + 0.5);
    }

    public static /* synthetic */ int compressEstim$default(DeflaterEstimatorLz4 deflaterEstimatorLz4, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return deflaterEstimatorLz4.compressEstim(byArray, n, n2);
    }

    @JvmOverloads
    public final int compressEstim(@NotNull byte[] src, int srcOff) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return DeflaterEstimatorLz4.compressEstim$default(this, src, srcOff, 0, 4, null);
    }

    @JvmOverloads
    public final int compressEstim(@NotNull byte[] src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return DeflaterEstimatorLz4.compressEstim$default(this, src, 0, 0, 6, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0013\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0017\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u001e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004J(\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0002J0\u0010%\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0004H\u0002J\u001e\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0004J\u000e\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004J\u0010\u0010.\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004H\u0002J\u000e\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0004J\u0016\u00101\u001a\u0002022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u0004J\u0018\u00103\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u0004H\u0002J\u0018\u00104\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u0004H\u0002J \u00105\u001a\u0002062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004H\u0002J\u0018\u00108\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u0004H\u0002J\u0018\u00109\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020:2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u0016\u0010;\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u0004J \u0010<\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020:2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/pixels/DeflaterEstimatorLz4$Companion;", "", "()V", "COPY_LENGTH", "", "HASH_LOG", "HASH_LOG_64K", "HASH_LOG_HC", "HASH_TABLE_SIZE", "HASH_TABLE_SIZE_64K", "HASH_TABLE_SIZE_HC", "LAST_LITERALS", "LZ4_64K_LIMIT", "MAX_DISTANCE", "MEMORY_USAGE", "MF_LIMIT", "MIN_LENGTH", "MIN_MATCH", "ML_BITS", "ML_MASK", "NOT_COMPRESSIBLE_DETECTION_LEVEL", "OPTIMAL_ML", "RUN_BITS", "RUN_MASK", "SKIP_STRENGTH", "checkLength", "", "len", "checkRange", "buf", "", "off", "commonBytes", "b", "o1", "o2", "limit", "commonBytesBackward", "l1", "l2", "compress64k", "src", "srcOff", "srcLen", "hash", "i", "hash64k", "maxCompressedLength", "length", "readByte", "", "readInt", "readIntBE", "readIntEquals", "", "j", "readIntLE", "readShort", "", "readShortLittleEndian", "writeShort", "v", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public final int compress64k(@NotNull byte[] src, int srcOff, int srcLen) {
            int runLen;
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            int srcEnd = srcOff + srcLen;
            int srcLimit = srcEnd - 5;
            int mflimit = srcEnd - 12;
            int sOff = srcOff;
            int dOff = 0;
            int anchor = sOff++;
            if (srcLen >= 13) {
                short[] hashTable = new short[8192];
                block0: while (true) {
                    int forwardOff = sOff;
                    int ref = 0;
                    int findMatchAttempts = (1 << SKIP_STRENGTH) + 3;
                    do {
                        sOff = forwardOff;
                        if ((forwardOff += findMatchAttempts++ >>> SKIP_STRENGTH) > mflimit) break block0;
                        int h = this.hash64k(this.readInt(src, sOff));
                        ref = srcOff + this.readShort(hashTable, h);
                        this.writeShort(hashTable, h, sOff - srcOff);
                    } while (!this.readIntEquals(src, ref, sOff));
                    int excess = this.commonBytesBackward(src, ref, sOff, srcOff, anchor);
                    ref -= excess;
                    int runLen2 = (sOff -= excess) - anchor;
                    ++dOff;
                    if (runLen2 >= 15) {
                        if (runLen2 > 15) {
                            dOff += (runLen2 - 15) / 255;
                        }
                        ++dOff;
                    }
                    dOff += runLen2;
                    while (true) {
                        dOff += 2;
                        int matchLen = this.commonBytes(src, ref += 4, sOff += 4, srcLimit);
                        sOff += matchLen;
                        if (matchLen >= 15) {
                            if (matchLen >= 270) {
                                dOff += (matchLen - 15) / 255;
                            }
                            ++dOff;
                        }
                        if (sOff > mflimit) {
                            anchor = sOff;
                            break block0;
                        }
                        this.writeShort(hashTable, this.hash64k(this.readInt(src, sOff - 2)), sOff - 2 - srcOff);
                        int h = this.hash64k(this.readInt(src, sOff));
                        ref = srcOff + this.readShort(hashTable, h);
                        this.writeShort(hashTable, h, sOff - srcOff);
                        if (!this.readIntEquals(src, sOff, ref)) break;
                        ++dOff;
                    }
                    anchor = sOff++;
                }
            }
            if ((runLen = srcEnd - anchor) >= 270) {
                dOff += (runLen - 15) / 255;
            }
            ++dOff;
            return dOff += runLen;
        }

        public final int maxCompressedLength(int length) {
            if (length < 0) {
                throw new IllegalStateException(("length must be >= 0, got " + length).toString());
            }
            return length + length / 255 + 16;
        }

        public final int hash(int i) {
            return i * -1640531535 >>> 20;
        }

        private final int hash64k(int i) {
            return i * -1640531535 >>> 19;
        }

        public final int readShortLittleEndian(@NotNull byte[] buf, int i) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return buf[i] & 0xFF | (buf[i + 1] & 0xFF) << 8;
        }

        private final boolean readIntEquals(byte[] buf, int i, int j) {
            return buf[i] == buf[j] && buf[i + 1] == buf[j + 1] && buf[i + 2] == buf[j + 2] && buf[i + 3] == buf[j + 3];
        }

        private final int commonBytes(byte[] b2, int o1, int o2, int limit) {
            int o12 = o1;
            int o22 = o2;
            int count2 = 0;
            while (o22 < limit && b2[o12++] == b2[o22++]) {
                ++count2;
            }
            return count2;
        }

        private final int commonBytesBackward(byte[] b2, int o1, int o2, int l1, int l2) {
            int o12 = o1;
            int o22 = o2;
            int count2 = 0;
            while (o12 > l1 && o22 > l2 && b2[--o12] == b2[--o22]) {
                ++count2;
            }
            return count2;
        }

        private final int readShort(short[] buf, int off) {
            return buf[off] & 0xFFFF;
        }

        public final byte readByte(@NotNull byte[] buf, int i) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return buf[i];
        }

        private final void checkRange(byte[] buf, int off) {
            if (off < 0 || off >= buf.length) {
                throw new IndexOutOfBoundsException(String.valueOf(off));
            }
        }

        public final void checkRange(@NotNull byte[] buf, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            this.checkLength(len);
            if (len > 0) {
                this.checkRange(buf, off);
                this.checkRange(buf, off + len - 1);
            }
        }

        private final void checkLength(int len) {
            if (len < 0) {
                throw new IllegalStateException("lengths must be >= 0".toString());
            }
        }

        private final int readIntBE(byte[] buf, int i) {
            return (buf[i] & 0xFF) << 24 | (buf[i + 1] & 0xFF) << 16 | (buf[i + 2] & 0xFF) << 8 | buf[i + 3] & 0xFF;
        }

        private final int readIntLE(byte[] buf, int i) {
            return buf[i] & 0xFF | (buf[i + 1] & 0xFF) << 8 | (buf[i + 2] & 0xFF) << 16 | (buf[i + 3] & 0xFF) << 24;
        }

        private final int readInt(byte[] buf, int i) {
            return Zip.INSTANCE.getIS_BYTE_ORDER_BIG_ENDIAN() ? this.readIntBE(buf, i) : this.readIntLE(buf, i);
        }

        private final void writeShort(short[] buf, int off, int v) {
            buf[off] = (short)v;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

